package com.cybelia.sandra.web.action.loading.model;


import java.util.Calendar;
import java.util.Date;

/**
 * La classe contenant des methodes utiles pour l'ecran de chargement.
 *
 * @author chemit
 */
public class ModelHelper {

    public static final int ONE_MINUTE_IN_MILLI = 1000 * 60;
    public static final int ONE_HOUR_IN_MIN = 60;

    /**
     * Calcule la borne inferieure du tableau a afficher, a partir de la date courante, du nombre
     * d'heures et de la position de la date courante dans le tableau.
     *
     * @param currentDate         la date courante
     * @param nbHours             le nombre d'heure a afficher
     * @param positionCurrentDate la position en pourcentage de l'heure courante a afficher
     * @return la borne inferieure du tableau a afficher, ou <code>null</code> si la date courante est nulle.
     */
    public static Date getStartingDateFromCurrentDate(Date currentDate, int nbHours, int positionCurrentDate) {
        if (currentDate == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(currentDate);
        double minutes = (nbHours * ONE_HOUR_IN_MIN * positionCurrentDate) / 100;
        calendar.add(Calendar.MINUTE, (int) -minutes);
        calendar.set(Calendar.MINUTE, 0);
        return calendar.getTime();
    }

    /*public static Chargement createChargement(ChargementUsineConfig config, Camion camion, Tour tour) {
        Chargement chargement = new Chargement();
        chargement.setCamionId(camion.getTopiaId());
        chargement.setTourId(tour.getTopiaId());
        chargement.setTourNumero(tour.getNumero());
        chargement.setStartingDate(tour.getDateChargement());
        // compute delay from config
        chargement.setDelay(60);
        chargement.setStatut(StatutEnum.PLANIFIE);
        return chargement;
    }*/

    public static Column[] createColumnModel(int nbHours, Day[] days, Date currentDate) {

        Column[] result = new Column[nbHours];
        int columnIndex = 0;

        for (Day day : days) {
            for (int hour = day.getFirstHour(), max = day.getLastHour(); hour <= max; hour++) {
                Column column = new Column();
                column.setDay(day);
                column.setHour(hour);
                column.setFirstHour(hour == day.getFirstHour());
                result[columnIndex++] = column;
                if (currentDate != null) {
                    if (column.getStartingDate().before(currentDate) && column.getEndingDate().after(currentDate)) {
                        column.setCurrentDate(currentDate);
                    }
                }
            }
        }
        return result;
    }
}
