package com.cybelia.sandra.web.action.loading;

import com.cybelia.sandra.entities.ChargementUsineConfig;
import com.cybelia.sandra.entities.ChargementUsineConfigImpl;
import com.cybelia.sandra.entities.Usine;
import com.cybelia.sandra.entities.UsineImpl;
import com.cybelia.sandra.web.action.ApplicationSession.Cache;
import com.cybelia.sandra.web.action.UtilAction;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;

/**
 * @author chemit
 */
public class ChargementUsineConfigForm extends ActionForm {

    protected String usineTopiaId;
    protected String topiaId;
    protected Integer nombreHeures;
    protected Integer positionHeureActuelle;
    protected Integer tempFixeParTournee;
    protected Integer tempFixeParLigneProduit;
    protected Integer tempVariableParQuantite;
    protected Long startingDateAsLong;

    private static final long serialVersionUID = 1L;

    public ChargementUsineConfigForm() throws Exception {
        usineTopiaId = Cache.Usine.getDefaultEntry();
    }

    public String getUsineTopiaId() {
        return usineTopiaId;
    }

    public void setUsineTopiaId(String usineTopiaId) {
        this.usineTopiaId = usineTopiaId;
    }

    public String getTopiaId() {
        return topiaId;
    }

    public void setTopiaId(String topiaId) {
        this.topiaId = topiaId;
    }

    public Integer getNombreHeures() {
        return nombreHeures;
    }

    public void setNombreHeures(Integer nombreHeures) {
        this.nombreHeures = nombreHeures;
    }

    public Integer getPositionHeureActuelle() {
        return positionHeureActuelle;
    }

    public void setPositionHeureActuelle(Integer positionHeureActuelle) {
        this.positionHeureActuelle = positionHeureActuelle;
    }

    public Integer getTempFixeParTournee() {
        return tempFixeParTournee;
    }

    public void setTempFixeParTournee(Integer tempFixeParTournee) {
        this.tempFixeParTournee = tempFixeParTournee;
    }

    public Integer getTempFixeParLigneProduit() {
        return tempFixeParLigneProduit;
    }

    public void setTempFixeParLigneProduit(Integer tempFixeParLigneProduit) {
        this.tempFixeParLigneProduit = tempFixeParLigneProduit;
    }

    public Integer getTempVariableParQuantite() {
        return tempVariableParQuantite;
    }

    public void setTempVariableParQuantite(Integer tempVariableParQuantite) {
        this.tempVariableParQuantite = tempVariableParQuantite;
    }

    public Long getStartingDateAsLong() {
        return startingDateAsLong;
    }

    public void setStartingDateAsLong(Long startingDateAsLong) {
        this.startingDateAsLong = startingDateAsLong;
    }

    @Override
    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {

        ActionErrors errors = new ActionErrors();
        UtilAction.checkRequiredField(request, errors, "usineTopiaId", "error.loading.config.usine.required");

        checkIntegerField(request, errors, "nombreHeures", 5, 50,
                "error.loading.config.nombreHeures.required",
                "error.load.config.nombreHeures.syntax");

        checkIntegerField(request, errors, "positionHeureActuelle", 10, 90,
                "error.loading.config.positionHeureActuelle.required",
                "error.load.config.positionHeureActuelle.syntax");

        checkIntegerField(request, errors, "tempFixeParTournee", 0, null,
                "error.loading.config.tempFixeParTournee.required",
                "error.load.config.tempFixeParTournee.syntax");

        checkIntegerField(request, errors, "tempFixeParLigneProduit", 0, null,
                "error.loading.config.tempFixeParLigneProduit.required",
                "error.load.config.tempFixeParLigneProduit.syntax");

        checkIntegerField(request, errors, "tempVariableParQuantite", 0, null,
                "error.loading.config.tempVariableParQuantite.required",
                "error.load.config.tempVariableParQuantite.syntax");

        return errors;
    }

    public void fromBean(ChargementUsineConfig bean) throws Exception {
        setTopiaId(bean.getTopiaId());
        setUsineTopiaId(bean.getUsine().getTopiaId());
        setNombreHeures(bean.getNombreHeures());
        setPositionHeureActuelle(bean.getPositionHeureActuelle());
        setTempFixeParTournee(bean.getTempFixeParTournee());
        setTempFixeParLigneProduit(bean.getTempFixeParLigneProduit());
        setTempVariableParQuantite(bean.getTempVariableParQuantite());
    }

    public ChargementUsineConfig toBean() {
        ChargementUsineConfig bean = new ChargementUsineConfigImpl();
        bean.setTopiaId(getTopiaId());
        Usine usine = new UsineImpl();
        usine.setTopiaId(getUsineTopiaId());
        bean.setUsine(usine);
        bean.setNombreHeures(getNombreHeures());
        bean.setPositionHeureActuelle(getPositionHeureActuelle());
        bean.setTempFixeParTournee(getTempFixeParTournee());
        bean.setTempFixeParLigneProduit(getTempFixeParLigneProduit());
        bean.setTempVariableParQuantite(getTempVariableParQuantite());

        return bean;
    }

    protected void checkIntegerField(HttpServletRequest request, ActionErrors errors, String field, Integer min, Integer max, String errorRequired, String errorSyntax) {
        if (!UtilAction.checkRequiredField(request, errors, field, errorRequired)) {
            return;
        }
        Integer value = UtilAction.checkIntegerField(request, errors, field, errorSyntax);

        if (value == null) {
            return;
        }
        if (((min != null && value < min) || (max != null && value > max))) {
            errors.add(field, new ActionMessage(errorSyntax));
        }
    }
}
