package com.cybelia.sandra.web.action.loading;

import com.cybelia.sandra.entities.ChargementUsineConfig;
import com.cybelia.sandra.entities.StatutEnum;
import com.cybelia.sandra.entities.Tour;
import com.cybelia.sandra.services.LogicException;
import com.cybelia.sandra.services.ServiceWeb;
import com.cybelia.sandra.web.action.ApplicationSession;
import com.cybelia.sandra.web.action.CommonMappingDispatchAction;
import com.cybelia.sandra.web.action.UtilAction;
import com.cybelia.sandra.web.action.loading.model.LoadingTable;
import com.cybelia.sandra.web.action.tour.StepsHelper;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.nuiton.topia.TopiaException;

/**
 * @author chemit
 */
public class ChargementUsineAction extends CommonMappingDispatchAction {

    public ActionForward view(ActionMapping mapping, ChargementUsineForm form,
                              HttpServletRequest request, HttpServletResponse response,
                              ApplicationSession applicationSession, ServiceWeb serviceWeb) throws Exception {

        String topiaId = form.getUsineTopiaId();
        if (StringUtils.isNotBlank(topiaId)) {

            ChargementUsineConfig config = serviceWeb.getChargementUsineConfigForUsine(null, topiaId);

            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date());
            calendar.set(Calendar.SECOND, 0);
            calendar.set(Calendar.MILLISECOND, 0);

            if (UtilAction.isNotEmptyParameter(request, "year")) {
                int year = UtilAction.getParameterInt(request, "year");
                int month = UtilAction.getParameterInt(request, "month");
                int date = UtilAction.getParameterInt(request, "date");
                int hour = UtilAction.getParameterInt(request, "hour");
                int minute = UtilAction.getParameterInt(request, "minute");
                calendar.set(year, month, date, hour, minute);
            }
            Date currentDate = calendar.getTime();
            LoadingTable model = new LoadingTable(currentDate);

            // form was previously load, so the config is already inside
            form.fromBean(config, model);

            // must fill the form with chargements, tours, camions, ,...
            buildModel(form, serviceWeb);
        }

        return mapping.findForward(SUCCESS_FORWARD);
    }

    public ActionForward drawCellule(ActionMapping mapping, ActionForm form,
                                     HttpServletRequest request,
                                     HttpServletResponse response,
                                     ApplicationSession applicationSession, ServiceWeb serviceWeb) throws Exception {
        response.setContentType("image/jpeg");
        int statutStr = UtilAction.getParameterInt(request, "statut");

        StatutEnum statut = StatutEnum.valueOfFromCode(statutStr);

        int numero = UtilAction.getParameterInt(request, "numero");
        long startingDate = UtilAction.getParameterLong(request, "startingDate");
        int delay = UtilAction.getParameterInt(request, "delay");
        int nbHours = UtilAction.getParameterInt(request, "nbHours");
        BufferedImage image = buildImage(statut, numero, new Date(startingDate), nbHours, delay, 30);

        ImageIO.write(image, "gif", response.getOutputStream());

        return null;
    }

    protected void buildModel(ChargementUsineForm form, ServiceWeb serviceWeb) throws LogicException, TopiaException {
        LoadingTable model = form.getModel();

        // obtain tours between startingDate and endingDate
        List<Tour> tours = serviceWeb.getLoading(null, model.getStartingDate(), model.getEndingDate(), form.getUsineTopiaId());

        // init rows in model
        model.initRows();

        // add loading for each camion
        StepsHelper.getSteps(tours, model);
    }

    protected BufferedImage buildImage(StatutEnum statut, int numero, Date startingDate, int nbHours, int delay, int height) throws Exception {
        // 900px = nbHours
        int size = (15 * delay) / nbHours;

        BufferedImage image = new BufferedImage(size, height, BufferedImage.TYPE_INT_RGB);
        Graphics2D g2 = image.createGraphics();

        // g2.setBackground(Color.RED); Ne fonctionne pas, l'image reste noir
        g2.setPaint(statut.getColor());
        g2.fillRect(0, 0, size, height);

        // compute center size 
        g2.setPaint(Color.WHITE);
        g2.drawString(numero + "", 1, 2 * height / 3);

        // border
        g2.setPaint(Color.BLACK);
        g2.drawRect(0, 0, size - 1, height - 1);

        return image;
    }
}
