package com.cybelia.sandra.web.action.loading;

import com.cybelia.sandra.entities.LigneProduit;
import com.cybelia.sandra.entities.Tour;
import com.cybelia.sandra.services.ServiceWeb;
import com.cybelia.sandra.web.action.CommonMappingDispatchAction;
import com.cybelia.sandra.web.action.ServiceFactory;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

/**
 * @author chemit
 */
public class ChargementTourAction extends CommonMappingDispatchAction {

    protected Object[] getArgs(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return new Object[]{mapping, form, request, ServiceFactory.newServiceWeb()};
    }

    public ActionForward view(ActionMapping mapping, ChargementTourForm form,
                              HttpServletRequest request, ServiceWeb serviceWeb) throws Exception {


        List<LigneProduit> produits = serviceWeb.getProduitsLoading(null, form.getUsineTopiaId(), form.getTourTopiaId());
        request.setAttribute("produits", produits);

        Tour tour = serviceWeb.getTour(null, form.getTourTopiaId());
        request.setAttribute("tour", tour);

        return mapping.findForward(SUCCESS_FORWARD);
    }

    public ActionForward save(ActionMapping mapping, ChargementTourForm form,
                              HttpServletRequest request, ServiceWeb serviceWeb) throws Exception {

        String[] topiaIds = form.getProduitsTopiaId();
        boolean[] disponibles = form.getProduitsStatut();
        boolean allStatut = form.getProduitsAllStatut();

        for (int index = 0; index < topiaIds.length; index++) {
            String topiaId = topiaIds[index];
            boolean disponible = disponibles[index];
            serviceWeb.saveProduitDisponible(null, topiaId, disponible | allStatut);
        }

        return mapping.findForward(SUCCESS_FORWARD);
    }
}
