package com.cybelia.sandra.web.action.breeder;

import com.cybelia.sandra.entities.Eleveur;
import com.cybelia.sandra.entities.Note;
import com.cybelia.sandra.services.ServiceWeb;
import com.cybelia.sandra.web.action.ServiceFactory;
import com.cybelia.sandra.web.action.UtilAction;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DownloadAction;

public class NoteAction extends com.cybelia.sandra.web.action.CommonMappingDispatchAction {

    @Override
    protected Object[] getArgs(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return new Object[]{mapping, form, request, response, ServiceFactory.newServiceWeb()};
    }

    public ActionForward newNote(ActionMapping mapping, NoteForm form,
                                 HttpServletRequest request, HttpServletResponse response,
                                 ServiceWeb serviceWeb) throws Exception {
        String topiaId = UtilAction.getParameterString(request, "breederTopiaId");
        Eleveur eleveur = serviceWeb.getEleveur(null, topiaId);

        form.fromBean(eleveur);
        return mapping.findForward(SUCCESS_FORWARD);
    }

    public ActionForward view(ActionMapping mapping, NoteForm form,
                              HttpServletRequest request, HttpServletResponse response,
                              ServiceWeb serviceWeb) throws Exception {
        String topiaId = UtilAction.getParameterString(request, "note");
        Note note = serviceWeb.getNote(null, topiaId);
        form.fromBean(note);
        return mapping.findForward(SUCCESS_FORWARD);
    }

    public ActionForward delete(ActionMapping mapping, ActionForm form,
                                HttpServletRequest request, HttpServletResponse response,
                                ServiceWeb serviceWeb) throws Exception {
        String topiaId = UtilAction.getParameterString(request, "note");

        Note note = serviceWeb.getNote(null, topiaId);
        request.setAttribute("topiaId", note.getEleveur().getTopiaId());

        serviceWeb.deleteNote(null, topiaId);

        return mapping.findForward(SUCCESS_FORWARD);
    }

    public ActionForward save(ActionMapping mapping, NoteForm form,
                              HttpServletRequest request, HttpServletResponse response,
                              ServiceWeb serviceWeb) throws Exception {

        Note note = form.toBean();
        InputStream inputStream = form.getInputStream();
        note = serviceWeb.saveNote(null, note, inputStream);

        form.fromBean(note);
        serviceWeb.addNote(null, form.getBreederTopiaId(), form.getTopiaId());

        request.setAttribute("topiaId", form.getBreederTopiaId());
        return mapping.findForward(SUCCESS_FORWARD);
    }

    public ActionForward image(ActionMapping mapping, NoteForm form,
                               HttpServletRequest request, HttpServletResponse response,
                               ServiceWeb serviceWeb) throws Exception {
        String topiaId = UtilAction.getParameterString(request, "note");
        int width = UtilAction.getParameterInt(request, "width");
        int height = UtilAction.getParameterInt(request, "height");

        Note note = serviceWeb.getNote(null, topiaId);
        String nom = note.getNom();
        String contentType = note.getContentType();

        response.setContentType(contentType);
        response.setHeader("Content-disposition",
                "attachment; filename=" + nom);

        if (contentType.startsWith("image/")) {
            InputStream file = serviceWeb.getFileNote(null, topiaId);
            BufferedImage image = ImageIO.read(file);
            BufferedImage buffer = UtilAction.scale(image, width, height);
            ImageIO.write(buffer, contentType.replaceFirst("image/", ""), response.getOutputStream());
        }

        return null;
    }

    public ActionForward download(ActionMapping mapping, ActionForm form,
                                  HttpServletRequest request, HttpServletResponse response,
                                  final ServiceWeb serviceWeb) throws Exception {
        DownloadAction downloadAction = new DownloadAction() {
            @Override
            protected StreamInfo getStreamInfo(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
                final String topiaId = UtilAction.getParameterString(request, "note");
                Note note = serviceWeb.getNote(null, topiaId);

                final String nom = note.getNom();
                final String contentType = note.getContentType();

                response.setHeader("Content-disposition",
                        "attachment; filename=" + nom);

                return new StreamInfo() {
                    @Override
                    public InputStream getInputStream() throws IOException {
                        try {
                            return serviceWeb.getFileNote(null, topiaId);
                        } catch (Exception ex) {
                            throw new IOException(ex);
                        }
                    }

                    @Override
                    public String getContentType() {
                        return contentType;
                    }
                };
            }
        };
        return downloadAction.execute(mapping, form, request, response);
    }
}
