/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.cybelia.sandra.web.action.breeder;

import com.cybelia.sandra.entities.InfoAccess;
import com.cybelia.sandra.entities.sig.PointGPS;
import com.cybelia.sandra.entities.sig.TraceGPS;
import com.cybelia.sandra.web.action.UtilAction;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;

/**
 * @author letellier
 */
public class InfoAccessForm extends ActionForm {

    private static final long serialVersionUID = 1L;

    static public int GPS_KO = 0;
    static public int GPS_OK_NOT_LOKED = 1;
    static public int GPS_OK_LOCKED = 2;

    protected String topiaId;
    protected String accesSilo;
    protected String modeChargement;
    protected String nomAccess;
    protected int type;
    protected int niveauSecurite;
    protected String commentSecurite;
    protected String[] risques;
    protected int etat;
    protected PointGPS gps;
    protected TraceGPS traceGPS;
    protected boolean existingGPS;
    protected String eleveurTopiaId;
    protected double latitude;
    protected double longitude;

    public InfoAccessForm() {
        latitude = 0;
        longitude = 0;
    }

    public String getEleveurTopiaId() {
        return eleveurTopiaId;
    }

    public void setEleveurTopiaId(String eleveurTopiaId) {
        this.eleveurTopiaId = eleveurTopiaId;
    }

    public TraceGPS getTraceGPS() {
        return traceGPS;
    }

    public void setTraceGPS(TraceGPS traceGPS) {
        this.traceGPS = traceGPS;
    }

    public PointGPS getGps() {
        return gps;
    }

    public void setGps(PointGPS gps) {
        this.gps = gps;
    }

    public String getAccesSilo() {
        return accesSilo;
    }

    public void setAccesSilo(String accesSilo) {
        this.accesSilo = accesSilo;
    }

    public String getCommentSecurite() {
        return commentSecurite;
    }

    public void setCommentSecurite(String commentSecurite) {
        this.commentSecurite = commentSecurite;
    }

    public String getModeChargement() {
        return modeChargement;
    }

    public void setModeChargement(String modeChargement) {
        this.modeChargement = modeChargement;
    }

    public int getNiveauSecurite() {
        return niveauSecurite;
    }

    public void setNiveauSecurite(int niveauSecurite) {
        this.niveauSecurite = niveauSecurite;
    }

    public String getNomAccess() {
        return nomAccess;
    }

    public void setNomAccess(String nomAccess) {
        this.nomAccess = nomAccess;
    }

    public String[] getRisques() {
        return risques;
    }

    public void setRisques(String[] risques) {
        this.risques = risques;
    }

    public int getEtat() {
        return etat;
    }

    public void setEtat(int etat) {
        this.etat = etat;
    }

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getTopiaId() {
        return topiaId;
    }

    public void setTopiaId(String topiaId) {
        this.topiaId = topiaId;
    }

    public double getLatitude() {
        return latitude;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public double getLongitude() {
        return longitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public boolean isHasTomTomGPS() {
        return !(getLatitude() == 0 && getLongitude() == 0);
    }

    protected List<String> getListRisques() {
        List<String> result = new ArrayList<String>();
        if (getRisques() != null) {
            for (String s : getRisques()) {
                result.add(s);
            }
        }
        return result;
    }

    @Override
    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();

        UtilAction.checkRequiredField(request, errors, "topiaId", "error.securite.required");

        return errors;
    }

    public Point getPoint() {
        GeometryFactory geometryFactory = new GeometryFactory();
        Coordinate coordinate = new Coordinate(getLongitude(), getLatitude());
        return geometryFactory.createPoint(coordinate);
    }

    public void fromBean(InfoAccess bean) {
        setTopiaId(bean.getTopiaId());
        setAccesSilo(bean.getAccesSilo());
        setCommentSecurite(bean.getCommentaireSecurite());
        setModeChargement(bean.getModeChargement());
        setNiveauSecurite(bean.getNiveauSecurite());
        setNomAccess(bean.getNomAcces());
        risques = bean.getRisques().toArray(new String[0]);
        setEtat(bean.getEtat());
        setType(bean.getType());
        setGps(bean.getGps());
        if (bean.getGps() != null) {
            setLongitude(bean.getGps().getPoint().getX());
            setLatitude(bean.getGps().getPoint().getY());
        } else {
            setLatitude(0);
            setLongitude(0);
        }
    }

    public InfoAccess toBean() {
        InfoAccess bean = new com.cybelia.sandra.entities.InfoAccessImpl();

        bean.setTopiaId(getTopiaId());
        bean.setAccesSilo(getAccesSilo());
        bean.setCommentaireSecurite(getCommentSecurite());
        bean.setGps(getGps());
        bean.setModeChargement(getModeChargement());
        bean.setNiveauSecurite(getNiveauSecurite());
        bean.setNomAcces(getNomAccess());
        bean.setRisques(getListRisques());
        bean.setEtat(getEtat());
        bean.setTrace(getTraceGPS());
        bean.setType(getType());

        PointGPS pointGPS = new com.cybelia.sandra.entities.sig.PointGPSImpl();
        pointGPS.setPoint(getPoint());
        bean.setGps(pointGPS);

        return bean;
    }

}
