package com.cybelia.sandra.web.action.breeder;

import com.cybelia.sandra.entities.ActionSecurite;
import com.cybelia.sandra.entities.Eleveur;
import com.cybelia.sandra.services.ServiceWeb;
import com.cybelia.sandra.web.action.ServiceFactory;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class BreederAction extends com.cybelia.sandra.web.action.CommonMappingDispatchAction {

    @Override
    protected Object[] getArgs(ActionMapping mapping, ActionForm form,
                               HttpServletRequest request, HttpServletResponse response) throws Exception {
        return new Object[]{mapping, form, request, ServiceFactory.newServiceWeb()};
    }

    public ActionForward select(ActionMapping mapping, BreederForm form,
                                HttpServletRequest request, ServiceWeb serviceWeb) throws Exception {
        String topiaId = request.getParameter("topiaId");
        if (StringUtils.isNotBlank(topiaId)) {
            topiaId = (String)request.getAttribute("breederTopiaId");
        }
        if (StringUtils.isNotBlank(topiaId)) {
            Eleveur eleveur = serviceWeb.getEleveur(null, topiaId);
            form.fromBean(eleveur);
            request.setAttribute("breederTopiaId", eleveur.getTopiaId());
            return mapping.findForward(SUCCESS_FORWARD);
        } else {
            return view(mapping, form, request, serviceWeb);
        }
    }

    public ActionForward view(ActionMapping mapping, BreederForm form,
                              HttpServletRequest request, ServiceWeb serviceWeb) throws Exception {
        String topiaId = request.getParameter("topiaId");
        if (StringUtils.isBlank(topiaId)) {
            topiaId = (String)request.getAttribute("topidaId");
        }
        if (StringUtils.isNotBlank(topiaId)) {
            Eleveur eleveur = serviceWeb.getEleveur(null, topiaId);
            form.fromBean(eleveur);
            request.setAttribute("breederTopiaId", eleveur.getTopiaId());
            List<ActionSecurite> actions = listActionLess(eleveur);
            request.setAttribute("actions", actions);
        }
        return mapping.findForward(SUCCESS_FORWARD);
    }

    public ActionForward edit(ActionMapping mapping, BreederForm form,
                              HttpServletRequest request, ServiceWeb serviceWeb) throws Exception {
        String topiaId = request.getParameter("topiaId");
        if (StringUtils.isNotBlank(topiaId)) {
            Eleveur eleveur = serviceWeb.getEleveur(null, topiaId);
            form.fromBean(eleveur);
            request.setAttribute("breederTopiaId", eleveur.getTopiaId());
        }
        return mapping.findForward(SUCCESS_FORWARD);
    }

    public ActionForward save(ActionMapping mapping, BreederForm form,
                              HttpServletRequest request, ServiceWeb serviceWeb) throws Exception {
        if (StringUtils.isNotBlank(form.getTopiaId())) {
            Eleveur eleveur = form.toBean();
            form.fromBean(serviceWeb.saveEleveur(null, eleveur));
        }
        return mapping.findForward(SUCCESS_FORWARD);
    }

    public ActionForward saveGPS(ActionMapping mapping, BreederForm form,
                                 HttpServletRequest request, ServiceWeb serviceWeb) throws Exception {
        serviceWeb.saveEleveurGPS(null, form.getTopiaId(), form.getPoint());
        return mapping.findForward(SUCCESS_FORWARD);
    }

    public ActionForward lockGPS(ActionMapping mapping, BreederForm form,
                                 HttpServletRequest request, ServiceWeb serviceWeb) throws Exception {
        if (StringUtils.isNotBlank(form.getTopiaId())) {
            serviceWeb.lockEleveurGPS(null, form.getTopiaId(), !form.isTomTomGPSLocked());
        }
        return mapping.findForward(SUCCESS_FORWARD);
    }

    public ActionForward requestGPS(ActionMapping mapping, BreederForm form,
                                    HttpServletRequest request, ServiceWeb serviceWeb) throws Exception {
        if (StringUtils.isNotBlank(form.getTopiaId())) {
            serviceWeb.requestToUnlockBreeder(null, form.getTopiaId());
        }
        return mapping.findForward(SUCCESS_FORWARD);
    }

    public ActionForward sendDangerousBreederEmail(ActionMapping mapping, BreederForm form,
                                    HttpServletRequest request, final ServiceWeb serviceWeb) throws Exception {

        Thread notif = new Thread(new Runnable() {

            @Override
            public void run() {
                try {
                    serviceWeb.sendFindDangerousBreeder(null);
                } catch (Exception eee) {
                    log.error("Failled to send dangerous breeder notification : ", eee);
                }
            }
        });

        notif.start();

        return mapping.findForward(SUCCESS_FORWARD);
    }

    public List<ActionSecurite> listActionLess(Eleveur eleveur) throws Exception {
        List<ActionSecurite> actions = ActionSecurityAction.getActions(eleveur);
        List<ActionSecurite> actionsLess = new ArrayList<ActionSecurite>();
        for (int i = 0; i < 3; i++) {
            if (actions.size() > i) {
                actionsLess.add(actions.get(i));
            }
        }
        return actionsLess;
    }
}
