package com.cybelia.sandra.web.action.breeder;

import com.cybelia.sandra.entities.ActionSecurite;
import com.cybelia.sandra.entities.Eleveur;
import com.cybelia.sandra.services.ServiceHelper;
import com.cybelia.sandra.services.ServiceWeb;
import com.cybelia.sandra.web.action.ServiceFactory;
import com.cybelia.sandra.web.action.UtilAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.nuiton.topia.taas.entities.TaasUser;

public class ActionSecurityAction extends com.cybelia.sandra.web.action.CommonMappingDispatchAction {

    protected Eleveur cachedEleveur;
    @Override
    protected Object[] getArgs(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return new Object[]{mapping, form, request, response, ServiceFactory.newServiceWeb()};
    }

    public ActionForward newActionSecurity(ActionMapping mapping, ActionSecurityForm form,
                                 HttpServletRequest request, HttpServletResponse response,
                                 ServiceWeb serviceWeb) throws Exception {

        String topiaId = UtilAction.getParameterString(request, "breederTopiaId");
        Eleveur eleveur = serviceWeb.getEleveur(null, topiaId);

        form.fromBean(eleveur);

        request.setAttribute("action", form.toBean());
        request.setAttribute("breederTopiaId", topiaId);
        request.setAttribute("breeder", eleveur);

        cachedEleveur = eleveur;
        return mapping.findForward(SUCCESS_FORWARD);
    }

    public ActionForward list(ActionMapping mapping, ActionSecurityForm form,
                              HttpServletRequest request, HttpServletResponse response,
                              ServiceWeb serviceWeb) throws Exception {

        String topiaId = request.getParameter("breederTopiaId");
        Eleveur eleveur = serviceWeb.getEleveur(null, topiaId);
        List<ActionSecurite> actions = getActions(eleveur);
        request.setAttribute("actions", actions);
        request.setAttribute("breederTopiaId", topiaId);
        request.setAttribute("breeder", eleveur);
        return mapping.findForward(SUCCESS_FORWARD);
    }

    public ActionForward view(ActionMapping mapping, ActionSecurityForm form,
                              HttpServletRequest request, HttpServletResponse response,
                              ServiceWeb serviceWeb) throws Exception {

        String topiaId = UtilAction.getParameterString(request, "topiaId");
        ActionSecurite action = serviceWeb.getActionSecurite(null, topiaId);
        form.fromBean(action);

        Eleveur eleveur = action.getEleveur();
        request.setAttribute("action", action);
        request.setAttribute("breederTopiaId", eleveur.getTopiaId());
        request.setAttribute("breeder", eleveur);

        cachedEleveur = eleveur;
        return mapping.findForward(SUCCESS_FORWARD);
    }

    public ActionForward delete(ActionMapping mapping, ActionSecurityForm form,
                                HttpServletRequest request, HttpServletResponse response,
                                ServiceWeb serviceWeb) throws Exception {

        String topiaId = UtilAction.getParameterString(request, "topiaId");

        serviceWeb.deleteActionSecurite(null, topiaId);

        String eleveurTopiaId = form.getEleveurTopiaId();
        if (eleveurTopiaId == null) {
            eleveurTopiaId = cachedEleveur.getTopiaId();
        }

        Eleveur eleveur = serviceWeb.getEleveur(null, eleveurTopiaId);
        if (eleveur == null) {
            eleveur = cachedEleveur;
        }
        
        request.setAttribute("actions", eleveur.getActionSecurite());
        request.setAttribute("breederTopiaId", eleveur.getTopiaId());
        request.setAttribute("breeder", eleveur);
        return mapping.findForward(SUCCESS_FORWARD);
    }
    
    public ActionForward requestToDelete(ActionMapping mapping, ActionSecurityForm form,
                                HttpServletRequest request, HttpServletResponse response,
                                ServiceWeb serviceWeb) throws Exception {

        TaasUser user = ServiceFactory.newServiceWeb().getUser();
        ServiceFactory.newServiceNotifier().notifyEvent("requestToDeleteAction",
                ServiceHelper.getSandraName(),
                ServiceHelper.getSandraUrl(),
                user.getLogin(),
                form.getEleveurTopiaId(),
                form.getInfoAccessTopiaId(),
                form.getTopiaId());

        String eleveurTopiaId = form.getEleveurTopiaId();
        if (eleveurTopiaId == null) {
            eleveurTopiaId = cachedEleveur.getTopiaId();
        }

        Eleveur eleveur = serviceWeb.getEleveur(null, eleveurTopiaId);
        if (eleveur == null) {
            eleveur = cachedEleveur;
        }

        request.setAttribute("actions", eleveur.getActionSecurite());
        request.setAttribute("breederTopiaId", eleveur.getTopiaId());
        request.setAttribute("breeder", eleveur);
        return mapping.findForward(SUCCESS_FORWARD);
    }
      
    public ActionForward save(ActionMapping mapping, ActionSecurityForm form,
                              HttpServletRequest request, HttpServletResponse response,
                              ServiceWeb serviceWeb) throws Exception {

        String breederTopiaId = form.getEleveurTopiaId();
        String siloTopiaId = form.getInfoAccessTopiaId();

        ActionSecurite action = form.toBean();

        action = serviceWeb.saveActionSecurite(null, action, breederTopiaId, siloTopiaId);

        form.fromBean(action);

        Eleveur eleveur = action.getEleveur();
        request.setAttribute("action", action);
        request.setAttribute("breederTopiaId", eleveur.getTopiaId());

        request.setAttribute("breeder", eleveur);

        cachedEleveur = eleveur;
        return mapping.findForward(SUCCESS_FORWARD);
    }

    public static List<ActionSecurite> getActions(Eleveur eleveur) {
        List<ActionSecurite> actions = new ArrayList<ActionSecurite>(eleveur.getActionSecurite());
        Collections.sort(actions, new Comparator<ActionSecurite>(){
            @Override
            public int compare(ActionSecurite o1, ActionSecurite o2) {

                return o1.getDateAction().compareTo(o2.getDateAction());
            }
        });
        return actions;
    }
}
