package com.cybelia.sandra.web.action;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMessage;

public class UtilAction {

    public static int getParameterInt(HttpServletRequest request, String name) throws BadInputException {
        String value = request.getParameter(name);
        try {
            return Integer.parseInt(value);
        } catch (NumberFormatException nfe) {
            throw new BadInputException("invalid.parameter.int", nfe);
        }
    }

    public static long getParameterLong(HttpServletRequest request, String name) throws BadInputException {
        String value = request.getParameter(name);
        try {
            return Long.parseLong(value);
        } catch (NumberFormatException nfe) {
            throw new BadInputException("invalid.parameter.long", nfe);
        }
    }

    public static boolean getParameterBoolean(HttpServletRequest request, String name) throws BadInputException {
        String value = request.getParameter(name);
        try {
            return Boolean.parseBoolean(value);
        } catch (NumberFormatException nfe) {
            throw new BadInputException("invalid.parameter.boolean", nfe);
        }
    }

    public static String getParameterString(HttpServletRequest request, String name) throws BadInputException {
        String value = request.getParameter(name);
        return value.trim();
    }

    public static boolean isEmptyParameter(HttpServletRequest request, String name) throws BadInputException {
        String value = request.getParameter(name);
        return StringUtils.isBlank(value);
    }

    public static boolean isNotEmptyParameter(HttpServletRequest request, String name) throws BadInputException {
        return !isEmptyParameter(request, name);
    }

    /**
     * Check if a field (in request) is present and not empty, otherwise add
     * an error in <code>errors</code> container.
     *
     * @param request current request
     * @param errors  errors container
     * @param field   field to check
     * @param error   error i18n code
     * @return <code>true</code> if field was found, <code>flase</code> otherwise.
     */
    public static boolean checkRequiredField(HttpServletRequest request, ActionErrors errors, String field, String error) {
        if (StringUtils.isBlank(request.getParameter(field))) {
            errors.add(field, new ActionMessage(error));
            return false;
        }
        return true;
    }

    /**
     * Modification des tailles d'une image
     */
    public static BufferedImage scale(BufferedImage source, int width, int height) {
        /* On crée une nouvelle image aux bonnes dimensions. */
        double sourceHeight = source.getHeight();
        double sourceWidth = source.getWidth();
        double ratio = sourceHeight / sourceWidth;

        if (sourceHeight < sourceWidth && sourceWidth > width) {
            height = (int) (width * ratio);
        }
        if (sourceHeight > sourceWidth && sourceHeight > height) {
            width = (int) (height / ratio);
        }

        BufferedImage buf = new BufferedImage(width, height, BufferedImage.TYPE_INT_RGB);

        /* On dessine sur le Graphics de l'image bufferisée. */
        Graphics2D g = buf.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.drawImage(source, 0, 0, width, height, null);
        g.dispose();

        /* On retourne l'image bufferisée, qui est une image. */
        return buf;
    }

    /**
     * Check if a field (in request) is an integer
     *
     * @param request current request
     * @param errors  errors container
     * @param field   field to check
     * @param error   error i18n code
     * @return the value of integer grabbed in request, or <code>null</code> if field is not an integer
     */
    public static Integer checkIntegerField(HttpServletRequest request, ActionErrors errors, String field, String error) {
        String tmp = request.getParameter(field);
        if (tmp == null) {
            return null;
        }
        Integer value;
        try {
            value = Integer.parseInt(tmp.trim());
        } catch (NumberFormatException e) {
            errors.add(field, new ActionMessage(error));
            value = null;
        }
        return value;
    }

    public static class BadInputException extends Exception {
        static final long serialVersionUID = 1L;

        public BadInputException(String msg) {
            super(msg);
        }

        private BadInputException(String string, NumberFormatException nfe) {
            super(string, nfe);
        }
    }

    public static Properties loadProperties(String propertiesPath) {
        InputStream stream = null;
        Properties data = null;
        try {
            stream = UtilAction.class.getResourceAsStream(propertiesPath);
            data = new Properties();
            data.load(stream);
        } catch (IOException ex) {
            Logger.getLogger(UtilAction.class.getName()).log(Level.SEVERE, null, ex);
        } finally {
            try {
                stream.close();
            } catch (IOException ex) {
                Logger.getLogger(UtilAction.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return data;
    }
}
