package com.cybelia.sandra.web.action;

import com.cybelia.sandra.SandraConfig;
import com.cybelia.sandra.services.ServiceHelper;
import com.cybelia.sandra.services.ServiceNotifier;
import com.cybelia.sandra.services.ServiceSchedule;
import com.cybelia.sandra.services.ServiceWeb;
import java.util.Properties;

/**
 * @author chemit
 */
public class ServiceFactory {

    protected static boolean local = true;

    /**
     * @param local <ocde>true</code> si on veut toujours utiliser des
     *              instances de services locaux, <code>false</code> autrement.
     */
    public static void setLocal(boolean local) {
        ServiceFactory.local = local;
    }

    /**
     * @return une instance du {@link ServiceWeb} locale si la variable
     *         {@link #local} est positionnee a <code>true</code>, distant sinon.
     */
    public static ServiceWeb newServiceWeb() {
        return local ? newLocalService(ServiceWeb.class) : newRemoteService(ServiceWeb.class);
    }

    /**
     * @return une instance du {@link ServiceWeb} locale si la variable
     *         {@link #local} est positionnee a <code>true</code>, distant
     *         sinon avec un context de securite pour l'utilisateur <code>guest</code>.
     */
    public static ServiceWeb newServiceGuest() {
        Properties env = SandraConfig.getConfig().getFlatOptions();
        return local ? ServiceHelper.newLocalService(ServiceWeb.class, env) : ServiceHelper.newRemoteService(ServiceWeb.class, env);
    }

    /**
     * @return une instance du {@link ServiceNotifier} locale si la
     *         variable {@link #local} est positionnee
     *         a <code>true</code>, distant sinon.
     */
    public static ServiceNotifier newServiceNotifier() {
        return local ? newLocalService(ServiceNotifier.class) : newRemoteService(ServiceNotifier.class);
    }

    public static ServiceSchedule newServiceSchedule() {
        return local ? newLocalService(ServiceSchedule.class) : newRemoteService(ServiceSchedule.class);
    }

    /**
     * Recupere une instance d'un service local donne par sa classe de contrat
     * sans contexte d'environnement.
     *
     * @param klass la classe du service recherche
     * @return une instance du service local recherche.
     */
    public static <S> S newLocalService(Class<S> klass) {
        return ServiceHelper.newLocalService(klass);
    }

    /**
     * Recupere une instance d'un service distant donne par sa classe de contrat
     * sans context d'environnement.
     *
     * @param klass la classe du service recherche
     * @return une instance du service distant recherche.
     */
    public static <S> S newRemoteService(Class<S> klass) {
        return ServiceHelper.newRemoteService(klass);
    }
}
