package com.cybelia.sandra.web.action;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.MappingDispatchAction;

/**
 * @author chemit
 */
public abstract class CommonMappingDispatchAction extends MappingDispatchAction {

    public final static String SUCCESS_FORWARD = "success";
    public final static String ERROR_FORWARD = "error";
    public final static String NEW_FORWARD = "new";
    public final static String MODIFY_FORWARD = "modify";

    protected Log log = LogFactory.getLog(getClass());

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form,
                                 HttpServletRequest request, HttpServletResponse response)
            throws Exception {
        long t0 = System.nanoTime();
        logdebug("######################################################################## begin");
        // init cache
        ApplicationSession.get(request);
        ActionForward forward = super.execute(mapping, form, request, response);

        logdebug("######################################################################## end   (" + org.nuiton.util.StringUtil.convertTime(System.nanoTime() - t0) + ")");
        return forward;
    }

    /**
     * Build the array of parameters to be used on an action method.
     * <p/>
     * <b>Note : All methods of a given action must have the same prototype.</b>
     *
     * @param mapping  current mapping
     * @param form     current form
     * @param request  current request
     * @param response current response
     * @return the parameters to be
     * @throws Exception if any pb while building te array of parameters
     */
    protected Object[] getArgs(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return new Object[]{mapping, form, request, response, ApplicationSession.get(request), ServiceFactory.newServiceWeb()};
    }


    /**
     * Dispatch to the specified method.
     * <p/>
     * Override to allow us to customize the prototype parameters.
     *
     * @since Struts 1.1
     */
    @Override
    protected ActionForward dispatchMethod(ActionMapping mapping,
                                           ActionForm form,
                                           HttpServletRequest request,
                                           HttpServletResponse response,
                                           String name) throws Exception {

        // Make sure we have a valid method name to call.
        // This may be null if the user hacks the query string.
        if (name == null) {
            return this.unspecified(mapping, form, request, response);
        }

        // Identify the method object to be dispatched to
        Method method;
        try {
            method = getMethod(name);

        } catch (NoSuchMethodException e) {
            String message =
                    messages.getMessage("dispatch.method", mapping.getPath(), name);
            log.error(message, e);
            throw e;
        }

        ActionForward forward;
        try {
            //logdebug("prototype : " + Arrays.toString(types));
            Object args[] = getArgs(mapping, form, request, response);
            logdebug("parameter : " + Arrays.toString(args));
            forward = (ActionForward) method.invoke(this, args);

        } catch (ClassCastException e) {
            String message =
                    messages.getMessage("dispatch.return", mapping.getPath(), name);
            log.error(message, e);
            throw e;

        } catch (IllegalAccessException e) {
            String message =
                    messages.getMessage("dispatch.error", mapping.getPath(), name);
            log.error(message, e);
            throw e;

        } catch (InvocationTargetException e) {
            // Rethrow the target exception if possible so that the
            // exception handling machinery can deal with it
            Throwable t = e.getTargetException();
            if (t instanceof Exception) {
                throw ((Exception) t);
            } else {
                String message =
                        messages.getMessage("dispatch.error", mapping.getPath(), name);
                log.error(message, e);
                throw new ServletException(t);
            }
        }

        // Return the returned ActionForward instance
        return (forward);
    }

    /**
     * Introspect the current class to identify a method of the specified
     * name that accepts the same parameter types as the <code>execute</code>
     * method does.
     *
     * @param name Name of the method to be introspected
     * @throws NoSuchMethodException if no such method can be found
     */
    @Override
    protected Method getMethod(String name)
            throws NoSuchMethodException {

        synchronized (methods) {
            Method method = (Method) methods.get(name);
            if (method == null) {
                // find out all methods
                for (Method method1 : clazz.getMethods()) {
                    if (method1.getName().equals(name)) {
                        method = method1;
                        break;
                    }
                }
                if (method == null) {
                    throw new IllegalArgumentException("could not find method " + name + " in " + clazz);
                }
                //method = clazz.getMethod(name, types);
                methods.put(name, method);
            }
            return (method);
        }

    }

    protected void loginfo(String msg) {
        if (log.isInfoEnabled()) {
            log.info(msg);
        }
    }

    protected void logdebug(String msg) {
        if (log.isDebugEnabled()) {
            log.debug(msg);
        }
    }
}
