package com.cybelia.sandra.web;

import com.cybelia.sandra.SandraHelper;
import com.cybelia.sandra.services.ServiceHelper;
import com.cybelia.sandra.services.ServiceNotifier;
import com.cybelia.sandra.web.action.ServiceFactory;
import java.util.Date;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaException;

/**
 * @author sletellier <letellier@codelutin.com>
 */
public class SandraApplicationListener implements ServletContextListener {

    protected static final Log log = LogFactory.getLog(SandraApplicationListener.class);

    @Override
    public void contextInitialized(ServletContextEvent servletContextEvent) {

        if (log.isInfoEnabled()) {
            log.info("Application starting at " + new Date() + "...");
        }

        // Init security
        try {
            ServiceNotifier serviceNotifier = ServiceFactory.newServiceNotifier();

            // Initialisation des notifiers
            serviceNotifier.init(null);
        } catch (Exception eee) {
            log.error("Failed to init notifier", eee);
        }
    }

    @Override
    public void contextDestroyed(ServletContextEvent servletContextEvent) {

        if (log.isInfoEnabled()) {
            log.info("Application is ending at " + new Date() + "...");
        }

        try {
            ServiceNotifier serviceNotifier = ServiceFactory.newServiceNotifier();
            serviceNotifier.notifyEvent("jbossHalt",
                    ServiceHelper.getSandraName(),
                    ServiceHelper.getSandraUrl(),
                    SandraHelper.convertDateToString(new Date()));

        } catch (TopiaException eee) {
            log.error("Cant send jboss halt notification, caused by : ", eee);
        }
    }
}
