/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra.services.ejb3;

import com.cybelia.sandra.SandraConfigHelper;
import com.cybelia.sandra.services.ejb3.BaseServiceImpl;
import com.cybelia.sandra.services.ejb3.Transaction;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import javax.interceptor.AroundInvoke;
import javax.interceptor.InvocationContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;

public class TransactionManager {
    static Log log = LogFactory.getLog(TransactionManager.class);
    protected TopiaContext rootContext;
    protected TopiaContext unsecureRootContext;

    @AroundInvoke
    public Object manageTrasaction(InvocationContext context) throws Exception {
        TopiaContext transaction;
        Method method = context.getMethod();
        if (!method.isAnnotationPresent(Transaction.class)) {
            return context.proceed();
        }
        BaseServiceImpl baseService = (BaseServiceImpl)context.getTarget();
        Transaction transactionAnnotation = method.getAnnotation(Transaction.class);
        try {
            TopiaContext topiaContext;
            if (transactionAnnotation.secure()) {
                if (this.rootContext == null) {
                    this.rootContext = SandraConfigHelper.getServiceRootContext();
                }
                topiaContext = this.rootContext;
            } else {
                if (this.unsecureRootContext == null) {
                    this.unsecureRootContext = SandraConfigHelper.getServiceRootContext(false);
                }
                topiaContext = this.unsecureRootContext;
            }
            transaction = topiaContext.beginTransaction();
        }
        catch (TopiaException eee) {
            log.error((Object)"Failed to begin transaction", (Throwable)eee);
            throw eee;
        }
        try {
            Object result;
            Object[] parameters = context.getParameters();
            ArrayList<Object> parameterList = new ArrayList<Object>();
            parameterList.add(transaction);
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (parameterTypes != null && parameterTypes.length > 0 && parameterTypes[0].equals(TopiaContext.class)) {
                ArrayList<Object> list = new ArrayList<Object>(Arrays.asList(parameters));
                list.remove(0);
                parameterList.addAll(list);
            } else {
                ArrayList parameterTypesList = new ArrayList();
                parameterTypesList.add(TopiaContext.class);
                parameterTypesList.addAll(Arrays.asList(parameterTypes));
                method = method.getDeclaringClass().getMethod(method.getName(), parameterTypesList.toArray(new Class[parameterTypesList.size()]));
                parameterList.addAll(Arrays.asList(parameters));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Invoke " + method.getName() + " with params : " + Arrays.toString(parameterList.toArray())));
            }
            Object object = result = method.invoke((Object)baseService, parameterList.toArray());
            return object;
        }
        catch (Exception eee) {
            Log logger = LogFactory.getLog(context.getTarget().getClass());
            String errorMsg = transactionAnnotation.errorMsg();
            if (StringUtils.isEmpty((CharSequence)errorMsg)) {
                errorMsg = "Failled to execute method '" + method.getName() + "'";
            }
            transactionAnnotation.errorLevel().logError(logger, errorMsg, eee);
            throw eee;
        }
        finally {
            if (transactionAnnotation.close()) {
                try {
                    transaction = TransactionManager.closeTransaction(transaction, transactionAnnotation.commit());
                }
                catch (TopiaException eee) {
                    log.error((Object)"Failed to commit transaction", (Throwable)eee);
                }
            }
        }
    }

    public static TopiaContext beginTransaction() throws TopiaException, IOException {
        TopiaContext rootContext = SandraConfigHelper.getServiceRootContext();
        return rootContext.beginTransaction();
    }

    public static TopiaContext closeTransaction(TopiaContext transaction, boolean commit) throws TopiaException {
        if (transaction != null && !transaction.isClosed()) {
            if (commit) {
                transaction.commitTransaction();
            }
            transaction.closeContext();
        } else {
            log.warn((Object)"Context is already closed");
        }
        return transaction;
    }
}

