/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra.services.ejb3;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.apache.commons.logging.Log;
import org.apache.log4j.Level;

@Documented
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD})
public @interface Transaction {
    public boolean secure() default true;

    public boolean commit() default true;

    public boolean close() default true;

    public String errorMsg() default "";

    public LogLevel errorLevel() default LogLevel.ERROR;

    public static enum LogLevel {
        FATAL(Level.FATAL),
        ERROR(Level.ERROR),
        WARN(Level.FATAL),
        INFO(Level.INFO),
        DEBUG(Level.DEBUG),
        TRACE(Level.TRACE);

        protected Level logLevel;

        private LogLevel(Level logLevel) {
            this.logLevel = logLevel;
        }

        public void logError(Log log, String msg, Throwable eee) {
            switch (this) {
                case FATAL: {
                    if (log.isFatalEnabled()) {
                        log.fatal((Object)msg, eee);
                    }
                }
                case ERROR: {
                    if (log.isErrorEnabled()) {
                        log.error((Object)msg, eee);
                    }
                }
                case WARN: {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)msg, eee);
                    }
                }
                case INFO: {
                    if (log.isInfoEnabled()) {
                        log.info((Object)msg, eee);
                    }
                }
                case DEBUG: {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)msg, eee);
                    }
                }
                case TRACE: {
                    if (!log.isTraceEnabled()) break;
                    log.trace((Object)msg, eee);
                }
            }
        }
    }
}

