/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra.services.ejb3;

import com.cybelia.sandra.EmailHelper;
import com.cybelia.sandra.SandraConfig;
import com.cybelia.sandra.SandraConfigHelper;
import com.cybelia.sandra.SandraDAOHelper;
import com.cybelia.sandra.SandraHelper;
import com.cybelia.sandra.entities.ActionSecurite;
import com.cybelia.sandra.entities.ActionSecuriteDAO;
import com.cybelia.sandra.entities.Camion;
import com.cybelia.sandra.entities.CamionDAO;
import com.cybelia.sandra.entities.ChargementUsineConfig;
import com.cybelia.sandra.entities.ChargementUsineConfigDAO;
import com.cybelia.sandra.entities.Chauffeur;
import com.cybelia.sandra.entities.ChauffeurDAO;
import com.cybelia.sandra.entities.Eleveur;
import com.cybelia.sandra.entities.EleveurDAO;
import com.cybelia.sandra.entities.Etape;
import com.cybelia.sandra.entities.EtapeDAO;
import com.cybelia.sandra.entities.GPSStateEnum;
import com.cybelia.sandra.entities.InfoAccess;
import com.cybelia.sandra.entities.InfoAccessDAO;
import com.cybelia.sandra.entities.InfoAccessEtat;
import com.cybelia.sandra.entities.Label;
import com.cybelia.sandra.entities.LabelDAO;
import com.cybelia.sandra.entities.LigneProduit;
import com.cybelia.sandra.entities.Note;
import com.cybelia.sandra.entities.NoteDAO;
import com.cybelia.sandra.entities.Societe;
import com.cybelia.sandra.entities.SocieteDAO;
import com.cybelia.sandra.entities.Tour;
import com.cybelia.sandra.entities.TourDAO;
import com.cybelia.sandra.entities.Transporteur;
import com.cybelia.sandra.entities.TransporteurDAO;
import com.cybelia.sandra.entities.UserIndicateurs;
import com.cybelia.sandra.entities.UserIndicateursDAO;
import com.cybelia.sandra.entities.Usine;
import com.cybelia.sandra.entities.UsineDAO;
import com.cybelia.sandra.entities.sig.PointGPS;
import com.cybelia.sandra.entities.sig.PointGPSDAO;
import com.cybelia.sandra.entities.trace.SuiviEtape;
import com.cybelia.sandra.entities.trace.SuiviLigneProduit;
import com.cybelia.sandra.entities.trace.SuiviLigneProduitDAO;
import com.cybelia.sandra.entities.trace.SuiviTour;
import com.cybelia.sandra.entities.trace.SuiviTourDAO;
import com.cybelia.sandra.ibu.injector.InjectorEleveurDuplicated;
import com.cybelia.sandra.ibu.manager.ManagerInjector;
import com.cybelia.sandra.security.NotifierSecurityHelper;
import com.cybelia.sandra.security.ProfilManager;
import com.cybelia.sandra.security.SecurityHelper;
import com.cybelia.sandra.services.LogicException;
import com.cybelia.sandra.services.ServiceHelper;
import com.cybelia.sandra.services.ServiceWeb;
import com.cybelia.sandra.services.ejb3.BaseServiceImpl;
import com.cybelia.sandra.services.ejb3.Transaction;
import com.cybelia.sandra.services.local.ServiceCommonLocal;
import com.cybelia.sandra.services.local.ServiceNotifierLocal;
import com.cybelia.sandra.services.local.ServiceScheduleLocal;
import com.cybelia.sandra.services.local.ServiceWebLocal;
import com.google.common.collect.Lists;
import com.vividsolutions.jts.geom.Point;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.security.PermitAll;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.jboss.ejb3.annotation.SecurityDomain;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaSecurityDAOHelper;
import org.nuiton.topia.framework.TopiaContextImpl;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaId;
import org.nuiton.topia.taas.TaasUtil;
import org.nuiton.topia.taas.entities.TaasAuthorization;
import org.nuiton.topia.taas.entities.TaasAuthorizationDAO;
import org.nuiton.topia.taas.entities.TaasPrincipal;
import org.nuiton.topia.taas.entities.TaasPrincipalDAO;
import org.nuiton.topia.taas.entities.TaasUser;
import org.nuiton.topia.taas.entities.TaasUserDAO;
import org.nuiton.util.DateUtil;

@Stateless
@SecurityDomain(value="sandra")
@PermitAll
public class ServiceWebImpl
extends BaseServiceImpl
implements ServiceWeb,
ServiceWebLocal {
    protected static final Log log = LogFactory.getLog(ServiceWebImpl.class);
    @EJB
    ServiceNotifierLocal serviceNotifier;
    @EJB
    ServiceScheduleLocal serviceSchedule;
    @EJB
    ServiceCommonLocal serviceCommon;

    public void setServiceNotifier(ServiceNotifierLocal serviceNotifier) {
        this.serviceNotifier = serviceNotifier;
    }

    public void setServiceSchedule(ServiceScheduleLocal serviceSchedule) {
        this.serviceSchedule = serviceSchedule;
    }

    public void setServiceCommon(ServiceCommonLocal serviceCommon) {
        this.serviceCommon = serviceCommon;
    }

    protected TaasUser getRestoredUser(TopiaContext transaction) throws TopiaException {
        TaasUserDAO userDAO = TopiaSecurityDAOHelper.getTaasUserDAO((TopiaContext)transaction);
        TaasUser privateCredential = SecurityHelper.getUser();
        TaasUser user = (TaasUser)userDAO.findByTopiaId(privateCredential.getTopiaId());
        return user;
    }

    @Override
    @Transaction
    public void createAllActionSecurityForEleveurs(TopiaContext transaction) throws TopiaException {
        log.info((Object)"createAllActionSecurityForEleveurs");
        EleveurDAO eleveurDAO = SandraDAOHelper.getEleveurDAO((TopiaContext)transaction);
        InfoAccessDAO infoAccessDAO = SandraDAOHelper.getInfoAccessDAO((TopiaContext)transaction);
        String hql = "SELECT silo FROM " + InfoAccess.class.getName() + " silo WHERE silo.niveauSecurite > 1" + " AND silo.eleveur IS NOT NULL";
        List silos = transaction.findAll(hql, new Object[0]);
        for (InfoAccess silo : silos) {
            Eleveur eleveur = silo.getEleveur();
            SandraHelper.createActionSecuriteIfNeeded((TopiaContext)transaction, null, (Eleveur)eleveur, (InfoAccess)silo);
            eleveurDAO.update((TopiaEntity)eleveur);
            infoAccessDAO.update((TopiaEntity)silo);
        }
    }

    @Override
    @Transaction
    public void createMissingPrincipalsForCamions(TopiaContext transaction) throws TopiaException {
        log.info((Object)"createMissingPrincipalsForCamions");
        CamionDAO camionDAO = SandraDAOHelper.getCamionDAO((TopiaContext)transaction);
        UserIndicateursDAO userIndicateursDAO = SandraDAOHelper.getUserIndicateursDAO((TopiaContext)transaction);
        TaasPrincipalDAO taasPrincipalDAO = TopiaSecurityDAOHelper.getTaasPrincipalDAO((TopiaContext)transaction);
        TaasUserDAO taasUserDAO = TopiaSecurityDAOHelper.getTaasUserDAO((TopiaContext)transaction);
        List camions = camionDAO.findAll();
        for (Camion camion : camions) {
            TaasPrincipal taasPrincipal;
            Collection principals;
            TaasUser taasUser;
            UserIndicateurs userIndicateurs = camion.getUserIndicateurs();
            Societe societe = camion.getSociete();
            if (userIndicateurs == null) {
                taasUser = (TaasUser)taasUserDAO.create(new Object[0]);
                taasUser.setLogin(societe.getCode() + "-" + camion.getCode());
                taasUser.setLink(societe.getTopiaId());
                taasUser.setEnabled(true);
                taasUser = (TaasUser)taasUserDAO.update((TopiaEntity)taasUser);
                userIndicateurs = userIndicateursDAO.createByNaturalId(taasUser);
                userIndicateurs = SandraHelper.razUserIndicateurs((UserIndicateurs)userIndicateurs);
                userIndicateurs = (UserIndicateurs)userIndicateursDAO.update((TopiaEntity)userIndicateurs);
                camion.setUserIndicateurs(userIndicateurs);
                camion = (Camion)camionDAO.update((TopiaEntity)camion);
            }
            if ((principals = (taasUser = userIndicateurs.getTaasUser()).getPrincipals()) != null && principals.size() >= 2) continue;
            String codeSocieteCamion = societe.getCode() + "-" + camion.getCode();
            boolean synchroExist = false;
            boolean principalExist = false;
            if (principals != null) {
                for (TaasPrincipal principal : principals) {
                    if ("synchro".equals(principal.getName())) {
                        synchroExist = true;
                        continue;
                    }
                    if (!codeSocieteCamion.equals(principal.getName())) continue;
                    principalExist = true;
                }
            }
            if (!synchroExist) {
                taasPrincipal = (TaasPrincipal)taasPrincipalDAO.create(new Object[0]);
                taasPrincipal.setName("synchro");
                taasPrincipalDAO.update((TopiaEntity)taasPrincipal);
                taasUser.addPrincipals(taasPrincipal);
            }
            if (!principalExist) {
                taasPrincipal = (TaasPrincipal)taasPrincipalDAO.create(new Object[0]);
                taasPrincipal.setName(codeSocieteCamion);
                taasPrincipalDAO.update((TopiaEntity)taasPrincipal);
                taasUser.addPrincipals(taasPrincipal);
            }
            taasUserDAO.update((TopiaEntity)taasUser);
        }
    }

    @Override
    @Transaction
    public void deleteDuplicatedEtapesAndCreateUniqueIndex(TopiaContext transaction) throws TopiaException {
        log.info((Object)"deleteDuplicatedEtapesAndCreateUniqueIndex");
        String sql = "SELECT e1.topiaid as topiaId1, e2.topiaid as topiaid2 FROM sandra.etape e1, sandra.etape e2 WHERE e1.ordre=e2.ordre AND e1.tour=e2.tour AND e1.eleveur=e2.eleveur AND e1.topiaId<>e2.topiaId;";
        SQLQuery sqlQuery = ((TopiaContextImpl)transaction).getHibernate().createSQLQuery(sql);
        List list = sqlQuery.list();
        EtapeDAO etapeDAO = SandraDAOHelper.getEtapeDAO((TopiaContext)transaction);
        do {
            ArrayList<Object> cachedTopiaid = new ArrayList<Object>();
            int size = list.size() / 2;
            log.info((Object)("Will delete " + size + " etapes"));
            int i = 0;
            for (Object[] ids : list) {
                Object id1 = ids[0];
                Object id2 = ids[1];
                if (cachedTopiaid.contains(id2)) continue;
                log.info((Object)("Will delete etape : " + id2));
                cachedTopiaid.add(id1);
                cachedTopiaid.add(id2);
                Etape etapeToDelete = (Etape)etapeDAO.findByTopiaId(String.valueOf(id2));
                SandraHelper.deleteEtape((TopiaContext)transaction, (Etape)etapeToDelete);
                log.info((Object)("Etape " + ++i + "/" + size + " deleted : " + id2));
            }
            transaction.commitTransaction();
        } while (!(list = (sqlQuery = ((TopiaContextImpl)transaction).getHibernate().createSQLQuery(sql)).list()).isEmpty());
        String removeIndexSql = "DROP INDEX sandra.etape_key;";
        ((TopiaContextImpl)transaction).getHibernate().createSQLQuery(removeIndexSql).executeUpdate();
        String addUniqueIndexSql = "CREATE UNIQUE INDEX etape_key ON sandra.etape(ordre, tour, eleveur);";
        ((TopiaContextImpl)transaction).getHibernate().createSQLQuery(addUniqueIndexSql).executeUpdate();
        log.info((Object)"End deleteDuplicatedEtapesAndCreateUniqueIndex");
    }

    @Override
    @Transaction
    public void deleteDuplicatedToursAndCreateUniqueIndex(TopiaContext transaction) throws TopiaException {
        log.info((Object)"deleteDuplicatedToursAndCreateUniqueIndex");
        String sql = "SELECT t1.topiaid as topiaId1, t2.topiaid as topiaid2 FROM sandra.tour t1, sandra.tour t2 WHERE t1.numero=t2.numero AND t1.dateLivraison=t2.dateLivraison AND t1.camion=t2.camion AND t1.topiaId<>t2.topiaId;";
        SQLQuery sqlQuery = ((TopiaContextImpl)transaction).getHibernate().createSQLQuery(sql);
        List list = sqlQuery.list();
        TourDAO tourDAO = SandraDAOHelper.getTourDAO((TopiaContext)transaction);
        SuiviTourDAO suiviTourDAO = SandraDAOHelper.getSuiviTourDAO((TopiaContext)transaction);
        do {
            ArrayList<Object> cachedTopiaid = new ArrayList<Object>();
            int size = list.size() / 2;
            log.info((Object)("Will delete " + size + " tours"));
            int i = 0;
            for (Object[] ids : list) {
                Object id1 = ids[0];
                Object id2 = ids[1];
                if (cachedTopiaid.contains(id2)) continue;
                cachedTopiaid.add(id1);
                cachedTopiaid.add(id2);
                Tour tourToDelete = (Tour)tourDAO.findByTopiaId(String.valueOf(id2));
                SuiviTour suiviTour = tourToDelete.getSuiviTour();
                if (suiviTour != null) {
                    suiviTourDAO.delete(suiviTour);
                }
                List etapes = tourToDelete.getEtapes();
                for (Etape etape : etapes) {
                    SandraHelper.deleteEtape((TopiaContext)transaction, (Etape)etape);
                }
                tourDAO.delete(tourToDelete);
                log.info((Object)("Tour " + ++i + "/" + size + " deleted : " + id2));
            }
            transaction.commitTransaction();
        } while (!(list = (sqlQuery = ((TopiaContextImpl)transaction).getHibernate().createSQLQuery(sql)).list()).isEmpty());
        String removeIndexSql = "DROP INDEX sandra.tour_key;";
        ((TopiaContextImpl)transaction).getHibernate().createSQLQuery(removeIndexSql).executeUpdate();
        String addUniqueIndexSql = "CREATE UNIQUE INDEX tour_key ON sandra.tour(dateLivraison, numero, camion);";
        ((TopiaContextImpl)transaction).getHibernate().createSQLQuery(addUniqueIndexSql).executeUpdate();
        log.info((Object)"End deleteDuplicatedToursAndCreateUniqueIndex");
    }

    @Override
    @Transaction
    public void createAndFillAccessEleveur(TopiaContext transaction) throws TopiaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"createAndFillAccessEleveur");
        }
        InfoAccessDAO infoAccessDAO = SandraDAOHelper.getInfoAccessDAO((TopiaContext)transaction);
        String hql = "select eleveur FROM " + Eleveur.class.getName() + " eleveur" + " WHERE acceseleveur IS NULL";
        List eleveurs = transaction.findAll(hql, new Object[0]);
        int cnt = 0;
        for (Eleveur e : eleveurs) {
            InfoAccess infoAccess = (InfoAccess)infoAccessDAO.create(new Object[0]);
            infoAccess.setCommentaireSecurite(e.getCommentaire());
            if (e.getNiveauSecurite() == 0) {
                infoAccess.setNiveauSecurite(-1);
            }
            e.setAccesEleveur(infoAccess);
            SandraDAOHelper.getEleveurDAO((TopiaContext)transaction).update((TopiaEntity)e);
            infoAccessDAO.update((TopiaEntity)infoAccess);
            ++cnt;
        }
        log.info((Object)(cnt + " access breeders are created"));
    }

    @Override
    public void resetAllUserIndicateurs() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"resetAllUserIndicateurs");
        }
        try {
            Thread notif = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        ServiceWebImpl.this.serviceSchedule.razNumberOfConnection(null);
                    }
                    catch (Exception eee) {
                        log.error((Object)"Error on resetAllUserIndicateurs : ", (Throwable)eee);
                    }
                }
            });
            notif.start();
        }
        catch (Exception eee) {
            log.error((Object)"Failed to resetAllUserIndicateurs", (Throwable)eee);
        }
    }

    @Override
    public void sendStatNotification() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"sendStatNotification");
        }
        try {
            Thread notif = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        ServiceWebImpl.this.serviceSchedule.sendStatNotification(null);
                    }
                    catch (Exception eee) {
                        log.error((Object)"Error on sending stats : ", (Throwable)eee);
                    }
                }
            });
            notif.start();
        }
        catch (Exception eee) {
            log.error((Object)"Failed to sendStatNotification", (Throwable)eee);
        }
    }

    @Override
    @Transaction
    public void sendFindDangerousBreeder(TopiaContext transaction) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"sendFindDangerousBreeder");
        }
        try {
            this.serviceSchedule.sendFindDangerousBreeder(transaction);
        }
        catch (Exception eee) {
            log.error((Object)"Failed to sendFindDangerousBreeder", (Throwable)eee);
        }
    }

    @Override
    @Transaction
    public void updateAllWorstSecurityLevel(TopiaContext transaction) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"updateAllWorstSecurityLevel");
        }
        EleveurDAO eleveurDAO = SandraDAOHelper.getEleveurDAO((TopiaContext)transaction);
        List eleveurs = eleveurDAO.findAll();
        for (Eleveur e : eleveurs) {
            Point point;
            int securityLevel = SandraHelper.getWorstSecurityLevel((Eleveur)e);
            e.setNiveauSecurite(securityLevel);
            PointGPS pointGPS = e.getTomtomGPS();
            if (pointGPS != null && pointGPS.getPoint() != null && (point = pointGPS.getPoint()).getX() == 0.0 && point.getY() == 0.0) {
                e.setTomtomGPS(null);
            }
            eleveurDAO.update((TopiaEntity)e);
        }
    }

    @Override
    @Transaction(commit=false)
    public int getToursCount(TopiaContext transaction, Date dateDebut, Date dateFin, boolean planifie, boolean termine, String topiaIdSociete, String topiaIdTransporteur, String topiaIdCamion, String topiaIdChauffeur) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getToursCount");
        }
        ArrayList<Object> arguments = new ArrayList<Object>();
        String requete = this.createTourQuery("SELECT count(*)", transaction, dateDebut, dateFin, planifie, termine, topiaIdSociete, topiaIdTransporteur, topiaIdCamion, topiaIdChauffeur, arguments);
        int count = ProfilManager.count(transaction, Tour.class, requete, arguments.toArray());
        if (log.isDebugEnabled()) {
            log.debug((Object)("count tours [" + requete + "] : " + count));
        }
        return count;
    }

    @Override
    @Transaction
    public List<Tour> getTours(TopiaContext transaction, Date dateDebut, Date dateFin, boolean planifie, boolean termine, String topiaIdSociete, String topiaIdTransporteur, String topiaIdCamion, String topiaIdChauffeur) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getTours");
        }
        ArrayList<Object> arguments = new ArrayList<Object>();
        String requete = this.createTourQuery("SELECT tour", transaction, dateDebut, dateFin, planifie, termine, topiaIdSociete, topiaIdTransporteur, topiaIdCamion, topiaIdChauffeur, arguments);
        List<Tour> tours = ProfilManager.find(transaction, Tour.class, requete, arguments.toArray());
        return tours;
    }

    @Override
    @Transaction
    public List<Tour> getTours(TopiaContext transaction, Date dateDebut, Date dateFin, boolean planifie, boolean termine, String topiaIdSociete, String topiaIdTransporteur, String topiaIdCamion, String topiaIdChauffeur, int startIndex, int endIndex, String sortCriterion, int sortDirection) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getTours [" + startIndex + "-" + endIndex + "]<" + sortCriterion + "-" + sortDirection + ">"));
        }
        ArrayList<Object> arguments = new ArrayList<Object>();
        String requete = this.createTourQuery("SELECT tour", transaction, dateDebut, dateFin, planifie, termine, topiaIdSociete, topiaIdTransporteur, topiaIdCamion, topiaIdChauffeur, arguments);
        String order = sortCriterion == null ? " ORDER BY tour.dateLivraison, tour.camion.code, tour.numero" : SandraHelper.addOrder((String)"tour", (String)sortCriterion, (int)sortDirection);
        if (log.isDebugEnabled()) {
            log.debug((Object)("use tour sorting " + order));
        }
        requete = requete + order;
        if (log.isDebugEnabled()) {
            log.debug((Object)("request : " + requete + ", arguments " + arguments));
        }
        List<Tour> tours = ProfilManager.findWithBounds(transaction, Tour.class, requete, startIndex, endIndex, arguments.toArray());
        return tours;
    }

    @Override
    public Pair<Etape, SuiviEtape> getEtape(TopiaContext transaction, String topiaId) throws LogicException, TopiaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getTour " + topiaId));
        }
        String query = "SELECT etape FROM " + Etape.class.getName() + " etape WHERE etape.topiaId = :topiaId";
        Etape etape = (Etape)ProfilManager.findUnique("error.service.etape.unfound", transaction, Etape.class, query, "topiaId", topiaId);
        Pair result = Pair.of((Object)etape, (Object)SandraDAOHelper.getSuiviEtapeDAO((TopiaContext)transaction).findByEtape(etape));
        return result;
    }

    @Override
    @Transaction
    public Tour getTour(TopiaContext transaction, String topiaId) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getTour " + topiaId));
        }
        String query = "SELECT tour FROM " + Tour.class.getName() + " tour WHERE tour.topiaId = :topiaId";
        Tour tour = (Tour)ProfilManager.findUnique("error.service.tour.unfound", transaction, Tour.class, query, "topiaId", topiaId);
        return tour;
    }

    @Override
    @Transaction
    public List<Tour> getToursByCamionAndDates(TopiaContext transaction, String camionTopiaId, Date dateDebut, Date dateFin) throws TopiaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getTourByCamionAndDate");
        }
        ArrayList<Object> arguments = new ArrayList<Object>();
        String requete = this.createTourQuery("SELECT tour", transaction, dateDebut, dateFin, true, true, null, null, camionTopiaId, null, arguments);
        requete = requete + " ORDER BY tour.dateLivraison, tour.numero";
        Object[] args = arguments.toArray();
        if (log.isDebugEnabled()) {
            log.debug((Object)("getToursByCamionAndDates final request : " + requete + " with args " + Arrays.toString(args)));
        }
        List<Tour> tours = ProfilManager.find(transaction, Tour.class, requete, args);
        return tours;
    }

    @Override
    @Transaction
    public List<Pair<Etape, SuiviEtape>> getEtapesByEleveurs(TopiaContext transaction, Date dateLivraisonStart, Date dateLivraisonEnd, String breederTopiaId, int startIndex, int endIndex, String sortCriterion, int sortDirection) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getToursByEleveurs [" + startIndex + "-" + endIndex + "]<" + sortCriterion + "-" + sortDirection + ">"));
        }
        ArrayList<Object> arguments = new ArrayList<Object>();
        String hql = this.getEtapesByEleveurHQL("SELECT etape ", dateLivraisonStart, dateLivraisonEnd, breederTopiaId, arguments);
        String order = sortCriterion == null ? " ORDER BY etape.tour.dateLivraison, etape.tour.camion.code, etape.tour.numero" : SandraHelper.addOrder((String)"etape.tour", (String)sortCriterion, (int)sortDirection);
        if (log.isDebugEnabled()) {
            log.debug((Object)("use tour sorting " + order));
        }
        hql = hql + order;
        if (log.isDebugEnabled()) {
            log.debug((Object)("request : " + hql + ", arguments " + arguments));
        }
        List<Etape> etapes = ProfilManager.findWithBounds(transaction, Etape.class, hql, startIndex, endIndex, arguments.toArray());
        ArrayList result = Lists.newArrayList();
        for (Etape etape : etapes) {
            result.add(Pair.of((Object)etape, (Object)SandraDAOHelper.getSuiviEtapeDAO((TopiaContext)transaction).findByEtape(etape)));
        }
        return result;
    }

    @Override
    @Transaction
    public int getEtapesByEleveursCount(TopiaContext transaction, Date dateLivraisonStart, Date dateLivraisonEnd, String breederTopiaId) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getToursByEleveursCount");
        }
        ArrayList<Object> arguments = new ArrayList<Object>();
        String hql = this.getEtapesByEleveurHQL("SELECT COUNT(etape) ", dateLivraisonStart, dateLivraisonEnd, breederTopiaId, arguments);
        if (log.isDebugEnabled()) {
            log.debug((Object)("request : " + hql + ", arguments " + arguments));
        }
        int count = ProfilManager.count(transaction, Etape.class, hql, arguments.toArray());
        return count;
    }

    protected String getEtapesByEleveurHQL(String hqlStart, Date dateLivraisonStart, Date dateLivraisonEnd, String breederTopiaId, List<Object> arguments) {
        String result = hqlStart + " FROM " + Etape.class.getName() + " etape WHERE etape.tour.dateLivraison >= :dateLivraisonStart" + " AND etape.tour.dateLivraison <= :dateLivraisonEnd AND etape.eleveur.topiaId=:breederTopiaId";
        arguments.add("dateLivraisonStart");
        arguments.add(dateLivraisonStart);
        arguments.add("dateLivraisonEnd");
        arguments.add(dateLivraisonEnd);
        arguments.add("breederTopiaId");
        arguments.add(breederTopiaId);
        return result;
    }

    @Override
    @Transaction
    public List<Tour> getLoading(TopiaContext transaction, Date dateDebut, Date dateFin, String topiaIdUsine) throws TopiaException, LogicException {
        String query = "SELECT tour FROM " + Tour.class.getName() + " tour JOIN tour.etapes AS etape JOIN etape.produits AS produit " + " WHERE ((tour.dateChargementReel >= :dateDebut AND tour.dateChargementReel <= :dateFin AND produit.usine.topiaId = :topiaIdUsine) OR" + " (tour.dateChargementInitiale >= :dateDebut AND tour.dateChargementInitiale <= :dateFin AND produit.usine.topiaId = :topiaIdUsine) OR" + " (tour IN (SELECT ligneProduit.etape.tour FROM " + LigneProduit.class.getName() + " ligneProduit WHERE ligneProduit.infoChargement.date >= :dateDebut AND ligneProduit.infoChargement.date <= :dateFin AND ligneProduit.usine.topiaId = :topiaIdUsine)) OR" + " (tour.suiviTour IN (SELECT suiviTour FROM " + SuiviTour.class.getName() + " suiviTour JOIN suiviTour.suiviUsines AS suiviUsine WHERE suiviUsine.dateChargementPrevue >= :dateDebut AND suiviUsine.dateChargementPrevue <= :dateFin AND suiviUsine.usine.topiaId = :topiaIdUsine)) OR" + " (tour.notificationRetourUsine >= :dateDebut AND tour.notificationRetourUsine <= :dateFin AND produit.usine.topiaId = :topiaIdUsine))" + " AND tour.camion.code != 'GUI' " + " ORDER BY tour.camion.societe.code, tour.camion.code";
        List<Tour> tours = ProfilManager.find(transaction, Tour.class, query, "dateDebut", dateDebut, "dateFin", dateFin, "topiaIdUsine", topiaIdUsine);
        return tours;
    }

    @Override
    @Transaction
    public List<LigneProduit> getProduitsLoading(TopiaContext transaction, String topiaIdUsine, String topiaIdTour) throws TopiaException, LogicException {
        String query = "SELECT produit FROM " + LigneProduit.class.getName() + " produit WHERE produit.usine.topiaId = :topiaIdUsine AND produit.etape.tour.topiaId = :topiaIdTour";
        List<LigneProduit> produits = ProfilManager.find(transaction, LigneProduit.class, query, "topiaIdUsine", topiaIdUsine, "topiaIdTour", topiaIdTour);
        return produits;
    }

    @Override
    @Transaction
    public void saveProduitDisponible(TopiaContext transaction, String topiaIdProduit, boolean disponible) throws TopiaException, LogicException {
        String query = "SELECT produit FROM " + LigneProduit.class.getName() + " produit WHERE produit.topiaId = :topiaIdProduit";
        LigneProduit produit = (LigneProduit)ProfilManager.findUnique("error.service.ligneproduit.unfound", transaction, LigneProduit.class, query, "topiaIdProduit", topiaIdProduit);
        produit.setDisponible(disponible);
        SandraDAOHelper.getLigneProduitDAO((TopiaContext)transaction).update((TopiaEntity)produit);
    }

    @Override
    @Transaction
    public Camion setActifCamion(TopiaContext transaction, String topiaId, boolean actif) throws TopiaException {
        CamionDAO camionDAO = SandraDAOHelper.getCamionDAO((TopiaContext)transaction);
        Camion camion = (Camion)camionDAO.findByTopiaId(topiaId);
        camion.setActif(actif);
        camion = (Camion)camionDAO.update((TopiaEntity)camion);
        return camion;
    }

    @Override
    @Transaction
    public List<Camion> getCamions(TopiaContext transaction) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getCamions");
        }
        String query = "SELECT camion FROM " + Camion.class.getName() + " camion ORDER BY camion.societe.code, camion.code";
        List<Camion> camions = ProfilManager.find(transaction, Camion.class, query, new Object[0]);
        return camions;
    }

    @Override
    @Transaction
    public List<Camion> getCamions(TopiaContext transaction, String societeId, boolean actif) throws TopiaException, LogicException {
        String query = "SELECT camion FROM " + Camion.class.getName() + " camion WHERE ";
        ArrayList<Object> arguments = new ArrayList<Object>();
        arguments.add("actif");
        arguments.add(actif);
        Societe societe = (Societe)SandraDAOHelper.getSocieteDAO((TopiaContext)transaction).findByTopiaId(societeId);
        if (societe != null) {
            arguments.add("societe");
            arguments.add(societe);
            query = query + " societe=:societe AND ";
        }
        query = query + "actif=:actif ORDER BY camion.societe.code, camion.code";
        List<Camion> camions = ProfilManager.find(transaction, Camion.class, query, arguments.toArray());
        return camions;
    }

    @Override
    @Transaction
    public List<Camion> getCamions(TopiaContext transaction, String societeId, boolean actif, int startIndex, int endIndex, String sortCriterion, int sortDirection) throws TopiaException, LogicException {
        String query = "SELECT camion FROM " + Camion.class.getName() + " camion WHERE ";
        ArrayList<Object> arguments = new ArrayList<Object>();
        arguments.add("actif");
        arguments.add(actif);
        Societe societe = (Societe)SandraDAOHelper.getSocieteDAO((TopiaContext)transaction).findByTopiaId(societeId);
        if (societe != null) {
            arguments.add("societe");
            arguments.add(societe);
            query = query + " societe=:societe AND ";
        }
        query = query + "actif=:actif " + SandraHelper.addOrder((String)"camion", (String)sortCriterion, (int)sortDirection);
        List<Camion> camions = ProfilManager.findWithBounds(transaction, Camion.class, query, startIndex, endIndex, arguments.toArray());
        return camions;
    }

    @Override
    @Transaction
    public Camion getCamion(TopiaContext transaction, String topiaId) throws TopiaException, LogicException {
        if (log.isInfoEnabled()) {
            log.info((Object)("getCamion " + topiaId));
        }
        String query = "SELECT camion FROM " + Camion.class.getName() + " camion WHERE camion.topiaId = :topiaId";
        Camion camion = (Camion)ProfilManager.findUnique("error.service.camion.unfound", transaction, Camion.class, query, "topiaId", topiaId);
        return camion;
    }

    @Override
    @Transaction
    public Camion saveCamion(TopiaContext transaction, Camion camion) throws TopiaException, LogicException {
        Camion camion2;
        CamionDAO dao = SandraDAOHelper.getCamionDAO((TopiaContext)transaction);
        String code = camion.getCode();
        String topiaId = camion.getTopiaId();
        Societe societe = this.getSociete(transaction, camion.getSociete().getTopiaId());
        camion.setSociete(societe);
        Transporteur transporteur = this.getTransporteur(transaction, camion.getTransporteur().getTopiaId());
        camion.setTransporteur(transporteur);
        if (StringUtils.isEmpty((CharSequence)topiaId)) {
            if (dao.findByCode(code) != null) {
                throw new LogicException("error.service.camion.already.exists");
            }
            camion2 = dao.createByNaturalId(code, camion.getSociete());
            TaasUserDAO taasUserDAO = TopiaSecurityDAOHelper.getTaasUserDAO((TopiaContext)transaction);
            TaasUser taasUser = (TaasUser)taasUserDAO.create(new Object[0]);
            taasUser.setLogin(societe.getCode() + "-" + camion.getCode());
            taasUser.setLink(societe.getTopiaId());
            taasUser.setEnabled(true);
            TaasPrincipalDAO taasPrincipalDAO = TopiaSecurityDAOHelper.getTaasPrincipalDAO((TopiaContext)transaction);
            TaasPrincipal synchroPrincipal = taasPrincipalDAO.findByName("synchro");
            TaasPrincipal taasPrincipal = (TaasPrincipal)taasPrincipalDAO.create(new Object[0]);
            taasPrincipal.setName(societe.getCode() + "-" + camion.getCode());
            taasPrincipalDAO.update((TopiaEntity)taasPrincipal);
            taasUser.addPrincipals(taasPrincipal);
            taasUser.addPrincipals(synchroPrincipal);
            taasUser = (TaasUser)taasUserDAO.update((TopiaEntity)taasUser);
            UserIndicateursDAO userIndicateursDAO = SandraDAOHelper.getUserIndicateursDAO((TopiaContext)transaction);
            UserIndicateurs userIndicateurs = userIndicateursDAO.createByNaturalId(taasUser);
            userIndicateurs = SandraHelper.razUserIndicateurs((UserIndicateurs)userIndicateurs);
            camion2.setUserIndicateurs(userIndicateurs);
            camion2.setActif(true);
            if (log.isInfoEnabled()) {
                log.info((Object)("has created camion " + camion2.getTopiaId()));
            }
        } else {
            camion2 = (Camion)dao.findByTopiaId(topiaId);
            if (!camion2.getCode().equals(code) && dao.findByCode(code) != null) {
                throw new LogicException("error.service.camion.already.exists");
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("update camion " + camion2.getTopiaId()));
            }
        }
        camion2.setTransporteur(camion.getTransporteur());
        camion2.setNombreCompartiments(camion.getNombreCompartiments());
        dao.update((TopiaEntity)camion2);
        return camion2;
    }

    @Override
    @Transaction
    public List<Camion> getCamionsPrincipaux(TopiaContext transaction) throws TopiaException, LogicException {
        List<Camion> camions;
        if (log.isDebugEnabled()) {
            log.debug((Object)"getCamionsPrincipaux");
        }
        if ((camions = this.getCamions(transaction)) == null || camions.isEmpty()) {
            return null;
        }
        ArrayList<String> camionsNonPrincipauxId = new ArrayList<String>();
        for (Camion camion : camions) {
            List camionsAssocies = camion.getCamionsAssocies();
            if (camionsAssocies == null || camionsAssocies.isEmpty()) continue;
            for (Camion camionsAssocy : camionsAssocies) {
                camionsNonPrincipauxId.add(camionsAssocy.getTopiaId());
            }
        }
        ArrayList<Camion> camionsPrincipaux = new ArrayList<Camion>();
        for (Camion camion : camions) {
            if (camionsNonPrincipauxId.contains(camion.getTopiaId())) continue;
            camionsPrincipaux.add(camion);
        }
        return camionsPrincipaux;
    }

    @Override
    @Transaction
    public Camion getCamionPrincipal(TopiaContext transaction, String camionId) throws TopiaException, LogicException {
        Camion camion = this.getCamion(transaction, camionId);
        if (camion.getCamionsAssocies() != null && !camion.getCamionsAssocies().isEmpty()) {
            return null;
        }
        for (Camion camionPrincipal : this.getCamions(transaction)) {
            List camionsAssocies = camionPrincipal.getCamionsAssocies();
            if (camionsAssocies == null || camionsAssocies.isEmpty()) continue;
            for (Camion camionsAssocy : camionsAssocies) {
                if (!camionId.equals(camionsAssocy.getTopiaId())) continue;
                return camionPrincipal;
            }
        }
        return null;
    }

    @Override
    @Transaction
    public void addCamionToCamionPrincipal(TopiaContext transaction, String camionId, String camionPrincipalId) throws LogicException, TopiaException {
        CamionDAO dao = SandraDAOHelper.getCamionDAO((TopiaContext)transaction);
        Camion camion = this.getCamion(transaction, camionId);
        Camion camionPrincipal = this.getCamion(transaction, camionPrincipalId);
        camionPrincipal.getCamionsAssocies().add(camion);
        dao.update((TopiaEntity)camionPrincipal);
    }

    @Override
    @Transaction
    public List<Chauffeur> getChauffeurs(TopiaContext transaction) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getChauffeurs");
        }
        String query = "SELECT chauffeur FROM " + Chauffeur.class.getName() + " chauffeur ORDER BY chauffeur.nom, chauffeur.prenom";
        List<Chauffeur> chauffeurs = ProfilManager.find(transaction, Chauffeur.class, query, new Object[0]);
        return chauffeurs;
    }

    @Override
    @Transaction
    public List<Chauffeur> getChauffeurs(TopiaContext transaction, int startIndex, int endIndex, String sortCriterion, int sortDirection) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getChauffeurs [" + startIndex + "-" + endIndex + "]<" + sortCriterion + "-" + sortDirection + ">"));
        }
        String order = sortCriterion == null ? " ORDER BY chauffeur.nom, chauffeur.prenom" : SandraHelper.addOrder((String)"chauffeur", (String)sortCriterion, (int)sortDirection);
        String query = "SELECT chauffeur FROM " + Chauffeur.class.getName() + " chauffeur" + order;
        List<Chauffeur> chauffeurs = ProfilManager.findWithBounds(transaction, Chauffeur.class, query, startIndex, endIndex, new Object[0]);
        return chauffeurs;
    }

    @Override
    @Transaction
    public Chauffeur getChauffeur(TopiaContext transaction, String topiaId) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getChauffeur " + topiaId));
        }
        String query = "SELECT chauffeur FROM " + Chauffeur.class.getName() + " chauffeur WHERE chauffeur.topiaId = :topiaId";
        Chauffeur chauffeur = (Chauffeur)ProfilManager.findUnique("error.service.chauffeur.unfound", transaction, Chauffeur.class, query, "topiaId", topiaId);
        chauffeur.getCamions().size();
        return chauffeur;
    }

    @Override
    @Transaction
    public Chauffeur saveChauffeur(TopiaContext transaction, Chauffeur chauffeur) throws TopiaException, LogicException {
        Chauffeur chauffeur2;
        ChauffeurDAO dao = SandraDAOHelper.getChauffeurDAO((TopiaContext)transaction);
        String code = chauffeur.getCode();
        String topiaId = chauffeur.getTopiaId();
        if (topiaId == null || "".equals(topiaId)) {
            if (dao.findByCode(code) != null) {
                throw new LogicException("error.service.chauffeur.already.exists");
            }
            chauffeur2 = (Chauffeur)dao.create(new Object[0]);
            if (log.isInfoEnabled()) {
                log.info((Object)("has created usine " + chauffeur2.getTopiaId()));
            }
        } else {
            chauffeur2 = (Chauffeur)dao.findByTopiaId(topiaId);
            if (!chauffeur2.getCode().equals(code) && dao.findByCode(code) != null) {
                throw new LogicException("error.service.chauffeur.already.exists");
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("update chauffeur " + chauffeur2.getTopiaId()));
            }
        }
        chauffeur2.setCode(code);
        chauffeur2.setNom(chauffeur.getNom());
        chauffeur2.setPrenom(chauffeur.getPrenom());
        chauffeur2.setTrigramme(chauffeur.getTrigramme());
        dao.update((TopiaEntity)chauffeur2);
        return chauffeur2;
    }

    @Override
    @Transaction
    public void addCamionsToChauffeur(TopiaContext transaction, String topiaIdChauffeur, String ... topiaIdCamion) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("addCamionsToChauffeur chauffeur:" + topiaIdChauffeur));
        }
        ChauffeurDAO dao = SandraDAOHelper.getChauffeurDAO((TopiaContext)transaction);
        CamionDAO cdao = SandraDAOHelper.getCamionDAO((TopiaContext)transaction);
        Chauffeur chauffeur = (Chauffeur)dao.findByTopiaId(topiaIdChauffeur);
        ArrayList<Camion> camions = new ArrayList<Camion>(chauffeur.getCamions());
        for (String s : topiaIdCamion) {
            Camion camion = (Camion)cdao.findByTopiaId(s);
            if (log.isDebugEnabled()) {
                log.debug((Object)("add camion " + camion.getTopiaId()));
            }
            camions.add(camion);
        }
        chauffeur.clearCamions();
        chauffeur.setCamions(camions);
        dao.update((TopiaEntity)chauffeur);
    }

    @Override
    @Transaction
    public void deleteCamionsToChauffeur(TopiaContext transaction, String topiaIdChauffeur, String ... topiaIdCamion) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("deleteCamionsToChauffeur chauffeur:" + topiaIdChauffeur));
        }
        ChauffeurDAO dao = SandraDAOHelper.getChauffeurDAO((TopiaContext)transaction);
        CamionDAO cdao = SandraDAOHelper.getCamionDAO((TopiaContext)transaction);
        Chauffeur chauffeur = (Chauffeur)dao.findByTopiaId(topiaIdChauffeur);
        for (String s : topiaIdCamion) {
            Camion camion = (Camion)cdao.findByTopiaId(s);
            if (log.isInfoEnabled()) {
                log.info((Object)("delete camion " + camion.getTopiaId()));
            }
            chauffeur.removeCamions(camion);
        }
        dao.update((TopiaEntity)chauffeur);
    }

    @Override
    @Transaction
    public List<Societe> getSocietes(TopiaContext transaction) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getSocietes");
        }
        String query = "SELECT societe FROM " + Societe.class.getName() + " societe ORDER BY societe.code";
        List<Societe> societes = ProfilManager.find(transaction, Societe.class, query, new Object[0]);
        return societes;
    }

    @Override
    @Transaction
    public List<Societe> getSocietes(TopiaContext transaction, int startIndex, int endIndex, String sortCriterion, int sortDirection) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getSocietes [" + startIndex + "-" + endIndex + "]<" + sortCriterion + "-" + sortDirection + ">"));
        }
        List<Societe> societes = null;
        String query = "SELECT societe FROM " + Societe.class.getName() + " societe" + SandraHelper.addOrder((String)"societe", (String)sortCriterion, (int)sortDirection);
        societes = ProfilManager.findWithBounds(transaction, Societe.class, query, startIndex, endIndex, new Object[0]);
        return societes;
    }

    @Override
    @Transaction
    public Societe getSociete(TopiaContext transaction, String topiaId) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getSociete " + topiaId));
        }
        String query = "SELECT societe FROM " + Societe.class.getName() + " societe WHERE societe.topiaId = :topiaId";
        Societe societe = (Societe)ProfilManager.findUnique("error.service.societe.unfound", transaction, Societe.class, query, "topiaId", topiaId);
        return societe;
    }

    @Override
    @Transaction
    public Societe saveSociete(TopiaContext transaction, Societe societe) throws TopiaException, LogicException {
        Societe societe2;
        SocieteDAO dao = SandraDAOHelper.getSocieteDAO((TopiaContext)transaction);
        String code = societe.getCode();
        String topiaId = societe.getTopiaId();
        if (topiaId == null || "".equals(topiaId)) {
            if (dao.findByCode(code) != null) {
                throw new LogicException("error.service.societe.already.exists");
            }
            societe2 = dao.createByNaturalId(code);
            if (log.isInfoEnabled()) {
                log.info((Object)("has created societe " + societe2.getTopiaId()));
            }
        } else {
            societe2 = (Societe)dao.findByTopiaId(topiaId);
            if (!societe2.getCode().equals(code) && dao.findByCode(code) != null) {
                throw new LogicException("error.service.societe.already.exists");
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("update societe " + societe2.getTopiaId()));
            }
        }
        dao.update((TopiaEntity)societe2);
        return societe2;
    }

    @Override
    @Transaction
    public List<Transporteur> getTransporteurs(TopiaContext transaction) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getTransporteurs");
        }
        List<Transporteur> transporteurs = ProfilManager.find(transaction, Transporteur.class, "SELECT transporteur FROM " + Transporteur.class.getName() + " transporteur ORDER BY transporteur.name", new Object[0]);
        return transporteurs;
    }

    @Override
    @Transaction
    public List<Transporteur> getTransporteurs(TopiaContext transaction, int startIndex, int endIndex, String sortCriterion, int sortDirection) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getTransporteurs [" + startIndex + "-" + endIndex + "]<" + sortCriterion + "-" + sortDirection + ">"));
        }
        String query = "SELECT transporteur FROM " + Transporteur.class.getName() + " transporteur" + SandraHelper.addOrder((String)"transporteur", (String)sortCriterion, (int)sortDirection);
        List<Transporteur> transporteurs = ProfilManager.findWithBounds(transaction, Transporteur.class, query, startIndex, endIndex, new Object[0]);
        return transporteurs;
    }

    @Override
    @Transaction
    public Transporteur getTransporteur(TopiaContext transaction, String topiaId) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getTransporteur " + topiaId));
        }
        String query = "SELECT transporteur FROM " + Transporteur.class.getName() + " transporteur WHERE transporteur.topiaId= :topiaId";
        Transporteur transporteur = (Transporteur)ProfilManager.findUnique("error.service.transporteur.unfound", transaction, Transporteur.class, query, "topiaId", topiaId);
        return transporteur;
    }

    @Override
    @Transaction
    public Transporteur saveTransporteur(TopiaContext transaction, Transporteur transporteur) throws TopiaException, LogicException {
        Transporteur transporteur2;
        TransporteurDAO dao = SandraDAOHelper.getTransporteurDAO((TopiaContext)transaction);
        String code = transporteur.getCode();
        String topiaId = transporteur.getTopiaId();
        if (topiaId == null || "".equals(topiaId)) {
            if (dao.findByCode(code) != null) {
                throw new LogicException("error.service.transporteur.already.exists");
            }
            transporteur2 = dao.createByNaturalId(code);
            if (log.isDebugEnabled()) {
                log.debug((Object)("has created transporteur " + transporteur2.getTopiaId()));
            }
        } else {
            transporteur2 = (Transporteur)dao.findByTopiaId(topiaId);
            if (!transporteur2.getCode().equals(code) && dao.findByCode(code) != null) {
                throw new LogicException("error.service.transporteur.already.exists");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("update transporteur " + transporteur2.getTopiaId()));
            }
        }
        transporteur2.setName(transporteur.getName());
        dao.update((TopiaEntity)transporteur2);
        return transporteur2;
    }

    @Override
    @Transaction
    public List<Usine> getUsines(TopiaContext transaction) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getUsines");
        }
        List<Usine> usines = ProfilManager.find(transaction, Usine.class, "SELECT usine FROM " + Usine.class.getName() + " usine ORDER BY usine.code", new Object[0]);
        return usines;
    }

    @Override
    @Transaction
    public List<Usine> getUsines(TopiaContext transaction, int startIndex, int endIndex, String sortCriterion, int sortDirection) throws TopiaException, LogicException {
        if (log.isInfoEnabled()) {
            log.info((Object)("getUsines [" + startIndex + "-" + endIndex + "]<" + sortCriterion + "-" + sortDirection + ">"));
        }
        String query = "SELECT usine FROM " + Usine.class.getName() + " usine" + SandraHelper.addOrder((String)"usine", (String)sortCriterion, (int)sortDirection);
        List<Usine> usines = ProfilManager.findWithBounds(transaction, Usine.class, query, startIndex, endIndex, new Object[0]);
        return usines;
    }

    @Override
    @Transaction
    public Usine getUsine(TopiaContext transaction, String topiaId) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getUsine " + topiaId));
        }
        String query = "SELECT usine FROM " + Usine.class.getName() + " usine WHERE usine.topiaId = :topiaId";
        Usine usine = (Usine)ProfilManager.findUnique("error.service.factory.unfound", transaction, Usine.class, query, "topiaId", topiaId);
        return usine;
    }

    @Override
    @Transaction
    public Usine saveUsine(TopiaContext transaction, Usine usine) throws TopiaException, LogicException {
        Usine usine2;
        UsineDAO dao = SandraDAOHelper.getUsineDAO((TopiaContext)transaction);
        String code = usine.getCode();
        String topiaId = usine.getTopiaId();
        if (topiaId == null || "".equals(topiaId)) {
            if (dao.findByCode(code) != null) {
                throw new LogicException("error.service.factory.already.exists");
            }
            usine2 = dao.createByNaturalId(code);
            if (log.isInfoEnabled()) {
                log.info((Object)("has created usine " + usine2.getTopiaId()));
            }
        } else {
            usine2 = (Usine)dao.findByTopiaId(topiaId);
            if (!usine2.getCode().equals(code) && dao.findByCode(code) != null) {
                throw new LogicException("error.service.factory.already.exists");
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("update usine " + usine2.getTopiaId()));
            }
        }
        usine2.setAdresse(usine.getAdresse());
        usine2.setCodePostal(usine.getCodePostal());
        usine2.setVille(usine.getVille());
        dao.update((TopiaEntity)usine2);
        return usine2;
    }

    @Override
    @Transaction
    public List<Eleveur> getEleveurs(TopiaContext transaction) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getEleveurs");
        }
        List<Eleveur> eleveurs = ProfilManager.find(transaction, Eleveur.class, "SELECT eleveur FROM " + Eleveur.class.getName() + " eleveur ORDER BY eleveur.raisonSociale", new Object[0]);
        return eleveurs;
    }

    @Override
    @Transaction
    public List<Eleveur> getEleveurs(TopiaContext transaction, int startIndex, int endIndex, String sortCriterion, int sortDirection) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getEleveurs [" + startIndex + "-" + endIndex + "]<" + sortCriterion + "-" + sortDirection + ">"));
        }
        String query = "SELECT eleveur FROM " + Eleveur.class.getName() + " eleveur" + SandraHelper.addOrder((String)"eleveur", (String)sortCriterion, (int)sortDirection);
        List<Eleveur> eleveurs = ProfilManager.findWithBounds(transaction, Eleveur.class, query, startIndex, endIndex, new Object[0]);
        return eleveurs;
    }

    @Override
    @Transaction
    public List<Eleveur> getEleveurs(TopiaContext transaction, String breederQuery, String gpsKey, String nivSecu, String camion, String societe, Date dateLivraison, String operator, int startIndex, int endIndex, String sortCriterion, int sortDirection) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getEleveurs with query '" + breederQuery + "' gps : " + gpsKey + " niveau de secu : " + nivSecu + " code camion : " + camion + " code societe " + societe + " Date livraison : " + dateLivraison + " [" + startIndex + "-" + endIndex + "]<" + sortCriterion + "-" + sortDirection + ">"));
        }
        ArrayList<Object> arguments = new ArrayList<Object>();
        String startQuery = "SELECT eleveur FROM " + Eleveur.class.getName() + " eleveur";
        String query = this.buildEleveurQuery(startQuery, breederQuery, gpsKey, nivSecu, camion, societe, dateLivraison, operator, arguments);
        if (sortCriterion != null) {
            query = query + SandraHelper.addOrder((String)"eleveur", (String)sortCriterion, (int)sortDirection);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("final query : " + query));
        }
        List<Eleveur> eleveurs = ProfilManager.findWithBounds(transaction, Eleveur.class, query, startIndex, endIndex, arguments.toArray());
        return eleveurs;
    }

    @Override
    @Transaction
    public int getEleveursCount(TopiaContext transaction, String breederQuery, String gpsKey, String nivSecu, String camion, String societe, Date livraisonDate, String operator) throws TopiaException, LogicException {
        ArrayList<Object> arguments = new ArrayList<Object>();
        String startQuery = "SELECT COUNT(eleveur.topiaId) FROM " + Eleveur.class.getName() + " eleveur";
        String query = this.buildEleveurQuery(startQuery, breederQuery, gpsKey, nivSecu, camion, societe, livraisonDate, operator, arguments);
        Object[] args = arguments.toArray();
        if (log.isDebugEnabled()) {
            log.debug((Object)("final count query : " + query + " with args : " + Arrays.toString(args)));
        }
        int eleveursCount = ProfilManager.count(transaction, Eleveur.class, query, args);
        return eleveursCount;
    }

    protected String buildEleveurQuery(String startQuery, String breederQuery, String gpsKey, String nivSecu, String camion, String societe, Date dateLivraison, String operator, List<Object> arguments) {
        if (dateLivraison != null) {
            return this.buildEleveurQuery(startQuery, breederQuery, gpsKey, nivSecu, camion, societe, DateUtil.setMinTimeOfDay((Date)dateLivraison), DateUtil.setMaxTimeOfDay((Date)dateLivraison), operator, arguments);
        }
        return this.buildEleveurQuery(startQuery, breederQuery, gpsKey, nivSecu, camion, societe, null, null, operator, arguments);
    }

    protected String buildEleveurQuery(String startQuery, String breederQuery, String gpsKey, String nivSecu, String camion, String societe, Date dateLivraisonStart, Date dateLivraisonEnd, String operator, List<Object> arguments) {
        Integer nivSecuAsInt;
        String query = "";
        String endQuery = "";
        if (dateLivraisonStart != null || dateLivraisonEnd != null || !StringUtils.isEmpty((CharSequence)camion)) {
            query = query + ", " + Etape.class.getName() + " etape";
            endQuery = " eleveur.topiaId = etape.eleveur AND etape.tour IN (SELECT tour FROM " + Tour.class.getName() + " tour WHERE";
            if (dateLivraisonStart != null) {
                endQuery = endQuery + " tour.dateLivraison >= :beginDateLivraison AND";
                arguments.add("beginDateLivraison");
                arguments.add(dateLivraisonStart);
            }
            if (dateLivraisonEnd != null) {
                endQuery = endQuery + " tour.dateLivraison < :endDateLivraison AND";
                arguments.add("endDateLivraison");
                arguments.add(DateUtil.setMaxTimeOfDay((Date)dateLivraisonEnd));
            }
            if (!StringUtils.isEmpty((CharSequence)camion)) {
                endQuery = endQuery + " tour.camion.topiaId = :camion";
                arguments.add("camion");
                arguments.add(camion);
            }
            endQuery = this.removeEndOfRequest(endQuery);
            endQuery = endQuery + ")";
        }
        query = query + " WHERE";
        if (!StringUtils.isEmpty((CharSequence)breederQuery)) {
            query = query + " (lower(eleveur.raisonSociale) LIKE '%" + breederQuery.toLowerCase() + "%' OR lower(eleveur.ville) LIKE '%" + breederQuery.toLowerCase() + "%') AND";
        }
        if (!StringUtils.isEmpty((CharSequence)societe)) {
            query = query + " eleveur.societe.topiaId = :societe AND";
            arguments.add("societe");
            arguments.add(societe);
        }
        if (!StringUtils.isEmpty((CharSequence)gpsKey) && !StringUtils.isEmpty((CharSequence)nivSecu)) {
            nivSecuAsInt = Integer.parseInt(nivSecu);
            if (StringUtils.isEmpty((CharSequence)operator)) {
                operator = "AND";
            }
            query = query + " (" + this.getGpsQuery(gpsKey) + " " + operator + " eleveur.accesEleveur.niveauSecurite = :nivSecu) AND";
            arguments.add("nivSecu");
            if (nivSecuAsInt.equals(0)) {
                nivSecuAsInt = -1;
            }
            arguments.add(nivSecuAsInt);
        } else if (!StringUtils.isEmpty((CharSequence)gpsKey)) {
            query = query + this.getGpsQuery(gpsKey) + " AND";
        } else if (!StringUtils.isEmpty((CharSequence)nivSecu)) {
            nivSecuAsInt = Integer.parseInt(nivSecu);
            query = query + " eleveur.accesEleveur.niveauSecurite = :nivSecu AND";
            arguments.add("nivSecu");
            if (nivSecuAsInt.equals(0)) {
                nivSecuAsInt = -1;
            }
            arguments.add(nivSecuAsInt);
        }
        String finalQuery = startQuery + query + endQuery;
        finalQuery = this.removeEndOfRequest(finalQuery);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Final query is : " + finalQuery));
        }
        return finalQuery;
    }

    protected String removeEndOfRequest(String query) {
        if (query.endsWith("AND")) {
            query = query.substring(0, query.length() - 3);
        }
        if (query.endsWith("WHERE")) {
            query = query.substring(0, query.length() - 5);
        }
        return query;
    }

    protected String getGpsQuery(String gpsKey) {
        GPSStateEnum state = GPSStateEnum.getGPSState((String)gpsKey);
        String result = "";
        switch (state) {
            case GPS_EMPTY: {
                result = " (eleveur.tomtomGPS IS NULL)";
                break;
            }
            case GPS_LOCKED: {
                result = " (eleveur.nbTomTomGPSModif > 3)";
                break;
            }
            case GPS_OK: {
                result = " (eleveur.tomtomGPS IS NOT NULL AND eleveur.nbTomTomGPSModif <= 3)";
            }
        }
        return result;
    }

    @Override
    @Transaction
    public Eleveur getEleveur(TopiaContext transaction, String topiaId) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getEleveur " + topiaId));
        }
        String query = "SELECT eleveur FROM " + Eleveur.class.getName() + " eleveur WHERE eleveur.topiaId = :topiaId";
        Eleveur eleveur = (Eleveur)ProfilManager.findUnique("error.service.eleveur.unfound", transaction, Eleveur.class, query, "topiaId", topiaId);
        return eleveur;
    }

    @Override
    @Transaction
    public void saveEleveurGPS(TopiaContext transaction, String topiaId, Point point) throws TopiaException, LogicException {
        EleveurDAO eleveurDAO = SandraDAOHelper.getEleveurDAO((TopiaContext)transaction);
        Eleveur eleveur = (Eleveur)eleveurDAO.findByTopiaId(topiaId);
        if (eleveur == null) {
            throw new LogicException("error.service.eleveur.unfound");
        }
        PointGPS pointGPSOld = null;
        if (eleveur.getTomtomGPS() != null) {
            pointGPSOld = eleveur.getTomtomGPS();
            PointGPS pointGPS = eleveur.getTomtomGPS();
            SandraDAOHelper.getPointGPSDAO((TopiaContext)transaction).delete(pointGPS);
        }
        if (eleveur.getNbTomTomGPSModif() <= 3) {
            if (point.getX() != 0.0 && point.getY() != 0.0) {
                PointGPSDAO pointGPSDAO = SandraDAOHelper.getPointGPSDAO((TopiaContext)transaction);
                PointGPS pointGPS = (PointGPS)pointGPSDAO.create(new Object[]{"point", point});
                eleveur.setTomtomGPS(pointGPS);
            } else {
                eleveur.setTomtomGPS(null);
            }
        }
        eleveur.setNbTomTomGPSModif(0);
        eleveurDAO.update((TopiaEntity)eleveur);
        double oldX = pointGPSOld == null || pointGPSOld.getPoint() == null ? 0.0 : pointGPSOld.getPoint().getX();
        double oldY = pointGPSOld == null || pointGPSOld.getPoint() == null ? 0.0 : pointGPSOld.getPoint().getY();
        double newX = point.getX();
        double newY = point.getY();
        if (oldX != newX || oldY != newY) {
            this.serviceNotifier.notifyEvent("updateWebBreederGPS", ServiceHelper.getSandraName(), ServiceHelper.getSandraUrl(), SecurityHelper.getUser().getLogin(), eleveur.getTopiaId(), String.valueOf(oldX), String.valueOf(oldY), String.valueOf(newX), String.valueOf(newY));
        }
    }

    @Override
    @Transaction
    public void lockEleveurGPS(TopiaContext transaction, String topiaId, boolean lock) throws TopiaException, LogicException {
        EleveurDAO eleveurDAO = SandraDAOHelper.getEleveurDAO((TopiaContext)transaction);
        Eleveur eleveur = (Eleveur)eleveurDAO.findByTopiaId(topiaId);
        if (eleveur == null) {
            throw new LogicException("error.service.eleveur.unfound");
        }
        if (lock) {
            eleveur.setNbTomTomGPSModif(Integer.MAX_VALUE);
        } else {
            eleveur.setNbTomTomGPSModif(0);
            InfoAccess accesEleveur = eleveur.getAccesEleveur();
            Collection users = accesEleveur.getUsersVerrouillage();
            if (users != null && !users.isEmpty()) {
                for (TaasUser user : users) {
                    String email = user.getEmail();
                    if (StringUtils.isEmpty((CharSequence)email)) continue;
                    String eleveurLbl = eleveur.getRaisonSociale() + eleveur.getVille() + " (" + eleveur.getCodePostal().substring(0, 2) + ")";
                    String eleveurUrl = ServiceHelper.getSandraUrl() + "/appli/breeder/view.do?topiaId=" + eleveur.getTopiaId().replace("#", "%23");
                    EmailHelper.sendEmail((String)email, (String)("[" + ServiceHelper.getSandraUrl() + "] Le GPS de l'\u00e9leveur '" + eleveurLbl + "' est d\u00e9verrouill\u00e9."), (String)("Le GPS de l'\u00e9leveur '" + eleveurLbl + "' vient d'\u00eatre d\u00e9verrouill\u00e9 : " + eleveurUrl), (String[])new String[0]);
                }
                accesEleveur.clearUsersVerrouillage();
                InfoAccessDAO infoAccessDAO = SandraDAOHelper.getInfoAccessDAO((TopiaContext)transaction);
                infoAccessDAO.update((TopiaEntity)accesEleveur);
            }
        }
        eleveurDAO.update((TopiaEntity)eleveur);
    }

    @Override
    @Transaction
    public String getMessageBienvenue(TopiaContext transaction) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getMessageBienvenue");
        }
        String valeur = null;
        LabelDAO labelDAO = SandraDAOHelper.getLabelDAO((TopiaContext)transaction);
        Label label = labelDAO.findById("msg0");
        if (label != null) {
            valeur = label.getValeur();
        }
        return valeur;
    }

    @Override
    @Transaction
    public String getCopyright(TopiaContext transaction) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getCopyright");
        }
        String valeur = null;
        LabelDAO labelDAO = SandraDAOHelper.getLabelDAO((TopiaContext)transaction);
        Label label = labelDAO.findById("copyright");
        if (label != null) {
            valeur = label.getValeur();
        }
        return valeur;
    }

    @Override
    @Transaction
    public int getUsersCount(TopiaContext transaction, boolean viewCamion) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getUsersCount");
        }
        String hql = "SELECT COUNT(user.topiaId) FROM " + TaasUser.class.getName() + " user";
        hql = hql + ServiceWebImpl.getUserHql(viewCamion);
        int count = ProfilManager.count(transaction, TaasUser.class, hql, new Object[0]);
        return count;
    }

    @Override
    @Transaction
    public List<TaasUser> getAllUsers(TopiaContext transaction) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getAllUsers");
        }
        String hql = "SELECT user FROM " + TaasUser.class.getName() + " user" + ServiceWebImpl.getUserHql(false);
        List<TaasUser> users = ProfilManager.find(transaction, TaasUser.class, hql, new Object[0]);
        for (TaasUser user : users) {
            user.getPrincipals().size();
        }
        return users;
    }

    @Override
    @Transaction
    public List<UserIndicateurs> getAllUserIndicateurs(TopiaContext transaction) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getAllUsers");
        }
        String hql = "SELECT userIndicateur FROM " + UserIndicateurs.class.getName() + " userIndicateur JOIN userIndicateur.taasUser AS taasUser " + ServiceWebImpl.getUserHql(true);
        List<UserIndicateurs> users = ProfilManager.find(transaction, UserIndicateurs.class, hql, new Object[0]);
        return users;
    }

    @Override
    @Transaction
    public List<TaasUser> getAllUsers(TopiaContext transaction, boolean isCamion) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.info((Object)"getAllUsers");
        }
        List<TaasUser> users = !isCamion ? this.getAllUsers(transaction) : this.getAllCamionUser(transaction);
        return users;
    }

    @Override
    @Transaction
    public List<TaasUser> getAllCamionUser(TopiaContext transaction) throws TopiaException, LogicException {
        return SandraHelper.getAllCamionUser((TopiaContext)transaction);
    }

    @Override
    @Transaction
    public List<TaasUser> getUsers(TopiaContext transaction, boolean viewCamion, int startIndex, int endIndex, String sortCriterion, int sortDirection) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("gtUsers [" + startIndex + "-" + endIndex + "]<" + sortCriterion + "-" + sortDirection + ">"));
        }
        String hql = "SELECT user FROM " + TaasUser.class.getName() + " user";
        hql = hql + ServiceWebImpl.getUserHql(viewCamion);
        hql = hql + SandraHelper.addOrder((String)"user", (boolean)true, (String)sortCriterion, (int)sortDirection);
        List<TaasUser> users = ProfilManager.findWithBounds(transaction, TaasUser.class, hql, startIndex, endIndex, new Object[0]);
        for (TaasUser user : users) {
            user.getPrincipals().size();
        }
        return users;
    }

    protected static String getUserHql(boolean viewCamion) {
        if (viewCamion) {
            return " WHERE user IN ( SELECT user FROM " + TaasUser.class.getName() + " user JOIN user.principals AS principal WHERE" + " principal.name = 'synchro' AND user.login != 'synchro')";
        }
        return " WHERE user NOT IN ( SELECT user2 FROM " + TaasUser.class.getName() + " user2" + " JOIN user2.principals AS principal WHERE" + " principal.name = 'synchro')";
    }

    @Override
    @Transaction
    public int getUserIndicateursCount(TopiaContext transaction, boolean viewCamion) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getUserIndicateursCount");
        }
        String hql = "SELECT COUNT(userIndicateurs.topiaId) FROM " + UserIndicateurs.class.getName() + " userIndicateurs WHERE userIndicateurs.taasUser IN (SELECT user FROM " + TaasUser.class.getName() + " user";
        hql = hql + ServiceWebImpl.getUserIndicateurHql(viewCamion);
        hql = hql + ")";
        return ProfilManager.count(transaction, UserIndicateurs.class, hql, new Object[0]);
    }

    @Override
    @Transaction
    public List<UserIndicateurs> getUserIndicateurs(TopiaContext transaction, boolean viewCamion, int startIndex, int endIndex, String sortCriterion, int sortDirection) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("gtUsersIndicator [" + startIndex + "-" + endIndex + "]<" + sortCriterion + "-" + sortDirection + ">"));
        }
        String hql = "SELECT userIndicateurs FROM " + UserIndicateurs.class.getName() + " userIndicateurs WHERE userIndicateurs.taasUser IN (SELECT user FROM " + TaasUser.class.getName() + " user";
        hql = hql + ServiceWebImpl.getUserIndicateurHql(viewCamion);
        hql = "login".equals(sortCriterion) || "email".equals(sortCriterion) || "lastConnectionDate".equals(sortCriterion) || "link".equals(sortCriterion) ? hql + SandraHelper.addOrder((String)"user", (boolean)true, (String)sortCriterion, (int)sortDirection) : hql + SandraHelper.addOrder((String)"userIndicateurs", (boolean)true, (String)sortCriterion, (int)sortDirection);
        hql = hql + ")";
        return ProfilManager.findWithBounds(transaction, UserIndicateurs.class, hql, startIndex, endIndex, new Object[0]);
    }

    protected static String getUserIndicateurHql(boolean viewCamion) {
        if (viewCamion) {
            return " WHERE user IN ( SELECT user FROM " + TaasUser.class.getName() + " user JOIN user.principals AS principal WHERE" + " principal.name = 'synchro' AND user.login != 'synchro')";
        }
        return " WHERE user NOT IN ( SELECT user2 FROM " + TaasUser.class.getName() + " user2" + " JOIN user2.principals AS principal WHERE" + " principal.name = 'synchro')";
    }

    @Override
    @Transaction
    public TaasUser getUser(TopiaContext transaction, String topiaId) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getUser " + topiaId));
        }
        String query = "SELECT user FROM " + TaasUser.class.getName() + " user WHERE user.topiaId = :topiaId";
        TaasUser user = (TaasUser)ProfilManager.findUnique("error.service.user.unfound", transaction, TaasUser.class, query, "topiaId", topiaId);
        user.getPrincipals().size();
        return user;
    }

    @Override
    @Transaction
    public TaasUser getSafeUser(TopiaContext transaction, String topiaId) throws TopiaException, LogicException {
        TaasUser user;
        try {
            user = this.getUser(transaction, topiaId);
        }
        catch (LogicException eee) {
            UserIndicateurs userIndicateurs = this.getUserIndicateurs(transaction, topiaId);
            user = userIndicateurs.getTaasUser();
        }
        return user;
    }

    @Override
    @Transaction
    public UserIndicateurs getUserIndicateurs(TopiaContext transaction, String topiaId) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getUser " + topiaId));
        }
        String query = "SELECT userIndicateurs FROM " + UserIndicateurs.class.getName() + " userIndicateurs WHERE userIndicateurs.topiaId = :topiaId";
        UserIndicateurs user = (UserIndicateurs)ProfilManager.findUnique("error.service.user.unfound", transaction, UserIndicateurs.class, query, "topiaId", topiaId);
        return user;
    }

    @Override
    public TaasUser getUser() throws TopiaException {
        return SecurityHelper.getUser();
    }

    @Override
    protected String getUserLogin() throws TopiaException {
        String login = "not found";
        TaasUser user = this.getUser();
        if (user != null) {
            login = user.getLogin();
        }
        return login;
    }

    @Override
    @Transaction
    public TaasUser saveUser(TopiaContext transaction, TaasUser user, boolean isWeb, boolean isAdmin, String profil) throws TopiaException, LogicException {
        String principalAdminName;
        TaasPrincipal principalUser;
        TaasUser user2;
        TaasUserDAO userDAO = TopiaSecurityDAOHelper.getTaasUserDAO((TopiaContext)transaction);
        TaasPrincipalDAO principalDAO = TopiaSecurityDAOHelper.getTaasPrincipalDAO((TopiaContext)transaction);
        TaasAuthorizationDAO authorizationDAO = TopiaSecurityDAOHelper.getTaasAuthorizationDAO((TopiaContext)transaction);
        String topiaId = user.getTopiaId();
        String login = user.getLogin();
        String email = user.getEmail();
        if (topiaId == null || "".equals(topiaId)) {
            if (principalDAO.findByName(login) != null || userDAO.findByEmail(email) != null) {
                throw new LogicException("error.service.user.already.exists");
            }
            user2 = (TaasUser)userDAO.create(new Object[0]);
            topiaId = user2.getTopiaId();
            String passwd = RandomStringUtils.randomAlphanumeric((int)7);
            user2.setPassword(TaasUtil.hash((String)passwd));
            EmailHelper.sendEmail((String)email, (String)("[" + ServiceHelper.getSandraUrl() + "] Bienvenue sur Sandra"), (String)("Votre compte a \u00e9t\u00e9 cr\u00e9e. Votre login est : " + login + ", votre mot de passe est : " + passwd), (String[])new String[0]);
            principalUser = (TaasPrincipal)principalDAO.create(new Object[]{"name", login});
            TaasAuthorization authorization = (TaasAuthorization)authorizationDAO.create(new Object[]{"expression", topiaId, "actions", 4});
            principalUser.addAuthorizations(authorization);
            user2.addPrincipals(principalUser);
        } else {
            user2 = (TaasUser)userDAO.findByTopiaId(topiaId);
            String beforeLogin = user2.getLogin();
            if (!login.equals(beforeLogin)) {
                principalUser = principalDAO.findByName(beforeLogin);
                principalUser.setName(login);
            }
        }
        user2.setLogin(login);
        user2.setEmail(email);
        user2.setEnabled(user.getEnabled());
        user2.setLink(user.getLink());
        TaasPrincipal principalWeb = principalDAO.findByName("web");
        if (isWeb) {
            if (!user2.getPrincipals().contains(principalWeb)) {
                user2.addPrincipals(principalWeb);
            }
        } else {
            user2.getPrincipals().remove(principalWeb);
        }
        if ((principalAdminName = NotifierSecurityHelper.getAdminProfilValue((String)profil)) != null) {
            TaasPrincipal principalAdmin = principalDAO.findByName(principalAdminName);
            if (isAdmin) {
                if (!user2.getPrincipals().contains(principalAdmin)) {
                    user2.addPrincipals(principalAdmin);
                }
            } else {
                user2.getPrincipals().remove(principalAdmin);
            }
        }
        userDAO.update((TopiaEntity)user2);
        SandraHelper.createUserIndicateurIfDontExist((TopiaContext)transaction, (TaasUser)user2);
        return user2;
    }

    @Override
    @Transaction
    public void addProfilUser(TopiaContext transaction, String topiaIdUser, String topiaIdProfil) throws TopiaException, LogicException {
        TaasAuthorization authorization;
        TaasUserDAO userDAO = TopiaSecurityDAOHelper.getTaasUserDAO((TopiaContext)transaction);
        TaasPrincipalDAO principalDAO = TopiaSecurityDAOHelper.getTaasPrincipalDAO((TopiaContext)transaction);
        TaasAuthorizationDAO authorizationDAO = TopiaSecurityDAOHelper.getTaasAuthorizationDAO((TopiaContext)transaction);
        TaasUser user = null;
        user = this.checkUserExists((TaasUser)userDAO.findByTopiaId(topiaIdUser));
        TaasPrincipal principal = principalDAO.findByName(user.getLogin());
        if (principal.getAuthorizations().size() == 1) {
            String principalTypeName = SecurityHelper.getProfilName(topiaIdProfil);
            TaasPrincipal principalType = principalDAO.findByName(principalTypeName);
            user.addPrincipals(principalType);
        }
        if ((authorization = (TaasAuthorization)authorizationDAO.findByProperties("expression", (Object)topiaIdProfil, new Object[]{"actions", 1})) == null) {
            authorization = (TaasAuthorization)authorizationDAO.create(new Object[]{"expression", topiaIdProfil, "actions", 1});
        }
        principal.addAuthorizations(authorization);
    }

    @Override
    @Transaction
    public void deleteProfilUser(TopiaContext transaction, String topiaIdUser, String topiaIdProfil) throws TopiaException, LogicException {
        TaasUserDAO userDAO = TopiaSecurityDAOHelper.getTaasUserDAO((TopiaContext)transaction);
        TaasPrincipalDAO principalDAO = TopiaSecurityDAOHelper.getTaasPrincipalDAO((TopiaContext)transaction);
        TaasAuthorizationDAO authorizationDAO = TopiaSecurityDAOHelper.getTaasAuthorizationDAO((TopiaContext)transaction);
        TaasUser user = this.checkUserExists((TaasUser)userDAO.findByTopiaId(topiaIdUser));
        TaasAuthorization authorization = (TaasAuthorization)authorizationDAO.findByProperties("expression", (Object)topiaIdProfil, new Object[]{"actions", 1});
        if (authorization == null) {
            throw new LogicException("error.service.authorization.unfound");
        }
        TaasPrincipal principal = principalDAO.findByName(user.getLogin());
        principal.removeAuthorizations(authorization);
        transaction.commitTransaction();
        if (principal.getAuthorizations().size() == 1) {
            String principalTypeName = SecurityHelper.getProfilName(topiaIdProfil);
            TaasPrincipal principalType = principalDAO.findByName(principalTypeName);
            user.getPrincipals().remove(principalType);
            String principalAdminName = NotifierSecurityHelper.getAdminProfilName((String)topiaIdProfil);
            TaasPrincipal principalAdmin = principalDAO.findByName(principalAdminName);
            user.getPrincipals().remove(principalAdmin);
        }
    }

    @Override
    @Transaction
    public void passwdUser(TopiaContext transaction, String passwdBefore, String passwdNew) throws TopiaException, LogicException {
        TaasUser privateCredential;
        TaasUserDAO userDAO = TopiaSecurityDAOHelper.getTaasUserDAO((TopiaContext)transaction);
        TaasUser user = (TaasUser)userDAO.findByTopiaId((privateCredential = SecurityHelper.getUser()).getTopiaId());
        if (!user.getPassword().equals(TaasUtil.hash((String)passwdBefore))) {
            throw new LogicException("error.service.user.unvalid.beforePassword");
        }
        user.setPassword(TaasUtil.hash((String)passwdNew));
        userDAO.update((TopiaEntity)user);
    }

    @Override
    @Transaction(secure=false)
    public void sendPasswdUser(TopiaContext transaction, String email) throws TopiaException, LogicException {
        TaasUserDAO userDAO = TopiaSecurityDAOHelper.getTaasUserDAO((TopiaContext)transaction);
        TaasUser user = this.checkUserExists(userDAO.findByEmail(email));
        String passwd = RandomStringUtils.randomAlphanumeric((int)7);
        user.setPassword(TaasUtil.hash((String)passwd));
        EmailHelper.sendEmail((String)email, (String)("[" + ServiceHelper.getSandraName() + "] Nouveau mot de passe"), (String)("Votre nouveau mot de passe pour l'instance " + ServiceHelper.getSandraUrl() + " est : " + passwd), (String[])new String[0]);
        userDAO.update((TopiaEntity)user);
    }

    @Override
    @Transaction
    public List<TaasUser> getUsersPrincipal(TopiaContext transaction, String name) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getUsersByPrincipal " + name));
        }
        String query = "SELECT user FROM " + TaasUser.class.getName() + " user JOIN user.principals AS principal WHERE principal.name = :name ORDER BY user.login";
        List<TaasUser> users = ProfilManager.find(transaction, TaasUser.class, query, "name", name);
        return users;
    }

    protected TaasUser checkUserExists(TaasUser user) throws LogicException {
        if (user == null) {
            throw new LogicException("error.service.user.unfound");
        }
        return user;
    }

    protected String createTourQuery(String beginQuery, TopiaContext transaction, Date dateDebut, Date dateFin, boolean planifie, boolean termine, String topiaIdSociete, String topiaIdTransporteur, String topiaIdCamion, String topiaIdChauffeur, List<Object> arguments) throws TopiaException {
        ArrayList<String> criteres = new ArrayList<String>();
        Societe societe = null;
        Transporteur transporteur = null;
        Camion camion = null;
        Chauffeur chauffeur = null;
        if (topiaIdSociete != null) {
            SocieteDAO societeDAO = SandraDAOHelper.getSocieteDAO((TopiaContext)transaction);
            societe = (Societe)societeDAO.findByTopiaId(topiaIdSociete);
        }
        if (topiaIdTransporteur != null) {
            TransporteurDAO transporteurDAO = SandraDAOHelper.getTransporteurDAO((TopiaContext)transaction);
            transporteur = (Transporteur)transporteurDAO.findByTopiaId(topiaIdTransporteur);
        }
        if (topiaIdCamion != null) {
            CamionDAO camionDAO = SandraDAOHelper.getCamionDAO((TopiaContext)transaction);
            camion = (Camion)camionDAO.findByTopiaId(topiaIdCamion);
        }
        if (topiaIdChauffeur != null) {
            ChauffeurDAO chauffeurDAO = SandraDAOHelper.getChauffeurDAO((TopiaContext)transaction);
            chauffeur = (Chauffeur)chauffeurDAO.findByTopiaId(topiaIdChauffeur);
        }
        String requete = beginQuery;
        arguments.add("dateDebut");
        arguments.add(DateUtil.setMinTimeOfDay((Date)dateDebut));
        criteres.add("tour.dateLivraison >= :dateDebut");
        arguments.add("dateFin");
        arguments.add(DateUtil.setMaxTimeOfDay((Date)dateFin));
        criteres.add("tour.dateLivraison <= :dateFin");
        criteres.add("tour.actif = true");
        boolean useJoin = false;
        if (!planifie && !termine) {
            arguments.add("statusTourTermine");
            arguments.add(-1);
            criteres.add("(suiviTour IS NOT NULL AND suiviTour.status != :statusTourTermine)");
            useJoin = true;
        } else if (planifie && !termine) {
            criteres.add("tour.suiviTour IS NULL");
        } else if (!planifie && termine) {
            arguments.add("statusTourTermine");
            arguments.add(-1);
            criteres.add("suiviTour.status = :statusTourTermine");
            useJoin = true;
        }
        if (societe != null) {
            arguments.add("societe");
            arguments.add(societe);
            criteres.add("tour.camion.societe = :societe");
        }
        if (transporteur != null) {
            arguments.add("transporteur");
            arguments.add(transporteur);
            criteres.add("tour.camion.transporteur = :transporteur");
        }
        if (camion != null) {
            arguments.add("camion");
            arguments.add(camion);
            criteres.add("tour.camion = :camion");
        }
        if (chauffeur != null) {
            arguments.add("chauffeur");
            arguments.add(chauffeur);
            criteres.add("tour.defautChauffeur = :chauffeur");
        }
        if (!criteres.isEmpty()) {
            requete = !useJoin ? requete + " FROM  " + Tour.class.getName() + " tour WHERE " : requete + " FROM " + Tour.class.getName() + " tour LEFT JOIN tour.suiviTour AS suiviTour WHERE ";
        }
        String and = "";
        for (String critere : criteres) {
            requete = requete + and + critere;
            and = " AND ";
        }
        return requete;
    }

    @Override
    @Transaction
    public InputStream getFileNote(TopiaContext transaction, String topiaId) throws TopiaException, LogicException {
        FileInputStream inputStream;
        NoteDAO dao = SandraDAOHelper.getNoteDAO((TopiaContext)transaction);
        Note note = (Note)dao.findByTopiaId(topiaId);
        if (note == null) {
            throw new LogicException("error.service.note.unfound");
        }
        String name = SandraConfigHelper.getNoteDir(SandraConfig.getConfig()) + File.separator + note.getNom();
        try {
            inputStream = new FileInputStream(name);
        }
        catch (FileNotFoundException ex) {
            throw new LogicException("error.service.file.unfound", ex);
        }
        return inputStream;
    }

    @Override
    @Transaction
    public Note saveNote(TopiaContext transaction, Note note, InputStream inputStream) throws TopiaException, LogicException {
        Note note2;
        NoteDAO dao = SandraDAOHelper.getNoteDAO((TopiaContext)transaction);
        Note noteByNom = dao.findByNom(note.getNom());
        if (noteByNom != null) {
            throw new LogicException("error.service.note.exist");
        }
        String topiaId = note.getTopiaId();
        if (topiaId == null || "".equals(topiaId)) {
            note2 = (Note)dao.create(new Object[0]);
            if (log.isInfoEnabled()) {
                log.info((Object)("has created note " + note2.getTopiaId()));
            }
        } else {
            note2 = (Note)dao.findByTopiaId(topiaId);
            if (log.isInfoEnabled()) {
                log.info((Object)("update note " + note2.getTopiaId()));
            }
        }
        note2.setNom(note.getNom());
        note2.setDescription(note.getDescription());
        note2.setContentType(note.getContentType());
        String name = SandraConfigHelper.getNoteDir(SandraConfig.getConfig()) + File.separator + note2.getNom();
        try {
            FileOutputStream outputStream = new FileOutputStream(name);
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
        catch (IOException ex) {
            log.error((Object)"error.service.file.copy", (Throwable)ex);
            throw new LogicException("error.service.file.copy", ex);
        }
        dao.update((TopiaEntity)note2);
        return note2;
    }

    @Override
    @Transaction
    public void addNote(TopiaContext transaction, String eleveurTopiaId, String noteTopiaId) throws TopiaException, LogicException {
        EleveurDAO eleveurDAO = SandraDAOHelper.getEleveurDAO((TopiaContext)transaction);
        Eleveur eleveur = (Eleveur)eleveurDAO.findByTopiaId(eleveurTopiaId);
        if (eleveur == null) {
            throw new LogicException("error.service.eleveur.unfound");
        }
        NoteDAO noteDAO = SandraDAOHelper.getNoteDAO((TopiaContext)transaction);
        Note note = (Note)noteDAO.findByTopiaId(noteTopiaId);
        if (note == null) {
            throw new LogicException("error.service.note.unfound");
        }
        eleveur.addNotes(note);
        eleveurDAO.update((TopiaEntity)eleveur);
    }

    @Override
    @Transaction
    public void deleteNote(TopiaContext transaction, String topiaId) throws TopiaException, LogicException {
        NoteDAO dao = SandraDAOHelper.getNoteDAO((TopiaContext)transaction);
        Note note = (Note)dao.findByTopiaId(topiaId);
        if (note == null) {
            throw new LogicException("error.service.note.unfound");
        }
        dao.delete((TopiaEntity)note);
        String name = SandraConfigHelper.getNoteDir(SandraConfig.getConfig()) + File.separator + note.getNom();
        boolean deleted = new File(name).delete();
        if (!deleted) {
            log.error((Object)("Cant delete note : " + name));
        }
    }

    @Override
    @Transaction
    public Note getNote(TopiaContext transaction, String topiaId) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getNote " + topiaId));
        }
        String query = "SELECT note FROM " + Note.class.getName() + " note WHERE note.topiaId = :topiaId";
        Note note = (Note)ProfilManager.findUnique("error.service.note.unfound", transaction, Note.class, query, "topiaId", topiaId);
        return note;
    }

    @Override
    @Transaction
    public List<Label> getLabels(TopiaContext transaction) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getLabels");
        }
        List<Label> labels = ProfilManager.find(transaction, Label.class, "SELECT label FROM " + Label.class.getName() + " label ORDER BY label.categorie, label.id", new Object[0]);
        return labels;
    }

    @Override
    @Transaction
    public List<Label> getLabels(TopiaContext transaction, int startIndex, int endIndex, String sortCriterion, int sortDirection) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getLabels [" + startIndex + "-" + endIndex + "]<" + sortCriterion + "-" + sortDirection + ">"));
        }
        String query = "SELECT label FROM " + Label.class.getName() + " label";
        String order = sortCriterion == null ? " ORDER BY label.categorie, label.id" : SandraHelper.addOrder((String)"label", (String)sortCriterion, (int)sortDirection);
        query = query + order;
        List<Label> labels = ProfilManager.findWithBounds(transaction, Label.class, query, startIndex, endIndex, new Object[0]);
        return labels;
    }

    @Override
    @Transaction
    public Label getLabel(TopiaContext transaction, String topiaId) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getLabel " + topiaId));
        }
        String query = "SELECT label FROM " + Label.class.getName() + " label WHERE label.topiaId = :topiaId";
        Label usine = (Label)ProfilManager.findUnique("error.service.label.unfound", transaction, Label.class, query, "topiaId", topiaId);
        return usine;
    }

    @Override
    @Transaction
    public Label saveLabel(TopiaContext transaction, Label label) throws TopiaException, LogicException {
        Label label2;
        LabelDAO dao = SandraDAOHelper.getLabelDAO((TopiaContext)transaction);
        String categorie = label.getCategorie();
        String id = label.getId();
        String topiaId = label.getTopiaId();
        if (topiaId == null || "".equals(topiaId)) {
            if (dao.findByNaturalId(id, categorie) != null) {
                throw new LogicException("error.service.label.already.exists");
            }
            label2 = label;
            label2.setTopiaId(TopiaId.create(Label.class));
            if (log.isInfoEnabled()) {
                log.info((Object)("has created label " + label2.getTopiaId()));
            }
        } else {
            label2 = (Label)dao.findByTopiaId(topiaId);
            if (!(label2.getCategorie().equals(categorie) && label2.getId().equals(id) || dao.findByProperties(id, (Object)categorie, new Object[0]) == null)) {
                throw new LogicException("error.service.label.already.exists");
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("update label " + label2.getTopiaId()));
            }
            label2.setCategorie(categorie);
            label2.setId(id);
            label2.setValeur(label.getValeur());
        }
        dao.update((TopiaEntity)label2);
        return label2;
    }

    @Override
    @Transaction
    public void deleteLabel(TopiaContext transaction, String topiaId) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("deleteLabel " + topiaId));
        }
        Label label = this.getLabel(transaction, topiaId);
        SandraDAOHelper.getLabelDAO((TopiaContext)transaction).delete((TopiaEntity)label);
    }

    @Override
    @Transaction
    public ChargementUsineConfig getChargementUsineConfigForUsine(TopiaContext transaction, String topiaId) throws TopiaException, LogicException {
        ChargementUsineConfig config;
        if (log.isDebugEnabled()) {
            log.debug((Object)("getChargementUsineConfigForUsine " + topiaId));
        }
        String query = "SELECT config FROM " + ChargementUsineConfig.class.getName() + " config WHERE config.usine.topiaId = :topiaId";
        try {
            config = (ChargementUsineConfig)ProfilManager.findUnique("error.service.loading.usine.unfound", transaction, ChargementUsineConfig.class, query, "topiaId", topiaId);
        }
        catch (LogicException e) {
            Usine usine = this.getUsine(transaction, topiaId);
            ChargementUsineConfigDAO dao = SandraDAOHelper.getChargementUsineConfigDAO((TopiaContext)transaction);
            config = (ChargementUsineConfig)dao.create(new Object[0]);
            config.setUsine(usine);
            config.setNombreHeures(25);
            config.setPositionHeureActuelle(40);
            dao.update((TopiaEntity)config);
        }
        return config;
    }

    @Override
    @Transaction
    public ChargementUsineConfig getChargementUsineConfig(TopiaContext transaction, String topiaId) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getChargementUsineConfig " + topiaId));
        }
        String query = "SELECT config FROM " + ChargementUsineConfig.class.getName() + " config WHERE config.topiaId = :topiaId";
        ChargementUsineConfig config = (ChargementUsineConfig)ProfilManager.findUnique("error.service.label.unfound", transaction, ChargementUsineConfig.class, query, "topiaId", topiaId);
        return config;
    }

    @Override
    @Transaction
    public ChargementUsineConfig saveChargementUsineConfig(TopiaContext transaction, ChargementUsineConfig chargementUsineConfig) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("saveChargementUsineConfig " + chargementUsineConfig.getTopiaId()));
        }
        ChargementUsineConfigDAO dao = SandraDAOHelper.getChargementUsineConfigDAO((TopiaContext)transaction);
        String topiaId = chargementUsineConfig.getTopiaId();
        ChargementUsineConfig chargementUsineConfig2 = topiaId == null || "".equals(topiaId) ? (ChargementUsineConfig)dao.create(new Object[0]) : (ChargementUsineConfig)dao.findByTopiaId(topiaId);
        Usine usine = this.getUsine(transaction, chargementUsineConfig.getUsine().getTopiaId());
        chargementUsineConfig2.setUsine(usine);
        chargementUsineConfig2.setNombreHeures(chargementUsineConfig.getNombreHeures());
        chargementUsineConfig2.setPositionHeureActuelle(chargementUsineConfig.getPositionHeureActuelle());
        chargementUsineConfig2.setTempFixeParTournee(chargementUsineConfig.getTempFixeParTournee());
        chargementUsineConfig2.setTempFixeParLigneProduit(chargementUsineConfig.getTempFixeParLigneProduit());
        chargementUsineConfig2.setTempVariableParQuantite(chargementUsineConfig.getTempVariableParQuantite());
        dao.update((TopiaEntity)chargementUsineConfig2);
        return chargementUsineConfig2;
    }

    @Override
    @Transaction
    public Eleveur saveEleveur(TopiaContext transaction, Eleveur breeder) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("saveEleveur " + breeder.getTopiaId()));
        }
        EleveurDAO eleveurDAO = SandraDAOHelper.getEleveurDAO((TopiaContext)transaction);
        InfoAccessDAO infoAccessDAO = SandraDAOHelper.getInfoAccessDAO((TopiaContext)transaction);
        SocieteDAO societeDAO = SandraDAOHelper.getSocieteDAO((TopiaContext)transaction);
        String breederTopiaId = breeder.getTopiaId();
        InfoAccess infoAccess = breeder.getAccesEleveur();
        String accessEleveurTopiaId = breeder.getAccesEleveur().getTopiaId();
        Eleveur breederOld = (Eleveur)eleveurDAO.findByTopiaId(breederTopiaId);
        InfoAccess infoAccessOld = (InfoAccess)infoAccessDAO.findByTopiaId(accessEleveurTopiaId);
        if (infoAccessOld == null) {
            log.error((Object)"acces eleveur is null !!!!!");
            infoAccessOld = (InfoAccess)infoAccessDAO.create(new Object[0]);
            infoAccessOld.setNiveauSecurite(-1);
            infoAccessOld.setEtat(InfoAccessEtat.INFOACCESS_ACTIF);
            infoAccessOld.setType(0);
        }
        this.serviceCommon.notifyChangedBreeder(transaction, "updateWebBreeder", this.getUserLogin(), breederOld, breeder, infoAccessOld, infoAccess);
        breederOld.setRaisonSociale(breeder.getRaisonSociale());
        breederOld.setAdresse(breeder.getAdresse());
        breederOld.setCodeINSEE(breeder.getCodeINSEE());
        breederOld.setCodePostal(breeder.getCodePostal());
        breederOld.setContrainteHoraire(breeder.getContrainteHoraire());
        breederOld.setMobile(breeder.getMobile());
        breederOld.setEmail(breeder.getEmail());
        breederOld.setTelephone(breeder.getTelephone());
        breederOld.setVille(breeder.getVille());
        breederOld.setCommentaire(breeder.getCommentaire());
        Societe societe = (Societe)societeDAO.findByTopiaId(breeder.getSociete().getTopiaId());
        if (societe != null) {
            breederOld.setSociete(societe);
        } else {
            log.error((Object)"societe is null !!!!!");
        }
        infoAccessOld.addAllRisques(infoAccess.getRisques());
        infoAccessOld.setAccesSilo(infoAccess.getAccesSilo());
        infoAccessOld.setCommentaireSecurite(infoAccess.getCommentaireSecurite());
        infoAccessOld.setEtat(infoAccess.getEtat());
        infoAccessOld.setGps(infoAccess.getGps());
        infoAccessOld.setModeChargement(infoAccess.getModeChargement());
        infoAccessOld.setNiveauSecurite(infoAccess.getNiveauSecurite());
        infoAccessOld.setNomAcces(infoAccess.getNomAcces());
        infoAccessOld.setRisques(infoAccess.getRisques());
        infoAccessOld.setTrace(infoAccess.getTrace());
        infoAccessOld.setType(infoAccess.getType());
        infoAccessDAO.update((TopiaEntity)infoAccessOld);
        eleveurDAO.update((TopiaEntity)breederOld);
        return breederOld;
    }

    @Override
    @Transaction
    public InfoAccess getInfoAccess(TopiaContext transaction, String topiaId) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getAccesSilo " + topiaId));
        }
        InfoAccessDAO infoAccessDAO = SandraDAOHelper.getInfoAccessDAO((TopiaContext)transaction);
        InfoAccess infoAccess = (InfoAccess)infoAccessDAO.findByTopiaId(topiaId);
        return infoAccess;
    }

    @Override
    @Transaction
    public Eleveur findEleveurByAccesSilo(TopiaContext transaction, String infoAccessTopiaId) throws TopiaException, LogicException {
        if (log.isInfoEnabled()) {
            log.info((Object)("findEleveurByAccesSilo " + infoAccessTopiaId));
        }
        InfoAccessDAO infoAccessDAO = SandraDAOHelper.getInfoAccessDAO((TopiaContext)transaction);
        InfoAccess silo = (InfoAccess)infoAccessDAO.findByTopiaId(infoAccessTopiaId);
        Eleveur breeder = silo.getEleveur();
        return breeder;
    }

    @Override
    @Transaction
    public InfoAccess saveInfoAccess(TopiaContext transaction, InfoAccess infoAccess, String breederTopiaID) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("saveInfoAccess " + infoAccess.getTopiaId()));
        }
        InfoAccessDAO dao = SandraDAOHelper.getInfoAccessDAO((TopiaContext)transaction);
        String topiaId = infoAccess.getTopiaId();
        InfoAccess infoAccess2 = (InfoAccess)dao.findByTopiaId(topiaId);
        PointGPS oldGPS = null;
        Point newGPS = infoAccess.getGps().getPoint();
        if (infoAccess2.getGps() != null) {
            oldGPS = infoAccess2.getGps();
            PointGPS pointGPS = infoAccess2.getGps();
            SandraDAOHelper.getPointGPSDAO((TopiaContext)transaction).delete(pointGPS);
        }
        if (infoAccess2.getEtat() == InfoAccessEtat.INFOACCESS_ACTIF) {
            PointGPSDAO pointGPSDAO = SandraDAOHelper.getPointGPSDAO((TopiaContext)transaction);
            PointGPS pointGPS = (PointGPS)pointGPSDAO.create(new Object[]{"point", newGPS});
            infoAccess2.setGps(pointGPS);
        }
        this.serviceCommon.notifyChangedInfoAccess(transaction, "updateWebAccesSilo", this.getUserLogin(), breederTopiaID, infoAccess2, infoAccess, oldGPS == null ? 0.0 : oldGPS.getPoint().getX(), oldGPS == null ? 0.0 : oldGPS.getPoint().getY());
        infoAccess2.setAccesSilo(infoAccess.getAccesSilo());
        infoAccess2.setCommentaireSecurite(infoAccess.getCommentaireSecurite());
        infoAccess2.setModeChargement(infoAccess.getModeChargement());
        infoAccess2.setNiveauSecurite(infoAccess.getNiveauSecurite());
        infoAccess2.setRisques(infoAccess.getRisques());
        infoAccess2.setTrace(infoAccess.getTrace());
        infoAccess2.setType(infoAccess.getType());
        dao.update((TopiaEntity)infoAccess2);
        return infoAccess2;
    }

    @Override
    @Transaction
    public void deleteAccesSilo(TopiaContext transaction, String infoAccessTopiaId) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("deleteAccesSilo " + infoAccessTopiaId));
        }
        InjectorEleveurDuplicated.deleteAccesSilo((TopiaContext)transaction, (String)infoAccessTopiaId);
    }

    @Override
    @Transaction
    public void lockOrUnlockInfoAccess(TopiaContext transaction, String infoAccessTopiaId) throws TopiaException, LogicException {
        InfoAccessDAO dao;
        InfoAccess infoAccess;
        if (log.isDebugEnabled()) {
            log.debug((Object)("lockOrUnlockInfoAccess " + infoAccessTopiaId));
        }
        if ((infoAccess = (InfoAccess)(dao = SandraDAOHelper.getInfoAccessDAO((TopiaContext)transaction)).findByTopiaId(infoAccessTopiaId)).getEtat() == InfoAccessEtat.INFOACCESS_ACTIF) {
            infoAccess.setEtat(InfoAccessEtat.INFOACCESS_VERROU);
        } else {
            infoAccess.setEtat(InfoAccessEtat.INFOACCESS_ACTIF);
            Collection users = infoAccess.getUsersVerrouillage();
            if (users != null && !users.isEmpty()) {
                for (TaasUser user : users) {
                    String email = user.getEmail();
                    if (StringUtils.isEmpty((CharSequence)email)) continue;
                    Eleveur eleveur = infoAccess.getEleveur();
                    String eleveurLbl = eleveur.getRaisonSociale() + eleveur.getVille() + eleveur.getCodePostal().substring(0, 2);
                    String siloLbl = infoAccess.getNomAcces();
                    String siloUrl = ServiceHelper.getSandraUrl() + "/appli/breeder/infoAccess/view.do?topiaId=" + infoAccess.getTopiaId().replace("#", "%23");
                    EmailHelper.sendEmail((String)email, (String)("[" + ServiceHelper.getSandraUrl() + "] Le GPS du silo '" + siloLbl + "'de l'\u00e9leveur '" + eleveurLbl + "' est d\u00e9verrouill\u00e9."), (String)("Le GPS du silo '" + siloLbl + "' de l'\u00e9leveur '" + eleveurLbl + "' est d\u00e9verrouill\u00e9 : " + siloUrl), (String[])new String[0]);
                }
                infoAccess.clearUsersVerrouillage();
            }
        }
        dao.update((TopiaEntity)infoAccess);
    }

    @Override
    @Transaction
    public void findAndDeleteDuplicateInfoAccess(TopiaContext transaction) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"findAndDeleteDuplicateInfoAccess");
        }
        InfoAccessDAO dao = SandraDAOHelper.getInfoAccessDAO((TopiaContext)transaction);
        int cnt = 0;
        List infoAccessList = dao.findAll();
        HashMap<String, InfoAccess> infoAccessNames = new HashMap<String, InfoAccess>();
        for (InfoAccess infoAccess : infoAccessList) {
            InfoAccess cached = (InfoAccess)infoAccessNames.get(infoAccess.getNomAcces());
            if (cached != null) {
                Eleveur cachedEleveur = this.findEleveurByAccesSilo(transaction, cached.getTopiaId());
                Eleveur eleveur = this.findEleveurByAccesSilo(transaction, infoAccess.getTopiaId());
                if (cachedEleveur == null || eleveur == null || !cachedEleveur.getTopiaId().equals(eleveur.getTopiaId())) continue;
                dao.delete(infoAccess);
                ++cnt;
                continue;
            }
            String name = infoAccess.getNomAcces();
            if (name == null || name.trim().isEmpty()) continue;
            infoAccessNames.put(name, infoAccess);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("All duplicate info access are deleted, found : " + cnt));
        }
    }

    @Override
    @Transaction
    public SuiviLigneProduit getSuiviProduit(TopiaContext transaction, LigneProduit product) throws TopiaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getSuiviProduit : " + product.getTopiaId()));
        }
        SuiviLigneProduitDAO suiviLigneProduitDAO = SandraDAOHelper.getSuiviLigneProduitDAO((TopiaContext)transaction);
        SuiviLigneProduit suiviProduit = suiviLigneProduitDAO.findByLigneProduit(product);
        if (log.isDebugEnabled()) {
            log.debug((Object)("getSuiviProduit : " + (suiviProduit == null ? "null" : suiviProduit.getTopiaId())));
        }
        return suiviProduit;
    }

    @Override
    @Transaction
    public ActionSecurite saveActionSecurite(TopiaContext transaction, ActionSecurite action, String eleveurId, String siloId, String emails, boolean history) throws TopiaException {
        ActionSecurite actionRestored;
        if (log.isDebugEnabled()) {
            log.debug((Object)("saveActionSecurite : " + action.getTopiaId() + " for eleveur " + eleveurId + " and silo " + siloId));
        }
        ActionSecuriteDAO actionDAO = SandraDAOHelper.getActionSecuriteDAO((TopiaContext)transaction);
        EleveurDAO eleveurDAO = SandraDAOHelper.getEleveurDAO((TopiaContext)transaction);
        InfoAccessDAO infoAccessDAO = SandraDAOHelper.getInfoAccessDAO((TopiaContext)transaction);
        String topiaId = action.getTopiaId();
        if (topiaId == null || "".equals(topiaId)) {
            actionRestored = (ActionSecurite)actionDAO.create(new Object[0]);
            actionRestored.setDateCreation(new Date());
            actionRestored.setUserCreation(this.getRestoredUser(transaction).getLogin());
        } else {
            actionRestored = (ActionSecurite)actionDAO.findByTopiaId(topiaId);
        }
        actionRestored.setDateAction(action.getDateAction());
        actionRestored.setCommentaire(action.getCommentaire());
        actionRestored.setType(action.getType());
        Eleveur eleveur = (Eleveur)eleveurDAO.findByTopiaId(eleveurId);
        actionRestored.setEleveur(eleveur);
        InfoAccess silo = (InfoAccess)infoAccessDAO.findByTopiaId(siloId);
        actionRestored.setInfoAccess(silo);
        int niveauSecurite = silo != null ? silo.getNiveauSecurite() : eleveur.getGloabalNiveauSecurite();
        actionRestored.setNiveauSecurite(niveauSecurite);
        eleveur.addActionSecurite(actionRestored);
        actionRestored = (ActionSecurite)actionDAO.update((TopiaEntity)actionRestored);
        eleveurDAO.update((TopiaEntity)eleveur);
        if (emails != null) {
            String[] to = emails.split(",|;|(\r)?\n");
            ArrayList pjs = new ArrayList(0);
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("action", actionRestored);
            if (history && silo != null) {
                String query = "SELECT act FROM " + ActionSecurite.class.getName() + " act " + " WHERE act.infoAccess = :silo AND act != :action AND act.infoAccess IS NOT NULL" + " ORDER BY act.dateAction";
                List actions = transaction.findAll(query, new Object[]{"action", action, "silo", silo});
                context.put("previousActions", actions);
            }
            HashMap<String, String> types = new HashMap<String, String>();
            context.put("types", types);
            LabelDAO labelDAO = SandraDAOHelper.getLabelDAO((TopiaContext)transaction);
            List labels = labelDAO.findAllByCategorie("ACT");
            for (Label label : labels) {
                String id = label.getId();
                String valeur = label.getValeur();
                types.put(id, valeur);
            }
            EmailHelper.sendEmailFromTemplate((String)"notifActionSecurite", context, (String[])to, pjs);
        }
        return actionRestored;
    }

    @Override
    @Transaction
    public void deleteActionSecurite(TopiaContext transaction, String topiaId) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("deleteActionSecurite : " + topiaId));
        }
        ActionSecuriteDAO dao = SandraDAOHelper.getActionSecuriteDAO((TopiaContext)transaction);
        EleveurDAO eleveurDAO = SandraDAOHelper.getEleveurDAO((TopiaContext)transaction);
        ActionSecurite action = (ActionSecurite)dao.findByTopiaId(topiaId);
        if (action == null) {
            throw new LogicException("error.service.action.unfound");
        }
        Eleveur eleveur = action.getEleveur();
        eleveur.removeActionSecurite(action);
        eleveurDAO.update((TopiaEntity)eleveur);
        dao.delete((TopiaEntity)action);
    }

    @Override
    @Transaction
    public ActionSecurite getActionSecurite(TopiaContext transaction, String topiaId) throws TopiaException, LogicException {
        ActionSecuriteDAO dao;
        ActionSecurite action;
        if (log.isDebugEnabled()) {
            log.debug((Object)("getActionSecurite : " + topiaId));
        }
        if ((action = (ActionSecurite)(dao = SandraDAOHelper.getActionSecuriteDAO((TopiaContext)transaction)).findByTopiaId(topiaId)) == null) {
            throw new LogicException("error.service.action.unfound");
        }
        return action;
    }

    @Override
    @Transaction
    public Societe getUserSociete(TopiaContext transaction, TaasUser user) throws TopiaException, LogicException {
        SocieteDAO dao;
        Societe societe;
        if (log.isDebugEnabled()) {
            log.debug((Object)("getUserSociete : " + user));
        }
        if ((societe = (Societe)(dao = SandraDAOHelper.getSocieteDAO((TopiaContext)transaction)).findByTopiaId(user.getLink())) == null) {
            throw new LogicException("error.service.societe.unfound");
        }
        return societe;
    }

    @Override
    @Transaction
    public void requestToUnlockBreeder(TopiaContext transaction, String topiaId) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("requestToUnlockBreeder : " + topiaId));
        }
        TaasUser user = this.getUser();
        EleveurDAO eleveurDAO = SandraDAOHelper.getEleveurDAO((TopiaContext)transaction);
        InfoAccessDAO infoAccessDAO = SandraDAOHelper.getInfoAccessDAO((TopiaContext)transaction);
        Eleveur eleveur = (Eleveur)eleveurDAO.findByTopiaId(topiaId);
        InfoAccess accesEleveur = eleveur.getAccesEleveur();
        accesEleveur.addUsersVerrouillage(user);
        infoAccessDAO.update((TopiaEntity)accesEleveur);
        this.serviceNotifier.notifyEvent("requestUnlockGPS", ServiceHelper.getSandraName(), ServiceHelper.getSandraUrl(), user.getLogin(), topiaId);
    }

    @Override
    @Transaction
    public void requestToUnlockInfoAcces(TopiaContext transaction, Eleveur eleveur, String topiaId) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("requestToUnlockBreeder : eleveur[" + eleveur.getTopiaId() + "] silo[" + topiaId + "]"));
        }
        TaasUser user = this.getUser();
        InfoAccessDAO infoAccessDAO = SandraDAOHelper.getInfoAccessDAO((TopiaContext)transaction);
        InfoAccess silo = (InfoAccess)infoAccessDAO.findByTopiaId(topiaId);
        silo.addUsersVerrouillage(user);
        infoAccessDAO.update((TopiaEntity)silo);
        this.serviceNotifier.notifyEvent("requestUnlockInfoAccess", ServiceHelper.getSandraUrl(), user.getLogin(), eleveur.getTopiaId(), topiaId);
    }

    @Override
    @Transaction
    public Eleveur registerBreederAsDuplicated(TopiaContext transaction, String eleveurId, String eleveurDuplicatedId) throws TopiaException, LogicException {
        ManagerInjector managerInjector = new ManagerInjector();
        managerInjector.setTransaction(transaction);
        Eleveur eleveur = InjectorEleveurDuplicated.registerBreederAsDuplicated((ManagerInjector)managerInjector, (String)eleveurId, (String)eleveurDuplicatedId, (boolean)true);
        return eleveur;
    }

    @Override
    @Transaction
    public String searchBreederAsDuplicated(TopiaContext transaction) throws TopiaException, IOException {
        String export = "ville;code postal;code soci\u00e9t\u00e9;code \u00e9leveur;raison sociale;adresse;t\u00e9l\u00e9phone;mobile;\u00e9tat GPS;nombre de silos;code;raison sociale;adresse\n";
        Session hibernate = ((TopiaContextImpl)transaction).getHibernate();
        SQLQuery query = hibernate.createSQLQuery("SELECT \ne.ville as eVille,\ne.codePostal as eCodePostal,\nse.code as esCode,\ne.code as eCode,\ne.raisonSociale as eRaisonSociale,\ne.adresse as eAdresse,\nregexp_replace(e.telephone, '[. -]' ,'', 'g') as eTelephone,\nregexp_replace(e.mobile, '[. -]' ,'', 'g') as eMobile,\nCASE WHEN e.nbTomTomGPSModif=2147483647 THEN 'Verrouill\u00e9'\n    WHEN e.nbTomTomGPSModif=0 THEN 'Non-renseign\u00e9'\n    ELSE 'Renseign\u00e9'\nEND as eGps,\ncount(i.topiaid) as eNbSilos,\nsc.code as scCode,\nc.code as cCode,\nc.raisonSociale as cRaisonSociale,\nc.adresse as cAdresse\nFROM copied e1, copied e2, sandra.Eleveur e LEFT OUTER JOIN sandra.infoaccess i ON (i.eleveur = e.topiaid), sandra.Eleveur c, sandra.Societe se, sandra.Societe sc\nWHERE e1.topiaid<>e2.topiaid \nAND e1.ville=e2.ville \nAND e1.topiaid = e.topiaid\nAND e2.topiaid = c.topiaid\nAND e.societe = se.topiaid\nAND c.societe = sc.topiaid\nAND (levenshtein(e1.name1, e2.name1) < 2 OR levenshtein(e1.name1, e2.name2) < 2 OR levenshtein(e1.name2, e2.name1) < 2 OR levenshtein(e1.name2, e2.name2) < 2) \nGROUP BY e.ville,\ne.codePostal,\nse.code,\ne.code,\ne.raisonSociale,\ne.adresse,\ne.telephone,\ne.mobile,\ne.nbTomTomGPSModif,\nsc.code,\nc.code,\nc.raisonSociale,\nc.adresse\nORDER BY e.ville;");
        List result = query.list();
        for (Object[] line : result) {
            export = export + StringUtils.join((Object[])line, (String)";") + "\n";
        }
        return export;
    }
}

