/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra.services.ejb3;

import com.cybelia.sandra.SandraDAOHelper;
import com.cybelia.sandra.SandraHelper;
import com.cybelia.sandra.entities.Camion;
import com.cybelia.sandra.entities.CamionDAO;
import com.cybelia.sandra.entities.ChauffeurDAO;
import com.cybelia.sandra.entities.Eleveur;
import com.cybelia.sandra.entities.EleveurDAO;
import com.cybelia.sandra.entities.Etape;
import com.cybelia.sandra.entities.EtapeDAO;
import com.cybelia.sandra.entities.InfoAccess;
import com.cybelia.sandra.entities.InfoAccessDAO;
import com.cybelia.sandra.entities.Lieu;
import com.cybelia.sandra.entities.LieuDAO;
import com.cybelia.sandra.entities.LigneProduit;
import com.cybelia.sandra.entities.LigneProduitDAO;
import com.cybelia.sandra.entities.Societe;
import com.cybelia.sandra.entities.SocieteDAO;
import com.cybelia.sandra.entities.StatutEnum;
import com.cybelia.sandra.entities.Tour;
import com.cybelia.sandra.entities.TourDAO;
import com.cybelia.sandra.entities.TourTypeModif;
import com.cybelia.sandra.entities.TypeConnectionEnum;
import com.cybelia.sandra.entities.UserIndicateurs;
import com.cybelia.sandra.entities.UserIndicateursDAO;
import com.cybelia.sandra.entities.Usine;
import com.cybelia.sandra.entities.UsineDAO;
import com.cybelia.sandra.entities.sig.PointGPS;
import com.cybelia.sandra.entities.sig.PointGPSDAO;
import com.cybelia.sandra.entities.sig.TraceGPS;
import com.cybelia.sandra.entities.sig.TraceGPSDAO;
import com.cybelia.sandra.entities.synchro.LogDAO;
import com.cybelia.sandra.entities.trace.CREtape;
import com.cybelia.sandra.entities.trace.CREtapeDAO;
import com.cybelia.sandra.entities.trace.CRTour;
import com.cybelia.sandra.entities.trace.CRTourDAO;
import com.cybelia.sandra.entities.trace.CRUsine;
import com.cybelia.sandra.entities.trace.CRUsineDAO;
import com.cybelia.sandra.entities.trace.CompteursKmDAO;
import com.cybelia.sandra.entities.trace.CompteursKmImpl;
import com.cybelia.sandra.entities.trace.SuiviEtape;
import com.cybelia.sandra.entities.trace.SuiviEtapeDAO;
import com.cybelia.sandra.entities.trace.SuiviLigneProduit;
import com.cybelia.sandra.entities.trace.SuiviLigneProduitDAO;
import com.cybelia.sandra.entities.trace.SuiviTour;
import com.cybelia.sandra.entities.trace.SuiviTourDAO;
import com.cybelia.sandra.entities.trace.SuiviUsine;
import com.cybelia.sandra.entities.trace.SuiviUsineDAO;
import com.cybelia.sandra.services.ServiceHelper;
import com.cybelia.sandra.services.ServiceSuivi;
import com.cybelia.sandra.services.ejb3.BaseServiceImpl;
import com.cybelia.sandra.services.ejb3.Transaction;
import com.cybelia.sandra.services.local.ServiceCommonLocal;
import com.cybelia.sandra.services.local.ServiceNotifierLocal;
import com.cybelia.sandra.services.local.ServiceSuiviLocal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.annotation.security.PermitAll;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.ejb3.annotation.SecurityDomain;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaId;
import org.nuiton.util.DateUtil;

@Stateless
@SecurityDomain(value="sandra")
@PermitAll
public class ServiceSuiviImpl
extends BaseServiceImpl
implements ServiceSuivi,
ServiceSuiviLocal {
    private static final Log log = LogFactory.getLog(ServiceSuiviImpl.class);
    @EJB
    ServiceNotifierLocal serviceNotifier;
    @EJB
    ServiceCommonLocal serviceCommon;

    public void setServiceNotifier(ServiceNotifierLocal serviceNotifier) {
        this.serviceNotifier = serviceNotifier;
    }

    public void setServiceCommon(ServiceCommonLocal serviceCommon) {
        this.serviceCommon = serviceCommon;
    }

    @Override
    @Transaction
    public void updateEleveur(Eleveur eleveur) throws TopiaException {
        throw new RuntimeException("This method must be never call");
    }

    public void updateEleveur(TopiaContext transaction, Eleveur eleveur) throws TopiaException {
        String codeSociete;
        SocieteDAO societeDAO;
        Societe societe;
        EleveurDAO eleveurDAO;
        Eleveur eleveurOld;
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.getUserLogin() + "]" + " updateEleveur " + eleveur.getNom()));
        }
        if ((eleveurOld = (eleveurDAO = SandraDAOHelper.getEleveurDAO((TopiaContext)transaction)).findByNaturalId(societe = (societeDAO = SandraDAOHelper.getSocieteDAO((TopiaContext)transaction)).findByCode(codeSociete = eleveur.getSociete().getCode()), eleveur.getCode())) == null) {
            String message = "Eleveur (" + eleveur.getCode() + ") not found. The user '" + this.getUserLogin() + "' probably does not have enough permissions.";
            if (log.isErrorEnabled()) {
                log.error((Object)message);
            }
            throw new TopiaException(message);
        }
        this.serviceCommon.notifyChangedBreeder(transaction, "updateBreeder", this.getUserLogin(), eleveurOld, eleveur);
        this.serviceCommon.copyEntityIfNecessary(transaction, eleveur, eleveurOld, "raisonSociale");
        this.serviceCommon.copyEntityIfNecessary(transaction, eleveur, eleveurOld, "telephone");
        this.serviceCommon.copyEntityIfNecessary(transaction, eleveur, eleveurOld, "mobile");
        this.serviceCommon.copyEntityIfNecessary(transaction, eleveur, eleveurOld, "adresse");
        this.serviceCommon.copyEntityIfNecessary(transaction, eleveur, eleveurOld, "ville");
        this.serviceCommon.copyEntityIfNecessary(transaction, eleveur, eleveurOld, "codePostal");
        this.serviceCommon.copyEntityIfNecessary(transaction, eleveur, eleveurOld, "email");
        this.serviceCommon.copyEntityIfNecessary(transaction, eleveur, eleveurOld, "codeINSEE");
        this.serviceCommon.copyEntityIfNecessary(transaction, eleveur, eleveurOld, "contrainteHoraire");
        this.serviceCommon.copyEntityIfNecessary(transaction, eleveur, eleveurOld, "commentaire");
        eleveurDAO.update((TopiaEntity)eleveurOld);
    }

    @Override
    @Transaction
    public void updateGPS(String topiaIdLieu, PointGPS pointGPS) throws TopiaException {
        throw new RuntimeException("This method must be never call");
    }

    public void updateGPS(TopiaContext transaction, String topiaIdLieu, PointGPS pointGPS) throws TopiaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.getUserLogin() + "]" + " updateGPS lieu " + topiaIdLieu));
        }
        PointGPSDAO pointGPSDAO = SandraDAOHelper.getPointGPSDAO((TopiaContext)transaction);
        LieuDAO lieuDAO = SandraDAOHelper.getLieuDAO((TopiaContext)transaction);
        Lieu lieu = (Lieu)lieuDAO.findByTopiaId(topiaIdLieu);
        if (lieu != null) {
            Eleveur eleveur;
            PointGPS pointGPSOld = lieu.getTomtomGPS();
            if (!(pointGPS.getPoint().getX() == 0.0 || pointGPS.getPoint().getY() == 0.0 || pointGPSOld != null && pointGPSOld.getPoint().getX() == pointGPS.getPoint().getX() && pointGPSOld.getPoint().getY() == pointGPS.getPoint().getY() || (eleveur = (Eleveur)SandraDAOHelper.getEleveurDAO((TopiaContext)transaction).findByTopiaId(topiaIdLieu)) != null && eleveur.getNbTomTomGPSModif() > 3)) {
                if (pointGPSOld != null) {
                    pointGPSDAO.delete(pointGPSOld);
                    transaction.commitTransaction();
                }
                pointGPS.setTopiaId(TopiaId.create(PointGPS.class));
                pointGPSDAO.update((TopiaEntity)pointGPS);
                lieu.setTomtomGPS(pointGPS);
                lieuDAO.update((TopiaEntity)lieu);
                if (eleveur != null) {
                    double oldX = pointGPSOld == null || pointGPSOld.getPoint() == null ? 0.0 : pointGPSOld.getPoint().getX();
                    double oldY = pointGPSOld == null || pointGPSOld.getPoint() == null ? 0.0 : pointGPSOld.getPoint().getY();
                    double newX = pointGPS.getPoint().getX();
                    double newY = pointGPS.getPoint().getY();
                    if (oldX != newX || oldY != newY) {
                        this.serviceNotifier.notifyEvent("updateBreederGPS", ServiceHelper.getSandraName(), ServiceHelper.getSandraUrl(), this.getUserLogin(), eleveur.getTopiaId(), String.valueOf(oldX), String.valueOf(oldY), String.valueOf(newX), String.valueOf(newY));
                        this.serviceCommon.incNbGpsMaj(transaction);
                        this.serviceCommon.incNbMaj(transaction);
                    }
                }
            }
        }
    }

    @Override
    @Transaction
    public void updateInfoAcces(String topiaIdEleveur, InfoAccess accesEleveur, List<InfoAccess> accesSilos) throws TopiaException {
        throw new RuntimeException("This method must be never call");
    }

    public void updateInfoAcces(TopiaContext transaction, String topiaIdEleveur, InfoAccess accesEleveur, List<InfoAccess> accesSilos) throws TopiaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.getUserLogin() + "]" + " updateInfoAcces topiaIdEleveur[" + topiaIdEleveur + "]"));
        }
        InfoAccessDAO infoAccessDAO = SandraDAOHelper.getInfoAccessDAO((TopiaContext)transaction);
        EleveurDAO eleveurDAO = SandraDAOHelper.getEleveurDAO((TopiaContext)transaction);
        Eleveur eleveur = (Eleveur)eleveurDAO.findByTopiaId(topiaIdEleveur);
        if (accesEleveur == null) {
            accesEleveur = (InfoAccess)infoAccessDAO.create(new Object[0]);
            accesEleveur.setNiveauSecurite(eleveur.getNiveauSecurite());
            accesEleveur.setCommentaireSecurite(eleveur.getCommentaire());
            accesEleveur.setType(0);
        } else if (eleveur.getNbTomTomGPSModif() <= 3) {
            String accesEleveurId = accesEleveur.getTopiaId();
            if (accesEleveurId == null) {
                accesEleveur.setTopiaId(TopiaId.create(InfoAccess.class));
                eleveur.setAccesEleveur(accesEleveur);
            }
            this.updateInfoAcces(transaction, true, eleveur, accesEleveur);
        }
        if (accesSilos != null) {
            for (InfoAccess accesSilo : accesSilos) {
                String accesSiloId = accesSilo.getTopiaId();
                if (accesSiloId == null) {
                    accesSilo.setTopiaId(TopiaId.create(InfoAccess.class));
                    eleveur.addAccesSilos(accesSilo);
                }
                this.updateInfoAcces(transaction, false, eleveur, accesSilo);
            }
        }
        eleveurDAO.update((TopiaEntity)eleveur);
    }

    protected void updateInfoAcces(TopiaContext transaction, boolean isAccesEleveur, Eleveur eleveur, InfoAccess infoAccessUpdate) throws TopiaException {
        int oldType;
        int newType;
        String infoAccessId;
        InfoAccessDAO infoAccessDAO = SandraDAOHelper.getInfoAccessDAO((TopiaContext)transaction);
        InfoAccess infoAccess = (InfoAccess)infoAccessDAO.findByTopiaId(infoAccessId = infoAccessUpdate.getTopiaId());
        if (infoAccess == null) {
            log.warn((Object)("Info access not found with id[" + infoAccessId + "] name[" + infoAccessUpdate.getAccesSilo() + "]"));
            log.warn((Object)"Ino access will not be updated");
            return;
        }
        String eleveurTopiaId = eleveur.getTopiaId();
        infoAccessUpdate.setNiveauSecurite(infoAccess.getNiveauSecurite());
        SandraHelper.createActionSecuriteIfNeeded((TopiaContext)transaction, (String)this.getUserLogin(), (Eleveur)eleveur, (InfoAccess)infoAccessUpdate);
        if (isAccesEleveur) {
            this.serviceCommon.notifyChangedInfoAccess(transaction, "updateAccesEleveur", this.getUserLogin(), eleveurTopiaId, infoAccess, infoAccessUpdate);
        } else {
            this.serviceCommon.notifyChangedInfoAccess(transaction, "updateAccesSilo", this.getUserLogin(), eleveurTopiaId, infoAccess, infoAccessUpdate);
        }
        this.serviceCommon.copyEntityIfNecessary(transaction, infoAccessUpdate, infoAccess, "accesSilo");
        this.serviceCommon.copyEntityIfNecessary(transaction, infoAccessUpdate, infoAccess, "commentaireSecurite");
        this.serviceCommon.copyEntityIfNecessary(transaction, infoAccessUpdate, infoAccess, "modeChargement");
        infoAccess.setEtat(infoAccessUpdate.getEtat());
        if (infoAccess.getNiveauSecurite() != infoAccessUpdate.getNiveauSecurite()) {
            infoAccess.setNiveauSecurite(infoAccessUpdate.getNiveauSecurite());
            if (!isAccesEleveur) {
                this.serviceCommon.incNbSecuMaj(transaction);
            }
            this.serviceCommon.incNbMaj(transaction);
        }
        Collection risquesUpdated = infoAccessUpdate.getRisques();
        Collection risques = infoAccess.getRisques();
        if (risques == null || !risques.equals(risquesUpdated)) {
            infoAccess.setRisques(risquesUpdated);
            this.serviceCommon.incNbMaj(transaction);
        }
        if ((newType = infoAccessUpdate.getType()) != (oldType = infoAccess.getType())) {
            infoAccess.setType(newType);
            this.serviceCommon.incNbMaj(transaction);
        }
        this.updateInfoAccessGPS(transaction, eleveur, infoAccess, infoAccessUpdate);
    }

    protected void updateInfoAccessGPS(TopiaContext transaction, Eleveur eleveur, InfoAccess infoAccesOld, InfoAccess infoAccessUpdate) throws TopiaException {
        double newY;
        PointGPS pointGPS;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Update infoAccess GPS");
        }
        InfoAccessDAO infoAccessDAO = SandraDAOHelper.getInfoAccessDAO((TopiaContext)transaction);
        PointGPSDAO pointGPSDAO = SandraDAOHelper.getPointGPSDAO((TopiaContext)transaction);
        TraceGPSDAO traceGPSDAO = SandraDAOHelper.getTraceGPSDAO((TopiaContext)transaction);
        PointGPS pointGPSOld = infoAccesOld.getGps();
        if (pointGPSOld != null) {
            pointGPSDAO.delete(pointGPSOld);
            transaction.commitTransaction();
        }
        if ((pointGPS = infoAccessUpdate.getGps()) != null) {
            pointGPS.setTopiaId(TopiaId.create(PointGPS.class));
            pointGPSDAO.update((TopiaEntity)pointGPS);
        }
        infoAccesOld.setGps(pointGPS);
        TraceGPS traceGPS = infoAccessUpdate.getTrace();
        if (traceGPS != null) {
            ArrayList pointsGPS = new ArrayList(traceGPS.getListePoints());
            traceGPS.clearListePoints();
            for (PointGPS tracePoint : pointsGPS) {
                tracePoint.setTopiaId(TopiaId.create(PointGPS.class));
                pointGPSDAO.update((TopiaEntity)tracePoint);
                traceGPS.addListePoints(pointGPS);
            }
            traceGPS.setTopiaId(TopiaId.create(TraceGPS.class));
            traceGPSDAO.update((TopiaEntity)traceGPS);
            infoAccesOld.setTrace(traceGPS);
        }
        infoAccessDAO.update((TopiaEntity)infoAccesOld);
        double oldX = pointGPSOld == null || pointGPSOld.getPoint() == null ? 0.0 : pointGPSOld.getPoint().getX();
        double oldY = pointGPSOld == null || pointGPSOld.getPoint() == null ? 0.0 : pointGPSOld.getPoint().getY();
        double newX = pointGPS == null || pointGPS.getPoint() == null ? 0.0 : pointGPS.getPoint().getX();
        double d = newY = pointGPS == null || pointGPS.getPoint() == null ? 0.0 : pointGPS.getPoint().getY();
        if (oldX != newX || oldY != newY) {
            Eleveur eleveurFound = SandraDAOHelper.getEleveurDAO((TopiaContext)transaction).findByAccesEleveur(infoAccesOld);
            if (eleveurFound != null) {
                this.serviceNotifier.notifyEvent("updateAccesEleveurGPS", ServiceHelper.getSandraName(), ServiceHelper.getSandraUrl(), this.getUserLogin(), eleveur.getTopiaId(), String.valueOf(oldX), String.valueOf(oldY), String.valueOf(newX), String.valueOf(newY));
            } else {
                this.serviceNotifier.notifyEvent("updateSiloGPS", ServiceHelper.getSandraName(), ServiceHelper.getSandraUrl(), this.getUserLogin(), eleveur.getTopiaId(), infoAccesOld.getTopiaId(), String.valueOf(oldX), String.valueOf(oldY), String.valueOf(newX), String.valueOf(newY));
            }
            this.serviceCommon.incNbMaj(transaction);
        }
    }

    @Override
    @Transaction
    public String updateSuiviTour(String topiaIdTourCurrent, SuiviTour suiviTour) throws TopiaException {
        throw new RuntimeException("This method must be never call");
    }

    public String updateSuiviTour(TopiaContext transaction, String topiaIdTourCurrent, SuiviTour suiviTour) throws TopiaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.getUserLogin() + "]" + " updateSuiviTour topiaIdTourCurrent[" + topiaIdTourCurrent + "]"));
        }
        log.info((Object)("Updating suivi tour for tour: " + topiaIdTourCurrent));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Suivi tour: " + suiviTour));
        }
        TourDAO tourDAO = SandraDAOHelper.getTourDAO((TopiaContext)transaction);
        SuiviTourDAO suiviTourDAO = SandraDAOHelper.getSuiviTourDAO((TopiaContext)transaction);
        Tour tour = (Tour)tourDAO.findByTopiaId(topiaIdTourCurrent);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Tour is: " + tour));
        }
        if (tour != null) {
            Tour tourPrecedentDuTourPrecedent;
            Object chauffeur;
            if (suiviTour.getReel() != null) {
                ChauffeurDAO chauffeurDAO = SandraDAOHelper.getChauffeurDAO((TopiaContext)transaction);
                chauffeur = chauffeurDAO.findByCode(suiviTour.getReel().getCode());
                suiviTour.setReel(chauffeur);
            }
            suiviTour.setTopiaId(TopiaId.create(SuiviTour.class));
            suiviTourDAO.update((TopiaEntity)suiviTour);
            tour.setSuiviTour(suiviTour);
            tourDAO.update((TopiaEntity)tour);
            SuiviTour suiviTourOld = tour.getSuiviTour();
            if (suiviTourOld != null && !suiviTourOld.getTopiaId().equals(suiviTour.getTopiaId())) {
                int newStatus;
                int oldStatus = suiviTourOld.getStatus();
                if (oldStatus != (newStatus = suiviTour.getStatus())) {
                    this.serviceCommon.incNbMaj(transaction);
                }
                suiviTour.setCRTour(suiviTourOld.getCRTour());
                suiviTour.addAllSuiviEtapes(suiviTourOld.getSuiviEtapes());
                suiviTour.addAllSuiviUsines(suiviTourOld.getSuiviUsines());
                suiviTourDAO.delete(suiviTourOld);
                transaction.commitTransaction();
            } else {
                chauffeur = suiviTour.getChauffeurNomPrenom();
                if (StringUtils.isNotEmpty((CharSequence)chauffeur)) {
                    this.serviceNotifier.notifyEvent("updateReportDriverNotAffectedToTruck", new String[]{ServiceHelper.getSandraName(), this.getUserLogin(), chauffeur, tour.getTopiaId()});
                }
            }
            Tour tourPrecedent = this.getPrecedentTour(transaction, tour);
            if (tourPrecedent != null && (tourPrecedentDuTourPrecedent = this.getPrecedentTour(transaction, tourPrecedent)) != null) {
                SuiviUsine usineDepartTourPrecedent = this.getUsineDepartTour(tourPrecedent);
                SuiviUsine usineDepartTourPrecedentDuTourPrecedent = this.getUsineDepartTour(tourPrecedentDuTourPrecedent);
                if (usineDepartTourPrecedent != null && usineDepartTourPrecedentDuTourPrecedent != null) {
                    Date dateSortie = usineDepartTourPrecedent.getDateEntree();
                    Date dateEntree = usineDepartTourPrecedentDuTourPrecedent.getDateEntree();
                    if (dateEntree != null && dateSortie != null) {
                        Date date = new Date(dateSortie.getTime() - dateEntree.getTime());
                        SuiviTour suiviTourPrecedentDuTourPrecedent = tourPrecedentDuTourPrecedent.getSuiviTour();
                        suiviTourPrecedentDuTourPrecedent.setDuree(date);
                        suiviTourDAO.update((TopiaEntity)suiviTourPrecedentDuTourPrecedent);
                    }
                }
            }
        } else {
            log.warn((Object)("No tour found with topiaId : " + topiaIdTourCurrent));
        }
        return suiviTour.getTopiaId();
    }

    protected SuiviUsine getUsineDepartTour(Tour tour) {
        List suiviUsines;
        SuiviUsine depart = null;
        SuiviTour suiviTour = tour.getSuiviTour();
        if (suiviTour != null && (suiviUsines = suiviTour.getSuiviUsines()) != null) {
            for (SuiviUsine usine : suiviUsines) {
                if (depart != null && usine.getNouvelleOrdre() >= depart.getNouvelleOrdre()) continue;
                depart = usine;
            }
        }
        return depart;
    }

    protected Tour getPrecedentTour(TopiaContext transaction, Tour tour) throws TopiaException {
        Tour tourPrecedent = null;
        List tours = null;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(tour.getDateLivraison());
        int numero = tour.getNumero();
        Camion camion = tour.getCamion();
        if (numero == 1) {
            String requete = "FROM com.cybelia.sandra.entities.Tour tour WHERE tour.dateLivraison >= :dateDebut AND tour.dateLivraison <= :dateFin AND tour.camion = :camion ORDER BY tour.numero DESC";
            for (int i = 0; i < 5 && (tours == null || tours.isEmpty()); ++i) {
                calendar.add(5, -1);
                Date dateDebut = DateUtil.setMinTimeOfDay((Date)calendar.getTime());
                Date dateFin = DateUtil.setMaxTimeOfDay((Date)calendar.getTime());
                tours = transaction.findAll(requete, new Object[]{"dateDebut", dateDebut, "dateFin", dateFin, "camion", camion});
            }
        } else {
            String requete = "FROM com.cybelia.sandra.entities.Tour tour WHERE tour.dateLivraison >= :dateDebut AND tour.dateLivraison <= :dateFin AND tour.camion = :camion AND tour.numero = :numero";
            Date dateDebut = DateUtil.setMinTimeOfDay((Date)calendar.getTime());
            Date dateFin = DateUtil.setMaxTimeOfDay((Date)calendar.getTime());
            tours = transaction.findAll(requete, new Object[]{"dateDebut", dateDebut, "dateFin", dateFin, "camion", camion, "numero", numero - 1});
        }
        if (tours != null && !tours.isEmpty()) {
            tourPrecedent = (Tour)tours.get(0);
        }
        return tourPrecedent;
    }

    @Override
    @Transaction
    public String updateSuiviEtape(String topiaIdTourCurrent, String topiaIdEtape, SuiviEtape suiviEtape) throws TopiaException {
        throw new RuntimeException("This method must be never call");
    }

    public String updateSuiviEtape(TopiaContext transaction, String topiaIdTourCurrent, String topiaIdEtape, SuiviEtape suiviEtape) throws TopiaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.getUserLogin() + "]" + " updateSuiviEtape topiaIdTourCurrent[" + topiaIdTourCurrent + "] topiaIdEtape[" + topiaIdEtape + "]"));
        }
        TourDAO tourDAO = SandraDAOHelper.getTourDAO((TopiaContext)transaction);
        EtapeDAO etapeDAO = SandraDAOHelper.getEtapeDAO((TopiaContext)transaction);
        SuiviEtapeDAO suiviEtapeDAO = SandraDAOHelper.getSuiviEtapeDAO((TopiaContext)transaction);
        Etape etape = (Etape)etapeDAO.findByTopiaId(topiaIdEtape);
        SuiviEtape suiviEtapeOld = suiviEtapeDAO.findByEtape(etape);
        Tour tour = (Tour)tourDAO.findByTopiaId(topiaIdTourCurrent);
        SuiviTour suiviTour = tour.getSuiviTour();
        if (suiviEtapeOld != null) {
            int newNouvelleOrdre;
            int oldNouvelleOrdre = suiviEtapeOld.getNouvelleOrdre();
            if (oldNouvelleOrdre != (newNouvelleOrdre = suiviEtape.getNouvelleOrdre())) {
                this.serviceCommon.incNbMaj(transaction);
            }
            CREtape crEtape = suiviEtapeOld.getCREtape();
            suiviEtapeOld.setCREtape(null);
            suiviEtape.setCREtape(crEtape);
            if (!suiviTour.isSuiviEtapesEmpty() && suiviTour.getSuiviEtapes().contains(suiviEtapeOld)) {
                suiviTour.removeSuiviEtapes(suiviEtapeOld);
            }
            suiviEtapeDAO.delete((TopiaEntity)suiviEtapeOld);
            transaction.commitTransaction();
        }
        suiviEtape.setTopiaId(TopiaId.create(SuiviEtape.class));
        suiviEtape.setEtape(etape);
        suiviEtapeDAO.update((TopiaEntity)suiviEtape);
        if (suiviTour != null) {
            suiviTour.addSuiviEtapes(suiviEtape);
            SandraDAOHelper.getSuiviTourDAO((TopiaContext)transaction).update((TopiaEntity)suiviTour);
        }
        return suiviEtape.getTopiaId();
    }

    @Override
    @Transaction
    public String updateSuiviUsine(String topiaIdTourCurrent, String codeUsine, int creationOrdreUsine, SuiviUsine suiviUsine) throws TopiaException {
        throw new RuntimeException("This method must be never call");
    }

    public String updateSuiviUsine(TopiaContext transaction, String topiaIdTourCurrent, String codeUsine, int creationOrdreUsine, SuiviUsine suiviUsine) throws TopiaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.getUserLogin() + "]" + " updateSuiviUsine topiaIdTourCurrent[" + topiaIdTourCurrent + "] codeUsine[" + codeUsine + "] creationOrdreUsine[" + creationOrdreUsine + "]"));
        }
        TourDAO tourDAO = SandraDAOHelper.getTourDAO((TopiaContext)transaction);
        UsineDAO usineDAO = SandraDAOHelper.getUsineDAO((TopiaContext)transaction);
        SuiviUsineDAO suiviUsineDAO = SandraDAOHelper.getSuiviUsineDAO((TopiaContext)transaction);
        Tour tour = (Tour)tourDAO.findByTopiaId(topiaIdTourCurrent);
        if (tour == null) {
            log.info((Object)("No tour find with topiaId : " + topiaIdTourCurrent));
            return null;
        }
        Usine usine = (Usine)usineDAO.findByCode(codeUsine);
        SuiviUsine suiviUsineOld = null;
        SuiviTour suiviTour = tour.getSuiviTour();
        if (suiviTour != null) {
            List suiviUsines = suiviTour.getSuiviUsines();
            if (suiviUsines != null && !suiviUsines.isEmpty()) {
                Iterator iterator = suiviUsines.iterator();
                while (iterator.hasNext() && suiviUsineOld == null) {
                    SuiviUsine item = (SuiviUsine)iterator.next();
                    if (item.getCreationOrdre() != creationOrdreUsine || !item.getUsine().getCode().equals(codeUsine)) continue;
                    suiviUsineOld = item;
                }
            } else {
                log.error((Object)("SuiviUsines are null or empty for tour : " + topiaIdTourCurrent));
            }
            if (suiviUsine == null) {
                suiviUsine = (SuiviUsine)suiviUsineDAO.create(new Object[0]);
            } else {
                suiviUsine.setTopiaId(TopiaId.create(SuiviUsine.class));
            }
            suiviUsine.setUsine(usine);
            if (suiviUsineOld != null) {
                Date oldHeureChargement = suiviUsineOld.getHeureChargement();
                Date newHeureChargement = suiviUsine.getHeureChargement();
                if (oldHeureChargement == null || !oldHeureChargement.equals(newHeureChargement)) {
                    this.serviceCommon.incNbMaj(transaction);
                }
                suiviUsine.setCRUsine(suiviUsineOld.getCRUsine());
                suiviUsine.addAllSuiviLigneProduit(suiviUsineOld.getSuiviLigneProduit());
                if (!suiviTour.isSuiviUsinesEmpty() && suiviTour.getSuiviUsines().contains(suiviUsineOld)) {
                    suiviTour.removeSuiviUsines(suiviUsineOld);
                }
                suiviUsineDAO.delete((TopiaEntity)suiviUsineOld);
                transaction.commitTransaction();
            }
            suiviUsineDAO.update((TopiaEntity)suiviUsine);
            suiviTour.addSuiviUsines(suiviUsine);
            SandraDAOHelper.getSuiviTourDAO((TopiaContext)transaction).update((TopiaEntity)suiviTour);
        } else {
            log.error((Object)("SuiviTour is null for tour " + topiaIdTourCurrent));
        }
        log.info((Object)("Adding suiviUsine : " + suiviUsine.getTopiaId()));
        return suiviUsine.getTopiaId();
    }

    @Override
    @Transaction
    public void updateCRTour(String topiaIdSuiviTour, CRTour crTour, long updateSynchroNumber) throws TopiaException {
        throw new RuntimeException("This method must be never call");
    }

    public void updateCRTour(TopiaContext transaction, String topiaIdSuiviTour, CRTour crTour, long updateSynchroNumber) throws TopiaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.getUserLogin() + "]" + " updateCRTour topiaIdSuiviTour[" + topiaIdSuiviTour + "]"));
        }
        SuiviTourDAO suiviTourDAO = SandraDAOHelper.getSuiviTourDAO((TopiaContext)transaction);
        TourDAO tourDAO = SandraDAOHelper.getTourDAO((TopiaContext)transaction);
        CRTourDAO crTourDAO = SandraDAOHelper.getCRTourDAO((TopiaContext)transaction);
        LogDAO logDAO = SandraDAOHelper.getLogDAO((TopiaContext)transaction);
        SuiviTour suiviTour = (SuiviTour)suiviTourDAO.findByTopiaId(topiaIdSuiviTour);
        CRTour crTourOld = suiviTour.getCRTour();
        if (crTourOld != null) {
            crTourDAO.delete(crTourOld);
            transaction.commitTransaction();
        }
        Tour tour = tourDAO.findBySuiviTour(suiviTour);
        crTour.setTopiaId(TopiaId.create(CRTour.class));
        crTourDAO.update((TopiaEntity)crTour);
        suiviTour.setCRTour(crTour);
        suiviTourDAO.update((TopiaEntity)suiviTour);
        if (tour != null) {
            com.cybelia.sandra.entities.synchro.Log logEntity = logDAO.findByTourTopiaID(tour.getTopiaId());
            if (logEntity == null) {
                logEntity = (com.cybelia.sandra.entities.synchro.Log)logDAO.create(new Object[]{"tourTopiaID", tour.getTopiaId()});
            }
            logEntity.setSynchroNumber(updateSynchroNumber);
            logEntity.setTimeStamp(System.currentTimeMillis());
            logEntity.setTypeModif(TourTypeModif.MODIF);
            SandraDAOHelper.getLogDAO((TopiaContext)transaction).update((TopiaEntity)logEntity);
        }
    }

    @Override
    @Transaction
    public void updateCREtape(String topiaIdSuiviEtape, CREtape crEtape) throws TopiaException {
        throw new RuntimeException("This method must be never call");
    }

    public void updateCREtape(TopiaContext transaction, String topiaIdSuiviEtape, CREtape crEtape) throws TopiaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.getUserLogin() + "]" + " updateCREtape topiaIdSuiviEtape[" + topiaIdSuiviEtape + "]"));
        }
        SuiviEtapeDAO suiviEtapeDAO = SandraDAOHelper.getSuiviEtapeDAO((TopiaContext)transaction);
        CREtapeDAO crEtapeDAO = SandraDAOHelper.getCREtapeDAO((TopiaContext)transaction);
        SuiviEtape suiviEtape = (SuiviEtape)suiviEtapeDAO.findByTopiaId(topiaIdSuiviEtape);
        crEtape.setTopiaId(TopiaId.create(CREtape.class));
        crEtapeDAO.update((TopiaEntity)crEtape);
        CREtape crEtapeOld = suiviEtape.getCREtape();
        if (crEtapeOld != null) {
            crEtapeDAO.delete(crEtapeOld);
            transaction.commitTransaction();
        }
        suiviEtape.setCREtape(crEtape);
        suiviEtapeDAO.update((TopiaEntity)suiviEtape);
        String livraisonStatut = crEtape.getLivraisonStatut();
        log.info((Object)("Livraison statut : " + livraisonStatut));
        if (!"RAS".equals(livraisonStatut)) {
            this.serviceNotifier.notifyEvent("updateReportKo", ServiceHelper.getSandraName(), this.getUserLogin(), suiviEtape.getEtape().getTopiaId(), SandraHelper.convertDateToString((Date)new Date()), this.serviceCommon.getLabel(transaction, "PGE", String.valueOf(crEtape.getPurge())), crEtape.getLivraisonStatut(), crEtape.getCommentaireLivraison(), SandraHelper.convertDateToString((Date)crEtape.getEtapeHeureLivraison()));
        }
    }

    @Override
    @Transaction
    public void updateCRUsine(String topiaIdSuiviUsine, CRUsine crUsine) throws TopiaException {
        throw new RuntimeException("This method must be never call");
    }

    public void updateCRUsine(TopiaContext transaction, String topiaIdSuiviUsine, CRUsine crUsine) throws TopiaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.getUserLogin() + "]" + " updateCRUsine topiaIdSuiviUsine[" + topiaIdSuiviUsine + "]"));
        }
        SuiviUsineDAO suiviUsineDAO = SandraDAOHelper.getSuiviUsineDAO((TopiaContext)transaction);
        CRUsineDAO crUsineDAO = SandraDAOHelper.getCRUsineDAO((TopiaContext)transaction);
        SuiviUsine suiviUsine = (SuiviUsine)suiviUsineDAO.findByTopiaId(topiaIdSuiviUsine);
        crUsine.setTopiaId(TopiaId.create(CRUsine.class));
        crUsineDAO.update((TopiaEntity)crUsine);
        suiviUsine.setCRUsine(crUsine);
        suiviUsineDAO.update((TopiaEntity)suiviUsine);
        CRUsine crUsineOld = suiviUsine.getCRUsine();
        if (crUsineOld != null) {
            crUsineDAO.delete(crUsine);
            transaction.commitTransaction();
        }
    }

    @Override
    @Transaction
    public void updateSuiviLigneProduit(String topiaIdLigneProduit, String topiaIdSuiviUsine, SuiviLigneProduit suiviLigneProduit) throws TopiaException {
        throw new RuntimeException("This method must be never call");
    }

    public void updateSuiviLigneProduit(TopiaContext transaction, String topiaIdLigneProduit, String topiaIdSuiviUsine, SuiviLigneProduit suiviLigneProduit) throws TopiaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.getUserLogin() + "]" + " updateSuiviLigneProduit topiaIdLigneProduit[" + topiaIdLigneProduit + "] topiaIdSuiviUsine[" + topiaIdSuiviUsine + "]"));
        }
        LigneProduitDAO ligneProduitDAO = SandraDAOHelper.getLigneProduitDAO((TopiaContext)transaction);
        SuiviLigneProduitDAO suiviLigneProduitDAO = SandraDAOHelper.getSuiviLigneProduitDAO((TopiaContext)transaction);
        SuiviUsineDAO suiviUsineDAO = SandraDAOHelper.getSuiviUsineDAO((TopiaContext)transaction);
        LigneProduit ligneProduit = (LigneProduit)ligneProduitDAO.findByTopiaId(topiaIdLigneProduit);
        SuiviUsine suiviUsine = (SuiviUsine)suiviUsineDAO.findByTopiaId(topiaIdSuiviUsine);
        SuiviLigneProduit suiviLigneProduitOld = suiviLigneProduitDAO.findByLigneProduit(ligneProduit);
        if (suiviLigneProduitOld != null) {
            String oldsCompartiments = suiviLigneProduitOld.getCompartiments();
            String newCompartiments = suiviLigneProduit.getCompartiments();
            if (oldsCompartiments == null || !oldsCompartiments.equals(newCompartiments)) {
                this.serviceCommon.incNbMaj(transaction);
            }
            if (!suiviUsine.isSuiviLigneProduitEmpty() && suiviUsine.getSuiviLigneProduit().contains(suiviLigneProduitOld)) {
                suiviUsine.removeSuiviLigneProduit(suiviLigneProduitOld);
                transaction.commitTransaction();
            }
            suiviLigneProduitDAO.delete((TopiaEntity)suiviLigneProduitOld);
            transaction.commitTransaction();
        }
        suiviLigneProduit.setTopiaId(TopiaId.create(SuiviLigneProduit.class));
        suiviLigneProduit.setLigneProduit(ligneProduit);
        suiviLigneProduitDAO.update((TopiaEntity)suiviLigneProduit);
        suiviUsine.addSuiviLigneProduit(suiviLigneProduit);
        suiviUsineDAO.update((TopiaEntity)suiviUsine);
        log.info((Object)("Adding suiviLigneProduit : " + suiviLigneProduit.getTopiaId()));
    }

    @Override
    @Transaction
    public int getStatusForTour(String tourTopiaId) throws TopiaException {
        throw new RuntimeException("This method must be never call");
    }

    public int getStatusForTour(TopiaContext transaction, String tourTopiaId) throws TopiaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.getUserLogin() + "]" + " updateSuiviLigneProduit tourTopiaId[" + tourTopiaId + "] getStatusForTour : " + tourTopiaId));
        }
        StatutEnum statut = null;
        TourDAO tourDAO = SandraDAOHelper.getTourDAO((TopiaContext)transaction);
        Tour tour = (Tour)tourDAO.findByTopiaId(tourTopiaId);
        SuiviTour suiviTour = tour.getSuiviTour();
        ArrayList<LigneProduit> produits = new ArrayList<LigneProduit>();
        if (suiviTour != null) {
            if (suiviTour.getStatus() == 4) {
                statut = StatutEnum.SEMI_LIVRE;
            }
            if (suiviTour.getStatus() == -1) {
                statut = StatutEnum.TERMINE;
            }
            if (statut == null) {
                List suiviEtapes = suiviTour.getSuiviEtapes();
                for (SuiviEtape suiviEtape : suiviEtapes) {
                    Etape etape = suiviEtape.getEtape();
                    if (etape == null) continue;
                    produits.addAll(etape.getProduits());
                }
            }
        }
        List etapes = tour.getEtapes();
        for (Etape etape : etapes) {
            produits.addAll(etape.getProduits());
        }
        statut = this.getStatutSteps(produits);
        int code = statut.getCode();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Return code " + code + " for tour : " + tourTopiaId));
        }
        return code;
    }

    protected StatutEnum getStatutSteps(List<LigneProduit> produits) {
        boolean oneAvailable = false;
        boolean allAvailable = true;
        boolean oneCharged = false;
        for (LigneProduit produit : produits) {
            oneAvailable |= produit.getDisponible();
            allAvailable &= produit.getDisponible();
            oneCharged |= produit.getInfoChargement().getQuantite() > 0;
        }
        StatutEnum statut = oneCharged ? StatutEnum.CHARGE : (allAvailable ? StatutEnum.DISPONIBLE : (oneAvailable ? StatutEnum.SEMI_DISPONIBLE : StatutEnum.PLANIFIE));
        return statut;
    }

    @Override
    @Transaction
    public UserIndicateurs updateSynchroStat(int typeConnection, boolean gprs, int sendSize, int recieveSize, int synchroNumber, int okSynchroNumber) throws TopiaException {
        throw new RuntimeException("This method must be never call");
    }

    public UserIndicateurs updateSynchroStat(TopiaContext transaction, int typeConnection, boolean gprs, int sendSize, int recieveSize, int synchroNumber, int okSynchroNumber) throws TopiaException {
        TypeConnectionEnum typeConnectionEnum = TypeConnectionEnum.getTypeConnectionEnum((int)typeConnection);
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.getUserLogin() + "]" + " updateSynchroStat with connection of type " + (gprs ? "SYNCHRO on GPRS" : typeConnectionEnum) + " : sendSize[" + sendSize + "]" + " recieveSize[" + recieveSize + "]" + " synchroNumber[" + synchroNumber + "]" + " okSynchroNumber[" + okSynchroNumber + "]"));
        }
        UserIndicateurs userIndicateurs = this.serviceCommon.incSynch(transaction, typeConnectionEnum, gprs, false);
        if (gprs) {
            userIndicateurs = this.serviceCommon.incNbOctetsSendGPRS(userIndicateurs, sendSize);
            userIndicateurs = this.serviceCommon.incNbOctetsReceivedGPRS(userIndicateurs, recieveSize);
        } else {
            userIndicateurs = this.serviceCommon.incNbOctetsSendWifi(userIndicateurs, sendSize);
            userIndicateurs = this.serviceCommon.incNbOctetsReceivedWifi(userIndicateurs, recieveSize);
        }
        int synchKo = synchroNumber - okSynchroNumber;
        if (synchKo > 0) {
            userIndicateurs = this.serviceCommon.incNbSynchKo(userIndicateurs, synchKo - 1);
        }
        UserIndicateursDAO userIndicateursDAO = SandraDAOHelper.getUserIndicateursDAO((TopiaContext)transaction);
        userIndicateurs = (UserIndicateurs)userIndicateursDAO.update((TopiaEntity)userIndicateurs);
        return userIndicateurs;
    }

    @Override
    @Transaction
    public void addCompteurKm(String codeUsine, String codeCamion, String codeSociete, Date dateEntree, Date dateSortie, int compteur) throws TopiaException {
        throw new RuntimeException("This method must be never call");
    }

    public void addCompteurKm(TopiaContext transaction, String codeUsine, String codeCamion, String codeSociete, Date dateEntree, Date dateSortie, int compteur) throws TopiaException {
        UsineDAO usineDAO = SandraDAOHelper.getUsineDAO((TopiaContext)transaction);
        Usine usine = usineDAO.findByNaturalId(codeUsine);
        SocieteDAO societeDAO = SandraDAOHelper.getSocieteDAO((TopiaContext)transaction);
        Societe societe = societeDAO.findByNaturalId(codeSociete);
        CamionDAO camionDAO = SandraDAOHelper.getCamionDAO((TopiaContext)transaction);
        Camion camion = camionDAO.findByNaturalId(codeCamion, societe);
        CompteursKmDAO compteursKmDAO = SandraDAOHelper.getCompteursKmDAO((TopiaContext)transaction);
        boolean exist = compteursKmDAO.existByNaturalId(dateSortie, camion, usine);
        if (!exist) {
            CompteursKmImpl compteursKm = new CompteursKmImpl();
            compteursKm.setCamion(camion);
            compteursKm.setUsine(usine);
            compteursKm.setDateEntree(dateEntree);
            compteursKm.setDateSortie(dateSortie);
            compteursKm.setCompteur(compteur);
            compteursKmDAO.create((TopiaEntity)compteursKm);
        } else {
            log.warn((Object)("CompteurKm is already inserted for " + dateSortie + " " + codeSociete + "-" + codeCamion + " " + codeUsine));
        }
    }
}

