/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra.services.ejb3;

import com.cybelia.sandra.SandraConfig;
import com.cybelia.sandra.SandraConfigHelper;
import com.cybelia.sandra.SandraDAOHelper;
import com.cybelia.sandra.SandraHelper;
import com.cybelia.sandra.entities.notifier.Cron;
import com.cybelia.sandra.entities.notifier.CronDAO;
import com.cybelia.sandra.entities.notifier.Event;
import com.cybelia.sandra.entities.notifier.EventDAO;
import com.cybelia.sandra.notifier.NotifierManager;
import com.cybelia.sandra.notifier.SandraNotifier;
import com.cybelia.sandra.security.ProfilManager;
import com.cybelia.sandra.security.SecurityHelper;
import com.cybelia.sandra.services.LogicException;
import com.cybelia.sandra.services.ejb3.BaseServiceImpl;
import com.cybelia.sandra.services.ejb3.Transaction;
import com.cybelia.sandra.services.local.ServiceNotifierLocal;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.Stateless;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.ejb3.annotation.RunAsPrincipal;
import org.jboss.ejb3.annotation.SecurityDomain;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.util.ApplicationConfig;
import org.quartz.CronExpression;

@Stateless
@SecurityDomain(value="sandra")
@RunAsPrincipal(value="notifier")
public class ServiceNotifierImpl
extends BaseServiceImpl
implements ServiceNotifierLocal {
    protected static final Log log = LogFactory.getLog(ServiceNotifierImpl.class);

    @Override
    @Transaction(close=false)
    public void init(TopiaContext transaction) {
        NotifierManager.getManager().start(transaction);
        log.info((Object)"NotifierManager is started");
    }

    @Override
    public void notifyEvent(String type, String ... values) throws TopiaException {
        new SandraNotifier().notifyEvent(type, values);
    }

    @Override
    public void notifyCron(String cronTopiaId) throws TopiaException {
        new SandraNotifier().notifyCron(cronTopiaId);
    }

    @Override
    @Transaction
    public Event getEvent(TopiaContext transaction, String eventTopiaId) throws TopiaException, LogicException {
        String query = "SELECT event FROM " + Event.class.getName() + " event WHERE event.topiaId = :topiaId";
        Event event = (Event)ProfilManager.findUnique("error.service.event.unfound", transaction, Event.class, query, "topiaId", eventTopiaId);
        return event;
    }

    @Override
    @Transaction
    public List<Event> getEvents(TopiaContext transaction) throws TopiaException {
        String query = "SELECT event FROM " + Event.class.getName() + " event";
        List<Event> events = ProfilManager.find(transaction, Event.class, query, new Object[0]);
        return events;
    }

    @Override
    @Transaction
    public Cron getCron(TopiaContext transaction, String cronTopiaId) throws TopiaException, LogicException {
        String query = "SELECT cron FROM " + Cron.class.getName() + " cron WHERE cron.topiaId = :topiaId";
        Cron cron = (Cron)ProfilManager.findUnique("error.service.cron.unfound", transaction, Cron.class, query, "topiaId", cronTopiaId);
        return cron;
    }

    @Override
    @Transaction
    public int getCronsCount(TopiaContext transaction) throws TopiaException {
        int count = ProfilManager.count(transaction, Cron.class, "SELECT count(*) FROM " + Cron.class.getName() + " cron", new Object[0]);
        return count;
    }

    @Override
    @Transaction
    public List<Cron> getCrons(TopiaContext transaction, int startIndex, int endIndex, String sortCriterion, int sortDirection) throws TopiaException {
        String query = "SELECT cron FROM " + Cron.class.getName() + " cron" + SandraHelper.addOrder((String)"cron", (String)sortCriterion, (int)sortDirection);
        List<Cron> crons = ProfilManager.findWithBounds(transaction, Cron.class, query, startIndex, endIndex, new Object[0]);
        return crons;
    }

    @Override
    @Transaction
    public Cron saveCron(TopiaContext transaction, Cron cron) throws TopiaException, LogicException {
        Cron newCron;
        CronDAO cronDAO = SandraDAOHelper.getCronDAO((TopiaContext)transaction);
        EventDAO eventDAO = SandraDAOHelper.getEventDAO((TopiaContext)transaction);
        String topiaId = cron.getTopiaId();
        String label = cron.getLabel();
        if (topiaId == null || "".equals(topiaId)) {
            if (cronDAO.findByLabel(label) != null) {
                throw new LogicException("error.service.cron.already.exists");
            }
            newCron = (Cron)cronDAO.create(new Object[0]);
        } else {
            newCron = (Cron)cronDAO.findByTopiaId(topiaId);
            if (!newCron.getLabel().equals(label) && cronDAO.findByLabel(label) != null) {
                throw new LogicException("error.service.cron.already.exists");
            }
            NotifierManager.getManager().del(cron);
        }
        newCron.setDateEnd(cron.getDateEnd());
        newCron.setDateStart(cron.getDateStart());
        newCron.setEnable(cron.getEnable());
        newCron.setLabel(label);
        newCron.setTemplate(cron.getTemplate());
        if (cron.getAuthor() != null && !cron.getAuthor().isEmpty()) {
            newCron.setAuthor(cron.getAuthor());
        } else {
            newCron.setAuthor(SecurityHelper.getUser().getTopiaId());
        }
        Event event = (Event)eventDAO.findByTopiaId(cron.getEvent().getTopiaId());
        newCron.setEvent(event);
        String expression = cron.getExpression();
        if (expression != null && !"".equals(expression) && !CronExpression.isValidExpression((String)expression)) {
            throw new LogicException("error.service.cron.expression.invalid");
        }
        newCron.setExpression(expression);
        cronDAO.update((TopiaEntity)newCron);
        NotifierManager.getManager().add(cron);
        return newCron;
    }

    @Override
    @Transaction
    public void deleteCron(TopiaContext transaction, String cronTopiaId) throws TopiaException, LogicException {
        CronDAO cronDAO = SandraDAOHelper.getCronDAO((TopiaContext)transaction);
        Cron cron = (Cron)cronDAO.findByTopiaId(cronTopiaId);
        NotifierManager.getManager().del(cron);
        cronDAO.delete(cron);
    }

    @Override
    @Transaction
    public void saveRecepient(TopiaContext transaction, String cronTopiaId, String recipient) throws TopiaException, LogicException {
        String query = "SELECT cron FROM " + Cron.class.getName() + " cron WHERE cron.topiaId = :topiaId";
        Cron cron = (Cron)ProfilManager.findUnique("error.service.cron.unfound", transaction, Cron.class, query, "topiaId", cronTopiaId);
        cron.addRecipients(recipient);
    }

    @Override
    @Transaction
    public void deleteRecipient(TopiaContext transaction, String cronTopiaId, String recipient) throws TopiaException, LogicException {
        String query = "SELECT cron FROM " + Cron.class.getName() + " cron WHERE cron.topiaId = :topiaId";
        Cron cron = (Cron)ProfilManager.findUnique("error.service.cron.unfound", transaction, Cron.class, query, "topiaId", cronTopiaId);
        cron.removeRecipients(recipient);
    }

    @Override
    public List<String> getTemplates() {
        String notifierTemplateDir = SandraConfigHelper.getNotifierTemplateDir((ApplicationConfig)SandraConfig.getConfig());
        File dir = new File(notifierTemplateDir);
        Preconditions.checkNotNull((Object)dir, (Object)("Failed to find templates dir '" + notifierTemplateDir + "'"));
        File[] templates = dir.listFiles();
        Preconditions.checkNotNull((Object)templates, (Object)("Failed to find templates in '" + dir.getPath() + "'"));
        ArrayList<String> names = new ArrayList<String>(templates.length);
        for (File template : templates) {
            names.add(template.getName().replace(SandraConfig.NOTIFIER_TEMPLATE_EXTENSION, ""));
        }
        return names;
    }

    @Override
    public String getTemplate(String name) throws LogicException {
        try {
            return FileUtils.readFileToString((File)SandraConfigHelper.getTemplateFile((ApplicationConfig)SandraConfig.getConfig(), (String)name), (String)"utf8");
        }
        catch (IOException ioe) {
            log.error((Object)"error.service.template.write", (Throwable)ioe);
            throw new LogicException("error.service.template.read");
        }
    }

    @Override
    public void saveTemplate(String name, String template) throws LogicException {
        try {
            FileUtils.writeStringToFile((File)SandraConfigHelper.getTemplateFile((ApplicationConfig)SandraConfig.getConfig(), (String)name), (String)template, (String)"utf8");
        }
        catch (IOException ioe) {
            log.error((Object)"error.service.template.write", (Throwable)ioe);
            throw new LogicException("error.service.template.write");
        }
    }
}

