/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra.services.ejb3;

import com.cybelia.sandra.SandraDAOHelper;
import com.cybelia.sandra.entities.Eleveur;
import com.cybelia.sandra.entities.InfoAccess;
import com.cybelia.sandra.entities.Label;
import com.cybelia.sandra.entities.TypeConnectionEnum;
import com.cybelia.sandra.entities.UserIndicateurs;
import com.cybelia.sandra.entities.UserIndicateursDAO;
import com.cybelia.sandra.security.SecurityHelper;
import com.cybelia.sandra.services.ServiceHelper;
import com.cybelia.sandra.services.ejb3.BaseServiceImpl;
import com.cybelia.sandra.services.ejb3.Transaction;
import com.cybelia.sandra.services.local.ServiceCommonLocal;
import com.cybelia.sandra.services.local.ServiceNotifierLocal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.security.PermitAll;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.ejb3.annotation.SecurityDomain;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.taas.TaasService;
import org.nuiton.topia.taas.entities.TaasUser;

@Stateless
@SecurityDomain(value="sandra")
@PermitAll
public class ServiceCommonImpl
extends BaseServiceImpl
implements ServiceCommonLocal {
    protected static final Log log = LogFactory.getLog(ServiceCommonImpl.class);
    @EJB
    protected ServiceNotifierLocal serviceNotifier;

    @Override
    public boolean canReadEntity(TopiaContext transaction, String topiaId) {
        return this.canDoOnEntity(transaction, topiaId, 1);
    }

    @Override
    public boolean canUpdateEntity(TopiaContext transaction, String topiaId) {
        return this.canDoOnEntity(transaction, topiaId, 4);
    }

    protected boolean canDoOnEntity(TopiaContext transaction, String topiaId, int actions) {
        TaasService taas;
        block6: {
            taas = null;
            try {
                taas = (TaasService)transaction.getService(TaasService.class);
            }
            catch (TopiaException te) {
                if (!log.isErrorEnabled()) break block6;
                log.error((Object)te);
            }
        }
        boolean canDo = true;
        if (taas != null) {
            try {
                taas.check(topiaId, actions);
            }
            catch (SecurityException se) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Permission check failed", (Throwable)se);
                }
                canDo = false;
            }
        }
        return canDo;
    }

    @Override
    public String getLabel(TopiaContext context, String category, String id) throws TopiaException {
        Label lbl;
        if (id != null && (lbl = SandraDAOHelper.getLabelDAO((TopiaContext)context).findByNaturalId(id, category)) != null) {
            return lbl.getValeur();
        }
        return null;
    }

    protected String diff(Object compare, Object to) {
        if (compare == null && to == null) {
            return null;
        }
        if (!(to == null || compare != null && compare.equals(to))) {
            return to.toString();
        }
        return null;
    }

    protected String diffAndMix(String oldValue, String newValue) {
        boolean newNullOrEmpty;
        boolean oldsNullOrEmpty;
        boolean bl = oldsNullOrEmpty = oldValue == null;
        if (!oldsNullOrEmpty) {
            oldsNullOrEmpty = oldValue.trim().isEmpty();
        }
        boolean bl2 = newNullOrEmpty = newValue == null;
        if (!newNullOrEmpty) {
            newNullOrEmpty = newValue.trim().isEmpty();
        }
        if (oldsNullOrEmpty && newNullOrEmpty) {
            return null;
        }
        if (newValue == null) {
            newValue = "";
        }
        if (oldValue == null) {
            oldValue = "";
        }
        if (!oldValue.equals(newValue)) {
            return oldValue + "&&" + newValue;
        }
        return null;
    }

    protected String diffAndMixOldAndNewLabelValue(TopiaContext context, String category, String oldValue, String newValue) throws TopiaException {
        boolean ndNew;
        boolean ndOld = oldValue == null || oldValue.isEmpty() || oldValue.trim().equals("ND");
        boolean bl = ndNew = newValue == null || newValue.isEmpty() || newValue.trim().equals("ND");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Label value old : " + oldValue + " new : " + newValue));
        }
        if (ndOld && ndNew) {
            return null;
        }
        return this.diffAndMix(this.getLabel(context, category, oldValue), this.getLabel(context, category, newValue));
    }

    protected String diffAndMixNiveauSecu(int oldSecurite, int newSecurite) {
        boolean dontSendNotif;
        boolean bl = dontSendNotif = oldSecurite == -1 && newSecurite <= 1;
        if (dontSendNotif) {
            return null;
        }
        return this.diffAndMix(String.valueOf(oldSecurite), String.valueOf(newSecurite));
    }

    protected String diffAndMixOldAndNewRiskValue(TopiaContext context, Collection<String> oldValues, Collection<String> newValues) throws TopiaException {
        String oldMix = "";
        if (oldValues != null) {
            for (String oldValue : oldValues) {
                oldMix = oldMix + this.getLabel(context, "RSK", oldValue).trim() + "##";
            }
        }
        if (!oldMix.trim().isEmpty()) {
            oldMix = oldMix.substring(0, oldMix.length() - 2);
        }
        String newMix = "";
        if (newValues != null) {
            for (String newValue : newValues) {
                newMix = newMix + this.getLabel(context, "RSK", newValue).trim() + "##";
            }
        }
        if (!newMix.trim().isEmpty()) {
            newMix = newMix.substring(0, newMix.length() - 2);
        }
        return this.diffAndMix(oldMix.trim(), newMix.trim());
    }

    @Override
    public void notifyChangedBreeder(TopiaContext context, String notifierName, String userLogin, Eleveur eleveurOld, Eleveur eleveur) throws TopiaException {
        List<String> breederValues = this.getChangedDatasBreeder(context, eleveurOld, eleveur);
        ArrayList<String> valuesToSend = new ArrayList<String>();
        if (this.changed(breederValues)) {
            valuesToSend.add(ServiceHelper.getSandraName());
            valuesToSend.add(ServiceHelper.getSandraUrl());
            valuesToSend.add(userLogin);
            valuesToSend.add(eleveur.getTopiaId());
            valuesToSend.add(this.diffAndMix(eleveurOld.getRaisonSociale(), eleveur.getRaisonSociale()));
            valuesToSend.addAll(breederValues);
            this.notifyChanged(notifierName, valuesToSend);
        }
    }

    @Override
    public void notifyChangedBreeder(TopiaContext context, String notifierName, String userLogin, Eleveur eleveurOld, Eleveur eleveur, InfoAccess accesOld, InfoAccess acces) throws TopiaException {
        List<String> breederValues = this.getChangedDatasBreeder(context, eleveurOld, eleveur);
        List<String> infoAccessValues = this.getChangedDatasInfoAccess(context, accesOld, acces);
        ArrayList<String> valuesToSend = new ArrayList<String>();
        if (this.changed(breederValues) || this.changed(infoAccessValues)) {
            valuesToSend.add(ServiceHelper.getSandraName());
            valuesToSend.add(ServiceHelper.getSandraUrl());
            valuesToSend.add(userLogin);
            valuesToSend.add(eleveur.getTopiaId());
            valuesToSend.addAll(breederValues);
            valuesToSend.addAll(infoAccessValues);
            this.notifyChanged(notifierName, valuesToSend);
        }
    }

    @Override
    public void notifyChangedInfoAccess(TopiaContext context, String notifierName, String userLogin, String breederTopiaId, InfoAccess infoAccesOld, InfoAccess infoAcces) throws TopiaException {
        List<String> values = this.getChangedDatasInfoAccess(context, infoAccesOld, infoAcces);
        ArrayList<String> valuesToSend = new ArrayList<String>();
        if (this.changed(values)) {
            valuesToSend.add(ServiceHelper.getSandraName());
            valuesToSend.add(ServiceHelper.getSandraUrl());
            valuesToSend.add(userLogin);
            valuesToSend.add(infoAcces.getTopiaId());
            valuesToSend.add(breederTopiaId);
            valuesToSend.addAll(values);
            this.notifyChanged(notifierName, valuesToSend);
        }
    }

    @Override
    public void notifyChangedInfoAccess(TopiaContext context, String notifierName, String userLogin, String breederTopiaId, InfoAccess infoAccesOld, InfoAccess infoAcces, Double oldX, Double oldY) throws TopiaException {
        List<String> values = this.getChangedDatasInfoAccess(context, infoAccesOld, infoAcces);
        String newX = String.valueOf(infoAcces.getGps().getPoint().getX());
        String newY = String.valueOf(infoAcces.getGps().getPoint().getY());
        String x = this.diffAndMix(String.valueOf(oldX), newX);
        String y = this.diffAndMix(String.valueOf(oldY), newY);
        ArrayList<String> valuesToSend = new ArrayList<String>();
        if (this.changed(values) || x != null || y != null) {
            valuesToSend.add(ServiceHelper.getSandraName());
            valuesToSend.add(ServiceHelper.getSandraUrl());
            valuesToSend.add(userLogin);
            valuesToSend.add(infoAcces.getTopiaId());
            valuesToSend.add(breederTopiaId);
            valuesToSend.add(x);
            valuesToSend.add(y);
            valuesToSend.addAll(values);
            this.notifyChanged(notifierName, valuesToSend);
        }
    }

    protected List<String> getChangedDatasBreeder(TopiaContext context, Eleveur eleveurOld, Eleveur eleveur) throws TopiaException {
        ArrayList<String> values = new ArrayList<String>();
        values.add(this.diffAndMix(eleveurOld.getTelephone(), eleveur.getTelephone()));
        values.add(this.diffAndMix(eleveurOld.getMobile(), eleveur.getMobile()));
        values.add(this.diffAndMix(eleveurOld.getAdresse(), eleveur.getAdresse()));
        values.add(this.diffAndMix(eleveurOld.getVille(), eleveur.getVille()));
        values.add(this.diffAndMix(eleveurOld.getCodePostal(), eleveur.getCodePostal()));
        values.add(this.diffAndMix(eleveurOld.getEmail(), eleveur.getEmail()));
        values.add(this.diffAndMixOldAndNewLabelValue(context, "ECH", eleveurOld.getContrainteHoraire(), eleveur.getContrainteHoraire()));
        values.add(this.diffAndMix(eleveurOld.getCommentaire(), eleveur.getCommentaire()));
        return values;
    }

    protected List<String> getChangedDatasInfoAccess(TopiaContext context, InfoAccess infoAcces, InfoAccess infoAccesUpdate) throws TopiaException {
        ArrayList<String> values = new ArrayList<String>();
        if (infoAcces != null && infoAccesUpdate != null) {
            values.add(this.diffAndMix(infoAcces.getNomAcces(), infoAccesUpdate.getNomAcces()));
            values.add(this.diffAndMixOldAndNewLabelValue(context, "IAS", infoAcces.getAccesSilo(), infoAccesUpdate.getAccesSilo()));
            values.add(this.diffAndMixOldAndNewLabelValue(context, "IMC", infoAcces.getModeChargement(), infoAccesUpdate.getModeChargement()));
            values.add(this.diffAndMix(String.valueOf(infoAcces.getEtat()), String.valueOf(infoAccesUpdate.getEtat())));
            values.add(this.diffAndMixNiveauSecu(infoAcces.getNiveauSecurite(), infoAccesUpdate.getNiveauSecurite()));
            values.add(this.diffAndMixOldAndNewRiskValue(context, infoAcces.getRisques(), infoAccesUpdate.getRisques()));
            values.add(this.diffAndMix(infoAcces.getCommentaireSecurite(), infoAccesUpdate.getCommentaireSecurite()));
        }
        return values;
    }

    protected boolean changed(List<String> values) {
        boolean sendNotif = false;
        for (String value : values) {
            boolean bl = sendNotif = value != null && !value.trim().isEmpty() || sendNotif;
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Changed : " + sendNotif + " value : " + value));
        }
        return sendNotif;
    }

    protected void notifyChanged(String notifierName, List<String> valuesToSend) throws TopiaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("notifyChanged : " + notifierName));
        }
        this.serviceNotifier.notifyEvent(notifierName, valuesToSend.toArray(new String[0]));
    }

    @Override
    public <E extends TopiaEntity> E copyEntityIfNecessary(TopiaContext transaction, E beanFrom, E beanTo, String field) {
        try {
            String fromValue = BeanUtils.getSimpleProperty(beanFrom, (String)field);
            String toValue = BeanUtils.getSimpleProperty(beanTo, (String)field);
            if (fromValue == null || !fromValue.equals(toValue)) {
                BeanUtils.setProperty(beanTo, (String)field, (Object)fromValue);
                this.incNbMaj(transaction);
            }
        }
        catch (Exception eee) {
            log.error((Object)("Failed to copy property " + field + " on bean " + beanFrom), (Throwable)eee);
        }
        return beanTo;
    }

    @Override
    public UserIndicateurs incSynch(TopiaContext transaction, TypeConnectionEnum typeConnection, boolean gprs, boolean update) throws TopiaException {
        UserIndicateurs result = null;
        switch (typeConnection) {
            case SYNCHRO: {
                result = gprs ? this.incNbSynchGprs(transaction, update) : this.incNbSynchWifi(transaction, update);
                result = this.updateLastSynchDate(transaction, result, update);
                break;
            }
            case AUTO: {
                result = this.incNbSynchAuto(transaction, update);
                result = this.updateLastSynchDate(transaction, result, update);
                break;
            }
            case NOTIFICATION: {
                result = this.incNbNotifs(transaction, update);
            }
        }
        return result;
    }

    @Override
    @Transaction(errorMsg="Failed to inc nb octets send gprs")
    public UserIndicateurs incNbOctetsReceivedGPRS(int inc) throws TopiaException {
        throw new RuntimeException("This method must be never call");
    }

    @Override
    public UserIndicateurs incNbOctetsReceivedGPRS(TopiaContext transaction, int inc) throws TopiaException {
        return this.incNbOctetsReceivedGPRS(transaction, inc, true);
    }

    @Override
    public UserIndicateurs incNbOctetsReceivedGPRS(TopiaContext transaction, int inc, boolean update) throws TopiaException {
        return this.inc(transaction, "nbOctetsReceivedGPRS", inc, update);
    }

    @Override
    public UserIndicateurs incNbOctetsReceivedGPRS(UserIndicateurs userIndicateurs, int inc) throws TopiaException {
        return this.inc(userIndicateurs, "nbOctetsReceivedGPRS", inc);
    }

    @Override
    @Transaction(errorMsg="Failed to inc nb octets send gprs")
    public UserIndicateurs incNbOctetsSendGPRS(int inc) throws TopiaException {
        throw new RuntimeException("This method must be never call");
    }

    @Override
    public UserIndicateurs incNbOctetsSendGPRS(TopiaContext transaction, int inc) throws TopiaException {
        return this.incNbOctetsSendGPRS(transaction, inc, true);
    }

    @Override
    public UserIndicateurs incNbOctetsSendGPRS(TopiaContext transaction, int inc, boolean update) throws TopiaException {
        return this.inc(transaction, "nbOctetsSendGPRS", inc, update);
    }

    @Override
    public UserIndicateurs incNbOctetsSendGPRS(UserIndicateurs userIndicateurs, int inc) throws TopiaException {
        return this.inc(userIndicateurs, "nbOctetsSendGPRS", inc);
    }

    @Override
    @Transaction(errorMsg="Failed to inc nb octets received wifi")
    public UserIndicateurs incNbOctetsReceivedWifi(int inc) throws TopiaException {
        throw new RuntimeException("This method must be never call");
    }

    @Override
    public UserIndicateurs incNbOctetsReceivedWifi(TopiaContext transaction, int inc) throws TopiaException {
        return this.incNbOctetsReceivedWifi(transaction, inc, true);
    }

    @Override
    public UserIndicateurs incNbOctetsReceivedWifi(TopiaContext transaction, int inc, boolean update) throws TopiaException {
        return this.inc(transaction, "nbOctetsReceivedWifi", inc, update);
    }

    @Override
    public UserIndicateurs incNbOctetsReceivedWifi(UserIndicateurs userIndicateurs, int inc) throws TopiaException {
        return this.inc(userIndicateurs, "nbOctetsReceivedWifi", inc);
    }

    @Override
    @Transaction(errorMsg="Failed to inc nb octets send wifi")
    public UserIndicateurs incNbOctetsSendWifi(int inc) throws TopiaException {
        throw new RuntimeException("This method must be never call");
    }

    @Override
    public UserIndicateurs incNbOctetsSendWifi(TopiaContext transaction, int inc) throws TopiaException {
        return this.incNbOctetsSendWifi(transaction, inc, true);
    }

    @Override
    public UserIndicateurs incNbOctetsSendWifi(TopiaContext transaction, int inc, boolean update) throws TopiaException {
        return this.inc(transaction, "nbOctetsSendWifi", inc, update);
    }

    @Override
    public UserIndicateurs incNbOctetsSendWifi(UserIndicateurs userIndicateurs, int inc) throws TopiaException {
        return this.inc(userIndicateurs, "nbOctetsSendWifi", inc);
    }

    @Override
    @Transaction(errorMsg="Failed to inc nb synch ko")
    public UserIndicateurs incNbSynchKo() throws TopiaException {
        throw new RuntimeException("This method must be never call");
    }

    public UserIndicateurs incNbSynchKo(TopiaContext transaction) throws TopiaException {
        return this.inc(transaction, "nbSynchKo");
    }

    @Override
    public UserIndicateurs incNbSynchKo(TopiaContext transaction, int inc) throws TopiaException {
        return this.incNbSynchKo(transaction, inc, true);
    }

    @Override
    public UserIndicateurs incNbSynchKo(TopiaContext transaction, int inc, boolean update) throws TopiaException {
        return this.inc(transaction, "nbSynchKo", inc, update);
    }

    @Override
    public UserIndicateurs incNbSynchKo(UserIndicateurs userIndicateurs, int inc) throws TopiaException {
        return this.inc(userIndicateurs, "nbSynchKo", inc);
    }

    @Override
    @Transaction(errorMsg="Failed to inc nb notifs")
    public UserIndicateurs incNbNotifs() throws TopiaException {
        throw new RuntimeException("This method must be never call");
    }

    @Override
    public UserIndicateurs incNbNotifs(TopiaContext transaction) throws TopiaException {
        return this.incNbNotifs(transaction, true);
    }

    @Override
    public UserIndicateurs incNbNotifs(TopiaContext transaction, boolean update) throws TopiaException {
        return this.inc(transaction, "nbNotifs", update);
    }

    @Override
    public UserIndicateurs incNbNotifs(UserIndicateurs userIndicateurs) throws TopiaException {
        return this.inc(userIndicateurs, "nbNotifs");
    }

    @Override
    @Transaction(errorMsg="Failed to inc nb synch auto")
    public UserIndicateurs incNbSynchAuto() throws TopiaException {
        throw new RuntimeException("This method must be never call");
    }

    @Override
    public UserIndicateurs incNbSynchAuto(TopiaContext transaction) throws TopiaException {
        return this.incNbSynchAuto(transaction, true);
    }

    @Override
    public UserIndicateurs incNbSynchAuto(TopiaContext transaction, boolean update) throws TopiaException {
        return this.inc(transaction, "nbSynchAuto", update);
    }

    @Override
    public UserIndicateurs incNbSynchAuto(UserIndicateurs userIndicateurs) throws TopiaException {
        return this.inc(userIndicateurs, "nbSynchAuto");
    }

    @Override
    @Transaction(errorMsg="Failed to inc nb gps maj")
    public UserIndicateurs incNbGpsMaj() throws TopiaException {
        throw new RuntimeException("This method must be never call");
    }

    @Override
    public UserIndicateurs incNbGpsMaj(TopiaContext transaction) throws TopiaException {
        return this.incNbGpsMaj(transaction, true);
    }

    @Override
    public UserIndicateurs incNbGpsMaj(TopiaContext transaction, boolean update) throws TopiaException {
        return this.inc(transaction, "nbGpsMaj", update);
    }

    @Override
    public UserIndicateurs incNbGpsMaj(UserIndicateurs userIndicateurs) throws TopiaException {
        return this.inc(userIndicateurs, "nbGpsMaj");
    }

    @Override
    @Transaction(errorMsg="Failed to inc nb secu maj")
    public UserIndicateurs incNbSecuMaj() throws TopiaException {
        throw new RuntimeException("This method must be never call");
    }

    @Override
    public UserIndicateurs incNbSecuMaj(TopiaContext transaction) throws TopiaException {
        return this.incNbSecuMaj(transaction, true);
    }

    @Override
    public UserIndicateurs incNbSecuMaj(TopiaContext transaction, boolean update) throws TopiaException {
        return this.inc(transaction, "nbSecuMaj", update);
    }

    @Override
    public UserIndicateurs incNbSecuMaj(UserIndicateurs userIndicateurs) throws TopiaException {
        return this.inc(userIndicateurs, "nbSecuMaj");
    }

    @Override
    @Transaction(errorMsg="Failed to inc nb maj")
    public UserIndicateurs incNbMaj() throws TopiaException {
        throw new RuntimeException("This method must be never call");
    }

    @Override
    public UserIndicateurs incNbMaj(TopiaContext transaction) throws TopiaException {
        UserIndicateurs result = this.incNbMaj(transaction, true);
        return result;
    }

    @Override
    public UserIndicateurs incNbMaj(TopiaContext transaction, boolean update) throws TopiaException {
        UserIndicateurs result = this.inc(transaction, "nbMaj", update);
        if (result != null) {
            result = this.updateLastModif(transaction, result, update);
        }
        return result;
    }

    @Override
    @Transaction(errorMsg="Failed to inc nb maj")
    public UserIndicateurs incNbMaj(UserIndicateurs userIndicateurs) throws TopiaException {
        throw new RuntimeException("This method must be never call");
    }

    public UserIndicateurs incNbMaj(TopiaContext transaction, UserIndicateurs userIndicateurs) throws TopiaException {
        UserIndicateurs result = this.inc(userIndicateurs, "nbMaj");
        result = this.updateLastModif(transaction, result);
        return result;
    }

    @Override
    @Transaction(errorMsg="Failed to inc nb synch wifi")
    public UserIndicateurs incNbSynchWifi() throws TopiaException {
        throw new RuntimeException("This method must be never call");
    }

    @Override
    public UserIndicateurs incNbSynchWifi(TopiaContext transaction) throws TopiaException {
        return this.incNbSynchWifi(transaction, true);
    }

    @Override
    public UserIndicateurs incNbSynchWifi(TopiaContext transaction, boolean update) throws TopiaException {
        return this.inc(transaction, "nbSynchWifi", update);
    }

    @Override
    public UserIndicateurs incNbSynchWifi(UserIndicateurs userIndicateurs) throws TopiaException {
        return this.inc(userIndicateurs, "nbSynchWifi");
    }

    @Override
    @Transaction(errorMsg="Failed to inc nb synch gprs")
    public UserIndicateurs incNbSynchGprs() throws TopiaException {
        throw new RuntimeException("This method must be never call");
    }

    @Override
    public UserIndicateurs incNbSynchGprs(TopiaContext transaction) throws TopiaException {
        return this.incNbSynchGprs(transaction, true);
    }

    @Override
    public UserIndicateurs incNbSynchGprs(TopiaContext transaction, boolean update) throws TopiaException {
        return this.inc(transaction, "nbSynchGPRS", update);
    }

    @Override
    public UserIndicateurs incNbSynchGprs(UserIndicateurs userIndicateurs) throws TopiaException {
        return this.inc(userIndicateurs, "nbSynchGPRS");
    }

    protected UserIndicateurs updateLastSynchDate(TopiaContext transaction, UserIndicateurs userIndicateurs, boolean update) throws TopiaException {
        UserIndicateursDAO userIndicateursDAO = SandraDAOHelper.getUserIndicateursDAO((TopiaContext)transaction);
        userIndicateurs.setLastSynch(new Date());
        if (update) {
            userIndicateurs = (UserIndicateurs)userIndicateursDAO.update((TopiaEntity)userIndicateurs);
        }
        return userIndicateurs;
    }

    protected UserIndicateurs updateLastModif(TopiaContext transaction, UserIndicateurs userIndicateurs) throws TopiaException {
        return this.updateLastModif(transaction, userIndicateurs, true);
    }

    protected UserIndicateurs updateLastModif(TopiaContext transaction, UserIndicateurs userIndicateurs, boolean update) throws TopiaException {
        UserIndicateursDAO userIndicateursDAO = SandraDAOHelper.getUserIndicateursDAO((TopiaContext)transaction);
        userIndicateurs.setLastModif(new Date());
        if (update) {
            userIndicateurs = (UserIndicateurs)userIndicateursDAO.update((TopiaEntity)userIndicateurs);
        }
        return userIndicateurs;
    }

    protected UserIndicateurs inc(TopiaContext transaction, String methodName) throws TopiaException {
        return this.inc(transaction, methodName, 1);
    }

    protected UserIndicateurs inc(TopiaContext transaction, String methodName, int inc) throws TopiaException {
        return this.inc(transaction, methodName, inc, true);
    }

    protected UserIndicateurs inc(TopiaContext transaction, String methodName, boolean update) throws TopiaException {
        return this.inc(transaction, methodName, 1, update);
    }

    protected UserIndicateurs inc(TopiaContext transaction, String methodName, int inc, boolean update) throws TopiaException {
        TaasUser user = SecurityHelper.getUser();
        UserIndicateursDAO userIndicateursDAO = SandraDAOHelper.getUserIndicateursDAO((TopiaContext)transaction);
        UserIndicateurs userIndicateurs = userIndicateursDAO.findByTaasUser(user);
        if (userIndicateurs != null) {
            userIndicateurs = this.inc(userIndicateurs, methodName, inc);
            if (update) {
                userIndicateurs = (UserIndicateurs)userIndicateursDAO.update((TopiaEntity)userIndicateurs);
            }
        }
        return userIndicateurs;
    }

    protected UserIndicateurs inc(UserIndicateurs userIndicateurs, String methodName) {
        return this.inc(userIndicateurs, methodName, 1);
    }

    protected UserIndicateurs inc(UserIndicateurs userIndicateurs, String methodName, int inc) {
        try {
            if (userIndicateurs != null) {
                String value = BeanUtils.getSimpleProperty((Object)userIndicateurs, (String)methodName);
                int i = Integer.parseInt(value);
                BeanUtils.setProperty((Object)userIndicateurs, (String)methodName, (Object)(i += inc));
            } else {
                log.warn((Object)("Failled to inc : " + methodName + " because userIndicateurs is null"));
            }
        }
        catch (Exception eee) {
            log.error((Object)("Failled to inc : " + methodName), (Throwable)eee);
        }
        return userIndicateurs;
    }
}

