/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra.services;

import com.cybelia.sandra.SandraConfig;
import com.cybelia.sandra.SandraConfigHelper;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ApplicationConfig;

public class ServiceHelper {
    private static final Log log = LogFactory.getLog(ServiceHelper.class);

    public static <S> S newLocalService(Class<S> klass) {
        return ServiceHelper.newLocalService(klass, null);
    }

    public static <S> S newLocalService(Class<S> klass, Properties env) {
        return ServiceHelper.newService(klass, env, "Impl/local");
    }

    public static <S> S newRemoteService(Class<S> klass) {
        return ServiceHelper.newRemoteService(klass, null);
    }

    public static <S> S newRemoteService(Class<S> klass, Properties env) {
        return ServiceHelper.newService(klass, env, "Impl/remote");
    }

    public static <S> S newService(Class<S> klass, Properties env, String suffix) {
        try {
            InitialContext context = new InitialContext(env);
            return (S)context.lookup(klass.getSimpleName() + suffix);
        }
        catch (NamingException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String getSandraName() {
        return SandraConfigHelper.getSandraName((ApplicationConfig)SandraConfig.getConfig());
    }

    public static String getSandraUrl() {
        return SandraConfigHelper.getSandraUrl((ApplicationConfig)SandraConfig.getConfig());
    }
}

