/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra.security;

import com.cybelia.sandra.security.NotifierSecurityHelper;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.security.SecurityAssociation;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaNotFoundException;
import org.nuiton.topia.persistence.TopiaId;
import org.nuiton.topia.taas.entities.TaasUser;

public class SecurityHelper
extends NotifierSecurityHelper {
    private static Log log = LogFactory.getLog(SecurityHelper.class);
    protected static TaasUser user;

    public static void setUser(TaasUser taasUser) {
        user = taasUser;
    }

    public static String getProfilName(String topiaIdProfil) throws TopiaNotFoundException {
        return SecurityHelper.getProfilClass(TopiaId.getClassName((String)topiaIdProfil));
    }

    public static String getProfilClass(Class classProfil) {
        return classProfil.getName();
    }

    public static TaasUser getUser() {
        Set<TaasUser> users;
        if (user != null) {
            return user;
        }
        try {
            Subject subject = SecurityAssociation.getSubject();
            if (subject == null) {
                return null;
            }
            Set<Object> users2 = subject.getPrivateCredentials();
            if (!users2.isEmpty()) {
                return (TaasUser)CollectionUtils.get(users2, (int)0);
            }
        }
        catch (Throwable eee) {
            log.error((Object)"Cant get users : ", eee);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"No user found !");
        }
        if ((users = SecurityAssociation.getSubject().getPrivateCredentials(TaasUser.class)).isEmpty()) {
            return null;
        }
        TaasUser user = users.iterator().next();
        return user;
    }

    public static String[] getAuthorizations() throws TopiaException {
        return SecurityHelper.getAuthorizations((TaasUser)SecurityHelper.getUser());
    }

    public static boolean isAdmin() {
        TaasUser user = SecurityHelper.getUser();
        return user != null && SecurityHelper.isAdmin((TaasUser)user);
    }
}

