/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra.security;

import com.cybelia.sandra.SandraConfigHelper;
import java.security.Principal;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.security.SimpleGroup;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.taas.TaasService;
import org.nuiton.topia.taas.jaas.TaasLoginModule;
import org.nuiton.topia.taas.jaas.TaasPrincipalWrapper;

public class SandraLoginModule
extends TaasLoginModule {
    private static Log log = LogFactory.getLog(SandraLoginModule.class);

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        log.info((Object)"SandraLoginModule is initialized");
        super.initialize(subject, callbackHandler, sharedState, options);
        if (this.taasService == null) {
            try {
                TopiaContext rootContext = SandraConfigHelper.getServiceRootContext();
                this.taasService = (TaasService)rootContext.getService(TaasService.class);
            }
            catch (Exception e) {
                log.error((Object)"Init failed", (Throwable)e);
                throw new SecurityException("init failed", e);
            }
        }
    }

    public boolean commit() throws LoginException {
        try {
            log.info((Object)"SandraLoginModule commit");
            super.commit();
            SimpleGroup roles = new SimpleGroup("Roles");
            for (TaasPrincipalWrapper principal : this.principals) {
                SimpleGroup group = new SimpleGroup(principal.getName());
                group.addMember((Principal)principal);
                roles.addMember((Principal)group);
            }
            this.subject.getPrincipals().add((Principal)roles);
            if (log.isDebugEnabled()) {
                log.debug((Object)("SandraLoginModule commit with subject " + this.subject));
            }
        }
        catch (Throwable eee) {
            log.error((Object)"Cant commit : ", eee);
            throw new LoginException(eee.getMessage());
        }
        return true;
    }

    public boolean logout() throws LoginException {
        log.info((Object)"SandraLoginModule logout");
        return super.logout();
    }
}

