/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra;

import com.cybelia.sandra.SandraConfig;
import com.cybelia.sandra.SandraSchedulerConfigHelper;
import com.cybelia.sandra.security.NoSecurityOnLoad;
import com.cybelia.sandra.security.SandraSubjectFinder;
import java.io.IOException;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaContextFactory;
import org.nuiton.topia.TopiaNotFoundException;
import org.nuiton.topia.taas.TaasService;
import org.nuiton.util.ApplicationConfig;

public class SandraConfigHelper
extends SandraSchedulerConfigHelper {
    public static final Log log = LogFactory.getLog(SandraConfigHelper.class);

    public static Properties getServiceTopiaProperties(boolean secure, ApplicationConfig config) throws IOException {
        Properties properties = SandraConfigHelper.getSchedulerTopiaProperties((ApplicationConfig)config);
        if (secure) {
            properties.put("topia.service.taas", TaasService.class.getName());
            properties.put("topia.service.taas.event", NoSecurityOnLoad.class.getName());
            properties.put("topia.service.taas.subject", SandraSubjectFinder.class.getName());
        }
        return properties;
    }

    public static String getGoogleMapKey(ApplicationConfig config) {
        return config.getOption(SandraConfig.SandraOption.GOOGLE_MAP_KEY.key);
    }

    public static String getSandraVersion(ApplicationConfig config) {
        return config.getOption(SandraConfig.SandraOption.SANDRA_VERSION.key);
    }

    public static Date getPreviousRAZDate(ApplicationConfig config) throws ParseException {
        Date nextDatefromProperies = SandraConfigHelper.getNextDatefromProperies((ApplicationConfig)config, (String)"sandra.scheduler.RAZNumberOfConnection");
        Calendar cal = Calendar.getInstance();
        if (nextDatefromProperies != null) {
            cal.setTime(nextDatefromProperies);
            cal.add(2, -1);
        }
        return cal.getTime();
    }

    public static String getNoteDir(ApplicationConfig config) {
        return config.getOption(SandraConfig.SandraOption.SANDRA_NOTE_DIR.key);
    }

    public static TopiaContext getServiceRootContext() throws IOException, TopiaNotFoundException {
        return SandraConfigHelper.getServiceRootContext(true);
    }

    public static TopiaContext getServiceRootContext(boolean secure) throws IOException, TopiaNotFoundException {
        ApplicationConfig config = SandraConfig.getConfig();
        Properties serviceTopiaProperties = SandraConfigHelper.getServiceTopiaProperties(secure, config);
        return TopiaContextFactory.getContext((Properties)serviceTopiaProperties);
    }
}

