/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra.notifier;

import com.cybelia.sandra.SandraSchedulerConfigHelper;
import com.cybelia.sandra.notifier.SandraNotifier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;

public class ThreadNotifyEvent
extends Thread {
    protected static final Log log = LogFactory.getLog(ThreadNotifyEvent.class);
    protected String type;
    protected String[] values;
    protected SandraNotifier notifier;

    public ThreadNotifyEvent(SandraNotifier notifier, String type, String[] values) {
        this.type = type;
        this.values = values;
        this.notifier = notifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Starting thread " + this.getName()));
        }
        TopiaContext transaction = null;
        try {
            TopiaContext ibuRootContext = SandraSchedulerConfigHelper.getSchedulerRootContext();
            transaction = ibuRootContext.beginTransaction();
            this.notifier.doNotifyEvent(transaction, this.type, this.values);
        }
        catch (Exception eee) {
            log.error((Object)"Error notify event", (Throwable)eee);
        }
        finally {
            if (transaction != null) {
                try {
                    if (!transaction.isClosed()) {
                        transaction.commitTransaction();
                        transaction.closeContext();
                    }
                }
                catch (TopiaException eee) {
                    log.error((Object)"Failed closing connection : ", (Throwable)eee);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Stopping thread " + this.getName()));
            }
        }
    }
}

