/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra.ibu.manager;

import com.cybelia.sandra.SandraDAOHelper;
import com.cybelia.sandra.entities.Tour;
import com.cybelia.sandra.entities.TourTypeModif;
import com.cybelia.sandra.entities.synchro.Log;
import com.cybelia.sandra.entities.synchro.LogDAO;
import com.cybelia.sandra.ibu.manager.ManagerInjector;
import java.math.BigInteger;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public class SynchNumberManager {
    protected static final org.apache.commons.logging.Log log = LogFactory.getLog(SynchNumberManager.class);

    public static Long getNextSynchroNumber(TopiaContext transaction) throws TopiaException {
        BigInteger resultInt = (BigInteger)((TopiaContextImpl)transaction).getHibernate().createSQLQuery("SELECT nextval('sandra.synchNumber')").uniqueResult();
        return resultInt.longValue();
    }

    public static Long getCurrentSynchroNumber(TopiaContext transaction) throws TopiaException {
        BigInteger resultInt = (BigInteger)((TopiaContextImpl)transaction).getHibernate().createSQLQuery("SELECT last_value FROM sandra.synchnumber").uniqueResult();
        return resultInt.longValue();
    }

    public static void notifyTourCreated(ManagerInjector manager, Tour tour, String camionTopiaId, String comment) throws TopiaException {
        LogDAO logDAO = SandraDAOHelper.getLogDAO((TopiaContext)manager.getTransaction());
        String tourTopiaId = tour.getTopiaId();
        Log synchroLog = (Log)logDAO.create(new Object[]{"tourTopiaID", tourTopiaId});
        synchroLog.setCamionTopiaID(camionTopiaId);
        synchroLog.setTypeModif(TourTypeModif.CREATE);
        SynchNumberManager.saveLog(manager, synchroLog, comment);
    }

    public static void notifyTourChange(ManagerInjector manager, Tour tour, String camionTopiaId, String comment) throws TopiaException {
        String tourTopiaId;
        LogDAO logDAO = SandraDAOHelper.getLogDAO((TopiaContext)manager.getTransaction());
        Log synchroLog = (Log)logDAO.findByProperties("tourTopiaID", (Object)(tourTopiaId = tour.getTopiaId()), new Object[]{"camionTopiaID", camionTopiaId});
        if (synchroLog == null) {
            synchroLog = (Log)logDAO.create(new Object[]{"tourTopiaID", tourTopiaId, "camionTopiaID", camionTopiaId});
        }
        int typeModif = TourTypeModif.MODIF;
        if (!tour.isActif()) {
            typeModif = TourTypeModif.SUPPR;
        }
        if (synchroLog.getTypeModif() == TourTypeModif.SUPPR && typeModif == TourTypeModif.SUPPR) {
            return;
        }
        synchroLog.setTypeModif(typeModif);
        SynchNumberManager.saveLog(manager, synchroLog, comment);
    }

    public static void saveLog(ManagerInjector manager, Log logToSave, String comment) {
        SynchNumberManager.saveLog(manager, null, logToSave, comment);
    }

    public static void saveLog(ManagerInjector manager, String fileName, Log logToSave, String comment) {
        if (StringUtils.isNotEmpty((CharSequence)fileName)) {
            logToSave.setFichierSynchro(fileName);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("[ManagerInjector] Saving log type " + logToSave.getTypeModif() + " for tour " + logToSave.getTourTopiaID() + " camion : " + logToSave.getCamionTopiaID() + " with comment : " + comment));
        }
        try {
            TopiaContext transaction = manager.getTransaction();
            LogDAO logDAO = SandraDAOHelper.getLogDAO((TopiaContext)transaction);
            logToSave.setTimeStamp(System.currentTimeMillis());
            long syncNum = SynchNumberManager.getNextSynchroNumber(transaction);
            logToSave.setSynchroNumber(syncNum);
            logDAO.update((TopiaEntity)logToSave);
        }
        catch (TopiaException eee) {
            log.error((Object)"Failed to save synch number", (Throwable)eee);
        }
    }
}

