/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra.ibu.injector;

import com.cybelia.sandra.SandraDAOHelper;
import com.cybelia.sandra.SandraHelper;
import com.cybelia.sandra.entities.Camion;
import com.cybelia.sandra.entities.Etape;
import com.cybelia.sandra.entities.LigneProduit;
import com.cybelia.sandra.entities.Societe;
import com.cybelia.sandra.entities.Tour;
import com.cybelia.sandra.entities.TourDAO;
import com.cybelia.sandra.entities.trace.SuiviTour;
import com.cybelia.sandra.entities.trace.SuiviTourDAO;
import com.cybelia.sandra.ibu.ModifsCollector;
import com.cybelia.sandra.ibu.csv.bean.Ibu;
import com.cybelia.sandra.ibu.manager.Injector;
import com.cybelia.sandra.ibu.manager.ManagerInjector;
import com.cybelia.sandra.ibu.manager.SynchNumberManager;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;

public class InjectorTour
implements Injector {
    private final Log log = LogFactory.getLog(InjectorTour.class);
    protected Tour tour;
    protected boolean commandeCommentaireIsModif = false;
    protected boolean commandeActifIsModif = false;

    public Tour getObject() {
        return this.tour;
    }

    @Override
    public void clear() {
        this.tour = null;
        this.commandeCommentaireIsModif = false;
        this.commandeActifIsModif = false;
    }

    public void setCommandeCommentaireIsModif(boolean commandeCommentaireIsModif) {
        this.commandeCommentaireIsModif = commandeCommentaireIsModif;
    }

    public void setCommandeActifChange(boolean commandeActifIsModif) {
        this.commandeActifIsModif = commandeActifIsModif;
    }

    @Override
    public void inject(ManagerInjector manager, Ibu ibu) throws TopiaException {
        TourDAO tourDAO = SandraDAOHelper.getTourDAO((TopiaContext)manager.getTransaction());
        Camion camion = manager.getCamion();
        this.tour = tourDAO.findByNaturalId(ibu.getTourDateLivraison(), ibu.getTourNumero(), camion);
        if (this.tour == null) {
            this.tour = tourDAO.createByNaturalId(ibu.getTourDateLivraison(), ibu.getTourNumero(), camion);
            SynchNumberManager.notifyTourCreated(manager, this.tour, camion.getTopiaId(), "[IBU] creation du tour");
            String msg = SandraHelper.getLogTour(this.tour, "create tour");
            this.log.info((Object)msg);
        } else {
            Tour oldTour;
            LigneProduit ligneProduit = manager.getLigneProduit();
            ModifsCollector modifsCollectorImpactSuivi = new ModifsCollector("[IBU] tour change because impact suiviTour : ");
            modifsCollectorImpactSuivi.add(Tour.class, "dateLivraison", this.tour.getDateLivraison().getTime(), ibu.getTourDateLivraison().getTime());
            modifsCollectorImpactSuivi.add(Tour.class, "numero", this.tour.getNumero(), ibu.getTourNumero());
            modifsCollectorImpactSuivi.add("Commande created", manager.isCommandeCreated());
            modifsCollectorImpactSuivi.add("Commande actif changed", this.commandeActifIsModif);
            modifsCollectorImpactSuivi.add("Infochargement changed", manager.isInfoChargementChanged());
            ModifsCollector modifsCollector = new ModifsCollector("[IBU] tour change because : ");
            modifsCollector.add(Tour.class, "commentaire", this.tour.getCommentaire(), ibu.getTourCommentaire());
            modifsCollector.add(Tour.class, "defautChauffeur", this.tour.getDefautChauffeur(), manager.getChauffeur());
            modifsCollector.add(LigneProduit.class, "silo", ligneProduit.getSilo(), manager.getSilo());
            modifsCollector.add(LigneProduit.class, "quantiteACharger", ligneProduit.getQuantiteACharger(), ibu.getProduitQuantiteAChargee());
            modifsCollector.add(LigneProduit.class, "quantiteCommandee", ligneProduit.getQuantiteCommandee(), ibu.getProduitQuantiteCommandee());
            modifsCollector.add(LigneProduit.class, "code", ligneProduit.getCode(), ibu.getProduitCode());
            modifsCollector.add("comande commentaire modifie", this.commandeCommentaireIsModif);
            Etape oldEtape = ligneProduit.getEtape();
            if (oldEtape != null) {
                oldTour = oldEtape.getTour();
                Camion oldCamion = oldTour.getCamion();
                String oldCamionSocieteCode = oldCamion.getSociete().getCode() + "-" + oldCamion.getCode();
                modifsCollectorImpactSuivi.add(Tour.class, "topiaId", oldTour.getTopiaId(), this.tour.getTopiaId());
                modifsCollectorImpactSuivi.add(Societe.class, "code", oldCamionSocieteCode, ibu.getCamionCodeSociete());
            }
            if (modifsCollector.isModified() || modifsCollectorImpactSuivi.isModified()) {
                if (modifsCollectorImpactSuivi.isModified()) {
                    InjectorTour.deleteSuiviTour(this.log, manager, this.tour);
                    if (oldEtape != null) {
                        oldTour = oldEtape.getTour();
                        InjectorTour.deleteSuiviTour(this.log, manager, oldTour);
                        SynchNumberManager.notifyTourChange(manager, oldTour, oldTour.getCamion().getTopiaId(), "lancien tour a change");
                        String msg = SandraHelper.getLogTour(oldTour, "old tour");
                        this.log.info((Object)msg);
                    }
                }
                SynchNumberManager.notifyTourChange(manager, this.tour, camion.getTopiaId(), modifsCollector.toString() + " - " + modifsCollectorImpactSuivi.toString());
            }
            String msg = SandraHelper.getLogTour(this.tour, "");
            this.log.info((Object)msg);
        }
        Date tourChargement = ibu.getTourChargement();
        this.tour.setDateChargementInitiale(tourChargement);
        Date chargementDate = ibu.getChargementDate();
        if (!chargementDate.equals(tourChargement)) {
            this.tour.setDateChargementReel(chargementDate);
        }
        this.tour.setCommentaire(ibu.getTourCommentaire());
        this.tour.setDefautChauffeur(manager.getChauffeur());
    }

    public static void deleteSuiviTour(Log log, ManagerInjector manager, Tour tour) throws TopiaException {
        SuiviTour suiviTour = tour.getSuiviTour();
        Camion camion = tour.getCamion();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Suppression des suivis pour le tour n\u00b0" + tour.getNumero() + " pour une date de livraison le " + tour.getDateLivraison() + " pour le camion " + camion.getSociete().getCode() + "-" + camion.getCode() + " : " + tour.getTopiaId()));
        }
        if (suiviTour != null) {
            TopiaContext transaction = manager.getTransaction();
            SuiviTourDAO suiviTourDAO = SandraDAOHelper.getSuiviTourDAO((TopiaContext)transaction);
            suiviTourDAO.delete(suiviTour);
        }
    }
}

