/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra.ibu.csv;

import java.beans.PropertyEditorSupport;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class DatePropertyEditor
extends PropertyEditorSupport {
    @Override
    public String getAsText() {
        Date d = (Date)this.getValue();
        if (d == null) {
            return "No Date Set";
        }
        return new SimpleDateFormat("dd/MM/yyyy hh:mm", Locale.FRANCE).format(d);
    }

    @Override
    public void setAsText(String s) {
        try {
            if (s.length() <= 10) {
                this.setValue(new SimpleDateFormat("dd/MM/yyyy", Locale.FRANCE).parse(s));
            } else {
                this.setValue(new SimpleDateFormat("dd/MM/yyyy hh:mm", Locale.FRANCE).parse(s));
            }
        }
        catch (ParseException pe) {
            IllegalArgumentException iae = new IllegalArgumentException("Could not parse date");
            throw iae;
        }
    }
}

