/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra;

import com.cybelia.sandra.entities.Camion;
import com.cybelia.sandra.entities.InfoAccessEtat;
import com.cybelia.sandra.entities.Tour;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;

public class UserIndicateursStats {
    protected static final transient Log log = LogFactory.getLog(UserIndicateursStats.class);
    protected Camion camion;
    public static final String BREEDER_REQUEST_COUNT = "SELECT DISTINCT etape.topiaId FROM " + Tour.class.getName() + " tour" + " JOIN tour.suiviTour AS suiviTour" + " JOIN suiviTour.suiviEtapes AS suiviEtape " + " JOIN suiviEtape.etape AS etape" + " WHERE tour.camion = :camion" + " AND tour.dateLivraison >= :dateLessMonth";
    public static final String SILO_REQUEST_COUNT = "SELECT DISTINCT produits.topiaId FROM " + Tour.class.getName() + " tour" + " JOIN tour.suiviTour AS suiviTour" + " JOIN suiviTour.suiviEtapes AS suiviEtapes " + " JOIN suiviEtapes.etape AS etape" + " JOIN etape.produits AS produits" + " JOIN produits.silo AS silo" + " WHERE tour.camion = :camion" + " AND tour.dateLivraison >= :dateLessMonth";
    public static final String BREEDER_GROUP_BY = " GROUP BY etape.topiaId, etape.eleveur";
    public static final String SILO_GROUP_BY = " GROUP BY produits.topiaId, silo";

    public UserIndicateursStats(Camion camion) {
        this.camion = camion;
    }

    public List<Integer> aquireDatas(TopiaContext transaction) throws TopiaException {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (Indicator indicator : Indicator.values()) {
            Integer resultIndicator = this.executeQuery(transaction, indicator);
            if (Indicator.NB_BREEDER_LIVRE.equals((Object)indicator) && resultIndicator == 0) {
                return null;
            }
            result.add(resultIndicator);
        }
        return result;
    }

    protected Integer executeQuery(TopiaContext transaction, Indicator indicator) throws TopiaException {
        Date dateLessOneMonth = DateUtils.addMonths((Date)new Date(), (int)-1);
        List found = transaction.findAll(indicator.getRequest(), new Object[]{"camion", this.camion, "dateLessMonth", dateLessOneMonth});
        int result = found.size();
        if (log.isDebugEnabled()) {
            log.debug((Object)(indicator.getRequest() + "\n" + "indicator : " + (Object)((Object)indicator) + " camion " + this.camion + " dateLessMonth " + dateLessOneMonth));
            log.debug((Object)(this.camion.getUserIndicateurs().getTaasUser().getLogin() + " " + (Object)((Object)indicator) + " : " + result));
        }
        return result;
    }

    static enum Indicator {
        NB_BREEDER_LIVRE(BREEDER_REQUEST_COUNT + " GROUP BY etape.topiaId, etape.eleveur"),
        PRCENT_BREEDER_GEP(BREEDER_REQUEST_COUNT + " AND etape.eleveur.tomtomGPS IS NOT NULL" + " GROUP BY etape.topiaId, etape.eleveur"),
        PRCENT_BREEDER_GEO_VERROUILLE(BREEDER_REQUEST_COUNT + " AND etape.eleveur.nbTomTomGPSModif = 3" + " GROUP BY etape.topiaId, etape.eleveur"),
        PRCENT_BREEDER_NIV0(BREEDER_REQUEST_COUNT + " AND (etape.eleveur.accesEleveur.niveauSecurite = '-1' OR etape.eleveur.accesEleveur.niveauSecurite = '0')" + " GROUP BY etape.topiaId, etape.eleveur"),
        PRCENT_BREEDER_NIV1(BREEDER_REQUEST_COUNT + " AND etape.eleveur.accesEleveur.niveauSecurite = 1" + " GROUP BY etape.topiaId, etape.eleveur"),
        PRCENT_BREEDER_NIV2(BREEDER_REQUEST_COUNT + " AND etape.eleveur.accesEleveur.niveauSecurite = 2" + " GROUP BY etape.topiaId, etape.eleveur"),
        PRCENT_BREEDER_NIV3(BREEDER_REQUEST_COUNT + " AND etape.eleveur.accesEleveur.niveauSecurite = 3" + " GROUP BY etape.topiaId, etape.eleveur"),
        PRCENT_BREEDER_NIV4(BREEDER_REQUEST_COUNT + " AND etape.eleveur.accesEleveur.niveauSecurite = 4" + " GROUP BY etape.topiaId, etape.eleveur"),
        PRCENT_BREEDER_WITH_ACCESS(BREEDER_REQUEST_COUNT + " AND etape.eleveur.accesEleveur.accesSilo IS NOT NULL" + " GROUP BY etape.topiaId, etape.eleveur"),
        PRCENT_BREEDER_WITH_EQUIPMENT(BREEDER_REQUEST_COUNT + " AND etape.eleveur.accesEleveur.modeChargement IS NOT NULL" + " GROUP BY etape.topiaId, etape.eleveur"),
        NB_SILO_LIVRE(SILO_REQUEST_COUNT + " GROUP BY produits.topiaId, silo"),
        PRCENT_SILO_GEO(SILO_REQUEST_COUNT + " AND silo.gps IS NOT NULL" + " GROUP BY produits.topiaId, silo"),
        PRCENT_SILO_GEO_VERROUILLE(SILO_REQUEST_COUNT + " AND silo.etat = " + InfoAccessEtat.INFOACCESS_VERROU + " GROUP BY produits.topiaId, silo"),
        PRCENT_SILO_NIV0(SILO_REQUEST_COUNT + " AND (silo.niveauSecurite = '-1' OR silo.niveauSecurite = 0)" + " GROUP BY produits.topiaId, silo"),
        PRCENT_SILO_NIV1(SILO_REQUEST_COUNT + " AND silo.niveauSecurite = 1" + " GROUP BY produits.topiaId, silo"),
        PRCENT_SILO_NIV2(SILO_REQUEST_COUNT + " AND silo.niveauSecurite = 2" + " GROUP BY produits.topiaId, silo"),
        PRCENT_SILO_NIV3(SILO_REQUEST_COUNT + " AND silo.niveauSecurite = 3" + " GROUP BY produits.topiaId, silo"),
        PRCENT_SILO_NIV4(SILO_REQUEST_COUNT + " AND silo.niveauSecurite = 4" + " GROUP BY produits.topiaId, silo"),
        PRCENT_SILO_WITH_ACCESS(SILO_REQUEST_COUNT + " AND silo.accesSilo IS NOT NULL" + " GROUP BY produits.topiaId, silo"),
        PRCENT_SILO_WITH_EQUIPEMENT(SILO_REQUEST_COUNT + " AND silo.modeChargement IS NOT NULL" + " GROUP BY produits.topiaId, silo");

        protected String request;

        private Indicator(String request) {
            this.request = request;
        }

        public String getRequest() {
            return this.request;
        }
    }
}

