/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra;

import com.cybelia.sandra.EmailHelper;
import com.cybelia.sandra.SandraConfig;
import com.cybelia.sandra.SandraDAOHelper;
import com.cybelia.sandra.SandraHelper;
import com.cybelia.sandra.SandraSchedulerConfigHelper;
import com.cybelia.sandra.UserIndicateursStats;
import com.cybelia.sandra.entities.Camion;
import com.cybelia.sandra.entities.Eleveur;
import com.cybelia.sandra.entities.Etape;
import com.cybelia.sandra.entities.InfoAccess;
import com.cybelia.sandra.entities.Tour;
import com.cybelia.sandra.entities.UserIndicateurs;
import com.cybelia.sandra.entities.UserIndicateursDAO;
import com.cybelia.sandra.entities.Usine;
import com.cybelia.sandra.entities.notifier.Queue;
import com.cybelia.sandra.entities.notifier.QueueDAO;
import com.cybelia.sandra.entities.trace.CompteursKm;
import com.cybelia.sandra.entities.trace.CompteursKmDAO;
import com.cybelia.sandra.entities.trace.SuiviTour;
import com.cybelia.sandra.entities.trace.SuiviTourDAO;
import com.cybelia.sandra.entities.trace.SuiviUsine;
import com.cybelia.sandra.entities.trace.SuiviUsineDAO;
import com.cybelia.sandra.ibu.IbuFileComparator;
import com.cybelia.sandra.ibu.MigrationContext;
import com.cybelia.sandra.ibu.csv.bean.Ibu;
import com.cybelia.sandra.ibu.csv.reader.CSVReaderIbu;
import com.cybelia.sandra.notifier.SandraNotifier;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileExistsException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.taas.entities.TaasUser;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.FileUtil;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.StatefulJob;

public class SchedulerJobFactory {
    public static final Log log = LogFactory.getLog(SchedulerJobFactory.class);
    public static final Comparator<Camion> CAMION_CODE_COMPARATOR = new Comparator<Camion>(){

        @Override
        public int compare(Camion c1, Camion c2) {
            return c1.getCode().compareTo(c2.getCode());
        }
    };
    public static final Comparator<TaasUser> USER_CODE_COMPARATOR = new Comparator<TaasUser>(){

        @Override
        public int compare(TaasUser u1, TaasUser u2) {
            return u1.getLogin().compareTo(u2.getLogin());
        }
    };

    protected static TopiaContext beginTransaction() throws TopiaException, IOException {
        TopiaContext ibuRootContext = SandraSchedulerConfigHelper.getSchedulerRootContext();
        return ibuRootContext.beginTransaction();
    }

    protected static void closeTransaction(TopiaContext transaction) throws TopiaException {
        if (transaction != null && !transaction.isClosed()) {
            transaction.commitTransaction();
            transaction.closeContext();
        }
    }

    protected static List<String[]> sortDataByCodeCamion(TopiaContext transaction, List<String[]> datas) throws TopiaException {
        ArrayList<String[]> datasTrie = new ArrayList<String[]>();
        ArrayList<TopiaEntity> camions = new ArrayList<TopiaEntity>();
        for (String[] stringArray : datas) {
            String camionTopiaId = stringArray[3];
            camions.add(SandraDAOHelper.getCamionDAO((TopiaContext)transaction).findByTopiaId(camionTopiaId));
        }
        Collections.sort(camions, CAMION_CODE_COMPARATOR);
        for (Camion camion : camions) {
            ArrayList<String[]> datasCopy = new ArrayList<String[]>(datas);
            for (String[] data : datasCopy) {
                String camionTopiaId = data[3];
                if (!camionTopiaId.equals(camion.getTopiaId())) continue;
                datasTrie.add(data);
                datas.remove(data);
            }
        }
        return datasTrie;
    }

    protected static Map<TaasUser, UserIndicateurs> getAllUserIndicateur(TopiaContext context, List<TaasUser> users) throws TopiaException {
        log.info((Object)"getAllUserIndicateur");
        HashMap<TaasUser, UserIndicateurs> result = new HashMap<TaasUser, UserIndicateurs>();
        UserIndicateursDAO userIndicateursDAO = SandraDAOHelper.getUserIndicateursDAO((TopiaContext)context);
        for (TaasUser user : users) {
            UserIndicateurs userIndicateurs = userIndicateursDAO.findByTaasUser(user);
            result.put(user, userIndicateurs);
        }
        return result;
    }

    protected static ListMultimap<UserIndicateurs, Integer> getAllStats(TopiaContext context, List<Camion> camions) throws TopiaException {
        log.info((Object)"getAllStats");
        ArrayListMultimap result = ArrayListMultimap.create();
        int allCount = camions.size();
        int cnt = 0;
        for (Camion camion : camions) {
            log.info((Object)("Getting all stats for " + camion.getUserIndicateurs().getTaasUser().getLogin() + " : " + ++cnt + "/" + allCount));
            UserIndicateursStats stats = new UserIndicateursStats(camion);
            List<Integer> value = stats.aquireDatas(context);
            if (value == null) continue;
            result.putAll((Object)camion.getUserIndicateurs(), value);
        }
        log.info((Object)"End of getAllStats");
        return result;
    }

    protected static List<Camion> getAllCamionLessSynchDate(TopiaContext context, Date dateLess, String ... orderBy) throws TopiaException {
        return SchedulerJobFactory.getAllCamionLessSynchDate(context, dateLess, false, orderBy);
    }

    protected static List<Camion> getAllCamionLessSynchDate(TopiaContext context, Date dateLess, boolean inverse, String ... orderBy) throws TopiaException {
        log.info((Object)"getAllCamionLessSynchDate");
        String hql = "SELECT camion FROM " + Camion.class.getName() + " camion" + " JOIN camion.userIndicateurs AS userIndicateurs" + " WHERE camion.actif =" + true;
        hql = inverse ? hql + " AND userIndicateurs.lastSynch < :dateLess" : hql + " AND userIndicateurs.lastSynch >= :dateLess";
        if (orderBy != null && orderBy.length > 0) {
            hql = hql + " ORDER BY " + StringUtils.join((Object[])orderBy, (String)",");
        }
        List camions = context.findAll(hql, new Object[]{"dateLess", dateLess});
        log.info((Object)("Total camions founds " + camions.size()));
        return camions;
    }

    public static class UpdateCompteursKm
    extends SchedulerJob {
        public static final String PATTERN = "sandra.scheduler.updateCompteursKm";

        @Override
        public void doAction(TopiaContext transaction) throws Exception {
            Tour previousTour;
            SuiviTour previousSuiviTour;
            SuiviTourDAO suiviTourDAO = SandraDAOHelper.getSuiviTourDAO((TopiaContext)transaction);
            CompteursKmDAO compteursKmDAO = SandraDAOHelper.getCompteursKmDAO((TopiaContext)transaction);
            SuiviUsineDAO suiviUsineDAO = SandraDAOHelper.getSuiviUsineDAO((TopiaContext)transaction);
            String query = "SELECT cpkm FROM " + CompteursKm.class.getName() + " cpkm " + "WHERE cpkm.tour is null " + "AND cpkm.dateSortie <= :now " + "AND cpkm.compteur > " + "(SELECT COALESCE(max(ref.compteur), 0) " + "FROM " + CompteursKm.class.getName() + " ref " + "WHERE ref.camion = cpkm.camion " + "AND ref.tour IS NOT NULL) " + "AND extract (year from cpkm.dateSortie) != 1970 " + "AND extract (year from cpkm.dateEntree) != 1970 " + "ORDER BY cpkm.camion ASC, cpkm.compteur DESC";
            List results = transaction.findAll(query, new Object[]{"now", new Date(new Date().getTime() - 0x6DDD00L)});
            CompteursKm nextCompteurKm = null;
            CompteursKm previousCompteurKm = null;
            if (!results.isEmpty()) {
                CompteursKm lastCompteurKm = (CompteursKm)results.get(results.size() - 1);
                Camion camion = lastCompteurKm.getCamion();
                int kmArrivee = lastCompteurKm.getCompteur();
                previousCompteurKm = this.getPreviousCompteurKm(transaction, camion, kmArrivee);
            }
            for (CompteursKm compteurKm : results) {
                List suiviUsines;
                boolean used;
                Camion camion = compteurKm.getCamion();
                Usine usine = compteurKm.getUsine();
                Date dateEntree = compteurKm.getDateEntree();
                Date dateSortie = compteurKm.getDateSortie();
                int kmDepart = compteurKm.getCompteur();
                Tour tour = this.getTourByDateChargement(transaction, camion, usine, dateEntree, dateSortie);
                if (tour == null && (tour = this.getTourByNextSuiviEtape(transaction, camion, usine, dateSortie)) == null) {
                    tour = this.getTourByNextCrEtape(transaction, camion, usine, dateSortie);
                }
                if (tour == null || (used = this.isTourUsed(transaction, tour))) continue;
                log.info((Object)("Found tour (" + tour.getTopiaId() + ") for " + camion.getSociete().getCode() + "-" + camion.getCode() + " at " + kmDepart));
                SuiviTour suiviTour = tour.getSuiviTour();
                if (suiviTour != null && (suiviUsines = suiviTour.getSuiviUsines()) != null && !suiviUsines.isEmpty()) {
                    SuiviUsine suiviUsine = (SuiviUsine)suiviUsines.get(0);
                    suiviUsine.setDateEntree(dateEntree);
                    suiviUsine.setDateSortie(dateSortie);
                    suiviUsineDAO.update((TopiaEntity)suiviUsine);
                }
                if (nextCompteurKm != null) {
                    if (suiviTour != null) {
                        int kmArrivee = nextCompteurKm.getCompteur();
                        suiviTour.setKmDepart(kmDepart);
                        suiviTour.setKmArrivee(kmArrivee);
                        suiviTourDAO.update((TopiaEntity)suiviTour);
                        SandraHelper.addSuiviTourCSV(tour, suiviTour);
                        compteurKm.setTour(tour);
                        compteursKmDAO.update((TopiaEntity)compteurKm);
                        log.info((Object)("Update tour (" + tour.getTopiaId() + ") for " + camion.getSociete().getCode() + "-" + camion.getCode() + " at " + kmArrivee));
                    } else {
                        log.warn((Object)("SuiviTour not found (" + tour.getTopiaId() + ") for " + camion.getSociete().getCode() + "-" + camion.getCode() + " at " + kmDepart));
                    }
                }
                nextCompteurKm = compteurKm;
            }
            if (previousCompteurKm != null && (previousSuiviTour = (previousTour = previousCompteurKm.getTour()).getSuiviTour()) != null) {
                int kmDepart = previousCompteurKm.getCompteur();
                int kmArrivee = nextCompteurKm.getCompteur();
                previousSuiviTour.setKmDepart(kmDepart);
                previousSuiviTour.setKmArrivee(kmArrivee);
                suiviTourDAO.update((TopiaEntity)previousSuiviTour);
                SandraHelper.addSuiviTourCSV(previousTour, previousSuiviTour);
            }
        }

        public Tour getTourByDateChargement(TopiaContext transaction, Camion camion, Usine usine, Date dateEntree, Date dateSortie) throws TopiaException {
            String query = "SELECT tour FROM " + Tour.class.getName() + " tour " + "JOIN tour.suiviTour AS suiviTour " + "JOIN suiviTour.suiviUsines AS suiviUsines " + "JOIN tour.etapes AS etape " + "JOIN etape.produits AS produit " + "WHERE tour.camion = :camion " + "AND (suiviUsines.usine = :usine " + "OR produit.usine = :usine) " + "AND produit.infoChargement.quantite > 0 " + "AND :dateEntree <= COALESCE(tour.dateChargementReel, tour.notificationRetourUsine, suiviUsines.dateChargementPrevue, tour.dateChargementInitiale) " + "AND :dateSortie >= COALESCE(tour.dateChargementReel, tour.notificationRetourUsine, suiviUsines.dateChargementPrevue, tour.dateChargementInitiale) ";
            List results = transaction.find(query, 0, 0, new Object[]{"camion", camion, "usine", usine, "dateEntree", new Date(dateEntree.getTime() - 1800000L), "dateSortie", new Date(dateSortie.getTime() + 1800000L)});
            if (results.isEmpty()) {
                return null;
            }
            return (Tour)results.get(0);
        }

        public Tour getTourByNextSuiviEtape(TopiaContext transaction, Camion camion, Usine usine, Date dateSortie) throws TopiaException {
            String query = "SELECT tour FROM " + Tour.class.getName() + " tour " + "JOIN tour.suiviTour AS suiviTour " + "JOIN suiviTour.suiviUsines AS suiviUsines " + "JOIN suiviTour.suiviEtapes AS suiviEtapes " + "JOIN suiviEtapes.etape AS etape " + "JOIN etape.produits AS produit " + "WHERE tour.camion = :camion " + "AND (suiviUsines.usine = :usine " + "OR produit.usine = :usine) " + "AND :date < suiviEtapes.dateEntree " + "ORDER BY suiviEtapes.dateEntree ASC";
            List results = transaction.find(query, 0, 0, new Object[]{"camion", camion, "usine", usine, "date", dateSortie});
            if (results.isEmpty()) {
                return null;
            }
            return (Tour)results.get(0);
        }

        public Tour getTourByNextCrEtape(TopiaContext transaction, Camion camion, Usine usine, Date dateSortie) throws TopiaException {
            String query = "SELECT tour FROM " + Tour.class.getName() + " tour " + "JOIN tour.suiviTour AS suiviTour " + "JOIN suiviTour.suiviUsines AS suiviUsines " + "JOIN suiviTour.suiviEtapes AS suiviEtapes " + "JOIN suiviEtapes.etape AS etape " + "JOIN etape.produits AS produit " + "WHERE tour.camion = :camion " + "AND (suiviUsines.usine = :usine " + "OR produit.usine = :usine) " + "AND :date < suiviEtapes.cREtape.etapeHeureLivraison " + "ORDER BY suiviEtapes.cREtape.etapeHeureLivraison ASC";
            List results = transaction.find(query, 0, 0, new Object[]{"camion", camion, "usine", usine, "date", dateSortie});
            if (results.isEmpty()) {
                return null;
            }
            return (Tour)results.get(0);
        }

        public boolean isTourUsed(TopiaContext transaction, Tour tour) throws TopiaException {
            String query = "SELECT cpkm FROM " + CompteursKm.class.getName() + " cpkm WHERE  cpkm.tour = :tour";
            List results = transaction.find(query, 0, 0, new Object[]{"tour", tour});
            return !results.isEmpty();
        }

        public CompteursKm getPreviousCompteurKm(TopiaContext transaction, Camion camion, int compteur) throws TopiaException {
            String query = "SELECT cpkm FROM " + CompteursKm.class.getName() + " cpkm " + "WHERE cpkm.camion = :camion " + "AND cpkm.tour IS NOT NULL " + "AND cpkm.compteur < :compteur " + "ORDER BY cpkm.compteur DESC";
            List results = transaction.find(query, 0, 0, new Object[]{"camion", camion, "compteur", compteur});
            if (results.isEmpty()) {
                return null;
            }
            return (CompteursKm)results.get(0);
        }

        @Override
        public String getPattern() {
            return PATTERN;
        }
    }

    public static class IbuVerifier
    extends SchedulerJob {
        public static final String PATTERN = "sandra.scheduler.ibuVerifier";

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doAction(TopiaContext transaction) throws Exception {
            ApplicationConfig config = SandraConfig.getConfig();
            String ibuDonePath = SandraSchedulerConfigHelper.getIbuDonePath(config);
            String ibuOldPath = SandraSchedulerConfigHelper.getIbuOldPath(config);
            String ibuPatternFile = SandraSchedulerConfigHelper.getPatternFile(config);
            File ibuDonePathFile = new File(ibuDonePath);
            List files = FileUtil.find((File)ibuDonePathFile, (String)ibuPatternFile, (boolean)false);
            Collections.sort(files, new IbuFileComparator(ibuPatternFile));
            ArrayListMultimap commandeInError = ArrayListMultimap.create();
            boolean inError = false;
            for (File f : files) {
                String fileName = f.getName();
                String old = ibuOldPath + File.separator + fileName;
                File oldFile = new File(old);
                try {
                    FileUtils.moveFile((File)f, (File)oldFile);
                }
                catch (FileExistsException eee) {
                    log.warn((Object)("File '" + fileName + "' is already in olds"));
                    FileUtils.deleteQuietly((File)oldFile);
                    FileUtils.moveFile((File)f, (File)oldFile);
                }
                boolean fileInError = false;
                try {
                    log.info((Object)("Verifing : " + fileName));
                    FileReader fileReader = new FileReader(oldFile);
                    CSVReaderIbu csvReaderIbu = new CSVReaderIbu();
                    List ibus = csvReaderIbu.parse(new MigrationContext(), fileReader);
                    for (Ibu ibu : ibus) {
                        String value;
                        if (ibu == null) continue;
                        String commandeCode = ibu.getCommandeCode();
                        int produitOrdreChargement = ibu.getProduitOrdreChargement();
                        int produitOrdre = ibu.getProduitOrdre();
                        Date tourDateLivraison = ibu.getTourDateLivraison();
                        String camionCode = ibu.getCamionCode();
                        int tourNumero = ibu.getTourNumero();
                        String usineCode = ibu.getUsineCode();
                        String hql = "SELECT count(etape) FROM " + Tour.class.getName() + " tour " + "JOIN tour.camion AS camion " + "JOIN tour.etapes AS etape " + "JOIN etape.produits AS produit " + "JOIN produit.commande AS commande " + "JOIN produit.usine AS usine WHERE " + "commande.numero = :commandeCode AND " + "etape.ordre = :produitOrdreChargement AND " + "produit.ordre = :produitOrdre AND " + "tour.dateLivraison = :tourDateLivraison AND " + "camion.code = :camionCode AND " + "tour.numero = :tourNumero AND " + "usine.code = :usineCode";
                        Object[] args = new Object[]{"commandeCode", commandeCode, "produitOrdreChargement", produitOrdreChargement, "produitOrdre", produitOrdre, "tourDateLivraison", tourDateLivraison, "camionCode", camionCode, "tourNumero", tourNumero, "usineCode", usineCode};
                        List result = transaction.findAll(hql, args);
                        Object o = result.get(0);
                        int etapesFound = Integer.valueOf("" + o);
                        if (etapesFound != 0) continue;
                        log.warn((Object)("Commande " + commandeCode + " is in error on file : " + fileName));
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("query : " + hql));
                            log.debug((Object)("Args : " + Arrays.toString(args)));
                        }
                        if (!commandeInError.containsValue((Object)(value = ibu.getSocieteCode() + " - " + commandeCode))) {
                            commandeInError.put((Object)fileName, (Object)value);
                        }
                        inError = true;
                        fileInError = true;
                    }
                }
                catch (Exception eee) {
                    log.error((Object)("Failed to verify : " + fileName), (Throwable)eee);
                }
                finally {
                    if (!fileInError) continue;
                    String ibuVerifierErrorPath = SandraSchedulerConfigHelper.getIbuVerifierErrorPath(config);
                    String errorPath = ibuVerifierErrorPath + File.separator + fileName + "_verifier.err";
                    try {
                        FileUtils.moveFile((File)oldFile, (File)new File(errorPath));
                    }
                    catch (Exception eee) {
                        log.error((Object)("Failed to move '" + oldFile.getPath() + "' to '" + errorPath));
                        FileUtils.deleteQuietly((File)oldFile);
                    }
                }
            }
            if (inError) {
                String filesInErrorForNotifier = SandraHelper.convertToListForNotifier(commandeInError.keySet());
                String commandeInErrorForNotifier = SandraHelper.convertToListOfListForNotifier(commandeInError);
                log.info((Object)("Mail will be send because some files are in error : " + filesInErrorForNotifier));
                new SandraNotifier().notifyEvent("commandesInError", SandraSchedulerConfigHelper.getSandraName(config), filesInErrorForNotifier, commandeInErrorForNotifier);
            }
        }

        @Override
        public String getPattern() {
            return PATTERN;
        }
    }

    public static class FindDangerousBreeder
    extends SchedulerJob {
        public static final String PATTERN = "sandra.scheduler.findDangerousBreeder";

        @Override
        public void doAction(TopiaContext transaction) throws Exception {
            String hql = "SELECT DISTINCT eleveur.topiaId FROM " + Eleveur.class.getName() + " eleveur, " + InfoAccess.class.getName() + " access WHERE access.niveauSecurite > 1 " + "AND (access.eleveur = eleveur.topiaId OR access.topiaId = eleveur.accesEleveur)" + " GROUP BY access.niveauSecurite, eleveur.topiaId" + " ORDER BY eleveur.topiaId";
            List dangerousBreedersAndSilos = transaction.findAll(hql, new Object[0]);
            String dangerousBreedersAndSilosString = SandraHelper.convertToListForNotifier(dangerousBreedersAndSilos);
            ApplicationConfig config = SandraConfig.getConfig();
            new SandraNotifier().notifyEvent("dangerousBreeder", SandraSchedulerConfigHelper.getSandraName(config), SandraSchedulerConfigHelper.getSandraUrl(config), dangerousBreedersAndSilosString);
        }

        @Override
        public String getPattern() {
            return PATTERN;
        }
    }

    public static class SendStatsNotification
    extends SchedulerJob {
        public static final String PATTERN = "sandra.scheduler.sendStatsNotification";
        public static final String CSV_HEADER = "Camion;Clients livr\u00e9s;G\u00e9opositionn\u00e9s;G\u00e9opositionn\u00e9s et verrouill\u00e9s;Niveau de s\u00e9curit\u00e9 non renseign\u00e9;Niveau de s\u00e9curit\u00e9 vert;Niveau de s\u00e9curit\u00e9 orange;Niveau de s\u00e9curit\u00e9 rouge;Niveau de s\u00e9curit\u00e9 noir;Renseign\u00e9 pour acc\u00e8s;Renseign\u00e9 pour \u00e9quipement;Silo livr\u00e9s;Silo g\u00e9opositionn\u00e9s;Silo g\u00e9opositionn\u00e9s et verrouill\u00e9s;Silo niveau de s\u00e9curit\u00e9 non renseign\u00e9;Silo niveau de s\u00e9curit\u00e9 vert;Silo niveau de s\u00e9curit\u00e9 orange;Silo niveau de s\u00e9curit\u00e9 rouge;Silo niveau de s\u00e9curit\u00e9 noir;Silo renseign\u00e9 pour acc\u00e8s;Silo renseign\u00e9 pour \u00e9quipement;Derni\u00e8re synchro en wifi;Synchros en automatique;Notifications;Synchro compl\u00e8te en gprs;Maj de coord GPS;Maj de niveau de s\u00e9curit\u00e9;Maj r\u00e9alis\u00e9es";

        @Override
        public void doAction(TopiaContext transaction) throws Exception {
            Date dateLessOneMonth = DateUtils.addMonths((Date)new Date(), (int)-1);
            List<Camion> allCamionLessSynchDate = SchedulerJobFactory.getAllCamionLessSynchDate(transaction, dateLessOneMonth, false, "societe", "code");
            log.info((Object)("allCamionLessNoTourFromDate size : " + allCamionLessSynchDate.size()));
            ListMultimap<UserIndicateurs, Integer> stats = SchedulerJobFactory.getAllStats(transaction, allCamionLessSynchDate);
            log.info((Object)("stats size : " + stats.size()));
            StringBuilder builder = new StringBuilder();
            builder.append(CSV_HEADER).append("\n");
            for (UserIndicateurs userIndicateurs : stats.keySet()) {
                builder.append(userIndicateurs.getTaasUser().getLogin()).append(';');
                List integers = stats.get((Object)userIndicateurs);
                builder.append(StringUtils.join((Iterable)integers, (char)';'));
                SimpleDateFormat dateLivraisonPatern = new SimpleDateFormat("dd/MM/yyyy");
                Date lastSynch = userIndicateurs.getLastSynch();
                String lastSynchAsString = "jamais";
                if (lastSynch != null) {
                    lastSynchAsString = dateLivraisonPatern.format(lastSynch);
                }
                builder.append(';');
                builder.append(lastSynchAsString);
                builder.append(';');
                builder.append(userIndicateurs.getNbSynchAuto());
                builder.append(';');
                builder.append(userIndicateurs.getNbNotifs());
                builder.append(';');
                builder.append(userIndicateurs.getNbSynchGPRS());
                builder.append(';');
                builder.append(userIndicateurs.getNbGpsMaj());
                builder.append(';');
                builder.append(userIndicateurs.getNbSecuMaj());
                builder.append(';');
                builder.append(userIndicateurs.getNbMaj());
                builder.append("\n");
            }
            ApplicationConfig config = SandraConfig.getConfig();
            new SandraNotifier().notifyEvent("userIndicatorStats", SandraSchedulerConfigHelper.getSandraName(config), SandraSchedulerConfigHelper.getSandraUrl(config), builder.toString());
        }

        @Override
        public String getPattern() {
            return PATTERN;
        }
    }

    public static class RazNumberOfConnection
    extends SchedulerJob {
        public static final String PATTERN = "sandra.scheduler.RAZNumberOfConnection";

        @Override
        public void doAction(TopiaContext transaction) throws Exception {
            log.info((Object)"RAZNumberOfConnection");
            new SendStatsNotification().doAction(transaction);
            StringBuilder hqlUSerIndicator = new StringBuilder();
            hqlUSerIndicator.append("UPDATE ");
            hqlUSerIndicator.append(UserIndicateurs.class.getName());
            hqlUSerIndicator.append(" SET ");
            hqlUSerIndicator.append("nbMaj");
            hqlUSerIndicator.append("=0, ");
            hqlUSerIndicator.append("nbGpsMaj");
            hqlUSerIndicator.append("=0, ");
            hqlUSerIndicator.append("nbSecuMaj");
            hqlUSerIndicator.append("=0, ");
            hqlUSerIndicator.append("nbSynchGPRS");
            hqlUSerIndicator.append("=0, ");
            hqlUSerIndicator.append("nbSynchWifi");
            hqlUSerIndicator.append("=0, ");
            hqlUSerIndicator.append("nbSynchKo");
            hqlUSerIndicator.append("=0, ");
            hqlUSerIndicator.append("nbSynchAuto");
            hqlUSerIndicator.append("=0, ");
            hqlUSerIndicator.append("nbNotifs");
            hqlUSerIndicator.append("=0, ");
            hqlUSerIndicator.append("nbOctetsReceivedGPRS");
            hqlUSerIndicator.append("=0, ");
            hqlUSerIndicator.append("nbOctetsSendGPRS");
            hqlUSerIndicator.append("=0, ");
            hqlUSerIndicator.append("nbOctetsReceivedWifi");
            hqlUSerIndicator.append("=0, ");
            hqlUSerIndicator.append("nbOctetsSendWifi");
            hqlUSerIndicator.append("=0");
            int result = transaction.execute(hqlUSerIndicator.toString(), new Object[0]);
            log.info((Object)(result + " UserIndicateurs raz"));
            StringBuilder hqlUser = new StringBuilder();
            hqlUser.append("UPDATE ");
            hqlUser.append(TaasUser.class.getName());
            hqlUser.append(" SET ");
            hqlUser.append("numberOfConnection");
            hqlUser.append("=0");
            result = transaction.execute(hqlUser.toString(), new Object[0]);
            log.info((Object)(result + " user raz"));
        }

        @Override
        public String getPattern() {
            return PATTERN;
        }
    }

    public static class CleanUpNotification
    extends SchedulerJob {
        public static final String PATTERN = "sandra.scheduler.cleanup";

        @Override
        public void doAction(TopiaContext transaction) throws Exception {
            QueueDAO queueDAO = SandraDAOHelper.getQueueDAO((TopiaContext)transaction);
            List queues = queueDAO.findAll();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Deleting " + queues.size() + " queues entry"));
            }
            for (Queue q : queues) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("deleting queue : " + q.getTopiaId()));
                }
                queueDAO.delete((TopiaEntity)q);
            }
        }

        @Override
        public String getPattern() {
            return PATTERN;
        }
    }

    public static class NotLockedGPSVerifier
    extends SchedulerJob {
        public static final String PATTERN = "sandra.scheduler.notLockedCoordGPS";

        @Override
        public void doAction(TopiaContext transaction) throws Exception {
            log.info((Object)"getAllEleveurWhithNotLockedGPS");
            ArrayList<String[]> datas = new ArrayList<String[]>();
            String hql = "select eleveur from " + Eleveur.class.getName() + " eleveur" + " WHERE tomtomgps IS NOT NULL AND nbtomtomgpsmodif = 0";
            List eleveurs = transaction.findAll(hql, new Object[0]);
            hql = "SELECT etape.topiaId, etape.eleveur.topiaId, etape.tour.topiaId, tour.camion.topiaId FROM " + Tour.class.getName() + " tour, " + Etape.class.getName() + " etape, " + Camion.class.getName() + " camion" + " WHERE tour = etape.tour" + " AND tour.camion = camion" + " AND etape.eleveur = :eleveur" + " AND camion.code != 'GUI'" + " AND tour.dateLivraison >= :date" + " GROUP BY camion.code, etape, etape.eleveur.topiaId, etape.tour.topiaId," + " tour.camion.topiaId, tour.camion.topiaId, tour.dateLivraison" + " ORDER BY camion.code, etape.eleveur.topiaId, tour.dateLivraison DESC";
            for (Eleveur eleveur : eleveurs) {
                List result = transaction.find(hql, 0, 0, new Object[]{"eleveur", eleveur, "date", SandraHelper.getLastWeekDate()});
                if (result.isEmpty()) continue;
                datas.add(SandraHelper.convertToStringArray((Object[])result.get(0)));
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Found " + datas.size() + " eleveurs with not locked GPS"));
            }
            List<String[]> eleveurGPSButNotLocked = SchedulerJobFactory.sortDataByCodeCamion(transaction, datas);
            log.info((Object)("Sending coordGPSExistingButNotLocked : " + eleveurGPSButNotLocked.size()));
            if (!eleveurGPSButNotLocked.isEmpty()) {
                EmailHelper.sendNotification("coordGPSExistingButNotLocked", eleveurGPSButNotLocked);
            }
        }

        @Override
        public String getPattern() {
            return PATTERN;
        }
    }

    public static class NoCoordGPSVerfier
    extends SchedulerJob {
        public static final String PATTERN = "sandra.scheduler.findnocoordgps";

        @Override
        public void doAction(TopiaContext transaction) throws Exception {
            log.info((Object)"getAllEleveurWhithNoGPS");
            ArrayList<String[]> datas = new ArrayList<String[]>();
            String hql = "SELECT eleveur FROM " + Eleveur.class.getName() + " eleveur" + " WHERE tomtomgps IS null";
            List eleveurs = transaction.findAll(hql, new Object[0]);
            hql = "SELECT etape.topiaId, etape.eleveur.topiaId, etape.tour.topiaId, tour.camion.topiaId FROM " + Tour.class.getName() + " tour, " + Etape.class.getName() + " etape, " + Camion.class.getName() + " camion" + " WHERE tour = etape.tour" + " AND tour.camion = camion" + " AND etape.eleveur = :eleveur" + " AND camion.code != 'GUI'" + " AND tour.dateLivraison >= :date" + " GROUP BY camion.code, etape.topiaId, etape.eleveur.topiaId," + " etape.tour.topiaId, tour.camion.topiaId, tour.dateLivraison" + " ORDER BY camion.code, etape.eleveur.topiaId, tour.dateLivraison DESC";
            for (Eleveur eleveur : eleveurs) {
                List result = transaction.find(hql, 0, 0, new Object[]{"eleveur", eleveur, "date", SandraHelper.getLastWeekDate()});
                if (result.isEmpty()) continue;
                datas.add(SandraHelper.convertToStringArray((Object[])result.get(0)));
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Found " + datas.size() + " eleveurs with no GPS"));
            }
            List<String[]> eleveurNoGPS = SchedulerJobFactory.sortDataByCodeCamion(transaction, datas);
            log.info((Object)("Sending noCoordGPS : " + eleveurNoGPS.size()));
            if (!eleveurNoGPS.isEmpty()) {
                EmailHelper.sendNotification("noCoordGPS", eleveurNoGPS);
            }
        }

        @Override
        public String getPattern() {
            return PATTERN;
        }
    }

    public static class FindUnconnectedCamion
    extends SchedulerJob {
        public static final String PATTERN = "sandra.scheduler.unconnectedcamion";

        @Override
        public void doAction(TopiaContext transaction) throws Exception {
            log.info((Object)"findUnconnectedCamion");
            Date now = new Date();
            Calendar cLess3 = Calendar.getInstance();
            cLess3.setTime(now);
            cLess3.add(6, -3);
            List<Camion> camions = SchedulerJobFactory.getAllCamionLessSynchDate(transaction, cLess3.getTime(), true, new String[0]);
            if (!camions.isEmpty()) {
                Collections.sort(camions, CAMION_CODE_COMPARATOR);
                String camionUnconnectedString = SandraHelper.convertEntitiesToListForNotifier(camions);
                new SandraNotifier().notifyEvent("unconnectedCamion", SandraSchedulerConfigHelper.getSandraName(SandraConfig.getConfig()), SandraSchedulerConfigHelper.getSandraUrl(SandraConfig.getConfig()), camionUnconnectedString);
            } else {
                log.warn((Object)"No camion connected last 3 days, abording sending notification");
            }
        }

        @Override
        public String getPattern() {
            return PATTERN;
        }
    }

    public static abstract class SchedulerJob
    implements StatefulJob {
        public abstract void doAction(TopiaContext var1) throws Exception;

        public abstract String getPattern();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(JobExecutionContext context) throws JobExecutionException {
            TopiaContext transaction = null;
            try {
                transaction = SchedulerJobFactory.beginTransaction();
                this.doAction(transaction);
            }
            catch (Exception eee) {
                log.error((Object)("Failed to execute scheduler " + I18n._((String)this.getPattern(), (Object[])new Object[0])), (Throwable)eee);
            }
            finally {
                try {
                    SchedulerJobFactory.closeTransaction(transaction);
                }
                catch (TopiaException eee) {
                    log.error((Object)"Failed to close transaction", (Throwable)eee);
                }
            }
        }
    }

    public static enum SchedulerJobClass {
        FIND_UNCONNECTED_CAMION(FindUnconnectedCamion.class, "sandra.scheduler.unconnectedcamion"),
        NO_COORD_GPS_VERIFIER(NoCoordGPSVerfier.class, "sandra.scheduler.findnocoordgps"),
        NO_LOCKED_GPS_VERIFIER(NotLockedGPSVerifier.class, "sandra.scheduler.notLockedCoordGPS"),
        CLEAN_UP_NOTIFICATION(CleanUpNotification.class, "sandra.scheduler.cleanup"),
        RAZ_NUMBER_OF_CONNECTION(RazNumberOfConnection.class, "sandra.scheduler.RAZNumberOfConnection"),
        SEND_STATS_NOTIFICATION(SendStatsNotification.class, "sandra.scheduler.sendStatsNotification"),
        FIND_DANGEROUS_BREEDER(FindDangerousBreeder.class, "sandra.scheduler.findDangerousBreeder"),
        IBU_VERIFIER(IbuVerifier.class, "sandra.scheduler.ibuVerifier"),
        UPDATE_COMPTEURS_KM(UpdateCompteursKm.class, "sandra.scheduler.updateCompteursKm");

        protected Class<? extends SchedulerJob> schedulerClass;
        protected String pattern;

        private SchedulerJobClass(Class<? extends SchedulerJob> schedulerClass, String pattern) {
            this.schedulerClass = schedulerClass;
            this.pattern = pattern;
        }

        public Class<? extends SchedulerJob> getSchedulerClass() {
            return this.schedulerClass;
        }

        public String getPattern() {
            return this.pattern;
        }
    }
}

