/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra;

import com.cybelia.sandra.SandraConfig;
import com.cybelia.sandra.SandraDAOHelper;
import com.cybelia.sandra.migration.SandraMigrationCallback;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaContextFactory;
import org.nuiton.topia.TopiaNotFoundException;
import org.nuiton.topia.migration.TopiaMigrationEngine;
import org.nuiton.topia.taas.TaasService;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.StringUtil;
import org.quartz.CronExpression;

public class SandraSchedulerConfigHelper {
    public static final Log log = LogFactory.getLog(SandraSchedulerConfigHelper.class);

    public static String getCSVDir(ApplicationConfig config) {
        return config.getOption(SandraConfig.SandraOption.SANDRA_INJECTION_DIR.key);
    }

    public static String getPatternFile(ApplicationConfig config) {
        return config.getOption(SandraConfig.SandraOption.IBU_PATTERN_FILE.key);
    }

    public static String getIbuPath(ApplicationConfig config) {
        return config.getOption(SandraConfig.SandraOption.IBU_INTEGRATION_PATH.key);
    }

    public static String getIbuErrorPath(ApplicationConfig config) {
        return config.getOption(SandraConfig.SandraOption.IBU_INTEGRATION_ERROR.key);
    }

    public static String getIbuVerifierErrorPath(ApplicationConfig config) {
        return config.getOption(SandraConfig.SandraOption.IBU_INTEGRATION_VERIFIER_ERROR.key);
    }

    public static String getIbuOldPath(ApplicationConfig config) {
        return config.getOption(SandraConfig.SandraOption.IBU_INTEGRATION_OLDS.key);
    }

    public static String getIbuWorkPath(ApplicationConfig config) {
        return config.getOption(SandraConfig.SandraOption.IBU_INTEGRATION_WORK.key);
    }

    public static String getIbuDonePath(ApplicationConfig config) {
        return config.getOption(SandraConfig.SandraOption.IBU_INTEGRATION_DONE.key);
    }

    public static String getSuiviTourPath(ApplicationConfig config) {
        return config.getOption(SandraConfig.SandraOption.SUIVI_TOUR_PATH.key);
    }

    public static String getSandraName(ApplicationConfig config) {
        return config.getOption(SandraConfig.SandraOption.SANDRA_NAME.key);
    }

    public static String getSandraUrl(ApplicationConfig config) {
        return config.getOption(SandraConfig.SandraOption.SANDRA_URL.key);
    }

    public static String getSandraEmailHost(ApplicationConfig config) {
        return config.getOption(SandraConfig.SandraOption.SANDRA_EMAIL_HOST.key);
    }

    public static int getSandraEmailPort(ApplicationConfig config) {
        return config.getOptionAsInt(SandraConfig.SandraOption.SANDRA_EMAIL_PORT.key);
    }

    public static String getSandraEmailTo(ApplicationConfig config) {
        return config.getOption(SandraConfig.SandraOption.SANDRA_EMAIL_TO.key);
    }

    public static String getSandraEmailForm(ApplicationConfig config) {
        return config.getOption(SandraConfig.SandraOption.SANDRA_EMAIL_FROM.key);
    }

    public static Locale getLocale(ApplicationConfig config) {
        return config.getOptionAsLocale(SandraConfig.SandraOption.LOCALE.key);
    }

    protected static Properties getTopiaProperties(ApplicationConfig config) throws IOException {
        return config.getOptionAsProperties(SandraConfig.SandraOption.SANDRA_TOPIA_PROPERTIES.key);
    }

    protected static Set<Class<?>> getSandraImplementationClasses() {
        Class[] sandraImplementationClasses = SandraDAOHelper.getImplementationClasses();
        HashSet sandraImplementationClassesSet = new HashSet(Arrays.asList(sandraImplementationClasses));
        sandraImplementationClassesSet.addAll(Arrays.asList(TaasService.getTaasPersistenceClasses()));
        return sandraImplementationClassesSet;
    }

    protected static Properties addTopiaPersistenceClassesToProperties(Properties topiaProperties, Set<Class<?>> implementationClasses) {
        StringUtil.ToString classToString = new StringUtil.ToString<Class<?>>(){

            public String toString(Class<?> aClass) {
                return aClass.getName();
            }
        };
        topiaProperties.put("topia.persistence.classes", StringUtil.join(implementationClasses, (StringUtil.ToString)classToString, (String)", ", (boolean)true));
        return topiaProperties;
    }

    public static Properties getSchedulerTopiaProperties(ApplicationConfig config) throws IOException {
        Properties topiaProperties = SandraSchedulerConfigHelper.getTopiaProperties(config);
        Set<Class<?>> sandraImplementationClasses = SandraSchedulerConfigHelper.getSandraImplementationClasses();
        Properties properties = SandraSchedulerConfigHelper.addTopiaPersistenceClassesToProperties(topiaProperties, sandraImplementationClasses);
        properties.put("topia.service.migration", TopiaMigrationEngine.class.getName());
        properties.put("topia.service.migration.callback", SandraMigrationCallback.class.getName());
        properties.put("topia.service.migration.showSql", String.valueOf(true));
        properties.put("topia.service.migration.showProgression", String.valueOf(true));
        return properties;
    }

    public static TopiaContext getSchedulerRootContext() throws IOException, TopiaNotFoundException {
        ApplicationConfig config = SandraConfig.getConfig();
        return TopiaContextFactory.getContext((Properties)SandraSchedulerConfigHelper.getSchedulerTopiaProperties(config));
    }

    public static File getTemplateFile(ApplicationConfig config, String name) {
        return new File(SandraSchedulerConfigHelper.getNotifierTemplateDir(config) + File.separator + name + SandraSchedulerConfigHelper.getNotifierTemplateExt(config));
    }

    public static String getNotifierTemplateDir(ApplicationConfig config) {
        return config.getOption(SandraConfig.SandraOption.NOTIFIER_TEMPLATE_DIR.key);
    }

    public static String getNotifierTemplateExt(ApplicationConfig config) {
        return config.getOption(SandraConfig.SandraOption.NOTIFIER_TEMPLATE_EXTENSION.key);
    }

    public static String getNotifPath(ApplicationConfig config) {
        return config.getOption(SandraConfig.SandraOption.NOTIF_PATH.key);
    }

    public static String getCronfromProperies(ApplicationConfig config, String pattern) throws ParseException {
        return config.getOption(pattern + ".cron");
    }

    public static Date getNextDatefromProperies(ApplicationConfig config, String pattern) throws ParseException {
        String expression = SandraSchedulerConfigHelper.getCronfromProperies(config, pattern);
        if (expression == null) {
            log.warn((Object)("No next date found for " + I18n._((String)pattern, (Object[])new Object[0])));
            return null;
        }
        CronExpression cronExpression = new CronExpression(expression);
        Calendar cal = Calendar.getInstance();
        cal.add(12, 1);
        Date next = cronExpression.getNextValidTimeAfter(cal.getTime());
        return next;
    }

    public static String getSecurityPrincipal(ApplicationConfig config) {
        return config.getOption("java.naming.security.principal");
    }

    public static String getSecurityCredentials(ApplicationConfig config) {
        return config.getOption("java.naming.security.credentials");
    }
}

