/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra;

import com.cybelia.sandra.SandraConfig;
import com.cybelia.sandra.SandraDAOHelper;
import com.cybelia.sandra.SandraSchedulerConfigHelper;
import com.cybelia.sandra.entities.ActionSecurite;
import com.cybelia.sandra.entities.ActionSecuriteDAO;
import com.cybelia.sandra.entities.Camion;
import com.cybelia.sandra.entities.Eleveur;
import com.cybelia.sandra.entities.EleveurDAO;
import com.cybelia.sandra.entities.Etape;
import com.cybelia.sandra.entities.EtapeDAO;
import com.cybelia.sandra.entities.InfoAccess;
import com.cybelia.sandra.entities.LigneProduit;
import com.cybelia.sandra.entities.Tour;
import com.cybelia.sandra.entities.UserIndicateurs;
import com.cybelia.sandra.entities.UserIndicateursDAO;
import com.cybelia.sandra.entities.trace.SuiviEtape;
import com.cybelia.sandra.entities.trace.SuiviLigneProduit;
import com.cybelia.sandra.entities.trace.SuiviLigneProduitDAO;
import com.cybelia.sandra.entities.trace.SuiviTour;
import com.cybelia.sandra.entities.trace.SuiviTourDAO;
import com.cybelia.sandra.entities.trace.SuiviUsine;
import com.cybelia.sandra.notifier.SandraNotifier;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImpl;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.taas.entities.TaasUser;
import org.nuiton.util.ApplicationConfig;

public class SandraHelper {
    protected static final Log log = LogFactory.getLog(SandraHelper.class);
    public static final String SUIVI_TOUR_PREFIX = "_";
    public static final String SUIVI_TOUR_EXTENTION = ".txt";

    public static int getDifferenceInMilliseconds(Date beginDate, Date endDate) {
        long begin = beginDate.getTime();
        long end = endDate.getTime();
        return (int)Math.ceil(end - begin);
    }

    public static String[] convertToStringArray(Object[] datas) {
        String[] params = new String[datas.length];
        System.arraycopy(datas, 0, params, 0, datas.length);
        return params;
    }

    public static int pareInt(String s) {
        return s == null || "".equals(s) ? 0 : Integer.parseInt(s);
    }

    public static List<List<String>> reformatData(List<String[]> datas) {
        ArrayList<List<String>> datasResult = new ArrayList<List<String>>();
        ArrayList<String> etapeTopiaIds = new ArrayList<String>();
        ArrayList<String> eleveurTopiaIds = new ArrayList<String>();
        ArrayList<String> tourTopiaIds = new ArrayList<String>();
        ArrayList<String> camionTopiaIds = new ArrayList<String>();
        for (String[] data : datas) {
            etapeTopiaIds.add(data[0]);
            eleveurTopiaIds.add(data[1]);
            tourTopiaIds.add(data[2]);
            camionTopiaIds.add(data[3]);
        }
        datasResult.add(etapeTopiaIds);
        datasResult.add(eleveurTopiaIds);
        datasResult.add(tourTopiaIds);
        datasResult.add(camionTopiaIds);
        return datasResult;
    }

    public static Date getLastWeekDate() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(5, -7);
        return cal.getTime();
    }

    public static String convertEntitiesToListForNotifier(Collection<? extends TopiaEntity> entities) {
        return SandraHelper.convertToListForNotifier(SandraHelper.extractIds(entities));
    }

    public static String convertToListForNotifier(Collection<?> list) {
        return StringUtils.join(list, (String)"&&") + "&&";
    }

    public static String convertToSubListForNotifier(Collection<?> list) {
        return StringUtils.join(list, (String)"##") + "##";
    }

    public static <K, V> String convertToListOfListForNotifier(ListMultimap<K, V> multimap) {
        ArrayList<String> list = new ArrayList<String>();
        for (Object key : multimap.keySet()) {
            List values = multimap.get(key);
            String subList = SandraHelper.convertToSubListForNotifier(values);
            list.add(subList);
        }
        String result = SandraHelper.convertToListForNotifier(list);
        return result;
    }

    public static List<String> extractIds(Collection<? extends TopiaEntity> entities) {
        ArrayList<String> result = new ArrayList<String>();
        for (TopiaEntity topiaEntity : entities) {
            result.add(topiaEntity.getTopiaId());
        }
        return result;
    }

    public static String convertDateToString(Date d) {
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        return c.get(5) + "/" + c.get(2) + "/" + c.get(1) + " \u00e0 " + c.get(11) + " h " + c.get(12);
    }

    public static int getWorstSecurityLevel(Eleveur breeder) {
        return SandraHelper.getWorstInfoAccessSecurityLevel(breeder).getNiveauSecurite();
    }

    public static InfoAccess getWorstInfoAccessSecurityLevel(Eleveur breeder) {
        InfoAccess result = breeder.getAccesEleveur();
        Collection ass = breeder.getActiveAccesSilo();
        int worstSecurityLevel = result.getNiveauSecurite();
        for (InfoAccess as : ass) {
            int siloSecurity;
            if (as == null || worstSecurityLevel >= (siloSecurity = as.getNiveauSecurite())) continue;
            worstSecurityLevel = siloSecurity;
            result = as;
        }
        return result;
    }

    public static UserIndicateurs razUserIndicateurs(UserIndicateurs userIndicateurs) {
        userIndicateurs.setNbMaj(0);
        userIndicateurs.setNbGpsMaj(0);
        userIndicateurs.setNbSecuMaj(0);
        userIndicateurs.setNbSynchGPRS(0);
        userIndicateurs.setNbSynchWifi(0);
        userIndicateurs.setNbSynchKo(0);
        userIndicateurs.setNbNotifs(0);
        userIndicateurs.setNbOctetsReceivedGPRS(0);
        userIndicateurs.setNbOctetsSendGPRS(0);
        userIndicateurs.setNbOctetsReceivedWifi(0);
        userIndicateurs.setNbOctetsSendWifi(0);
        return userIndicateurs;
    }

    public static String addOrder(String alias, String sortCriterion, int sortDirection) {
        return SandraHelper.addOrder(alias, false, sortCriterion, sortDirection);
    }

    public static String addOrder(String alias, boolean isNull, String sortCriterion, int sortDirection) {
        String criteria = alias + "." + sortCriterion;
        if (!isNull) {
            return " ORDER BY " + criteria + " " + (sortDirection == 1 ? "DESC" : "ASC");
        }
        return " ORDER BY CASE WHEN " + criteria + " IS NULL THEN 1 ELSE 0 END, " + criteria + " " + (sortDirection == 1 ? "DESC" : "ASC");
    }

    public static UserIndicateurs createUserIndicateurIfDontExist(TopiaContext transaction, TaasUser user) throws TopiaException {
        UserIndicateursDAO userIndicateursDAO = SandraDAOHelper.getUserIndicateursDAO((TopiaContext)transaction);
        UserIndicateurs userIndicateurs = userIndicateursDAO.findByTaasUser(user);
        if (userIndicateurs == null) {
            userIndicateurs = userIndicateursDAO.createByNaturalId(user);
            userIndicateurs = SandraHelper.razUserIndicateurs(userIndicateurs);
            userIndicateursDAO.update((TopiaEntity)userIndicateurs);
        }
        return userIndicateurs;
    }

    public static List<TaasUser> getAllCamionUser(TopiaContext transaction) throws TopiaException {
        String hql = "SELECT user FROM " + TaasUser.class.getName() + " user" + " JOIN user.principals AS principal WHERE" + " principal.name = 'synchro' AND user.login != 'synchro'";
        List users = transaction.findAll(hql, new Object[0]);
        for (TaasUser user : users) {
            user.getPrincipals().size();
        }
        return users;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSuiviTourCSV(Tour tour, SuiviTour suiviTour) throws IOException {
        if (suiviTour.getKmDepart() <= 0 || suiviTour.getKmArrivee() <= 0) {
            return;
        }
        int kmTotal = suiviTour.getKmTotal();
        if (kmTotal <= 0 || kmTotal > 1000) {
            return;
        }
        ApplicationConfig config = SandraConfig.getConfig();
        String suiviTourPath = SandraSchedulerConfigHelper.getSuiviTourPath(config);
        SimpleDateFormat format = new SimpleDateFormat("yyMMddHHmmss");
        String now = format.format(new Date());
        File file = new File(suiviTourPath + File.separator + tour.getCamion().getSociete().getCode() + SUIVI_TOUR_PREFIX + now + SUIVI_TOUR_EXTENTION);
        Camion camion = tour.getCamion();
        String codeSociete = camion.getSociete().getCode();
        String codeCamion = camion.getCode();
        int numeroTour = tour.getNumero();
        Date dateLivraisonTour = tour.getDateLivraison();
        SimpleDateFormat dateLivraisonPatern = new SimpleDateFormat("dd/MM/yyyy");
        String dateLivraisonAsString = dateLivraisonPatern.format(dateLivraisonTour);
        Date duree = suiviTour.getDuree();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(duree);
        String dureeAsString = "0";
        if (duree != null) {
            float hour = calendar.get(10);
            dureeAsString = new DecimalFormat("00.#0").format(hour += (float)(calendar.get(12) / 60));
        }
        int litresGasoil = suiviTour.getLitresGasoil();
        String lineToWrite = dateLivraisonAsString + ';' + "\"" + codeSociete + "-" + codeCamion + "\"" + ';' + numeroTour + ';' + kmTotal + ';' + dureeAsString + ';' + litresGasoil + "\n";
        OutputStreamWriter writer = null;
        try {
            if (!file.exists()) {
                writer = new FileWriter(file, true);
                writer.write("DAT_LIV;CAM_GROUP;TOU;KM;h_REEL;L_GO\n");
            }
            if (writer == null) {
                writer = new FileWriter(file, true);
            }
            writer.write(lineToWrite);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    public static Collection<InfoAccess> mergeEleveurInfoAccess(Eleveur oldEleveur, Eleveur eleveur) {
        final Map<String, InfoAccess> silos = SandraHelper.extractInfoAccess(eleveur.getAccesSilos());
        Extractor<InfoAccess, Map<String, InfoAccess>> infoAccessMerge = new Extractor<InfoAccess, Map<String, InfoAccess>>(){

            @Override
            public void extract(InfoAccess value) {
                silos.put(value.getNomAcces(), value);
            }

            @Override
            public Map<String, InfoAccess> getResult() {
                return silos;
            }
        };
        for (InfoAccess oldSilo : oldEleveur.getAccesSilos()) {
            infoAccessMerge.extract(oldSilo);
        }
        return ((Map)infoAccessMerge.getResult()).values();
    }

    public static Map<String, InfoAccess> extractInfoAccess(Collection<InfoAccess> silos) {
        SimpleMapExtractor<String, InfoAccess> infoAccessExtractor = new SimpleMapExtractor<String, InfoAccess>(){

            @Override
            protected String getKey(InfoAccess value) {
                return value.getNomAcces();
            }
        };
        if (silos != null) {
            for (InfoAccess silo : silos) {
                infoAccessExtractor.extract(silo);
            }
        }
        return infoAccessExtractor.getResult();
    }

    public static String getLogTour(Tour tour, String additionnal) {
        SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy");
        String formatedDate = null;
        if (tour.getDateLivraison() != null) {
            formatedDate = format.format(tour.getDateLivraison());
        }
        return "tour : topiaId[" + tour.getTopiaId() + "] num[" + tour.getNumero() + "] dateLivraison[" + formatedDate + "] " + additionnal;
    }

    public static String getEleveurTitle(Eleveur eleveur) {
        return SandraHelper.getEleveurTitle(eleveur.getRaisonSociale(), eleveur.getSociete().getCode(), eleveur.getCode(), eleveur.getVille(), eleveur.getCodePostal());
    }

    public static String getEleveurTitle(String raisonSocial, String codeSociete, String codeEleveur, String ville, String codePostal) {
        String title = "";
        String department = SandraHelper.getDepartment(codePostal);
        title = title + raisonSocial + " (" + codeSociete + "-" + codeEleveur + ") " + ville;
        if (department != null) {
            title = title + " (" + department + ")";
        }
        return title;
    }

    public static String getDepartment(Eleveur eleveur) {
        return SandraHelper.getDepartment(eleveur.getCodePostal());
    }

    public static String getDepartment(String codePostal) {
        String department = null;
        if (codePostal != null) {
            if (codePostal.length() == 4) {
                department = "0" + codePostal.substring(0, 1);
            } else if (codePostal.length() == 5) {
                department = codePostal.substring(0, 2);
            }
        }
        return department;
    }

    public static void deleteEtape(TopiaContext transaction, Etape etape) throws TopiaException {
        Tour tour = etape.getTour();
        EtapeDAO etapeDAO = SandraDAOHelper.getEtapeDAO((TopiaContext)transaction);
        SuiviLigneProduitDAO suiviLigneProduitDAO = SandraDAOHelper.getSuiviLigneProduitDAO((TopiaContext)transaction);
        SuiviTour suiviTour = tour.getSuiviTour();
        if (suiviTour != null) {
            for (SuiviEtape suiviEtape : suiviTour.getSuiviEtapes()) {
                suiviEtape.setEtape(null);
            }
            for (SuiviUsine suiviUsine : suiviTour.getSuiviUsines()) {
                for (SuiviLigneProduit suiviLigneProduit : suiviUsine.getSuiviLigneProduit()) {
                    suiviLigneProduit.setLigneProduit(null);
                }
            }
            tour.setSuiviTour(null);
        }
        for (LigneProduit produit : etape.getProduits()) {
            List suiviLigneProduits = suiviLigneProduitDAO.findAllByLigneProduit(produit);
            for (SuiviLigneProduit suiviLigneProduit : suiviLigneProduits) {
                suiviLigneProduit.setLigneProduit(null);
            }
        }
        tour.removeEtapes(etape);
        etapeDAO.delete(etape);
        if (suiviTour != null) {
            SuiviTourDAO suiviTourDAO = SandraDAOHelper.getSuiviTourDAO((TopiaContext)transaction);
            suiviTourDAO.delete(suiviTour);
        }
    }

    public static void checkDuplicateBreeder(TopiaContext transaction, List<Eleveur> eleveurs, String template) throws TopiaException {
        for (Eleveur eleveur : eleveurs) {
            List duplicateEleveurIds = ((TopiaContextImpl)transaction).getHibernate().createSQLQuery("SELECT find_duplicate_breeder('" + eleveur.getTopiaId() + "');").list();
            if (duplicateEleveurIds.isEmpty() || duplicateEleveurIds.get(0) == null) continue;
            String duplicateEleveurIdsString = SandraHelper.convertToListForNotifier(duplicateEleveurIds);
            ApplicationConfig config = SandraConfig.getConfig();
            new SandraNotifier().notifyEvent(template, SandraSchedulerConfigHelper.getSandraName(config), SandraSchedulerConfigHelper.getSandraUrl(config), eleveur.getTopiaId(), duplicateEleveurIdsString);
        }
    }

    public static void createActionSecuriteIfNeeded(TopiaContext transaction, String userLogin, Eleveur eleveur, InfoAccess infoAccess) throws TopiaException {
        String type = "A001";
        ActionSecuriteDAO actionSecuriteDAO = SandraDAOHelper.getActionSecuriteDAO((TopiaContext)transaction);
        EleveurDAO eleveurDAO = SandraDAOHelper.getEleveurDAO((TopiaContext)transaction);
        ActionSecurite actionSecurite = (ActionSecurite)actionSecuriteDAO.create(new Object[0]);
        actionSecurite.setNiveauSecurite(infoAccess.getNiveauSecurite());
        actionSecurite.setType(type);
        actionSecurite.setDateAction(new Date());
        actionSecurite.setUserCreation(userLogin);
        if (!eleveur.getAccesEleveur().equals(infoAccess)) {
            actionSecurite.setInfoAccess(infoAccess);
        }
        actionSecurite.setCommentaire(infoAccess.getCommentaireSecurite());
        eleveur.addActionSecurite(actionSecurite);
        actionSecuriteDAO.update((TopiaEntity)actionSecurite);
        eleveurDAO.update((TopiaEntity)eleveur);
        log.info((Object)("Creation of default action security for eleveur " + eleveur.getNom()));
    }

    protected static abstract class MapExtractor<K, T, R>
    implements Extractor<T, Map<K, R>> {
        protected Map<K, R> values = Maps.newHashMap();

        protected MapExtractor() {
        }

        @Override
        public void extract(T value) {
            this.values.put(this.getKey(value), this.getElement(value));
        }

        @Override
        public Map<K, R> getResult() {
            return this.values;
        }

        protected abstract K getKey(T var1);

        protected abstract R getElement(T var1);
    }

    protected static abstract class SimpleMapExtractor<K, T>
    extends MapExtractor<K, T, T> {
        protected SimpleMapExtractor() {
        }

        @Override
        protected abstract K getKey(T var1);

        @Override
        protected T getElement(T value) {
            return value;
        }
    }

    protected static abstract class ListExtractor<T, R>
    implements Extractor<T, List<R>> {
        protected List<R> values = Lists.newArrayList();

        protected ListExtractor() {
        }

        @Override
        public void extract(T value) {
            this.values.add(this.getElement(value));
        }

        @Override
        public List<R> getResult() {
            return this.values;
        }

        protected abstract R getElement(T var1);
    }

    protected static class SimpleListExtractor<T>
    extends ListExtractor<T, T> {
        protected SimpleListExtractor() {
        }

        @Override
        protected T getElement(T value) {
            return value;
        }
    }

    protected static interface Extractor<T, E> {
        public void extract(T var1);

        public E getResult();
    }
}

