/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra;

import java.util.Locale;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.i18n.init.DefaultI18nInitializer;
import org.nuiton.i18n.init.I18nInitializer;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.ArgumentsParserException;

public class SandraConfig {
    static Log log = LogFactory.getLog(SandraConfig.class);
    public static String NOTIFIER_TEMPLATE_EXTENSION = ".ftl";
    private static final String SANDRA_PROPERTIES = "sandra.properties";
    protected static ApplicationConfig config;

    private SandraConfig() {
    }

    public static ApplicationConfig getConfig() {
        return SandraConfig.getConfig(null, null, new String[0]);
    }

    public static ApplicationConfig getConfig(String[] args) {
        return SandraConfig.getConfig(null, null, args);
    }

    public static ApplicationConfig getConfig(String configFilename) {
        return SandraConfig.getConfig(null, configFilename, new String[0]);
    }

    public static ApplicationConfig getConfig(Properties props) {
        return SandraConfig.getConfig(props, null, new String[0]);
    }

    public static ApplicationConfig getConfig(Properties props, String configFilename, String ... args) {
        block7: {
            if (config == null) {
                try {
                    I18n.init((I18nInitializer)new DefaultI18nInitializer("sandra-service-i18n"), (Locale)Locale.FRANCE);
                }
                catch (Exception e) {
                    try {
                        I18n.init((I18nInitializer)new DefaultI18nInitializer("sandra-scheduler-i18n"), (Locale)Locale.FRANCE);
                    }
                    catch (Exception eee) {
                        log.error((Object)"Failed to initialize i18n", (Throwable)eee);
                    }
                }
                config = new ApplicationConfig(SandraOption.class, null, props, configFilename);
                try {
                    config.parse(args);
                }
                catch (ArgumentsParserException eee) {
                    if (!log.isErrorEnabled()) break block7;
                    log.error((Object)"Can't load sandra configuration", (Throwable)eee);
                }
            }
        }
        return config;
    }

    public static enum SandraOption implements ApplicationConfig.OptionDef
    {
        SANDRA_CONFIG_FILE("config.file", "Main configuration sandra file", "sandra.properties", String.class),
        NOTIFIER_TEMPLATE_EXTENSION("sandra.notifier.template.ext", "sandra.notifier.template.ext.descritption", ".ftl", String.class),
        NOTIFIER_TEMPLATE_DIR("sandra.notifier.dir", "sandra.notifier.dir.description", "/workspace/projets/glon/sandra/src/sandra/sandra-config/src/main/resources/data/sandra/templates/", String.class),
        SANDRA_INJECTION_DIR("sandra.injection.dir", "sandra.injection.dir.description", "/data/sandra/csv", String.class),
        IBU_PATTERN_FILE("sandra.integration.ibu.pattern", "sandra.integration.ibu.pattern.description", "_sdra\\_(.*)\\.txt$", String.class),
        IBU_INTEGRATION_PATH("sandra.integration.ibu.path", "sandra.integration.ibu.path.description", "/data/sandra/ibu", String.class),
        IBU_INTEGRATION_WORK("sandra.integration.ibu.work", "sandra.integration.ibu.work.description", "/data/sandra/ibu/work", String.class),
        IBU_INTEGRATION_DONE("sandra.integration.ibu.done", "sandra.integration.ibu.done.description", "/data/sandra/ibu/done", String.class),
        SUIVI_TOUR_PATH("sandra.suivi.tour.path", "sandra.suivi.tour.path.description", "/data/sandra/suiviTour", String.class),
        NOTIF_PATH("sandra.notif.path", "sandra.notif.path.description", "/data/sandra/notif", String.class),
        IBU_INTEGRATION_ERROR("sandra.integration.ibu.errors", "sandra.integration.ibu.errors.description", "/data/sandra/ibu/error", String.class),
        IBU_INTEGRATION_VERIFIER_ERROR("sandra.integration.ibu.verifier.errors", "sandra.integration.ibu.verifier.errors.description", "/data/sandra/ibu/error/verifier", String.class),
        IBU_INTEGRATION_OLDS("sandra.integration.ibu.olds", "sandra.integration.ibu.olds.description", "/data/sandra/ibu/olds", String.class),
        SANDRA_NAME("sandra.name", "sandra.name.description", "Sandra local", String.class),
        SANDRA_URL("sandra.url", "sandra.url.description", "/data/sandra/csv", String.class),
        SANDRA_EMAIL_HOST("sandra.email.host", "sandra.email.host.description", "smtp", String.class),
        SANDRA_EMAIL_PORT("sandra.email.port", "sandra.email.port.description", "25", String.class),
        SANDRA_EMAIL_FROM("sandra.email.from", "sandra.email.from.description", "sandra@cybelia.fr", String.class),
        SANDRA_EMAIL_TO("sandra.email.to", "sandra.email.to.description", "letellier@codelutin.com", String.class),
        LOCALE("sandra.locale", "sandra.locale.description", Locale.FRANCE.toString(), Locale.class),
        SANDRA_TOPIA_PROPERTIES("sandra.topia.properties", "sandra.topia.properties.description", "/etc/sandra-topia.properties", String.class),
        SANDRA_NOTE_DIR("sandra.note.dir", "sandra.note.dir.descritption", "/data/sandra/notes", String.class),
        GOOGLE_MAP_KEY("sandra.googlemap", "sandra.googlemap.description", "", String.class),
        SANDRA_VERSION("sandra.version", "sandra.version.descition", "0.0", String.class);

        public String key;
        public String description;
        public String defaultValue;
        public Class<?> type;
        public boolean isTransient;
        public boolean isFinal;

        private SandraOption(String key, String description, String defaultValue, Class<?> type) {
            this.key = key;
            this.description = description;
            this.defaultValue = defaultValue;
            this.type = type;
        }

        public String getKey() {
            return this.key;
        }

        public Class<?> getType() {
            return this.type;
        }

        public String getDescription() {
            return this.description;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public boolean isTransient() {
            return this.isTransient;
        }

        public boolean isFinal() {
            return this.isFinal;
        }

        public void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public void setTransient(boolean isTransient) {
            this.isTransient = false;
        }

        public void setFinal(boolean isFinal) {
            this.isFinal = false;
        }
    }
}

