/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra;

import com.cybelia.sandra.SandraConfig;
import com.cybelia.sandra.SandraHelper;
import com.cybelia.sandra.SandraSchedulerConfigHelper;
import com.cybelia.sandra.notifier.SandraNotifier;
import freemarker.core.Environment;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.mail.EmailAttachment;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.MultiPartEmail;
import org.nuiton.topia.TopiaException;
import org.nuiton.util.ApplicationConfig;

public class EmailHelper {
    private static final Log log = LogFactory.getLog(EmailHelper.class);

    public static void sendEmail(String[] to, String subject, String msg, String ... attachments) {
        log.info((Object)("Mail will sent to subject : " + subject + " to " + Arrays.toString(to)));
        ApplicationConfig config = SandraConfig.getConfig();
        MultiPartEmail email = new MultiPartEmail();
        email.setCharset("utf-8");
        email.setHostName(SandraSchedulerConfigHelper.getSandraEmailHost(config));
        email.setSmtpPort(SandraSchedulerConfigHelper.getSandraEmailPort(config));
        email.setSubject(subject);
        try {
            email.setFrom(SandraSchedulerConfigHelper.getSandraEmailForm(config));
            for (String recipient : to) {
                email.addTo(recipient);
            }
            email.addPart(msg, "text/plain;charset=UTF-8");
            for (String attachmentPath : attachments) {
                EmailAttachment attachment = new EmailAttachment();
                attachment.setPath(attachmentPath);
                email.attach(attachment);
            }
            email.send();
            log.info((Object)("Mail sent subject : " + subject + " to " + Arrays.toString(to)));
        }
        catch (EmailException e) {
            String msgErr = "EmailException impossible d'envoyer le mail";
            log.fatal((Object)msgErr, (Throwable)e);
            throw new RuntimeException(msgErr, e);
        }
    }

    public static void sendEmail(String to, String subject, String message, String ... attachments) {
        EmailHelper.sendEmail(new String[]{to}, subject, message, attachments);
    }

    public static void sendEmailToAdmin(String subject, String message, String ... attachments) {
        EmailHelper.sendEmail(SandraSchedulerConfigHelper.getSandraEmailTo(SandraConfig.getConfig()), subject, message, attachments);
    }

    public static void sendEmailFromTemplate(String templateName, Map<String, Object> context, String to, List<String> pjs) {
        EmailHelper.sendEmailFromTemplate(templateName, context, new String[]{to}, pjs);
    }

    public static void sendEmailFromTemplate(String templateName, Map<String, Object> context, String[] to, List<String> pjs) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"sendEmailFromTemplate");
        }
        ApplicationConfig appConfig = SandraConfig.getConfig();
        String dirName = SandraSchedulerConfigHelper.getNotifierTemplateDir(appConfig);
        String fileName = dirName + templateName + SandraSchedulerConfigHelper.getNotifierTemplateExt(appConfig);
        if (log.isDebugEnabled()) {
            log.debug((Object)("dirName : " + dirName + " fileName : " + fileName));
        }
        StringWriter content = new StringWriter();
        Configuration config = new Configuration();
        config.setDefaultEncoding("utf8");
        try {
            Template template = new Template(dirName, (Reader)new FileReader(fileName), config, "utf8");
            if (log.isDebugEnabled()) {
                log.debug((Object)("Template encoding : " + template.getEncoding()));
            }
            Environment env = template.createProcessingEnvironment(context, (Writer)content);
            env.setOutputEncoding("utf8");
            env.process();
        }
        catch (Exception e) {
            log.error((Object)("Generating failed fileName : " + fileName + " content : " + content.toString()), (Throwable)e);
        }
        String subject = "";
        String body = "";
        StringBuffer message = content.getBuffer();
        int index = message.indexOf("\n");
        if (index != -1) {
            subject = message.substring(0, index).trim();
            body = message.substring(index).trim();
        } else {
            subject = "(no subject)";
            body = message.toString().trim();
        }
        if (!body.isEmpty()) {
            if (log.isInfoEnabled()) {
                log.info((Object)("sendEmail to : " + to + " subject : " + subject));
            }
            EmailHelper.sendEmail(to, subject, body, pjs.toArray(new String[pjs.size()]));
        }
    }

    public static void sendNotification(String name, List<String[]> datas) {
        try {
            List<List<String>> reformatData = SandraHelper.reformatData(datas);
            String etapeTopiaIdsAsString = SandraHelper.convertToListForNotifier((Collection)reformatData.get(0));
            String eleveurTopiaIdsAsString = SandraHelper.convertToListForNotifier((Collection)reformatData.get(1));
            String tourTopiaIdsAsString = SandraHelper.convertToListForNotifier((Collection)reformatData.get(2));
            String camionTopiaIdsAsString = SandraHelper.convertToListForNotifier((Collection)reformatData.get(3));
            ApplicationConfig config = SandraConfig.getConfig();
            SandraNotifier sandraNotifier = new SandraNotifier();
            sandraNotifier.notifyEvent(name, SandraSchedulerConfigHelper.getSandraName(config), SandraSchedulerConfigHelper.getSandraUrl(config), etapeTopiaIdsAsString, eleveurTopiaIdsAsString, tourTopiaIdsAsString, camionTopiaIdsAsString);
        }
        catch (TopiaException ex) {
            log.error((Object)"TopiaException : ", (Throwable)ex);
        }
    }
}

