[${event.sandraName}] Liste des élevages où les conditions de livraison peuvent être dangereuses

Bonjour,

Voici la liste des élevages où les conditions de livraison peuvent être dangereuses :

Avec niveau de sécurité noir :
==============================

<#list event.listBreeder as breeder>
    <#if getWorstSecurityLevel(breeder) == 4>
- ${breeder.raisonSociale} (${breeder.societe.code}-${breeder.code}) ${breeder.ville} (${breeder.codePostal?substring(0, 2)})
        <@afficheRsks helper=event.helper lbl=event.lbl breeder=breeder/>
        <#if breeder.accesEleveur.commentaireSecurite??>
            <#if (breeder.accesEleveur.commentaireSecurite?trim?length > 0)>
  Commentaire de sécurité : ${breeder.accesEleveur.commentaireSecurite}
            </#if>
        </#if>
        <@afficheSilos helper=event.helper lbl=event.lbl breeder=breeder/>
  ${event.sandraUrl}/appli/breeder/view.do?topiaId=${breeder.topiaId?replace("#", "%23")}

    </#if>
</#list>

Avec niveau de sécurité rouge :
===============================

<#list event.listBreeder as breeder>
    <#if getWorstSecurityLevel(breeder) == 3>
- ${breeder.raisonSociale} (${breeder.societe.code}-${breeder.code}) ${breeder.ville} (${breeder.codePostal?substring(0, 2)})
        <@afficheRsks helper=event.helper lbl=event.lbl breeder=breeder/>
        <#if breeder.accesEleveur.commentaireSecurite??>
            <#if (breeder.accesEleveur.commentaireSecurite?trim?length > 0)>
  Commentaire de sécurité : ${breeder.accesEleveur.commentaireSecurite}
            </#if>
        </#if>
        <@afficheSilos helper=event.helper lbl=event.lbl breeder=breeder/>
  ${event.sandraUrl}/appli/breeder/view.do?topiaId=${breeder.topiaId?replace("#", "%23")}

    </#if>
</#list>

Avec niveau de sécurité orange :
================================

<#list event.listBreeder as breeder>
    <#if getWorstSecurityLevel(breeder) == 2>
- ${breeder.raisonSociale} (${breeder.societe.code}-${breeder.code}) ${breeder.ville} (${breeder.codePostal?substring(0, 2)})
        <@afficheRsks helper=event.helper lbl=event.lbl breeder=breeder/>
        <#if breeder.accesEleveur.commentaireSecurite??>
            <#if (breeder.accesEleveur.commentaireSecurite?trim?length > 0)>
  Commentaire de sécurité : ${breeder.accesEleveur.commentaireSecurite}
            </#if>
        </#if>
        <@afficheSilos helper=event.helper lbl=event.lbl breeder=breeder/>
  ${event.sandraUrl}/appli/breeder/view.do?topiaId=${breeder.topiaId?replace("#", "%23")}

    </#if>
</#list>

Cordialement,

L'équipe Sandra.

<#macro afficheSecurite valeur><#if valeur == 2>orange<#elseif valeur == 3>rouge<#elseif valeur == 4>noir<#else>Ne devrait pas ce produire !</#if></#macro>

<#function getWorstSecurityLevel breeder>
  <#assign worstSecurityLevel=breeder.accesEleveur.niveauSecurite>
  <#list breeder.accesSilos as silo>
    <#if (silo.etat != 2)>
      <#if (silo.niveauSecurite > worstSecurityLevel)>
        <#assign worstSecurityLevel=silo.niveauSecurite>
      </#if>
    </#if>
  </#list>
  <#return worstSecurityLevel>
</#function>

<#macro afficheRsks helper lbl breeder>
    <#assign rsks=helper.extractRisques(lbl, breeder)/>
    <#if (rsks?length > 0)>
  Risques : ${rsks}
    </#if>
</#macro>

<#macro afficheSilos helper lbl breeder>
    <#if (breeder.accesSilos??)>
        <#list breeder.accesSilos as silo>
            <#if (silo.niveauSecurite > 1)>
                <#if silo.nomAcces??>
  - ${silo.nomAcces} (<@afficheSecurite valeur=silo.niveauSecurite/>) : <#if silo.commentaireSecurite??><#if (silo.commentaireSecurite?trim?length > 0)>Commentaire de sécurité : ${silo.commentaireSecurite}</#if></#if>
	            <#else>
  - (pas de nom de renseigné) (<@afficheSecurite valeur=silo.niveauSecurite/>) : <#if silo.commentaireSecurite??><#if (silo.commentaireSecurite?trim?length > 0)>Commentaire de sécurité : ${silo.commentaireSecurite}</#if></#if>
                </#if>
             </#if>
         </#list>
     </#if>
</#macro>