package com.cybelia.sandra.security;

import com.cybelia.sandra.entities.Camion;
import com.cybelia.sandra.entities.ChargementUsineConfig;
import com.cybelia.sandra.entities.Chauffeur;
import com.cybelia.sandra.entities.Eleveur;
import com.cybelia.sandra.entities.EleveursDoublons;
import com.cybelia.sandra.entities.Etape;
import com.cybelia.sandra.entities.InfoAccess;
import com.cybelia.sandra.entities.Label;
import com.cybelia.sandra.entities.LigneProduit;
import com.cybelia.sandra.entities.Note;
import com.cybelia.sandra.entities.Societe;
import com.cybelia.sandra.entities.Tour;
import com.cybelia.sandra.entities.Transporteur;
import com.cybelia.sandra.entities.UserIndicateurs;
import com.cybelia.sandra.entities.Usine;
import com.cybelia.sandra.entities.notifier.Cron;
import com.cybelia.sandra.entities.notifier.Event;
import com.cybelia.sandra.entities.notifier.Queue;
import static com.cybelia.sandra.security.Filter.AllFilter;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.taas.entities.TaasUser;

import static com.cybelia.sandra.security.Filter.NoFilter;
import static com.cybelia.sandra.security.FilterManagerProfil.PARAM_DATE_PREVIOUS_8_NAME;
import static com.cybelia.sandra.security.FilterManagerProfil.PARAM_PROFIL_NAME;
import static com.cybelia.sandra.security.FilterManagerProfil.PARAM_USER_NAME;
import static com.cybelia.sandra.security.FilterManagerProfil.filters;

public class FilterManagerProfil {

    private static final Log log = LogFactory.getLog(FilterManagerProfil.class);
    protected static Map<Class<? extends TopiaEntity>, Map<Class<? extends TopiaEntity>, Filter>> filters;

    public static String PARAM_PROFIL_NAME = "profil";
    public static String PARAM_PROFIL = ":" + PARAM_PROFIL_NAME;

    public static String PARAM_DATE_PREVIOUS_8_NAME = "datePrevious8";
    public static String PARAM_DATE_PREVIOUS_8 = ":" + PARAM_DATE_PREVIOUS_8_NAME;

    public static String PARAM_USER_NAME = "user";
    public static String PARAM_USER = ":" + PARAM_USER_NAME;

    static {
        Map<Class<? extends TopiaEntity>, Filter> filter;
        filters = new HashMap<Class<? extends TopiaEntity>, Map<Class<? extends TopiaEntity>, Filter>>();

        // Tour ////////////////////////////////////////////////////////////////
        filter = new HashMap<Class<? extends TopiaEntity>, Filter>();
        filters.put(Tour.class, filter);

        filter.put(Societe.class, new Filter(
                "tour.camion.societe.topiaId IN (" + PARAM_PROFIL + ") "
                + "AND tour.camion.code != 'GUI' "
                + "AND EXISTS (SELECT etape_ FROM " + Etape.class.getName() + " etape_ WHERE etape_.tour = tour AND etape_.produits is not empty)"));
        filter.put(Transporteur.class, new Filter(
                "tour.camion.transporteur.topiaId IN (" + PARAM_PROFIL + ") "
                + "AND tour.camion.code != 'GUI' "
                + "AND EXISTS (SELECT etape_ FROM " + Etape.class.getName() + " etape_ WHERE etape_.tour = tour AND etape_.produits is not empty)"));
        filter.put(Camion.class, new Filter(
                "tour.camion.topiaId IN (" + PARAM_PROFIL + ") "
                + "AND tour.camion.code != 'GUI' "
                + "AND EXISTS (SELECT etape_ FROM " + Etape.class.getName() + " etape_ WHERE etape_.tour = tour AND etape_.produits is not empty)"));
        filter.put(Chauffeur.class, new Filter(
                "tour.defautChauffeur.topiaId IN (" + PARAM_PROFIL + ") "
                + "AND tour.camion.code != 'GUI' "
                + "AND EXISTS (SELECT etape_ FROM " + Etape.class.getName() + " etape_ WHERE etape_.tour = tour AND etape_.produits is not empty)"));
        filter.put(Usine.class, new Filter(
                "JOIN tour.etapes as _etape JOIN _etape.produits as _produit",
                "_produit.usine.topiaId IN ( " + PARAM_PROFIL + ") "
                + "AND tour.camion.code != 'GUI' "
                + "AND EXISTS (SELECT etape_ FROM " + Etape.class.getName() + " etape_ WHERE etape_.tour = tour AND etape_.produits is not empty)"));
        filter.put(Eleveur.class, new Filter(
                Etape.class.getName() + " _etape",
                "_etape.tour = tour and _etape.eleveur.topiaId IN (" + PARAM_PROFIL + ") "
                + "AND tour.camion.code != 'GUI' "
                + "AND EXISTS (SELECT etape_ FROM " + Etape.class.getName() + " etape_ WHERE etape_.tour = tour AND etape_.produits is not empty)"));
        filter.put(EleveursDoublons.class, new Filter("tour.camion.code != 'GUI'"));

        // Etape /////////////////////////////////////////////////////////////
        filter = new HashMap<Class<? extends TopiaEntity>, Filter>();
        filters.put(Etape.class, filter);

        filter.put(Societe.class, new Filter(
                "etape.tour.camion.societe.topiaId IN (" + PARAM_PROFIL + ") "
                + "AND etape.tour.camion.code != 'GUI' "
                + "AND EXISTS (SELECT etape_ FROM " + Etape.class.getName() + " etape_ WHERE etape_ = etape AND etape_.produits is not empty)"));
        filter.put(Transporteur.class, new Filter(
                "etape.tour.camion.transporteur.topiaId IN (" + PARAM_PROFIL + ") "
                + "AND etape.tour.camion.code != 'GUI' "
                + "AND EXISTS (SELECT etape_ FROM " + Etape.class.getName() + " etape_ WHERE etape_ = etape AND etape_.produits is not empty)"));
        filter.put(Camion.class, new Filter(
                "etape.tour.camion.topiaId IN (" + PARAM_PROFIL + ") "
                + "AND etape.tour.camion.code != 'GUI' "
                + "AND EXISTS (SELECT etape_ FROM " + Etape.class.getName() + " etape_ WHERE etape_ = etape AND etape_.produits is not empty)"));
        filter.put(Chauffeur.class, new Filter(
                "etape.tour.defautChauffeur.topiaId IN (" + PARAM_PROFIL + ") "
                + "AND etape.tour.camion.code != 'GUI' "
                + "AND EXISTS (SELECT etape_ FROM " + Etape.class.getName() + " etape_ WHERE etape_ = etape AND etape_.produits is not empty)"));
        filter.put(Usine.class, new Filter(
                "JOIN etape.tour.etapes as _etape JOIN _etape.produits as _produit",
                "_produit.usine.topiaId IN ( " + PARAM_PROFIL + ") "
                + "AND etape.tour.camion.code != 'GUI' "
                + "AND EXISTS (SELECT etape_ FROM " + Etape.class.getName() + " etape_ WHERE etape_ = etape AND etape_.produits is not empty)"));
        filter.put(Eleveur.class, new Filter(
                Etape.class.getName() + " _etape",
                "_etape.tour = etape.tour and _etape.eleveur.topiaId IN (" + PARAM_PROFIL + ") "
                + "AND etape.tour.camion.code != 'GUI' "
                + "AND EXISTS (SELECT etape_ FROM " + Etape.class.getName() + " etape_ WHERE etape_ = etape AND etape_.produits is not empty)"));
        filter.put(EleveursDoublons.class, new Filter(
                "etape.tour.camion.code != 'GUI' "
                + "AND EXISTS (SELECT etape_ FROM " + Etape.class.getName() + " etape_ WHERE etape_ = etape AND etape_.produits is not empty)"));
        
        // Societe /////////////////////////////////////////////////////////////
        filter = new HashMap<Class<? extends TopiaEntity>, Filter>();
        filters.put(Societe.class, filter);

        filter.put(Societe.class, new Filter(
                "societe.topiaId IN (" + PARAM_PROFIL + ")"));
        filter.put(Transporteur.class, new Filter(
                Transporteur.class.getName() + " _transporteur",
                "_transporteur.topiaId IN (" + PARAM_PROFIL + ")"));
        filter.put(Camion.class, new Filter(
                Camion.class.getName() + " _camion",
                "_camion.societe = societe and _camion.topiaId IN (" + PARAM_PROFIL + ")"));
        filter.put(Chauffeur.class, NoFilter);
        filter.put(Usine.class, NoFilter);
        filter.put(Eleveur.class, new Filter(
                Eleveur.class.getName() + " _eleveur",
                "_eleveur.societe = societe and _eleveur.topiaId IN (" + PARAM_PROFIL + ")"));
        filter.put(EleveursDoublons.class, NoFilter);

        // Transporteur ////////////////////////////////////////////////////////
        filter = new HashMap<Class<? extends TopiaEntity>, Filter>();
        filters.put(Transporteur.class, filter);

        filter.put(Societe.class, NoFilter);
        filter.put(Transporteur.class, new Filter(
                "transporteur.topiaId IN (" + PARAM_PROFIL + ")"));
        filter.put(Camion.class, new Filter(
                Camion.class.getName() + " _camion",
                "_camion.transporteur = transporteur and _camion.topiaId IN (" + PARAM_PROFIL + ")"));
        filter.put(Chauffeur.class, new Filter(
                Camion.class.getName() + " _camion JOIN _camion.defautChauffeurs as _chauffeur",
                "_camion.transporteur = transporteur AND _chauffeur.topiaId IN (" + PARAM_PROFIL + ")"));
        filter.put(Usine.class, NoFilter);
        filter.put(Eleveur.class, NoFilter);
        filter.put(EleveursDoublons.class, NoFilter);

        // Camion //////////////////////////////////////////////////////////////
        filter = new HashMap<Class<? extends TopiaEntity>, Filter>();
        filters.put(Camion.class, filter);

        filter.put(Societe.class, new Filter(
                "camion.societe.topiaId IN (" + PARAM_PROFIL + ") "
                + "AND camion.code != 'GUI'"));
        filter.put(Transporteur.class, new Filter(
                "transporteur.topiaId IN (" + PARAM_PROFIL + ") "
                + "AND camion.code != 'GUI'"));
        filter.put(Camion.class, new Filter(
                "camion.topiaId IN (" + PARAM_PROFIL + ") "
                + "AND camion.code != 'GUI'"));
        filter.put(Chauffeur.class, new Filter(
                "JOIN camion.defautChauffeurs AS _chauffeur",
                "_chauffeur.topiaId IN (" + PARAM_PROFIL + ") "
                + "AND camion.code != 'GUI'"));
        filter.put(Usine.class, new Filter("camion.code != 'GUI'"));
        filter.put(Eleveur.class, new Filter("camion.code != 'GUI'"));
        filter.put(EleveursDoublons.class, new Filter("camion.code != 'GUI'"));

        // Chauffeur ///////////////////////////////////////////////////////////
        filter = new HashMap<Class<? extends TopiaEntity>, Filter>();
        filters.put(Chauffeur.class, filter);

        filter.put(Societe.class, NoFilter);
        filter.put(Transporteur.class, new Filter(
                "JOIN chauffeur.camions AS _camion",
                "_camion.transporteur.topiaId IN (" + PARAM_PROFIL + ")"));
        filter.put(Camion.class, new Filter(
                "JOIN chauffeur.camions AS _camion",
                "_camion.topiaId IN (" + PARAM_PROFIL + ")"));
        filter.put(Chauffeur.class, new Filter(
                "chauffeur.topiaId IN (" + PARAM_PROFIL + ")"));
        filter.put(Usine.class, NoFilter);
        filter.put(Eleveur.class, NoFilter);
        filter.put(EleveursDoublons.class, NoFilter);

        // Usine ///////////////////////////////////////////////////////////////
        filter = new HashMap<Class<? extends TopiaEntity>, Filter>();
        filters.put(Usine.class, filter);

        filter.put(Societe.class, NoFilter);
        filter.put(Transporteur.class, NoFilter);
        filter.put(Camion.class, NoFilter);
        filter.put(Chauffeur.class, NoFilter);
        filter.put(Usine.class, new Filter(
                "usine.topiaId IN (" + PARAM_PROFIL + ")"));
        filter.put(Eleveur.class, NoFilter);
        filter.put(EleveursDoublons.class, NoFilter);

        // Eleveur /////////////////////////////////////////////////////////////
        filter = new HashMap<Class<? extends TopiaEntity>, Filter>();
        filters.put(Eleveur.class, filter);

        filter.put(Societe.class, new Filter("eleveur.societe.topiaId IN (" + PARAM_PROFIL + ")"));
        filter.put(Transporteur.class, new Filter(
                "eleveur IN (SELECT _etape.eleveur FROM " + Tour.class.getName() + " _tour " +
                        "JOIN _tour.etapes AS _etape " +
                        "WHERE _tour.dateLivraison >= " + PARAM_DATE_PREVIOUS_8 + " AND " +
                        "_tour.camion.transporteur.topiaId IN (" + PARAM_PROFIL + "))"));

        filter.put(Camion.class, new Filter(
                "eleveur IN (SELECT _etape.eleveur FROM " + Tour.class.getName() + " _tour " +
                        "JOIN _tour.etapes AS _etape " +
                        "WHERE _tour.dateLivraison >= " + PARAM_DATE_PREVIOUS_8 + " AND " +
                        "_tour.camion.topiaId IN (" + PARAM_PROFIL + "))"));

        filter.put(Chauffeur.class, new Filter(
                "eleveur IN (SELECT _etape.eleveur FROM " + Tour.class.getName() + " _tour " +
                        "JOIN _tour.etapes AS _etape " +
                        "WHERE _tour.dateLivraison >= " + PARAM_DATE_PREVIOUS_8 + " AND " +
                        "_tour.defautChauffeur.topiaId IN (" + PARAM_PROFIL + ")) OR " +

                 "eleveur IN (SELECT etape_.eleveur FROM " + Tour.class.getName() + " tour_ " +
                        "JOIN tour_.etapes AS etape_ " +
                        "WHERE tour_.dateLivraison >= " + PARAM_DATE_PREVIOUS_8 + " AND " +
                        "tour_.suiviTour.reel.topiaId IN (" + PARAM_PROFIL + "))"));

        filter.put(Usine.class, NoFilter);
        filter.put(Eleveur.class, new Filter("eleveur.topiaId IN (" + PARAM_PROFIL + ")"));
        filter.put(EleveursDoublons.class, NoFilter);

        // EleveurDoublons /////////////////////////////////////////////////////////////
        filter = new HashMap<Class<? extends TopiaEntity>, Filter>();
        filters.put(EleveursDoublons.class, filter);
        filter.put(Societe.class, NoFilter);
        filter.put(Transporteur.class, NoFilter);
        filter.put(Camion.class, NoFilter);
        filter.put(Chauffeur.class, NoFilter);
        filter.put(Usine.class, NoFilter);
        filter.put(Eleveur.class, NoFilter);
        filter.put(EleveursDoublons.class, NoFilter);

        // InfoAccess /////////////////////////////////////////////////////////////
        filter = new HashMap<Class<? extends TopiaEntity>, Filter>();
        filters.put(InfoAccess.class, filter);

        filter.put(Societe.class, new Filter(
                "infoAccess.eleveur IN (SELECT _eleveur FROM " + Eleveur.class.getName() + " _eleveur " +
                        "WHERE _eleveur.societe.topiaId IN (" + PARAM_PROFIL + ")) OR " +

                "infoAccess IN (SELECT eleveur_.accesEleveur FROM " + Eleveur.class.getName() + " eleveur_ " +
                        "WHERE eleveur_.societe.topiaId IN (" + PARAM_PROFIL + "))"));

        filter.put(Transporteur.class, new Filter(
                "infoAccess.eleveur IN (SELECT _eleveur FROM " + Eleveur.class.getName() + " _eleveur " +
                        "WHERE _eleveur.topiaId IN (SELECT _etape.eleveur FROM " + Tour.class.getName() + " _tour " +
                        "JOIN _tour.etapes AS _etape " +
                        "WHERE _tour.dateLivraison >= " + PARAM_DATE_PREVIOUS_8 + " AND " +
                        "_tour.camion.transporteur.topiaId IN (" + PARAM_PROFIL + "))) OR " +

                "infoAccess IN (SELECT eleveur_.accesEleveur FROM " + Eleveur.class.getName() + " eleveur_ " +
                        "WHERE eleveur_.topiaId IN (SELECT etape_.eleveur FROM " + Tour.class.getName() +
                        " tour_ JOIN tour_.etapes AS etape_ " +
                        "WHERE tour_.dateLivraison >= " + PARAM_DATE_PREVIOUS_8 + " AND " +
                        "tour_.camion.transporteur.topiaId IN (" + PARAM_PROFIL + ")))"));

        filter.put(Camion.class, new Filter(
                "infoAccess.eleveur IN (SELECT _eleveur FROM " + Eleveur.class.getName() + " _eleveur " +
                        "WHERE _eleveur.topiaId IN (SELECT _etape.eleveur FROM " + Tour.class.getName() + " _tour " +
                        "JOIN _tour.etapes AS _etape " +
                        "WHERE _tour.dateLivraison >= " + PARAM_DATE_PREVIOUS_8 + " AND " +
                        "_tour.camion.topiaId IN (" + PARAM_PROFIL + "))) OR " +

                "infoAccess IN (SELECT eleveur_.accesEleveur FROM " + Eleveur.class.getName() + " eleveur_ " +
                        "WHERE eleveur_.topiaId IN (SELECT etape_.eleveur FROM " + Tour.class.getName() +
                        " tour_ JOIN tour_.etapes AS etape_ " +
                        "WHERE tour_.dateLivraison >= " + PARAM_DATE_PREVIOUS_8 + " AND " +
                        "tour_.camion.topiaId IN (" + PARAM_PROFIL + ")))"));

        filter.put(Chauffeur.class, new Filter(
                "infoAccess.eleveur IN (SELECT _eleveur FROM " + Eleveur.class.getName() + " _eleveur " +
                        "WHERE _eleveur.topiaId IN (SELECT _etape.eleveur FROM " + Tour.class.getName() + " _tour " +
                        "JOIN _tour.etapes AS _etape " +
                        "WHERE _tour.dateLivraison >= " + PARAM_DATE_PREVIOUS_8 + " AND " +
                        "_tour.defautChauffeur.topiaId IN (" + PARAM_PROFIL + "))) OR " +

                "infoAccess IN (SELECT eleveur_.accesEleveur FROM " + Eleveur.class.getName() + " eleveur_ " +
                        "WHERE eleveur_.topiaId IN (SELECT etape_.eleveur FROM " + Tour.class.getName() + " tour_ " +
                        "JOIN tour_.etapes AS etape_ " +
                        "WHERE tour_.dateLivraison >= " + PARAM_DATE_PREVIOUS_8 + " AND " +
                        "tour_.defautChauffeur.topiaId IN (" + PARAM_PROFIL + "))) OR " +

                "infoAccess.eleveur IN (SELECT _eleveur_ FROM " + Eleveur.class.getName() + " _eleveur_ " +
                        "WHERE _eleveur_.topiaId IN (SELECT _etape_.eleveur FROM " + Tour.class.getName() + " _tour_ " +
                        "JOIN _tour_.etapes AS _etape_ " +
                        "WHERE _tour_.dateLivraison >= " + PARAM_DATE_PREVIOUS_8 + " AND " +
                        "_tour_.suiviTour.reel.topiaId IN (" + PARAM_PROFIL + "))) OR " +

                "infoAccess IN (SELECT eleveur.accesEleveur FROM " + Eleveur.class.getName() + " eleveur " +
                        "WHERE eleveur.topiaId IN (SELECT etape.eleveur FROM " + Tour.class.getName() + " tour " +
                        "JOIN tour.etapes AS etape " +
                        "WHERE tour.dateLivraison >= " + PARAM_DATE_PREVIOUS_8 + " AND " +
                        "tour.suiviTour.reel.topiaId IN (" + PARAM_PROFIL + ")))"));

        filter.put(Usine.class, NoFilter);
        filter.put(Eleveur.class, new Filter(
                "infoAccess.eleveur IN (SELECT _eleveur FROM " + Eleveur.class.getName() + " _eleveur " +
                        "WHERE _eleveur.topiaId IN (" + PARAM_PROFIL + ")) OR " +
                "infoAccess IN (SELECT eleveur_.accesEleveur FROM " + Eleveur.class.getName() + " eleveur_ " +
                        "WHERE eleveur_.topiaId IN (" + PARAM_PROFIL + "))"));
        filter.put(EleveursDoublons.class, NoFilter);

        // TaasUser ////////////////////////////////////////////////////////////
        filter = new HashMap<Class<? extends TopiaEntity>, Filter>();
        filters.put(TaasUser.class, filter);
        filter.put(Societe.class, new Filter(
                "user.link IN (" + PARAM_PROFIL + ")"));
        filter.put(Transporteur.class, AllFilter);
        filter.put(Camion.class, AllFilter);
        filter.put(Chauffeur.class, AllFilter);
        filter.put(Usine.class, AllFilter);
        filter.put(Eleveur.class, AllFilter);
        filter.put(EleveursDoublons.class, AllFilter);

        // UserIndicateurs ////////////////////////////////////////////////////////////
        filter = new HashMap<Class<? extends TopiaEntity>, Filter>();
        filters.put(UserIndicateurs.class, filter);
        filter.put(Societe.class, new Filter(
                "userIndicateurs IN (SELECT userIndicateurs FROM " +
                UserIndicateurs.class.getName() +
                " userIndicateurs JOIN userIndicateurs.taasUser AS user" +
                " WHERE user.link IN (" + PARAM_PROFIL + "))"));
        filter.put(Transporteur.class, AllFilter);
        filter.put(Camion.class, AllFilter);
        filter.put(Chauffeur.class, AllFilter);
        filter.put(Usine.class, AllFilter);
        filter.put(Eleveur.class, AllFilter);
        filter.put(EleveursDoublons.class, AllFilter);

        // Note ////////////////////////////////////////////////////////////////
        filter = new HashMap<Class<? extends TopiaEntity>, Filter>();
        filters.put(Note.class, filter);

        filter.put(Societe.class, NoFilter);
        filter.put(Transporteur.class, NoFilter);
        filter.put(Camion.class, NoFilter);
        filter.put(Chauffeur.class, NoFilter);
        filter.put(Usine.class, NoFilter);
        filter.put(Eleveur.class, new Filter(
                "eleveur.topiaId IN (" + PARAM_PROFIL + ")"));
        filter.put(EleveursDoublons.class, NoFilter);

        // Label ///////////////////////////////////////////////////////////////
        filter = new HashMap<Class<? extends TopiaEntity>, Filter>();
        filters.put(Label.class, filter);

        filter.put(Societe.class, NoFilter);
        filter.put(Transporteur.class, NoFilter);
        filter.put(Camion.class, NoFilter);
        filter.put(Chauffeur.class, NoFilter);
        filter.put(Usine.class, NoFilter);
        filter.put(Eleveur.class, NoFilter);
        filter.put(EleveursDoublons.class, NoFilter);

        // ChargementUsineConfig ///////////////////////////////////////////////
        filter = new HashMap<Class<? extends TopiaEntity>, Filter>();
        filters.put(ChargementUsineConfig.class, filter);

        filter.put(Societe.class, NoFilter);
        filter.put(Transporteur.class, NoFilter);
        filter.put(Camion.class, NoFilter);
        filter.put(Chauffeur.class, NoFilter);
        filter.put(Usine.class, NoFilter);
        filter.put(Eleveur.class, NoFilter);
        filter.put(EleveursDoublons.class, NoFilter);

        // Event ///////////////////////////////////////////////////////////////
        filter = new HashMap<Class<? extends TopiaEntity>, Filter>();
        filters.put(Event.class, filter);

        filter.put(Societe.class, NoFilter);
        filter.put(Transporteur.class, AllFilter);
        filter.put(Camion.class, AllFilter);
        filter.put(Chauffeur.class, AllFilter);
        filter.put(Usine.class, AllFilter);
        filter.put(Eleveur.class, AllFilter);
        filter.put(EleveursDoublons.class, NoFilter);

        // Cron ////////////////////////////////////////////////////////////////
        filter = new HashMap<Class<? extends TopiaEntity>, Filter>();
        filters.put(Cron.class, filter);

        filter.put(Societe.class, new Filter(
                "cron.author = " + PARAM_USER));
        filter.put(Transporteur.class, AllFilter);
        filter.put(Camion.class, AllFilter);
        filter.put(Chauffeur.class, AllFilter);
        filter.put(Usine.class, AllFilter);
        filter.put(Eleveur.class, AllFilter);
        filter.put(EleveursDoublons.class, NoFilter);

        // Queue ///////////////////////////////////////////////////////////////
        filter = new HashMap<Class<? extends TopiaEntity>, Filter>();
        filters.put(Queue.class, filter);

        filter.put(Societe.class, AllFilter);
        filter.put(Transporteur.class, AllFilter);
        filter.put(Camion.class, AllFilter);
        filter.put(Chauffeur.class, AllFilter);
        filter.put(Usine.class, AllFilter);
        filter.put(Eleveur.class, AllFilter);
        filter.put(EleveursDoublons.class, NoFilter);

        // LigneProduit ////////////////////////////////////////////////////////
        filter = new HashMap<Class<? extends TopiaEntity>, Filter>();
        filters.put(LigneProduit.class, filter);

        filter.put(Societe.class, new Filter(
                "produit.etape.tour.camion.societe.topiaId IN (" + PARAM_PROFIL + ") "
                + "AND produit.etape.tour.camion.code != 'GUI'"));
        filter.put(Transporteur.class, new Filter(
                "produit.etape.tour.camion.transporteur.topiaId IN (" + PARAM_PROFIL + ") "
                + "AND produit.etape.tour.camion.code != 'GUI'"));
        filter.put(Camion.class, new Filter(
                "produit.etape.tour.camion.topiaId IN (" + PARAM_PROFIL + ") "
                + "AND produit.etape.tour.camion.code != 'GUI'"));
        filter.put(Chauffeur.class, new Filter(
                "produit.etape.tour.defautChauffeur.topiaId IN (" + PARAM_PROFIL + ") "
                + "AND produit.etape.tour.camion.code != 'GUI'"));
        filter.put(Usine.class, new Filter(
                "produit.usine.topiaId IN ( " + PARAM_PROFIL + ") "
                + "AND produit.etape.tour.camion.code != 'GUI'"));
        filter.put(Eleveur.class, new Filter(
                "produit.etape.eleveur.topiaId IN (" + PARAM_PROFIL + ") "
                + "AND produit.etape.tour.camion.code != 'GUI'"));
        filter.put(EleveursDoublons.class, new Filter("produit.etape.tour.camion.code != 'GUI'"));
    }

    public static Filter getFilter(Class<? extends TopiaEntity> classSearch, Class<? extends TopiaEntity> classProfil) {
        Map<Class<? extends TopiaEntity>, Filter> filter = filters.get(classSearch);
        if (filter == null) {
            log.error("Error filterManger on search : " + classSearch.getName());
            return null;
        }
        Filter result = filter.get(classProfil);
        if (result == null) {
            log.error("Error filterManger on profil : " + classProfil.getName());
        }
        return result;
    }
}
