package com.cybelia.sandra.migration;

import java.util.List;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.migration.TopiaMigrationCallbackByClass;
import org.nuiton.util.Version;

/**
 * @author sletellier <letellier@codelutin.com>
 */
public class MigrationV15V16 extends TopiaMigrationCallbackByClass.MigrationCallBackForVersion {

    public MigrationV15V16(Version version, TopiaMigrationCallbackByClass callBack) {
        super(version, callBack);
    }

    @Override
    protected void prepareMigrationScript(TopiaContextImplementor tx, List<String> queries, boolean showSql, boolean showProgression) throws TopiaException {

        // natural id index

        // UserIndicateurs
        queries.add("DROP INDEX sandra.userindicateurs_key;");
        queries.add("CREATE UNIQUE INDEX userindicateurs_key ON sandra.userindicateurs(taasUser);");
        queries.add("ALTER TABLE sandra.userindicateurs ALTER COLUMN taasUser SET NOT NULL;");

        // Label
        queries.add("DROP INDEX sandra.label_key;");
        queries.add("CREATE UNIQUE INDEX label_key ON sandra.label(id, categorie);");
        queries.add("ALTER TABLE sandra.label ALTER COLUMN id SET NOT NULL;");
        queries.add("ALTER TABLE sandra.label ALTER COLUMN categorie SET NOT NULL;");

        // Societe
        queries.add("DROP INDEX sandra.societe_key;");
        queries.add("CREATE UNIQUE INDEX societe_key ON sandra.societe(code);");

        // Camion
        queries.add("DROP INDEX sandra.camion_key;");
        queries.add("CREATE UNIQUE INDEX camion_key ON sandra.camion(code, societe);");
        queries.add("ALTER TABLE sandra.camion ALTER COLUMN code SET NOT NULL;");
        queries.add("ALTER TABLE sandra.camion ALTER COLUMN societe SET NOT NULL;");

        // Transporteur
        queries.add("DROP INDEX sandra.transporteur_key;");
        queries.add("CREATE UNIQUE INDEX transporteur_key ON sandra.transporteur(code, societe);");
        queries.add("DELETE FROM sandra.transporteur WHERE code IS NULL;");
        queries.add("ALTER TABLE sandra.transporteur ALTER COLUMN code SET NOT NULL;");
        queries.add("ALTER TABLE sandra.transporteur ALTER COLUMN societe SET NOT NULL;");

        // Chauffeur
        queries.add("DELETE FROM sandra.camions_defautchauffeurs WHERE defautchauffeurs IN (" +
                        "SELECT c1.topiaid FROM sandra.chauffeur c1, sandra.chauffeur c2 WHERE " +
                            "c2.topiaId!=c1.topiaid AND c2.societe=c1.societe AND c1.code=c2.code AND NOT EXISTS (" +
                                "SELECT DISTINCT t.defautChauffeur FROM sandra.tour t WHERE t.defautChauffeur=c1.topiaId));");

        queries.add("DELETE FROM sandra.chauffeur WHERE topiaid IN (" +
                        "SELECT c1.topiaid FROM sandra.chauffeur c1, sandra.chauffeur c2 WHERE " +
                        "c2.topiaId!=c1.topiaid AND c2.societe=c1.societe AND c1.code=c2.code AND NOT EXISTS (" +
                            "SELECT DISTINCT t.defautChauffeur FROM sandra.tour t WHERE t.defautChauffeur=c1.topiaId));");

        queries.add("DROP INDEX sandra.chauffeur_key;");
        queries.add("UPDATE sandra.tour SET defautchauffeur=null WHERE defautchauffeur IN (SELECT topiaid FROM sandra.chauffeur WHERE code IS NULL);");
        queries.add("UPDATE sandra.suivitour SET reel=null WHERE reel IN (SELECT topiaid FROM sandra.chauffeur WHERE code IS NULL);");
        queries.add("UPDATE sandra.tour SET defautchauffeur=null WHERE defautchauffeur IN (SELECT topiaid FROM sandra.chauffeur WHERE trigramme IS NULL);");
        queries.add("DELETE FROM sandra.camions_defautchauffeurs WHERE defautchauffeurs IN (SELECT topiaid FROM sandra.chauffeur WHERE code IS NULL);");
        queries.add("DELETE FROM sandra.camions_defautchauffeurs WHERE defautchauffeurs IN (SELECT topiaid FROM sandra.chauffeur WHERE trigramme IS NULL);");
        queries.add("UPDATE sandra.suivitour SET reel=null WHERE reel IN (SELECT topiaid FROM sandra.chauffeur WHERE trigramme IS NULL);");
        queries.add("DELETE FROM sandra.chauffeur WHERE code IS NULL;");
        queries.add("DELETE FROM sandra.chauffeur WHERE trigramme IS NULL;");
        queries.add("CREATE UNIQUE INDEX chauffeur_key ON sandra.chauffeur(code);");
        queries.add("ALTER TABLE sandra.chauffeur ALTER COLUMN code SET NOT NULL;");

        // Commande
        queries.add("UPDATE sandra.ligneproduit SET commande=null WHERE commande in (" +
                        "SELECT c1.topiaid from sandra.commande c1, sandra.commande c2 where c1.numero=c2.numero AND c1.topiaId!=c2.topiaId);");
        queries.add("DELETE FROM sandra.commande WHERE topiaId in (" +
                        "SELECT c1.topiaid from sandra.commande c1, sandra.commande c2 where c1.numero=c2.numero AND c1.topiaId!=c2.topiaId);");
        queries.add("DROP INDEX sandra.commande_key;");
        queries.add("CREATE UNIQUE INDEX commande_key ON sandra.commande(numero);");
        queries.add("DELETE FROM sandra.commande WHERE numero IS NULL;");
        queries.add("ALTER TABLE sandra.commande ALTER COLUMN numero SET NOT NULL;");

        // InfoChargement
        queries.add("DROP INDEX sandra.infochargement_key;");

        // LigneProduit
        queries.add("UPDATE sandra.ligneproduit SET infochargement=null WHERE commande IS NULL;");

        queries.add("UPDATE sandra.infochargement SET ligneproduit=null WHERE ligneproduit IN (" +
                "SELECT topiaid FROM sandra.ligneproduit WHERE commande IS NULL);");

        queries.add("DELETE FROM sandra.infochargement WHERE ligneproduit IN (" +
                        "SELECT topiaid FROM sandra.ligneproduit WHERE commande IS NULL);");

        queries.add("UPDATE sandra.suiviligneproduit SET ligneproduit=null WHERE ligneproduit IN (" +
                        "SELECT topiaid FROM sandra.ligneproduit WHERE commande IS NULL);");

        queries.add("DELETE FROM sandra.ligneproduit WHERE commande IS NULL;");
        queries.add("DROP INDEX sandra.ligneproduit_key;");
        queries.add("CREATE UNIQUE INDEX ligneproduit_key ON sandra.ligneproduit(ordre, commande);");
        queries.add("ALTER TABLE sandra.ligneproduit ALTER COLUMN ordre SET NOT NULL;");

        // Dont work on delete tour
        //queries.add("ALTER TABLE sandra.ligneproduit ALTER COLUMN commande SET NOT NULL;");

        // Usine
        queries.add("DROP INDEX sandra.usine_key;");
        queries.add("CREATE UNIQUE INDEX usine_key ON sandra.usine(code);");
        queries.add("ALTER TABLE sandra.usine ALTER COLUMN code SET NOT NULL;");

        // Eleveur
        queries.add("DROP INDEX sandra.eleveur_key;");
        queries.add("CREATE UNIQUE INDEX eleveur_key ON sandra.eleveur(code, societe);");
        queries.add("UPDATE sandra.etape SET eleveur=null WHERE eleveur IN (SELECT topiaid FROM sandra.eleveur WHERE code IS NULL);");
        queries.add("DELETE FROM sandra.eleveur WHERE code IS NULL;");
        queries.add("ALTER TABLE sandra.eleveur ALTER COLUMN code SET NOT NULL;");
        queries.add("ALTER TABLE sandra.eleveur ALTER COLUMN societe SET NOT NULL;");

        // Etape
        queries.add("DROP INDEX sandra.etape_key;");
        queries.add("CREATE INDEX etape_key ON sandra.etape(ordre, tour, eleveur);");
        queries.add("ALTER TABLE sandra.etape ALTER COLUMN ordre SET NOT NULL;");

        queries.add("DELETE FROM sandra.etape WHERE tour IS NULL;");

        // Dont work on delete tour
//        queries.add("ALTER TABLE sandra.etape ALTER COLUMN tour SET NOT NULL;");
        queries.add("UPDATE sandra.ligneproduit SET etape=null WHERE etape IN (" +
                        "SELECT topiaid FROM sandra.etape WHERE eleveur IS NULL);");

        queries.add("UPDATE sandra.ligneproduit SET infochargement=null WHERE etape IS NULL;");
        queries.add("DELETE FROM sandra.infochargement WHERE ligneproduit in (" +
                        "SELECT topiaid FROM sandra.ligneproduit WHERE etape IS NULL);");

        queries.add("UPDATE sandra.suiviligneproduit SET ligneproduit=null WHERE ligneproduit IN (" +
                        "SELECT topiaid FROM sandra.ligneproduit WHERE etape IS NULL);");

        queries.add("DELETE FROM sandra.ligneproduit WHERE etape IS NULL;");
        queries.add("UPDATE sandra.suivietape SET etape=null WHERE etape IN (SELECT topiaid FROM sandra.etape WHERE eleveur IS NULL);");
        queries.add("DELETE FROM sandra.etape WHERE eleveur IS NULL;");
        queries.add("ALTER TABLE sandra.etape ALTER COLUMN eleveur SET NOT NULL;");

        // Tour
        queries.add("DROP INDEX sandra.tour_key;");
        queries.add("CREATE INDEX tour_key ON sandra.tour(dateLivraison, numero, camion);");
        queries.add("DELETE FROM sandra.tour WHERE dateLivraison IS NULL;");
        queries.add("ALTER TABLE sandra.tour ALTER COLUMN dateLivraison SET NOT NULL;");
        queries.add("ALTER TABLE sandra.tour ALTER COLUMN numero SET NOT NULL;");
//        queries.add("ALTER TABLE sandra.tour ALTER COLUMN camion SET NOT NULL;");

        // suivis
        queries.add("UPDATE sandra.tour SET suivitour=null WHERE suivitour IN (" +
                        "SELECT topiaid FROM sandra.suivitour WHERE topiaid IN (" +
                            "SELECT suivitour FROM sandra.suivietape WHERE etape IS NULL));");

        queries.add("DELETE FROM sandra.suivietape WHERE etape IS NULL;");
        queries.add("UPDATE sandra.suiviusine SET suivitour=null WHERE suivitour IN (" +
                        "SELECT topiaid FROM sandra.suivitour st WHERE NOT EXISTS (" +
                            "SELECT suivitour FROM sandra.suivietape WHERE st.topiaid=suivitour));");

        queries.add("DELETE FROM sandra.suiviligneproduit WHERE suiviusine IN (" +
                        "SELECT topiaid FROM sandra.suiviusine WHERE suivitour IS NULL);");

        queries.add("DELETE FROM sandra.suiviusine WHERE suivitour IS NULL;");
        queries.add("UPDATE sandra.tour SET suivitour=null WHERE suivitour IN (" +
                        "SELECT topiaid FROM sandra.suivitour st WHERE NOT EXISTS (" +
                            "SELECT suivitour FROM sandra.suivietape WHERE st.topiaid=suivitour));");

        queries.add("DELETE FROM sandra.suivitour st WHERE NOT EXISTS (" +
                        "SELECT suivitour FROM sandra.suivietape WHERE st.topiaid=suivitour);");

//        TODO sletellier : dont work on delete suivitour
//        queries.add("ALTER TABLE sandra.suivietape ALTER COLUMN etape SET NOT NULL;");

        queries.add("DELETE FROM sandra.suivietape WHERE suivitour IS NULL;");

//        TODO sletellier : dont work on delete suivitour
//        queries.add("ALTER TABLE sandra.suivietape ALTER COLUMN suivitour SET NOT NULL;");

        queries.add("DELETE FROM sandra.suiviligneproduit WHERE ligneproduit IS NULL;");

//        TODO sletellier : dont work on delete suivitour
//        queries.add("ALTER TABLE sandra.suiviligneproduit ALTER COLUMN ligneproduit SET NOT NULL;");

//        TODO sletellier : dont work on delete suivitour
//        queries.add("ALTER TABLE sandra.suiviusine ALTER COLUMN suivitour SET NOT NULL;");
        queries.add("ALTER TABLE sandra.suiviusine ALTER COLUMN usine SET NOT NULL;");

        queries.add("DELETE FROM sandra.suiviligneproduit WHERE suiviusine IS NULL;");
//        TODO sletellier : dont work on delete suivitour
//        queries.add("ALTER TABLE sandra.suiviligneproduit ALTER COLUMN suiviusine SET NOT NULL;");
        queries.add("DELETE FROM sandra.crtour ct WHERE NOT EXISTS (" +
                        "SELECT crtour FROM sandra.suivitour WHERE ct.topiaid=crtour);");

        queries.add("DELETE FROM sandra.crusine cu WHERE NOT EXISTS (" +
                        "SELECT crusine FROM sandra.suiviusine WHERE cu.topiaid=crusine);");

        queries.add("DELETE FROM sandra.cretape ce WHERE NOT EXISTS (" +
                        "SELECT cretape FROM sandra.suivietape WHERE ce.topiaid=cretape);");

        queries.add("ALTER TABLE sandra.infochargement DROP COLUMN ligneproduit;");

        // foreign key index
        queries.add("DROP INDEX sandra.idx_Etape_produits;");
        queries.add("CREATE INDEX idx_Etape_produits ON sandra.ligneProduit(etape);");
        queries.add("DROP INDEX sandra.idx_InfoAccess_usersVerrouillage;");
        queries.add("CREATE INDEX idx_InfoAccess_usersVerrouillage ON sandra.infoaccess_usersverrouillage(infoAccess);");
        queries.add("DROP INDEX sandra.idx_Camion_camionsAssocies;");
        queries.add("CREATE INDEX idx_Camion_camionsAssocies ON sandra.camion(camion);");
        queries.add("DROP INDEX sandra.idx_Camion_defautChauffeurs;");
        queries.add("CREATE INDEX idx_Camion_defautChauffeurs ON sandra.camions_defautchauffeurs(camions);");
        queries.add("DROP INDEX sandra.idx_Queue_cron;");
        queries.add("CREATE INDEX idx_Queue_cron ON sandra.cron_queue(queue);");
        queries.add("DROP INDEX sandra.idx_SuiviUsine_suiviLigneProduit;");
        queries.add("CREATE INDEX idx_SuiviUsine_suiviLigneProduit ON sandra.suiviLigneProduit(suiviUsine);");
        queries.add("DROP INDEX sandra.idx_SuiviTour_suiviEtapes;");
        queries.add("CREATE INDEX idx_SuiviTour_suiviEtapes ON sandra.suiviEtape(suiviTour);");
        queries.add("DROP INDEX sandra.idx_SuiviTour_suiviUsines;");
        queries.add("CREATE INDEX idx_SuiviTour_suiviUsines ON sandra.suiviUsine(suiviTour);");
        queries.add("DROP INDEX sandra.idx_Chauffeur_camions;");
        queries.add("CREATE INDEX idx_Chauffeur_camions ON sandra.camions_defautchauffeurs(defautChauffeurs);");
        queries.add("DROP INDEX sandra.idx_TraceGPS_listePoints;");
        queries.add("CREATE INDEX idx_TraceGPS_listePoints ON sandra.pointGPS(traceGPS);");
        queries.add("DROP INDEX IF EXISTS sandra.idx_Tour_etapes;");
        queries.add("CREATE INDEX idx_Tour_etapes ON sandra.etape(tour);");
        queries.add("DROP INDEX sandra.idx_Eleveur_accesSilos;");
        queries.add("CREATE INDEX idx_Eleveur_accesSilos ON sandra.infoAccess(eleveur);");
        queries.add("DROP INDEX sandra.idx_Eleveur_notes;");
        queries.add("CREATE INDEX idx_Eleveur_notes ON sandra.note(eleveur);");
        queries.add("DROP INDEX sandra.idx_Eleveur_actionSecurite;");
        queries.add("CREATE INDEX idx_Eleveur_actionSecurite ON sandra.actionSecurite(eleveur);");

        queries.add("UPDATE sandra.taasuser SET password='c71c2c917503b09e8ec3d8af6936d3370d285351' WHERE login='admin';");
    }
}
