package com.cybelia.sandra.ibu.injector;

import com.cybelia.sandra.SandraDAOHelper;
import com.cybelia.sandra.entities.Societe;
import com.cybelia.sandra.entities.SocieteDAO;
import com.cybelia.sandra.ibu.csv.bean.Ibu;
import com.cybelia.sandra.ibu.csv.bean.IbuCamion;
import com.cybelia.sandra.ibu.csv.bean.IbuChauffeur;
import com.cybelia.sandra.ibu.csv.bean.IbuTransporteur;
import com.cybelia.sandra.ibu.manager.Injector;
import com.cybelia.sandra.ibu.manager.ManagerInjector;
import org.nuiton.topia.TopiaException;

public class InjectorSociete implements Injector {

    protected Societe societe;

    public Societe getObject() {
        return societe;
    }

    public void clear() {
        societe = null;
    }

    public void inject(ManagerInjector manager, Ibu ibu) throws TopiaException {
        SocieteDAO societeDAO = SandraDAOHelper.getSocieteDAO(manager.getTransaction());

        // Recherche
        societe = societeDAO.findByCode(ibu.getSocieteCode());

        // Création
        if (societe == null) {
            societe = societeDAO.createByNaturalId(ibu.getSocieteCode());
        }
    }

    public void inject(ManagerInjector manager, IbuCamion camion) throws TopiaException {
        SocieteDAO societeDAO = SandraDAOHelper.getSocieteDAO(manager.getTransaction());

        // Recherche
        societe = societeDAO.findByCode(camion.getSociete());

        // Création
        if (societe == null) {
            societe = societeDAO.createByNaturalId(camion.getSociete());
        }
    }

    public void inject(ManagerInjector manager, IbuChauffeur chauffeur) throws TopiaException {
        SocieteDAO societeDAO = SandraDAOHelper.getSocieteDAO(manager.getTransaction());

        // Recherche
        societe = societeDAO.findByCode(chauffeur.getSociete());

        // Création
        if (societe == null) {
            societe = societeDAO.createByNaturalId(chauffeur.getSociete());
        }
    }

    public void inject(ManagerInjector manager, IbuTransporteur transporteur) throws TopiaException {
        SocieteDAO societeDAO = SandraDAOHelper.getSocieteDAO(manager.getTransaction());

        // Recherche
        societe = societeDAO.findByCode(transporteur.getSociete());

        // Création
        if (societe == null) {
            societe = societeDAO.createByNaturalId(transporteur.getSociete());
        }
    }
}
