package com.cybelia.sandra.ibu.injector;

import com.cybelia.sandra.SandraDAOHelper;
import com.cybelia.sandra.entities.Camion;
import com.cybelia.sandra.entities.CamionDAO;
import com.cybelia.sandra.entities.Chauffeur;
import com.cybelia.sandra.entities.ChauffeurDAO;
import com.cybelia.sandra.ibu.csv.bean.Ibu;
import com.cybelia.sandra.ibu.csv.bean.IbuChauffeur;
import com.cybelia.sandra.ibu.manager.Injector;
import com.cybelia.sandra.ibu.manager.ManagerInjector;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.topia.TopiaException;

public class InjectorChauffeur implements Injector {

    protected Chauffeur chauffeur;

    public Chauffeur getObject() {
        return chauffeur;
    }

    public void clear() {
        chauffeur = null;
    }

    public void inject(ManagerInjector manager, Ibu ibu) throws TopiaException {
        ChauffeurDAO chauffeurDAO = SandraDAOHelper.getChauffeurDAO(manager.getTransaction());

        // Recherche
        chauffeur = chauffeurDAO.findByNaturalId(ibu.getChauffeurCode());

        // Création
        // Ibu don't create chauffeur any more : #352
//        if (chauffeur == null) {
//            chauffeur = chauffeurDAO.createByNaturalId(ibu.getChauffeurCode(), manager.getSociete());
//            chauffeur.setNom(ibu.getChauffeurNom());
//        }
    }

    public void inject(ManagerInjector manager, IbuChauffeur ibuChauffeur) throws TopiaException {
        ChauffeurDAO chauffeurDAO = SandraDAOHelper.getChauffeurDAO(manager.getTransaction());

        // Recherche
        chauffeur = chauffeurDAO.findByNaturalId(ibuChauffeur.getCode());

        // Création
        if (chauffeur == null) {
            chauffeur = chauffeurDAO.createByNaturalId(ibuChauffeur.getCode());
        }

        // Mise à jour
        chauffeur.setNom(ibuChauffeur.getNom());
        chauffeur.setPrenom(ibuChauffeur.getPrenom());
        chauffeur.setTrigramme(ibuChauffeur.getTrigramme());

        // Chauffeur par défaut
        addDefautChauffeur(manager, ibuChauffeur.getCamion1());
        addDefautChauffeur(manager, ibuChauffeur.getCamion2());
        addDefautChauffeur(manager, ibuChauffeur.getCamion3());
        addDefautChauffeur(manager, ibuChauffeur.getCamion4());
        addDefautChauffeur(manager, ibuChauffeur.getCamion5());
        addDefautChauffeur(manager, ibuChauffeur.getCamion6());
    }

    private void addDefautChauffeur(ManagerInjector manager, String camionCode) throws TopiaException {
        if (StringUtils.isNotEmpty(camionCode)) {
            CamionDAO camionDAO = SandraDAOHelper.getCamionDAO(manager.getTransaction());
            Camion camion = camionDAO.findByNaturalId(camionCode,
                                                      manager.getSociete());

            // FIXME : Enlever le test !!!!
            if (camion != null) {
                Collection<Chauffeur> defautChauffeurs = camion.getDefautChauffeurs();
                if (defautChauffeurs == null) {
                    defautChauffeurs = new ArrayList<Chauffeur>();
                    camion.setDefautChauffeurs(defautChauffeurs);
                }

                if (!defautChauffeurs.contains(chauffeur)) {
                    defautChauffeurs.add(chauffeur);
                }
            }
        }
    }
}
