package com.cybelia.sandra.ibu.csv.reader;

import com.cybelia.sandra.ibu.csv.CSVReaderGeneric;
import com.cybelia.sandra.ibu.csv.bean.Ibu;
import java.util.HashMap;
import java.util.Map;

/**
 * Permet de parser un fichier CSV et de récupérer les beans Ibu associés.
 *
 * @author julien
 */
public class CSVReaderIbu extends CSVReaderGeneric<Ibu> {

    protected void initStrategy() {
        strategy.setType(Ibu.class);

        Map<String, String> mapping = new HashMap<String, String>();
        strategy.setColumnMapping(mapping);
        mapping.put("CDE", "commandeCode");
        mapping.put(" CDL", "produitOrdre");
        mapping.put(" ETA_CDE", "commandeEtat");
        mapping.put(" DAT_CDE", "commandeDate");
        mapping.put(" OPE", "commandePreneurInitiale");
        mapping.put(" CLI_LIV", "eleveurAllCode");
        mapping.put(" RAI_SOC_LIV", "eleveurRaisonSociale");
        mapping.put(" ADR_LIV1", "eleveurAdresse");
        mapping.put(" ADR_LIV2", "eleveurVille");
        mapping.put(" DAT_LIV", "tourDateLivraison");
        mapping.put(" MOM_LIV", "commandeMoment");
        mapping.put(" RAI_SOC_CHA", "chauffeurNom");
        mapping.put(" CAM", "camionCode");
        mapping.put(" CAM_GROUP", "camionCodeSociete");
        mapping.put(" TOU ", "tourNumero");
        mapping.put(" USI", "usineCode");
        mapping.put(" ART", "produitCode");
        mapping.put(" ART_LIB", "produitLibelle");
        mapping.put(" CDL_MEL", "commandeLigneMelange"); // ?????
        mapping.put(" PRE", "produitPresentation");
        mapping.put(" CAP_UNI ", "produitCapaciteUnitaire");
        mapping.put(" ORD", "produitOrdonnance");
        mapping.put(" QTE_CDE", "produitQuantiteAChargee");
        mapping.put(" CMM_ART", "produitCommentaire");
        mapping.put(" QTE_LIV", "produitQuantiteLivree");
        mapping.put(" LIB_BAT", "siloNom"); // ?????
        mapping.put(" CMM_CLI", "eleveurCommentaire");
        mapping.put(" CMM_TOU", "commandeCommentaire");
        mapping.put(" TON_SAC", "commandeTonnageSacs");
        mapping.put(" COD_POS", "eleveurCodePostal");
        mapping.put(" TEL", "eleveurTelephone");
        mapping.put(" RAI_SOC_FAC", "eleveurFactureRaisonSociale");
        mapping.put(" ETAT", "commandeLigneEtat");
        mapping.put(" CHA", "chauffeurCode");
        mapping.put(" IMM", "camionImmatriculation");
        mapping.put(" STE", "societeCode");
        mapping.put(" DAT_ENV", "commandeEnvoi");
        mapping.put(" DAT_TRAIT", "commandeTraite");
        mapping.put(" GSM", "eleveurMobile");
        mapping.put(" NOM_COM", "eleveurCommune");
        mapping.put(" COM", "eleveurCommuneCode");
        mapping.put(" TIE_LIV", "eleveurCode");
        mapping.put(" CMM_LOG", "tourCommentaire");
        mapping.put(" CPL_RAI_SOC_LIV", "eleveurRaisonSocialeComplement");
        mapping.put(" CPL_RAI_SOC_FAC", "eleveurFactureRaisonSocialeComplement");
        mapping.put(" DAT_CHR", "tourChargement");
        mapping.put(" TOU_ORDR", "produitOrdreChargement");
        mapping.put(" SIL_CLI", "produitSilo");
        mapping.put(" CDT", "produitConditionnement");
        mapping.put(" QTE_UNI", "produitQuantiteUnitaire");
        mapping.put(" QTE_CMD", "produitQuantiteCommandee");
        mapping.put(" ACC_VEH", "produitAcces");
        mapping.put(" MAT", "produitEquipement");
        mapping.put(" CASES", "chargementCompartiments");
        mapping.put(" SECURITE", "eleveurSecurite");
        mapping.put(" MAIL", "eleveurMail");
        mapping.put(" DAT_CHR_REEL", "chargementDate");
    }
}
