package com.cybelia.sandra.ibu.csv;

import java.beans.PropertyEditorSupport;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

/**
 * Permet la conversion des chaînes de type date en objet de type date.
 * Utiliser pendant la lecture du csv pour la création des beans.
 *
 * @author julien
 */
public class DatePropertyEditor extends PropertyEditorSupport {

    public String getAsText() {
        Date d = (Date) getValue();
        if (d == null) {
            return "No Date Set";
        }
        return new SimpleDateFormat("dd/MM/yyyy hh:mm", Locale.FRANCE).format(d);
    }

    public void setAsText(String s) {
        try {
            // Test pour savoir si il y à l'heure
            if (s.length() <= 10) {
                setValue(new SimpleDateFormat("dd/MM/yyyy", Locale.FRANCE).parse(s));
            } else {
                setValue(new SimpleDateFormat("dd/MM/yyyy hh:mm", Locale.FRANCE).parse(s));
            }
        } catch (ParseException pe) {
            IllegalArgumentException iae = new IllegalArgumentException("Could not parse date");
            throw iae;
        }
    }
}
