/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra.security;

import com.cybelia.sandra.security.Filter;
import com.cybelia.sandra.security.FilterManagerProfil;
import com.cybelia.sandra.security.NotifierSecurityHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.exception.SQLGrammarException;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaNotFoundException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaId;
import org.nuiton.topia.taas.entities.TaasUser;

public class NotifierProfilManager {
    private static Log log = LogFactory.getLog(NotifierProfilManager.class);

    public static TopiaEntity getTopiaEntity(TopiaContext transaction, TaasUser user, String topiaId) throws TopiaNotFoundException, TopiaException {
        Class klass = TopiaId.getClassName((String)topiaId);
        String alias = StringUtils.uncapitalize((String)klass.getSimpleName().replace("Taas", ""));
        String hql = "SELECT " + alias + " FROM " + klass.getName() + " " + alias + " WHERE " + alias + ".topiaId = :topiaId";
        List result = NotifierProfilManager.find(transaction, (Class<? extends TopiaEntity>)klass, user, hql, "topiaId", topiaId);
        TopiaEntity entity = null;
        if (result != null && !result.isEmpty()) {
            entity = (TopiaEntity)result.get(0);
        }
        return entity;
    }

    public static <T> List<T> find(TopiaContext context, Class<? extends TopiaEntity> classSearch, TaasUser user, String query, Object ... args) throws TopiaException {
        return NotifierProfilManager.find(context, classSearch, user, query, -1, -1, args);
    }

    public static <T> List<T> find(TopiaContext context, Class<? extends TopiaEntity> classSearch, TaasUser user, String query, int startIndex, int endIndex, Object ... args) throws TopiaException {
        Object[] authorizations = NotifierSecurityHelper.getAuthorizations(user);
        if (authorizations.length > 0) {
            String autorizations;
            ArrayList<Object> argsList = new ArrayList<Object>(Arrays.asList(args));
            String queryFilter = query;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Authorizations : " + Arrays.toString(authorizations)));
            }
            if (!(autorizations = authorizations[0]).equals("*")) {
                Class classProfil = TopiaId.getClassName((String)autorizations);
                Filter filter = FilterManagerProfil.getFilter(classSearch, classProfil);
                queryFilter = filter.addFilter(query);
                NotifierProfilManager.addParametersForFilter(filter, argsList, user, (String[])authorizations);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("queryFilter : " + queryFilter));
            }
            List result = null;
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Execute final query : " + queryFilter));
                }
                result = startIndex != -1 && endIndex != -1 ? context.find(queryFilter, startIndex, endIndex, argsList.toArray()) : context.find(queryFilter, argsList.toArray());
            }
            catch (TopiaException ex) {
                Throwable cause = ex.getCause();
                if (cause instanceof SQLGrammarException && log.isErrorEnabled()) {
                    log.error((Object)("SQL executed with error : " + ((SQLGrammarException)cause).getSQL()));
                }
                log.error((Object)"TopiaException ", (Throwable)ex);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Query filter result : " + result));
            }
            return result;
        }
        return null;
    }

    protected static void addParametersForFilter(Filter filter, List<Object> argsList, TaasUser user, String[] authorizations) {
        if (filter.needParameter(FilterManagerProfil.PARAM_PROFIL)) {
            argsList.add(FilterManagerProfil.PARAM_PROFIL_NAME);
            argsList.add(authorizations);
        }
        if (filter.needParameter(FilterManagerProfil.PARAM_DATE_PREVIOUS_8)) {
            argsList.add(FilterManagerProfil.PARAM_DATE_PREVIOUS_8_NAME);
            Calendar calendar = Calendar.getInstance();
            calendar.add(6, -8);
            argsList.add(calendar.getTime());
        }
        if (filter.needParameter(FilterManagerProfil.PARAM_USER)) {
            argsList.add(FilterManagerProfil.PARAM_USER_NAME);
            argsList.add(user.getTopiaId());
        }
    }
}

