/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra.notifier;

import com.cybelia.sandra.entities.Eleveur;
import com.cybelia.sandra.entities.InfoAccess;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TemplateHelper {
    protected static final Log log = LogFactory.getLog(TemplateHelper.class);

    public String extractRisques(Map<String, String> lbl, Eleveur eleveur) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Find risques for breeder '" + eleveur.getRaisonSociale()));
        }
        HashSet<String> allRisque = new HashSet<String>();
        Collection<String> risques = this.extractRsk(eleveur.getAccesEleveur());
        allRisque.addAll(risques);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Acces eleveur risques : " + Arrays.toString(allRisque.toArray())));
        }
        for (InfoAccess silo : eleveur.getActiveAccesSilo()) {
            Collection<String> risquesSilo = this.extractRsk(silo);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Silo riques : " + Arrays.toString(risquesSilo.toArray())));
            }
            allRisque.addAll(risquesSilo);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Final breeder riques : " + Arrays.toString(allRisque.toArray())));
        }
        HashSet<String> allRsk = new HashSet<String>();
        for (String risque : allRisque) {
            allRsk.add(lbl.get("RSK-" + risque));
        }
        String rsks = StringUtils.join(allRsk, (String)", ");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Final risques found : " + rsks));
        }
        return rsks;
    }

    protected Collection<String> extractRsk(InfoAccess ia) {
        return ia.getRisques();
    }
}

