/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra.notifier;

import com.cybelia.sandra.entities.notifier.Cron;
import com.cybelia.sandra.notifier.SandraNotifier;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;

public class NotifierManager {
    protected static final Log log = LogFactory.getLog(NotifierManager.class);
    protected static NotifierManager manager;
    protected Scheduler scheduler;

    protected NotifierManager() {
    }

    public static NotifierManager getManager() {
        if (manager == null) {
            manager = new NotifierManager();
        }
        return manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(TopiaContext transaction) {
        try {
            if (this.scheduler == null) {
                this.scheduler = StdSchedulerFactory.getDefaultScheduler();
                String hql = "SELECT cron from " + Cron.class.getName() + " cron WHERE " + "cron.enable = :enable AND " + "cron.expression IS NOT NULL AND " + "cron.expression != '' AND " + "(cron.dateStart IS NULL OR cron.dateStart >= :date) AND " + "(cron.dateEnd IS NULL OR cron.dateEnd <= :date)";
                List crons = transaction.find(hql, new Object[]{"enable", true, "date", new Date()});
                for (Cron cron : crons) {
                    this.del(cron);
                    this.addCron(cron);
                }
                log.info((Object)"Notifier started.");
            }
        }
        catch (Exception eee) {
            log.error((Object)"Starting failed", (Throwable)eee);
        }
        finally {
            if (transaction != null && !transaction.isClosed()) {
                try {
                    transaction.commitTransaction();
                    transaction.closeContext();
                }
                catch (TopiaException eee) {
                    log.error((Object)"Failed to close transaction", (Throwable)eee);
                }
            }
        }
    }

    public void stop() {
        try {
            this.scheduler.shutdown();
            log.info((Object)"Notifier stoped.");
        }
        catch (Exception e) {
            log.error((Object)"Stoping failed", (Throwable)e);
        }
    }

    public void add(Cron cron) {
        try {
            boolean enable = cron.getEnable();
            String expression = cron.getExpression();
            if (enable && expression != null && !"".equals(expression)) {
                this.addCron(cron);
            }
        }
        catch (Exception e) {
            log.error((Object)"Adding failed", (Throwable)e);
        }
    }

    public void del(Cron cron) {
        try {
            boolean result = this.scheduler.deleteJob(cron.getLabel(), "DEFAULT");
            if (result) {
                log.info((Object)("Deleted cron : " + cron.getLabel()));
            } else {
                log.info((Object)("Failed delete cron : " + cron.getLabel()));
            }
        }
        catch (Exception e) {
            log.error((Object)"Deleting failed", (Throwable)e);
        }
    }

    protected void addCron(Cron cron) throws Exception {
        CronTrigger cronTrigger = new CronTrigger(cron.getLabel(), "DEFAULT", cron.getLabel(), "DEFAULT", cron.getDateStart(), cron.getDateEnd(), cron.getExpression());
        JobDetail jobDetail = new JobDetail(cron.getLabel(), "DEFAULT", NotifierJob.class);
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put("cronTopiaId", cron.getTopiaId());
        jobDetail.setJobDataMap(jobDataMap);
        this.scheduler.scheduleJob(jobDetail, (Trigger)cronTrigger);
        log.info((Object)("Added cron : " + cron.getLabel()));
    }

    public static class NotifierJob
    implements Job {
        public void execute(JobExecutionContext context) throws JobExecutionException {
            JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
            String cronTopiaId = jobDataMap.getString("cronTopiaId");
            try {
                log.info((Object)("Notify cron " + cronTopiaId));
                new SandraNotifier().notifyCron(cronTopiaId);
            }
            catch (TopiaException te) {
                log.error((Object)"Error in notification", (Throwable)te);
                new JobExecutionException((Throwable)te, true);
            }
        }
    }
}

