/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra.ibu.manager;

import com.cybelia.sandra.SandraDAOHelper;
import com.cybelia.sandra.entities.TourTypeModif;
import com.cybelia.sandra.entities.synchro.Log;
import com.cybelia.sandra.entities.synchro.LogDAO;
import java.math.BigInteger;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public class SynchNumberManager {
    protected static final org.apache.commons.logging.Log log = LogFactory.getLog(SynchNumberManager.class);

    public static Long getNextSynchroNumber(TopiaContext transaction) throws TopiaException {
        BigInteger resultInt = (BigInteger)((TopiaContextImpl)transaction).getHibernate().createSQLQuery("SELECT nextval('sandra.synchNumber')").uniqueResult();
        return resultInt.longValue();
    }

    public static Long getCurrentSynchroNumber(TopiaContext transaction) throws TopiaException {
        BigInteger resultInt = (BigInteger)((TopiaContextImpl)transaction).getHibernate().createSQLQuery("SELECT last_value FROM sandra.synchnumber").uniqueResult();
        return resultInt.longValue();
    }

    public static void notifyTourChange(TopiaContext transaction, String tourTopiaId, String camionTopiaId, int typeModif) throws TopiaException {
        LogDAO logDAO = SandraDAOHelper.getLogDAO((TopiaContext)transaction);
        Log log = logDAO.findByTourTopiaID(tourTopiaId);
        if (log == null) {
            log = (Log)logDAO.create(new Object[]{"tourTopiaID", tourTopiaId});
        }
        if (log.getTypeModif() != TourTypeModif.SUPPR) {
            log.setCamionTopiaID(camionTopiaId);
            log.setTypeModif(typeModif);
            SynchNumberManager.saveLog(transaction, log);
        }
    }

    public static void saveLog(TopiaContext transaction, Log logToSave) throws TopiaException {
        SynchNumberManager.saveLog(transaction, null, logToSave);
    }

    public static void saveLog(TopiaContext transaction, String fileName, Log logToSave) throws TopiaException {
        LogDAO logDAO = SandraDAOHelper.getLogDAO((TopiaContext)transaction);
        if (StringUtils.isNotEmpty((String)fileName)) {
            logToSave.setFichierSynchro(fileName);
        }
        logToSave.setTimeStamp(System.currentTimeMillis());
        long syncNum = SynchNumberManager.getNextSynchroNumber(transaction);
        logToSave.setSynchroNumber(syncNum);
        logDAO.update((TopiaEntity)logToSave);
        if (log.isDebugEnabled()) {
            log.debug((Object)("[ManagerInjector] Saving log type " + logToSave.getTypeModif() + " for tour " + logToSave.getTourTopiaID() + " camion : " + logToSave.getCamionTopiaID() + " with synch number : " + logToSave.getSynchroNumber() + " and timstamp : " + logToSave.getTimeStamp()));
        }
    }
}

