/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra.ibu.injector;

import com.cybelia.sandra.SandraDAOHelper;
import com.cybelia.sandra.entities.Tour;
import com.cybelia.sandra.entities.TourDAO;
import com.cybelia.sandra.entities.TourTypeModif;
import com.cybelia.sandra.ibu.csv.bean.Ibu;
import com.cybelia.sandra.ibu.manager.Injector;
import com.cybelia.sandra.ibu.manager.ManagerInjector;
import com.cybelia.sandra.ibu.manager.SynchNumberManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;

public class InjectorTour
implements Injector {
    private final Log log = LogFactory.getLog(InjectorTour.class);
    protected Tour tour;

    public Tour getObject() {
        return this.tour;
    }

    @Override
    public void clear() {
        this.tour = null;
    }

    @Override
    public void inject(ManagerInjector manager, Ibu ibu) throws TopiaException {
        TourDAO tourDAO = SandraDAOHelper.getTourDAO((TopiaContext)manager.getTransaction());
        this.tour = (Tour)tourDAO.findByProperties("dateLivraison", (Object)ibu.getTourDateLivraison(), new Object[]{"numero", ibu.getTourNumero(), "camion", manager.getCamion()});
        if (this.tour == null) {
            this.tour = (Tour)tourDAO.create(new Object[0]);
            this.tour.setDateLivraison(ibu.getTourDateLivraison());
            this.tour.setNumero(ibu.getTourNumero());
            this.tour.setCamion(manager.getCamion());
            SynchNumberManager.notifyTourChange(manager.getTransaction(), this.tour.getTopiaId(), manager.getCamion().getTopiaId(), TourTypeModif.CREATE);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("[InjectorTour] Creating create log for tour : " + this.tour.getTopiaId() + " and camion : " + manager.getCamion().getTopiaId()));
            }
        } else {
            boolean modif = false;
            if (this.tour.getCommentaire() == null && ibu.getTourCommentaire() != null || !this.tour.getCommentaire().equals(ibu.getTourCommentaire())) {
                modif = true;
            }
            if (this.tour.getDefautChauffeur() == null && manager.getChauffeur() != null || !this.tour.getDefautChauffeur().equals(manager.getChauffeur())) {
                modif = true;
            }
            if (manager.isCommandeCreated()) {
                modif = true;
            }
            if (modif) {
                SynchNumberManager.notifyTourChange(manager.getTransaction(), this.tour.getTopiaId(), manager.getCamion().getTopiaId(), TourTypeModif.MODIF);
            }
        }
        this.tour.setCommentaire(ibu.getTourCommentaire());
        this.tour.setDefautChauffeur(manager.getChauffeur());
        this.tour.setDateChargement(ibu.getTourChargement());
    }
}

