/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra.ibu.injector;

import com.cybelia.sandra.SandraDAOHelper;
import com.cybelia.sandra.entities.Camion;
import com.cybelia.sandra.entities.Etape;
import com.cybelia.sandra.entities.LigneProduit;
import com.cybelia.sandra.entities.LigneProduitDAO;
import com.cybelia.sandra.entities.Tour;
import com.cybelia.sandra.entities.TourTypeModif;
import com.cybelia.sandra.entities.trace.CREtape;
import com.cybelia.sandra.entities.trace.CREtapeDAO;
import com.cybelia.sandra.entities.trace.CRTour;
import com.cybelia.sandra.entities.trace.CRTourDAO;
import com.cybelia.sandra.entities.trace.CRUsine;
import com.cybelia.sandra.entities.trace.CRUsineDAO;
import com.cybelia.sandra.entities.trace.SuiviEtape;
import com.cybelia.sandra.entities.trace.SuiviEtapeDAO;
import com.cybelia.sandra.entities.trace.SuiviLigneProduit;
import com.cybelia.sandra.entities.trace.SuiviLigneProduitDAO;
import com.cybelia.sandra.entities.trace.SuiviTour;
import com.cybelia.sandra.entities.trace.SuiviTourDAO;
import com.cybelia.sandra.entities.trace.SuiviUsine;
import com.cybelia.sandra.entities.trace.SuiviUsineDAO;
import com.cybelia.sandra.ibu.csv.bean.Ibu;
import com.cybelia.sandra.ibu.manager.Injector;
import com.cybelia.sandra.ibu.manager.ManagerInjector;
import com.cybelia.sandra.ibu.manager.SynchNumberManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;

public class InjectorLigneProduit
implements Injector {
    private final Log log = LogFactory.getLog(InjectorLigneProduit.class);
    protected LigneProduit ligneProduit;
    protected boolean commandeCommentaireIsModif = false;

    public LigneProduit getObject() {
        return this.ligneProduit;
    }

    @Override
    public void clear() {
        this.ligneProduit = null;
        this.commandeCommentaireIsModif = false;
    }

    @Override
    public void inject(ManagerInjector manager, Ibu ibu) throws TopiaException {
        LigneProduitDAO ligneProduitDAO = SandraDAOHelper.getLigneProduitDAO((TopiaContext)manager.getTransaction());
        this.ligneProduit = (LigneProduit)ligneProduitDAO.findByProperties("ordre", (Object)ibu.getProduitOrdre(), new Object[]{"commande", manager.getCommande()});
        this.deleteSuiviTour(manager, manager.getTour());
        if (this.ligneProduit == null) {
            this.ligneProduit = (LigneProduit)ligneProduitDAO.create(new Object[0]);
            this.ligneProduit.setOrdre(ibu.getProduitOrdre());
            this.ligneProduit.setCommande(manager.getCommande());
        } else {
            boolean nomSiloChanged;
            Etape etape = this.ligneProduit.getEtape();
            Tour tour = etape.getTour();
            Camion camion = tour.getCamion();
            String camionSocieteCode = camion.getSociete().getCode() + "-" + camion.getCode();
            if (tour.getNumero() != ibu.getTourNumero() || tour.getDateLivraison().getTime() != ibu.getTourDateLivraison().getTime() || !camionSocieteCode.equals(ibu.getCamionCodeSociete()) || !etape.getTopiaId().equals(manager.getEtape().getTopiaId()) || etape.getOrdre() != manager.getEtape().getOrdre()) {
                String tourTopiaId = tour.getTopiaId();
                SynchNumberManager.notifyTourChange(manager.getTransaction(), tourTopiaId, camion.getTopiaId(), TourTypeModif.MODIF);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("[InjectorLigneProduit] Adding modif log for tour " + tourTopiaId + " for camion " + camion.getTopiaId()));
                }
                this.deleteSuiviTour(manager, tour);
                etape.removeProduits(this.ligneProduit);
                if (!etape.equals(manager.getEtape()) && etape.getProduits().isEmpty()) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Suppression de l'\u00e9tape n\u00b0 " + etape.getOrdre() + " pour le tour n\u00b0" + tour.getNumero() + " pour une date de livraison le " + tour.getDateLivraison() + " pour le camion " + camion.getSociete().getCode() + "-" + camion.getCode()));
                    }
                    SandraDAOHelper.getEtapeDAO((TopiaContext)manager.getTransaction()).delete(etape);
                    tour.removeEtapes(etape);
                    if (tour.getEtapes().isEmpty()) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("Suppression du tour n\u00b0" + tour.getNumero() + " pour une date de livraison le " + tour.getDateLivraison() + " pour le camion " + camion.getSociete().getCode() + "-" + camion.getCode()));
                        }
                        SandraDAOHelper.getTourDAO((TopiaContext)manager.getTransaction()).delete(tour);
                        SynchNumberManager.notifyTourChange(manager.getTransaction(), tourTopiaId, camion.getTopiaId(), TourTypeModif.SUPPR);
                    }
                }
            }
            boolean bl = nomSiloChanged = this.ligneProduit.getSilo() == null && ibu.getProduitSilo() != null || ibu.getProduitSilo() == null || !ibu.getProduitSilo().equals(this.ligneProduit.getSilo().getNomAcces());
            if (nomSiloChanged || this.ligneProduit.getQuantiteACharger() != ibu.getProduitQuantiteAChargee() || this.ligneProduit.getQuantiteCommandee() != ibu.getProduitQuantiteCommandee() || !this.ligneProduit.getCode().equals(ibu.getProduitCode()) || this.commandeCommentaireIsModif) {
                SynchNumberManager.notifyTourChange(manager.getTransaction(), tour.getTopiaId(), camion.getTopiaId(), TourTypeModif.MODIF);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("[InjectorLigneProduit] Adding modif log for tour " + tour.getTopiaId() + " for camion " + camion.getTopiaId()));
                }
            }
        }
        this.ligneProduit.setCode(ibu.getProduitCode());
        this.ligneProduit.setLibelle(ibu.getProduitLibelle());
        this.ligneProduit.setPresentation(ibu.getProduitPresentation());
        this.ligneProduit.setConditionnement(ibu.getProduitConditionnement());
        this.ligneProduit.setCapaciteUnitaire(ibu.getProduitCapaciteUnitaire());
        this.ligneProduit.setQuantiteACharger(ibu.getProduitQuantiteAChargee());
        this.ligneProduit.setMedicament(ibu.getProduitOrdonnance() != 0);
        this.ligneProduit.setCommentaire(ibu.getProduitCommentaire());
        this.ligneProduit.setSilo(manager.getSilo());
        this.ligneProduit.setUsine(manager.getUsine());
        this.ligneProduit.setQuantiteCommandee(ibu.getProduitQuantiteCommandee());
        this.ligneProduit.setAcces(ibu.getProduitAcces());
        this.ligneProduit.setEquipement(ibu.getProduitEquipement());
        this.ligneProduit.setEtape(manager.getEtape());
        manager.getEtape().addProduits(this.ligneProduit);
    }

    protected void deleteSuiviTour(ManagerInjector manager, Tour tour) throws TopiaException {
        SuiviTour suiviTour = tour.getSuiviTour();
        Camion camion = tour.getCamion();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Suppression des suivis pour le tour n\u00b0" + tour.getNumero() + " pour une date de livraison le " + tour.getDateLivraison() + " pour le camion " + camion.getSociete().getCode() + "-" + camion.getCode()));
        }
        if (suiviTour != null) {
            CREtape cr;
            CREtapeDAO crEtapeDAO = SandraDAOHelper.getCREtapeDAO((TopiaContext)manager.getTransaction());
            SuiviEtapeDAO suiviEtapeDAO = SandraDAOHelper.getSuiviEtapeDAO((TopiaContext)manager.getTransaction());
            SuiviLigneProduitDAO suiviLigneProduitDAO = SandraDAOHelper.getSuiviLigneProduitDAO((TopiaContext)manager.getTransaction());
            SuiviUsineDAO suiviUsineDAO = SandraDAOHelper.getSuiviUsineDAO((TopiaContext)manager.getTransaction());
            CRUsineDAO crUsineDAO = SandraDAOHelper.getCRUsineDAO((TopiaContext)manager.getTransaction());
            CRTourDAO crTourDAO = SandraDAOHelper.getCRTourDAO((TopiaContext)manager.getTransaction());
            SuiviTourDAO suiviTourDAO = SandraDAOHelper.getSuiviTourDAO((TopiaContext)manager.getTransaction());
            for (SuiviEtape suiviEtape : suiviTour.getSuiviEtapes()) {
                cr = suiviEtape.getCREtape();
                if (cr != null) {
                    crEtapeDAO.delete(cr);
                }
                suiviEtapeDAO.delete((TopiaEntity)suiviEtape);
            }
            for (SuiviUsine suiviUsine : suiviTour.getSuiviUsines()) {
                for (SuiviLigneProduit suiviLigneProduit : suiviUsine.getSuiviLigneProduit()) {
                    suiviLigneProduitDAO.delete((TopiaEntity)suiviLigneProduit);
                }
                cr = suiviUsine.getCRUsine();
                if (cr != null) {
                    crUsineDAO.delete((CRUsine)cr);
                }
                suiviUsineDAO.delete((TopiaEntity)suiviUsine);
            }
            CRTour cr2 = suiviTour.getCRTour();
            if (cr2 != null) {
                crTourDAO.delete(cr2);
            }
            suiviTourDAO.delete(suiviTour);
        }
    }

    public void setCommandeCommentaireIsModif(boolean commandeCommentaireIsModif) {
        this.commandeCommentaireIsModif = commandeCommentaireIsModif;
    }
}

