/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra.ibu.injector;

import com.cybelia.sandra.SandraDAOHelper;
import com.cybelia.sandra.entities.ActionSecurite;
import com.cybelia.sandra.entities.ActionSecuriteDAO;
import com.cybelia.sandra.entities.Eleveur;
import com.cybelia.sandra.entities.EleveurDAO;
import com.cybelia.sandra.entities.EleveursDoublons;
import com.cybelia.sandra.entities.EleveursDoublonsDAO;
import com.cybelia.sandra.entities.Etape;
import com.cybelia.sandra.entities.EtapeDAO;
import com.cybelia.sandra.entities.InfoAccess;
import com.cybelia.sandra.entities.InfoAccessDAO;
import com.cybelia.sandra.entities.InfoAccessEtat;
import com.cybelia.sandra.entities.Note;
import com.cybelia.sandra.entities.NoteDAO;
import com.cybelia.sandra.entities.Societe;
import com.cybelia.sandra.entities.SocieteDAO;
import com.cybelia.sandra.entities.Tour;
import com.cybelia.sandra.entities.TourTypeModif;
import com.cybelia.sandra.ibu.csv.bean.Ibu;
import com.cybelia.sandra.ibu.csv.bean.IbuEleveurDuplicated;
import com.cybelia.sandra.ibu.manager.Injector;
import com.cybelia.sandra.ibu.manager.ManagerInjector;
import com.cybelia.sandra.ibu.manager.SynchNumberManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;

public class InjectorEleveurDuplicated
implements Injector {
    protected static final Log log = LogFactory.getLog(InjectorEleveurDuplicated.class);

    @Override
    public Object getObject() {
        return null;
    }

    @Override
    public void clear() {
    }

    @Override
    public void inject(ManagerInjector manager, Ibu ibu) throws TopiaException {
    }

    public void inject(ManagerInjector manager, IbuEleveurDuplicated ibu) throws TopiaException {
        SocieteDAO societeDAO = SandraDAOHelper.getSocieteDAO((TopiaContext)manager.getTransaction());
        EleveurDAO eleveurDAO = SandraDAOHelper.getEleveurDAO((TopiaContext)manager.getTransaction());
        Societe societeNew = societeDAO.findByCode(ibu.getCodeSocieteNew());
        Societe societeOld = societeDAO.findByCode(ibu.getCodeSocieteOld());
        if (societeNew != null && societeOld != null) {
            Eleveur eleveurNew = (Eleveur)eleveurDAO.findByProperties("code", (Object)ibu.getCodeEleveurNew(), new Object[]{"societe", societeNew});
            Eleveur eleveurOld = (Eleveur)eleveurDAO.findByProperties("code", (Object)ibu.getCodeEleveurOld(), new Object[]{"societe", societeOld});
            InjectorEleveurDuplicated.registerBreederAsDuplicated(manager.getTransaction(), eleveurNew.getTopiaId(), eleveurOld.getTopiaId(), false);
        } else {
            String codeSocieteError = ibu.getCodeSocieteNew();
            if (societeOld == null) {
                codeSocieteError = ibu.getCodeSocieteOld();
            }
            log.warn((Object)("Societe '" + codeSocieteError + "' not found"));
        }
    }

    public static Eleveur registerBreederAsDuplicated(TopiaContext transaction, String eleveurId, String eleveurDuplicatedId, boolean merge) throws TopiaException {
        if (eleveurId == null) {
            return null;
        }
        EleveurDAO eleveurDAO = SandraDAOHelper.getEleveurDAO((TopiaContext)transaction);
        Eleveur eleveur = (Eleveur)eleveurDAO.findByTopiaId(eleveurId);
        Eleveur eleveurDuplicated = (Eleveur)eleveurDAO.findByTopiaId(eleveurDuplicatedId);
        log.info((Object)("registerBreederAsDuplicated old : " + eleveurDuplicated.getNom() + " new : " + eleveur.getNom()));
        EleveursDoublonsDAO eleveursDoublonsDAO = SandraDAOHelper.getEleveursDoublonsDAO((TopiaContext)transaction);
        EleveursDoublons eleveursDoublons = (EleveursDoublons)eleveursDoublonsDAO.create(new Object[]{"codeSocieteOld", eleveurDuplicated.getSociete().getCode(), "codeEleveurOld", eleveurDuplicated.getCode(), "codeSocieteNew", eleveur.getSociete().getCode(), "codeEleveurNew", eleveur.getCode()});
        eleveursDoublonsDAO.update((TopiaEntity)eleveursDoublons);
        NoteDAO noteDAO = SandraDAOHelper.getNoteDAO((TopiaContext)transaction);
        ActionSecuriteDAO actionSecuriteDAO = SandraDAOHelper.getActionSecuriteDAO((TopiaContext)transaction);
        if (merge) {
            Collection actionSecuritesFromBean;
            ArrayList accesSilosDuplicated = new ArrayList(eleveurDuplicated.getActiveAccesSilo());
            eleveurDuplicated.clearAccesSilos();
            eleveur.addAllAccesSilos(accesSilosDuplicated);
            for (InfoAccess siloDuplicated : accesSilosDuplicated) {
                siloDuplicated.setEleveur(eleveur);
                SandraDAOHelper.getInfoAccessDAO((TopiaContext)transaction).update((TopiaEntity)siloDuplicated);
            }
            Collection notesFromBean = eleveurDuplicated.getNotes();
            if (notesFromBean != null) {
                ArrayList notes = new ArrayList(notesFromBean);
                eleveurDuplicated.clearNotes();
                eleveur.addAllNotes(notes);
                for (Note noteDuplicated : notes) {
                    noteDuplicated.setEleveur(eleveur);
                    noteDAO.update((TopiaEntity)noteDuplicated);
                }
            }
            if ((actionSecuritesFromBean = eleveurDuplicated.getActionSecurite()) != null) {
                ArrayList actionSecurites = new ArrayList(actionSecuritesFromBean);
                eleveurDuplicated.clearActionSecurite();
                eleveur.addAllActionSecurite(actionSecurites);
                for (ActionSecurite actionSecuriteDuplicated : actionSecurites) {
                    actionSecuriteDuplicated.setEleveur(eleveur);
                    actionSecuriteDAO.update((TopiaEntity)actionSecuriteDuplicated);
                }
            }
            eleveur = (Eleveur)eleveurDAO.update((TopiaEntity)eleveur);
        } else {
            Collection accesSilos = eleveurDuplicated.getActiveAccesSilo();
            for (InfoAccess silo : accesSilos) {
                Collection actionSecurites;
                InjectorEleveurDuplicated.deleteAccesSilo(transaction, silo.getTopiaId());
                Collection notes = eleveur.getNotes();
                if (notes != null) {
                    for (Note note : notes) {
                        noteDAO.delete((TopiaEntity)note);
                    }
                }
                if ((actionSecurites = eleveur.getActionSecurite()) == null) continue;
                for (ActionSecurite actionSecurite : actionSecurites) {
                    actionSecuriteDAO.delete((TopiaEntity)actionSecurite);
                }
            }
        }
        EtapeDAO etapeDAO = SandraDAOHelper.getEtapeDAO((TopiaContext)transaction);
        List etapesConcerned = etapeDAO.findAllByEleveur(eleveurDuplicated);
        for (Etape etape : etapesConcerned) {
            etape.setEleveur(eleveur);
            etapeDAO.update((TopiaEntity)etape);
            Tour tour = etape.getTour();
            SynchNumberManager.notifyTourChange(transaction, tour.getTopiaId(), tour.getCamion().getTopiaId(), TourTypeModif.MODIF);
        }
        eleveurDAO.delete(eleveurDuplicated);
        return eleveur;
    }

    public static void deleteAccesSilo(TopiaContext transaction, String infoAccessTopiaId) throws TopiaException {
        if (log.isInfoEnabled()) {
            log.info((Object)("deleteAccesSilo " + infoAccessTopiaId));
        }
        InfoAccessDAO dao = SandraDAOHelper.getInfoAccessDAO((TopiaContext)transaction);
        InfoAccess infoAccess2 = (InfoAccess)dao.findByTopiaId(infoAccessTopiaId);
        infoAccess2.setEtat(InfoAccessEtat.INFOACCESS_SUPPR);
        dao.update((TopiaEntity)infoAccess2);
    }
}

