/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra.ibu.injector;

import com.cybelia.sandra.SandraDAOHelper;
import com.cybelia.sandra.entities.Eleveur;
import com.cybelia.sandra.entities.EleveurDAO;
import com.cybelia.sandra.entities.InfoAccess;
import com.cybelia.sandra.entities.InfoAccessDAO;
import com.cybelia.sandra.entities.InfoAccessEtat;
import com.cybelia.sandra.ibu.csv.bean.Ibu;
import com.cybelia.sandra.ibu.manager.Injector;
import com.cybelia.sandra.ibu.manager.ManagerInjector;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;

public class InjectorEleveur
implements Injector {
    protected static final Log log = LogFactory.getLog(InjectorEleveur.class);
    protected static final String SILO_PREFIX = "S";
    protected Eleveur eleveur;
    protected InfoAccess silo;

    public Eleveur getObject() {
        return this.eleveur;
    }

    public InfoAccess getSilo() {
        return this.silo;
    }

    @Override
    public void clear() {
        this.eleveur = null;
        this.silo = null;
    }

    @Override
    public void inject(ManagerInjector manager, Ibu ibu) throws TopiaException {
        String siloNom;
        EleveurDAO eleveurDAO = SandraDAOHelper.getEleveurDAO((TopiaContext)manager.getTransaction());
        InfoAccessDAO infoAccessDAO = SandraDAOHelper.getInfoAccessDAO((TopiaContext)manager.getTransaction());
        this.eleveur = (Eleveur)eleveurDAO.findByProperties("code", (Object)ibu.getEleveurCode(), new Object[]{"societe", manager.getSociete()});
        if (this.eleveur == null) {
            this.eleveur = (Eleveur)eleveurDAO.create(new Object[0]);
            this.eleveur.setCode(ibu.getEleveurCode());
            this.eleveur.setSociete(manager.getSociete());
            InfoAccess infoAccess = (InfoAccess)infoAccessDAO.create(new Object[0]);
            infoAccess.setNiveauSecurite(-1);
            infoAccess.setEtat(0);
            infoAccessDAO.update((TopiaEntity)infoAccess);
            this.eleveur.setAccesEleveur(infoAccess);
        }
        if (ibu.getProduitCapaciteUnitaire() != null && ibu.getProduitCapaciteUnitaire().equals("00") && (siloNom = ibu.getProduitSilo()) != null && !siloNom.trim().isEmpty() && !siloNom.trim().equals("0")) {
            if (this.eleveur.getAccesSilos() == null) {
                ArrayList silos = new ArrayList();
                this.eleveur.setAccesSilos(silos);
            }
            try {
                int siloNum = Integer.parseInt(siloNom);
                String newSiloNom = SILO_PREFIX + siloNum;
                this.silo = this.getIfExist(this.eleveur, siloNom);
                if (this.silo != null) {
                    InfoAccess newSilo = this.getIfExist(this.eleveur, newSiloNom);
                    if (newSilo != null) {
                        InfoAccessDAO dao = SandraDAOHelper.getInfoAccessDAO((TopiaContext)manager.getTransaction());
                        dao.delete(this.silo);
                        this.silo = newSilo;
                    } else {
                        this.silo.setNomAcces(newSiloNom);
                        this.silo = (InfoAccess)infoAccessDAO.update((TopiaEntity)this.silo);
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Replace numerical name '" + siloNom + "' by '" + newSiloNom + "'"));
                }
                siloNom = newSiloNom;
            }
            catch (NumberFormatException eee) {
                // empty catch block
            }
            if (this.silo == null) {
                this.silo = this.getIfExist(this.eleveur, siloNom);
                if (this.silo == null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Creating acces silo : " + siloNom + " for eleveur : " + this.eleveur.getTopiaId()));
                    }
                    this.silo = (InfoAccess)infoAccessDAO.create(new Object[0]);
                    this.silo.setNomAcces(siloNom);
                    this.silo.setEtat(InfoAccessEtat.INFOACCESS_ACTIF);
                    this.silo.setNiveauSecurite(-1);
                    this.silo.setType(0);
                    this.silo = (InfoAccess)infoAccessDAO.update((TopiaEntity)this.silo);
                    this.eleveur.addAccesSilos(this.silo);
                }
            }
        }
        this.eleveur.setRaisonSociale(ibu.getEleveurRaisonSociale());
        this.eleveur.setTelephone(ibu.getEleveurTelephone());
        this.eleveur.setMobile(ibu.getEleveurMobile());
        this.eleveur.setAdresse(ibu.getEleveurAdresse() + " " + ibu.getEleveurVille());
        this.eleveur.setCodePostal(ibu.getEleveurCodePostal());
        this.eleveur.setVille(ibu.getEleveurCommune());
        this.eleveur.setCodeINSEE(ibu.getEleveurCommuneCode());
        this.eleveur.setEmail(ibu.getEleveurMail());
        this.eleveur = (Eleveur)eleveurDAO.update((TopiaEntity)this.eleveur);
    }

    protected boolean exist(Eleveur eleveur, String siloNom) {
        return this.getIfExist(eleveur, siloNom) != null;
    }

    protected InfoAccess getIfExist(Eleveur eleveur, String siloNom) {
        for (InfoAccess s : eleveur.getAccesSilos()) {
            if (s == null || !siloNom.trim().equalsIgnoreCase(s.getNomAcces())) continue;
            return s;
        }
        return null;
    }
}

