/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra.ibu.injector;

import com.cybelia.sandra.SandraDAOHelper;
import com.cybelia.sandra.entities.Commande;
import com.cybelia.sandra.entities.CommandeDAO;
import com.cybelia.sandra.ibu.csv.bean.Ibu;
import com.cybelia.sandra.ibu.injector.InjectorLigneProduit;
import com.cybelia.sandra.ibu.manager.Injector;
import com.cybelia.sandra.ibu.manager.ManagerInjector;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;

public class InjectorCommande
implements Injector {
    protected Commande commande;
    protected boolean commandeCreated = false;

    public Commande getObject() {
        return this.commande;
    }

    public boolean isCommandeCreated() {
        return this.commandeCreated;
    }

    @Override
    public void clear() {
        this.commande = null;
        this.commandeCreated = false;
    }

    @Override
    public void inject(ManagerInjector manager, Ibu ibu) throws TopiaException {
        CommandeDAO commandeDAO = SandraDAOHelper.getCommandeDAO((TopiaContext)manager.getTransaction());
        this.commande = commandeDAO.findByNumero(ibu.getCommandeCode());
        if (this.commande == null) {
            this.commande = (Commande)commandeDAO.create(new Object[0]);
            this.commande.setNumero(ibu.getCommandeCode());
            this.commandeCreated = true;
        }
        if (this.commande.getCommentaire() == null && ibu.getCommandeCommentaire() != null || !this.commande.getCommentaire().equals(ibu.getCommandeCommentaire())) {
            manager.getInjector(InjectorLigneProduit.class).setCommandeCommentaireIsModif(true);
        }
        this.commande.setCommentaire(ibu.getCommandeCommentaire());
        this.commande.setContrainteHoraire(ibu.getCommandeMoment());
    }
}

