/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra.ibu.injector;

import com.cybelia.sandra.SandraDAOHelper;
import com.cybelia.sandra.entities.Camion;
import com.cybelia.sandra.entities.CamionDAO;
import com.cybelia.sandra.entities.Chauffeur;
import com.cybelia.sandra.entities.ChauffeurDAO;
import com.cybelia.sandra.ibu.csv.bean.Ibu;
import com.cybelia.sandra.ibu.csv.bean.IbuChauffeur;
import com.cybelia.sandra.ibu.manager.Injector;
import com.cybelia.sandra.ibu.manager.ManagerInjector;
import java.util.ArrayList;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;

public class InjectorChauffeur
implements Injector {
    protected Chauffeur chauffeur;

    public Chauffeur getObject() {
        return this.chauffeur;
    }

    @Override
    public void clear() {
        this.chauffeur = null;
    }

    @Override
    public void inject(ManagerInjector manager, Ibu ibu) throws TopiaException {
        ChauffeurDAO chauffeurDAO = SandraDAOHelper.getChauffeurDAO((TopiaContext)manager.getTransaction());
        this.chauffeur = (Chauffeur)chauffeurDAO.findByProperties("code", (Object)ibu.getChauffeurCode(), new Object[]{"societe", manager.getSociete()});
        if (this.chauffeur == null) {
            this.chauffeur = (Chauffeur)chauffeurDAO.create(new Object[0]);
            this.chauffeur.setCode(ibu.getChauffeurCode());
            this.chauffeur.setSociete(manager.getSociete());
            this.chauffeur.setNom(ibu.getChauffeurNom());
        }
    }

    public void inject(ManagerInjector manager, IbuChauffeur ibuChauffeur) throws TopiaException {
        ChauffeurDAO chauffeurDAO = SandraDAOHelper.getChauffeurDAO((TopiaContext)manager.getTransaction());
        this.chauffeur = (Chauffeur)chauffeurDAO.findByProperties("code", (Object)ibuChauffeur.getCode(), new Object[]{"societe", manager.getSociete()});
        if (this.chauffeur == null) {
            this.chauffeur = (Chauffeur)chauffeurDAO.create(new Object[0]);
            this.chauffeur.setCode(ibuChauffeur.getCode());
            this.chauffeur.setSociete(manager.getSociete());
        }
        this.chauffeur.setNom(ibuChauffeur.getNom());
        this.chauffeur.setPrenom(ibuChauffeur.getPrenom());
        this.chauffeur.setTrigramme(ibuChauffeur.getTrigramme());
        this.addDefautChauffeur(manager, ibuChauffeur.getCamion1());
        this.addDefautChauffeur(manager, ibuChauffeur.getCamion2());
        this.addDefautChauffeur(manager, ibuChauffeur.getCamion3());
        this.addDefautChauffeur(manager, ibuChauffeur.getCamion4());
        this.addDefautChauffeur(manager, ibuChauffeur.getCamion5());
        this.addDefautChauffeur(manager, ibuChauffeur.getCamion6());
    }

    private void addDefautChauffeur(ManagerInjector manager, String camionCode) throws TopiaException {
        CamionDAO camionDAO;
        Camion camion;
        if (camionCode != null && !"".equals(camionCode) && (camion = (Camion)(camionDAO = SandraDAOHelper.getCamionDAO((TopiaContext)manager.getTransaction())).findByProperties("code", (Object)camionCode, new Object[]{"societe", manager.getSociete()})) != null) {
            ArrayList<Chauffeur> defautChauffeurs = camion.getDefautChauffeurs();
            if (defautChauffeurs == null) {
                defautChauffeurs = new ArrayList<Chauffeur>();
                camion.setDefautChauffeurs(defautChauffeurs);
            }
            if (!defautChauffeurs.contains(this.chauffeur)) {
                defautChauffeurs.add(this.chauffeur);
            }
        }
    }
}

