/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra.ibu.injector;

import com.cybelia.sandra.SandraDAOHelper;
import com.cybelia.sandra.SandraHelper;
import com.cybelia.sandra.entities.Camion;
import com.cybelia.sandra.entities.CamionDAO;
import com.cybelia.sandra.entities.Societe;
import com.cybelia.sandra.entities.SocieteDAO;
import com.cybelia.sandra.entities.UserIndicateurs;
import com.cybelia.sandra.entities.UserIndicateursDAO;
import com.cybelia.sandra.ibu.csv.bean.Ibu;
import com.cybelia.sandra.ibu.csv.bean.IbuCamion;
import com.cybelia.sandra.ibu.manager.Injector;
import com.cybelia.sandra.ibu.manager.ManagerInjector;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaSecurityDAOHelper;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.taas.entities.TaasUser;
import org.nuiton.topia.taas.entities.TaasUserDAO;

public class InjectorCamion
implements Injector {
    private final Log log = LogFactory.getLog(InjectorCamion.class);
    protected Camion camion;

    public Camion getObject() {
        return this.camion;
    }

    @Override
    public void clear() {
        this.camion = null;
    }

    @Override
    public void inject(ManagerInjector manager, Ibu ibu) throws TopiaException {
        String[] splited;
        CamionDAO camionDAO = SandraDAOHelper.getCamionDAO((TopiaContext)manager.getTransaction());
        String camionCodeSociete = ibu.getCamionCodeSociete();
        if (!StringUtils.isEmpty((String)camionCodeSociete) && (splited = camionCodeSociete.split("-")).length == 2) {
            SocieteDAO societeDAO = SandraDAOHelper.getSocieteDAO((TopiaContext)manager.getTransaction());
            String codeSociete = splited[0];
            String codeCamion = splited[1];
            Societe societe = societeDAO.findByCode(codeSociete);
            this.camion = (Camion)camionDAO.findByProperties("code", (Object)codeCamion, new Object[]{"societe", societe});
        }
        if (this.camion == null) {
            String camionCode = ibu.getCamionCode();
            this.camion = (Camion)camionDAO.findByProperties("code", (Object)camionCode, new Object[]{"societe", manager.getSociete()});
        }
        if (this.camion == null) {
            this.camion = (Camion)camionDAO.findByProperties("code", (Object)"GUI", new Object[]{"societe", manager.getSociete()});
        }
    }

    public void inject(ManagerInjector manager, IbuCamion ibuCamion) throws TopiaException {
        TopiaContext transaction = manager.getTransaction();
        CamionDAO camionDAO = SandraDAOHelper.getCamionDAO((TopiaContext)transaction);
        SocieteDAO societeDAO = SandraDAOHelper.getSocieteDAO((TopiaContext)transaction);
        Societe societe = manager.getSociete();
        this.camion = (Camion)camionDAO.findByProperties("code", (Object)ibuCamion.getCode(), new Object[]{"societe", societe});
        if (this.camion == null) {
            this.camion = (Camion)camionDAO.create(new Object[0]);
            this.camion.setCode(ibuCamion.getCode());
            this.camion.setSociete(societe);
            this.camion = (Camion)camionDAO.create(new Object[0]);
            TaasUserDAO taasUserDAO = TopiaSecurityDAOHelper.getTaasUserDAO((TopiaContext)transaction);
            TaasUser taasUser = (TaasUser)taasUserDAO.create(new Object[0]);
            taasUser.setLogin(societe.getCode() + "-" + this.camion.getCode());
            taasUser.setLink(societe.getTopiaId());
            taasUser = (TaasUser)taasUserDAO.update((TopiaEntity)taasUser);
            UserIndicateursDAO userIndicateursDAO = SandraDAOHelper.getUserIndicateursDAO((TopiaContext)transaction);
            UserIndicateurs userIndicateurs = (UserIndicateurs)userIndicateursDAO.create(new Object[0]);
            userIndicateurs = SandraHelper.razUserIndicateurs(userIndicateurs);
            userIndicateurs.setTaasUser(taasUser);
            this.camion.setUserIndicateurs(userIndicateurs);
            this.camion.setActif(true);
        }
        this.camion.setNombreCompartiments(ibuCamion.getNbCompartiment());
        this.camion.setTransporteur(manager.getTransporteur());
        String codePrincipal = ibuCamion.getCodePrincipal();
        if (codePrincipal != null && !"".equals(codePrincipal)) {
            Societe societeAssocie = societeDAO.findByCode(codePrincipal.substring(0, 1));
            Camion principal = (Camion)camionDAO.findByProperties("code", (Object)codePrincipal.substring(2), new Object[]{"societe", societeAssocie});
            ArrayList<Camion> camionsAssocies = principal.getCamionsAssocies();
            if (camionsAssocies == null) {
                camionsAssocies = new ArrayList<Camion>();
                principal.setCamionsAssocies(camionsAssocies);
            }
            if (!camionsAssocies.contains(this.camion)) {
                camionsAssocies.add(this.camion);
            }
        }
    }
}

